/*
 * Decompiled with CFR 0.152.
 */
package com.endofhope.neurasthenia.webcontainer.servlet;

import com.endofhope.neurasthenia.webcontainer.servlet.PanzerRequest;
import java.io.IOException;
import javax.servlet.ServletInputStream;

public class HttpServletInputStreamImpl
extends ServletInputStream {
    private boolean blockingMode;
    private int readSize;
    private int bodySize;
    private byte[] bodyBytes;

    public HttpServletInputStreamImpl(PanzerRequest panzerRequest) {
        this.blockingMode = panzerRequest.isBlockingMode();
        if (!this.blockingMode) {
            this.readSize = 0;
            this.bodyBytes = panzerRequest.getBodyBytes();
            this.bodySize = panzerRequest.getContentLength();
        }
    }

    public int read() throws IOException {
        if (!this.blockingMode && this.bodyBytes != null && this.readSize < this.bodySize) {
            return this.bodyBytes[this.readSize];
        }
        return -1;
    }

    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    public int read(byte[] b, int off, int len) throws IOException {
        int copiedSize = -1;
        if (!this.blockingMode && this.bodyBytes != null) {
            int remainSize = this.bodySize - this.readSize;
            if (remainSize > 0) {
                if (len < remainSize) {
                    System.arraycopy(this.bodyBytes, this.readSize, b, 0, len);
                    this.readSize += len;
                    copiedSize = len;
                } else {
                    System.arraycopy(this.bodyBytes, this.readSize, b, 0, remainSize);
                    this.readSize = this.bodySize;
                    copiedSize = remainSize;
                }
            } else {
                return -1;
            }
        }
        return copiedSize;
    }
}

