/*
 * Decompiled with CFR 0.152.
 */
package com.endofhope.neurasthenia.webcontainer.servlet;

import com.endofhope.neurasthenia.webcontainer.MimeManager;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.URL;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class ResourceServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;

    protected void service(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        ServletContext sc = this.getServletContext();
        String requestUri = req.getRequestURI();
        String contextPath = req.getContextPath();
        URL resourceURL = null;
        resourceURL = "/".equals(contextPath) ? sc.getResource(requestUri) : sc.getResource(requestUri.substring(contextPath.length()));
        String resourcePath = resourceURL.getPath();
        if (resourcePath == null || "".equals(resourcePath)) {
            resp.sendError(404, "resource not found for " + requestUri);
        } else {
            File targetFile = new File(resourcePath);
            if (targetFile.exists() && targetFile.isFile()) {
                int readSize;
                String fileName = targetFile.getName();
                String fileExtension = null;
                int indexOfLastPoint = fileName.lastIndexOf(".");
                if (indexOfLastPoint > 1) {
                    fileExtension = fileName.substring(indexOfLastPoint + 1);
                }
                String mimeType = MimeManager.getInstance().getMimeType(fileExtension);
                resp.setContentType(mimeType);
                int contentLength = (int)targetFile.length();
                resp.setContentLength(contentLength);
                FileInputStream fis = new FileInputStream(targetFile);
                ServletOutputStream sos = resp.getOutputStream();
                byte[] buf = new byte[512];
                while ((readSize = fis.read(buf)) > 0) {
                    sos.write(buf, 0, readSize);
                }
                fis.close();
            } else {
                resp.sendError(404, "resource not found for " + requestUri);
            }
        }
    }
}

