/*
 * Decompiled with CFR 0.152.
 */
package com.endofhope.neurasthenia.webcontainer.servlet;

import com.endofhope.neurasthenia.LifeCycle;
import com.endofhope.neurasthenia.webcontainer.WebContextManager;
import com.endofhope.neurasthenia.webcontainer.servlet.ServletManager;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.RequestDispatcher;
import javax.servlet.Servlet;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;

public class ServletContextImpl
implements ServletContext,
LifeCycle {
    private static Logger logger = Logger.getLogger("servlet");
    private WebContextManager webContextManager;
    private String directory;
    private String contextName;
    private String contextPath;
    private int version;
    private Map<String, String> initParamMap;
    private ServletManager servletManager;
    private Map<String, Object> attributeMap;
    public static final String serverInfo = "Communicator Servlet Container";
    private volatile boolean running;

    protected Map<String, String> getInitParamMap() {
        return this.initParamMap;
    }

    public int getVersion() {
        return this.version;
    }

    public ServletContextImpl(WebContextManager webContextManager, String directory, String contextName, String contextPath, int version) {
        this.webContextManager = webContextManager;
        this.directory = directory;
        this.contextName = contextName;
        this.contextPath = contextPath;
        this.version = version;
        this.attributeMap = new ConcurrentHashMap<String, Object>();
        this.initParamMap = new HashMap<String, String>();
        this.servletManager = new ServletManager(this);
    }

    public WebContextManager getWebContextManager() {
        return this.webContextManager;
    }

    protected String getRealContextPath() {
        return this.directory;
    }

    public ServletManager getServletManager() {
        return this.servletManager;
    }

    public void setAttribute(String name, Object object) {
        this.attributeMap.put(name, object);
    }

    public Object getAttribute(String name) {
        return this.attributeMap.get(name);
    }

    public void removeAttribute(String name) {
        this.attributeMap.remove(name);
    }

    public Enumeration getAttributeNames() {
        Set<String> nameSet = this.attributeMap.keySet();
        Vector<String> nameVector = new Vector<String>();
        nameVector.addAll(nameSet);
        return nameVector.elements();
    }

    public ServletContext getContext(String uripath) {
        return this.webContextManager.getServletContext(uripath);
    }

    public String getContextPath() {
        return this.contextPath;
    }

    public String getInitParameter(String name) {
        return this.initParamMap.get(name);
    }

    public Enumeration getInitParameterNames() {
        Vector<String> nameVector = new Vector<String>();
        nameVector.addAll(this.initParamMap.keySet());
        return nameVector.elements();
    }

    public int getMajorVersion() {
        return 2;
    }

    public String getMimeType(String file) {
        throw new UnsupportedOperationException("Until not supported");
    }

    public int getMinorVersion() {
        return 5;
    }

    public RequestDispatcher getNamedDispatcher(String name) {
        throw new UnsupportedOperationException("Until not supported");
    }

    public String getRealPath(String path) {
        return this.directory + path;
    }

    public RequestDispatcher getRequestDispatcher(String path) {
        throw new UnsupportedOperationException("Until not supported");
    }

    public URL getResource(String path) throws MalformedURLException {
        String absolutePath = this.getRealPath(path);
        return new URL("file", "localhost", absolutePath);
    }

    public InputStream getResourceAsStream(String path) {
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(this.getResource(path).getFile());
        }
        catch (FileNotFoundException e) {
            logger.log(Level.WARNING, "resource not found", e);
        }
        catch (MalformedURLException e) {
            logger.log(Level.WARNING, "resource is not well formed", e);
        }
        return fis;
    }

    public Set getResourcePaths(String path) {
        throw new UnsupportedOperationException();
    }

    public String getServerInfo() {
        return serverInfo;
    }

    public Servlet getServlet(String name) throws ServletException {
        return this.servletManager.getServlet(name);
    }

    public String getServletContextName() {
        return this.contextName;
    }

    public Enumeration getServletNames() {
        Set<String> keySet = this.servletManager.getServletMap().keySet();
        Vector<String> nameVector = new Vector<String>();
        nameVector.addAll(keySet);
        return nameVector.elements();
    }

    public Enumeration getServlets() {
        Vector<Servlet> servletVector = new Vector<Servlet>();
        servletVector.addAll(this.servletManager.getServletMap().values());
        return servletVector.elements();
    }

    public void log(String msg) {
        logger.log(Level.INFO, msg);
    }

    public void log(Exception exception, String msg) {
        logger.log(Level.SEVERE, msg, exception);
    }

    public void log(String message, Throwable throwable) {
        logger.log(Level.SEVERE, message, throwable);
    }

    @Override
    public void boot() {
        this.running = true;
        this.servletManager.boot();
    }

    @Override
    public void down() {
        this.servletManager.down();
        this.running = false;
    }

    @Override
    public boolean isRunning() {
        return this.running;
    }
}

