#pragma once

#include <vector>

class CState;
template<class TYPE> class LGraph;
template<class TYPE> class LStrongcon;

class CDag {
public:
	CDag();
	~CDag() { 
		//delete state_diagram; 
	}

	unsigned int create_node();
	void remove_node(unsigned int id);

	void create_edge(unsigned int from, unsigned int to);
	void remove_edge(unsigned int from, unsigned int to);

	//void compute_scc();
	
	unsigned compute_scc();
	unsigned compute_rea(unsigned state_id);
	
	LGraph<CState*> *graph;

	unsigned scc_nodes[100];
	unsigned rea_nodes[100];

private:
	LStrongcon<CState*> *lsc;
	unsigned scc_nodes_count;
	unsigned rea_nodes_count;
};


#define INLINE

////////////////////////////////////////////////////////////////////////////
// LSTAQ.H
////////////////////////////////////////////////////////////////////////////
template<class TYPE>
struct LStaqNode {
	TYPE info;
	LStaqNode<TYPE> *next;
	LStaqNode(const TYPE &x, LStaqNode<TYPE> *n=0);
	LStaqNode(const LStaqNode<TYPE> &s);
};

template<class TYPE>
INLINE LStaqNode<TYPE>::LStaqNode(const TYPE &x, LStaqNode<TYPE> *n)
: info(x), next(n)
{
}

template<class TYPE>
INLINE LStaqNode<TYPE>::LStaqNode(const LStaqNode<TYPE> &s)
: info(s.info), next(0)
{
}

template<class TYPE>
class LStaq {
private:
	LStaqNode<TYPE> *head, *tail;
public:
	LStaq();
	LStaq(const LStaq<TYPE> &s);
	~LStaq();
	void Clear();
	int Copy(const LStaq<TYPE> &s);
	void operator=(const LStaq<TYPE> &s);
	int Push(const TYPE &x);
	int Pop(TYPE &x);
	int Pop();
	int Insert(const TYPE &x);
	int Extract(TYPE &x);
	int Extract();
	int AddFront(const TYPE &x);
	int AddBack(const TYPE &x);
	int RmvFront(TYPE &x);
	int RmvFront();
	int IsEmpty() const;
	TYPE *Top() const;
	TYPE *Front() const;
	TYPE *Bottom() const;
	TYPE *Back() const;
	LStaqNode<TYPE> *Head() const;
	LStaqNode<TYPE> *Tail() const;
};

template<class TYPE>
INLINE LStaq<TYPE>::LStaq()
{
	head = 0; tail = 0;
}

template<class TYPE>
INLINE void LStaq<TYPE>::operator=(const LStaq<TYPE> &s)
{
	Copy(s);
}

template<class TYPE>
INLINE int LStaq<TYPE>::IsEmpty() const
{
	return head == 0;
}

template<class TYPE>
INLINE int LStaq<TYPE>::Extract(TYPE &x)
{
	return RmvFront(x);
}

template<class TYPE>
INLINE int LStaq<TYPE>::Extract()
{
	return RmvFront();
}

template<class TYPE>
INLINE int LStaq<TYPE>::Push(const TYPE &x)
{
	return AddFront(x);
}

template<class TYPE>
INLINE int LStaq<TYPE>::Insert(const TYPE &x)
{
	return AddBack(x);
}

template<class TYPE>
INLINE int LStaq<TYPE>::Pop(TYPE &x)
{
	return RmvFront(x);
}

template<class TYPE>
INLINE int LStaq<TYPE>::Pop()
{
	return RmvFront();
}

template<class TYPE>
INLINE TYPE *LStaq<TYPE>::Top() const
{
	return head ? &head->info : 0;
}

template<class TYPE>
INLINE TYPE *LStaq<TYPE>::Front() const
{
	return head ? &head->info : 0;
}

template<class TYPE>
INLINE TYPE *LStaq<TYPE>::Bottom() const
{
	return tail ? &tail->info : 0;
}

template<class TYPE>
INLINE TYPE *LStaq<TYPE>::Back() const
{
	return tail ? &tail->info : 0;
}

template<class TYPE>
INLINE LStaqNode<TYPE> *LStaq<TYPE>::Head() const
{
	return head;
}

template<class TYPE>
INLINE LStaqNode<TYPE> *LStaq<TYPE>::Tail() const
{
	return tail;
}

////////////////////////////////////////////////////////////////////////////
// EDGE.H
////////////////////////////////////////////////////////////////////////////
template<class TYPE>
struct EdgeData {
	TYPE wt;
	unsigned src, dest;
};

template<class TYPE>
struct EdgeParm {
	TYPE wt;
	unsigned adjvtx;
	EdgeParm();
	EdgeParm(unsigned av, const TYPE &x);
};

template<class TYPE>
INLINE EdgeParm<TYPE>::EdgeParm()
{
}

template<class TYPE>
INLINE EdgeParm<TYPE>::EdgeParm(unsigned av, const TYPE &x)
: wt(x), adjvtx(av)
{
}

////////////////////////////////////////////////////////////////////////////
// LGRAPTH.H
////////////////////////////////////////////////////////////////////////////
template<class TYPE>
struct EdgeLink : EdgeParm<TYPE> {
	EdgeLink<TYPE> *next;
	EdgeLink(unsigned av, const TYPE &x, EdgeLink<TYPE> *n=0);
};

template<class TYPE>
class LGraph {
protected:
	EdgeLink<TYPE> **vertices;
	TYPE no_edge;
	unsigned def_grow_factor, nv_alloc, nv, ne;
	int is_digraph;
	void RmvEdgeList(EdgeLink<TYPE> *v);
	int Grow(unsigned ga=0);
	int SetDirEdge(unsigned a, const TYPE &x, unsigned b);
	void RmvDirEdge(unsigned a, unsigned b);
	int Realloc(unsigned n);
	int Copy(const LGraph<TYPE> &g);
public:
	LGraph(unsigned nv_, int is_digraph_ = 1, const TYPE &no_edge_ = 0);
	LGraph(const LGraph<TYPE> &g);
	virtual ~LGraph();
	void operator=(const LGraph<TYPE> &g);
	void SetGrowthFactor(unsigned dgf);
	void Clear();
	unsigned NewVtx();
	int DetachVtx(unsigned v);
	int SetEdge(unsigned a, const TYPE &x, unsigned b);
	void RmvEdge(unsigned a, unsigned b);
	const TYPE *EdgeWt(unsigned a, unsigned b) const;
	const TYPE &operator()(unsigned a, unsigned b) const;
	EdgeLink<TYPE> *AdjEdges(unsigned v) const;
	int ValidVtx(unsigned v) const;
	const TYPE &NoEdge() const;
	unsigned NumVertices() const;
	unsigned NumEdges() const;
	unsigned Capacity() const;
	void Valence(unsigned *in_deg, unsigned *out_deg) const;
	void InDegrees(unsigned *in_deg) const;
	void OutDegrees(unsigned *out_deg) const;
	int IsDigraph() const;
};

template<class TYPE>
INLINE int LGraph<TYPE>::ValidVtx(unsigned v) const
// Returns 1 if v is a valid vertex handle, else 0
{
	return v > 0 && v <= nv;
}

template<class TYPE>
INLINE const TYPE &LGraph<TYPE>::NoEdge() const
// Returns the value used to indicate "no edge" when
// using the operator() function.
{
	return no_edge;
}

template<class TYPE>
INLINE void LGraph<TYPE>::SetGrowthFactor(unsigned dgf)
// Sets the growth factor for the vertex array. A gf
// of 4 means 4/8 or 50%
{
	def_grow_factor = dgf;
}

template<class TYPE>
INLINE unsigned LGraph<TYPE>::NumVertices() const
// Number of vertices in use
{
	return nv;
}

template<class TYPE>
INLINE unsigned LGraph<TYPE>::NumEdges() const
// Returns number of "logical" edges in the graph. For digraphs,
// that's the same as the number edge links. For undirected
// graphs, we divide by two because two edge links are used per 
// undirected edge.
{
	return is_digraph ? ne : ne / 2;
}

template<class TYPE>
INLINE unsigned LGraph<TYPE>::Capacity() const
// Returns the number of vertices this graph can
// hold before having to reallocate.
{
	return nv_alloc;
}

template<class TYPE>
INLINE void LGraph<TYPE>::InDegrees(unsigned *in_deg) const
// Computes the in-degree (number of edges coming in to
// a vertex) for each vertex and stores the results in
// the array in_deg, which should be 1-based and have
// room for nv items.
{
	Valence(in_deg, 0);
}

template<class TYPE>
INLINE void LGraph<TYPE>::OutDegrees(unsigned *out_deg) const
// Computes the out-degree (number of edges leaving a
// vertex) for each vertex and stores the results in 
// the array out_deg, which should be 1-based and have
// room for nv items.
{
	Valence(0, out_deg);
}

template<class TYPE>
INLINE int LGraph<TYPE>::IsDigraph() const
// Returns 1 if this graph is a digraph, else 0.
{
	return is_digraph;
}


////////////////////////////////////////////////////////////////////////////
// LSTRNGCN.H
////////////////////////////////////////////////////////////////////////////
struct LStrongconInfo {
	unsigned num;         // Depth-first number;
	unsigned low;         // Lowest num seen by children
	unsigned group;       // Connected group number
};

template<class TYPE>
class LStrongcon {
protected:
	LStaq< unsigned > stk;  // Temporary stack of vertices
	LGraph<TYPE> *g;        // The graph we are traversing
	LStrongconInfo *info;   // Vertex info while running
	unsigned tkt;           // Visit "ticket" dispenser
	unsigned grp_tkt;       // Group "ticket" dispenser
	void Dealloc();
	int Realloc(unsigned n);
public:
	LStrongcon(LGraph<TYPE> *g_);
	virtual ~LStrongcon();
	virtual void Reset();
	virtual void Reset(LGraph<TYPE> *g_);
	unsigned Run(unsigned u);
	void RunAll();
	unsigned Num(unsigned v) const;
	unsigned Low(unsigned v) const;
	unsigned Group(unsigned v) const;
};

template<class TYPE>
INLINE unsigned LStrongcon<TYPE>::Num(unsigned v) const
{
	return info[v].num;
}

template<class TYPE>
INLINE unsigned LStrongcon<TYPE>::Low(unsigned v) const
{
	return info[v].low;
}

template<class TYPE>
INLINE unsigned LStrongcon<TYPE>::Group(unsigned v) const
{
	return info[v].group;
}


#undef INLINE



