#include "stdafx.h"
#include "model.h"
#include "dag.h"

///////////////////////////////////////////////////////////////////////////
// Class : CState
///////////////////////////////////////////////////////////////////////////
CState::CState(void)
	:_topo(CState::None)
{
}

CState::~CState(void)
{
}

void CState::addLabel(CLabel l) 
{
	labels.push_back(l);
}

void CState::delLabel(CLabel l)
{
	vector<CLabel> temp;
	vector<CLabel>::iterator itr = labels.begin();
	for (itr; itr!=labels.end(); itr++) {
		if (!((*itr).Name() == l.Name() && (*itr).IsTrue() == l.IsTrue()))
			temp.push_back(*itr);
	}

	labels.clear();
	labels = temp;

}
void CState::modLabel(CLabel l1, CLabel l2)
{
	delLabel(l1);
	addLabel(l2);
}

bool CState::hasLabel(CLabel l)
{
	vector<CLabel>::iterator itr = labels.begin();
	for (itr; itr!=labels.end(); itr++) {
		if ((*itr).Name() == l.Name() && (*itr).IsTrue() == l.IsTrue())
			return true;
	}

	return false;
}

///////////////////////////////////////////////////////////////////////////
// Class : CTransition
///////////////////////////////////////////////////////////////////////////
CState* CTransition::From()
{
	return this->from;
}

CState* CTransition::To()
{
	return this->to;
}

///////////////////////////////////////////////////////////////////////////
// Class : CModel
///////////////////////////////////////////////////////////////////////////
CState const NO_EDGE;

CModel::CModel(void)
{
	construct_dag();
	::AfxTrace("New Model is created..\n");
}

CModel::~CModel(void)
{
}

void CModel::createVar(CString name)
{
	//
	// , ̹ ǵ  üũѴ.
	//
	if (isExistVar(name))
		return;

	variables.push_back(name);

	//
	// 𵨳 µ鿡   ߰Ѵ.
	//
	add_variable_to_states(name);
}

void CModel::deleteVar(CString name)
{
	vector<CString> temp;
	for (vector<CString>::iterator itr=variables.begin(); itr!=variables.end(); itr++)
	{
		if (*itr != name)
			temp.push_back(name);
	}

	variables.clear();
	variables = temp;

	//
	//  µκ   Ѵ.
	//
	del_variable_from_states(name);
}

void CModel::modifyVar(CString from, CString to)
{
	deleteVar(from);
	createVar(to);
}

bool CModel::isExistVar(CString name)
{
	vector<CString>::iterator itr=variables.begin();
	for (itr; itr!=variables.end(); itr++) {
		if (*itr == name)
			return true;
	}

	return false;
}

void CModel::clearVar()
{
	vector<CString>::iterator itr=variables.begin();
	for (itr; itr!=variables.end(); itr++) {
		del_variable_from_states(*itr);
	}
	variables.clear();
}

void CModel::trace()
{
	::AfxTrace("######### Trace Model ###########\n");
	::AfxTrace("## States\n");
	vector<CState*>::iterator states_itr = states.begin();
	for (states_itr; states_itr!=states.end(); states_itr++) {
		::AfxTrace("  State[%d]\n", (*states_itr)->getid());
	}
	::AfxTrace("## Transitions\n");
	vector<CTransition*>::iterator trans_itr = transitions.begin();
	for (trans_itr; trans_itr != transitions.end(); trans_itr++) {
		::AfxTrace("  Transtion[%d->%d]\n", 
			(*trans_itr)->From()->getid(), (*trans_itr)->To()->getid());
	}
}

void CModel::trace(CString& str)
{
	str.Append("Model Information\n");
	str.Append(" \n");
	str.Append("States:\n");
	vector<CState*>::iterator states_itr = states.begin();
	for (states_itr; states_itr!=states.end(); states_itr++) {
		str.AppendFormat("   [%d]\n", (*states_itr)->getid());
	}
	str.Append(" \n");
	str.Append("Transitions:\n");
	vector<CTransition*>::iterator trans_itr = transitions.begin();
	for (trans_itr; trans_itr != transitions.end(); trans_itr++) {
		str.AppendFormat("   Transtion[%d->%d]\n", 
			(*trans_itr)->From()->getid(), (*trans_itr)->To()->getid());
	}
	str.Append(" \n");
	str.Append("Variables:\n");
	vector<CString>::iterator vars_itr = variables.begin();
	for (vars_itr; vars_itr != variables.end(); vars_itr++) {
		str.Append("   ");str.Append(*vars_itr);str.Append("\n");
	}
	
	CString spec;
	specification.trace(spec);
	str.Append(" \n");
	str.Append("Specification:\n");
	str.Append("   ");str.Append(spec);
}

CState* CModel::createState()
{
	CState* node = new CState();
	states.push_back(node);

	//
	//  ִ   ¿ Ҵ
	//
	for (vector<CString>::iterator itr=variables.begin(); itr!=variables.end(); itr++) {
		node->addLabel(*(new CLabel(*itr, false)));
	}

	node->setid(state_diagram->create_node());

	::AfxTrace("New state[%d] is created..\n", node->getid());

	return node;
}

void CModel::deleteState(CState* state)
{
	if (!state) {
		::AfxTrace("[CModel::deleteState] state is null\n");
		return;
	}

	vector<CState*>::iterator itr = states.begin();
	for (itr; itr!=states.end(); itr++) {
		if (*itr == state) {
			states.erase(itr);
			::AfxTrace("state[%d] is deleted..\n", state->getid());
			//
			// ϳ ° Ǹ  ¿  
			// Transition    ǾѴ.
			//
			deleteTransition(state);
			return;
		}
	}
}

void CModel::createTransition(CState* s1, CState* s2)
{
	if (is_transition_exist(s1, s2))
		return;

	CTransition* trans = new CTransition(s1, s2);
	transitions.push_back(trans);
	state_diagram->create_edge(s1->getid(), s2->getid());

	::AfxTrace("New transition[%d->%d] is created..\n", 
		s1->getid(), s2->getid());
}

//
//  s    transtiion  Ѵ.
//
void CModel::deleteTransition(CState* s)
{
	if (!s) {
		::AfxTrace("[CModel::deleteTransition] s is null\n");
		return;
	}

	//
	//   
	//
	vector<CTransition*> new_trans;
	vector<CTransition*>::iterator itr = transitions.begin();
	for (itr; itr!=transitions.end(); itr++) {
		if ((*itr)->From() == s || (*itr)->To() == s) {
			//
			//  
			//
			state_diagram->remove_edge((*itr)->From()->getid(), (*itr)->To()->getid());
			::AfxTrace("Transition[%d->%d] is deleted..\n", 
				(*itr)->From()->getid(), (*itr)->To()->getid());
		} else {
			new_trans.push_back(*itr);
		}
	}

	transitions.clear();
	for (itr=new_trans.begin(); itr!=new_trans.end(); itr++) {
		transitions.push_back(*itr);
	}

	return;
}

void CModel::deleteTransition(CState* s1, CState* s2)
{
	if (!s1 || !s2) {
		::AfxTrace("[CModel::deleteTransition] s1 or s2 is null\n");
		return;
	}

	vector<CTransition*>::iterator itr = transitions.begin();
	for (itr; itr!=transitions.end(); itr++) {
		if ((*itr)->From() == s1 && (*itr)->To() == s2) {
			::AfxTrace("Transition[%d->%d] is deleted..\n", s1->getid(), s2->getid());
			//
			//  
			//
			state_diagram->remove_edge(s1->getid(), s2->getid());
			transitions.erase(itr);
			return;
		}
	}
}


/*
void CModel::findSCC(CStateList& list)
{
}
*/


void CModel::construct_dag()
{
	//
	// ־ state  transition   directed acyclic graph  Ѵ.
	//
	state_diagram = new CDag();
}

bool CModel::is_transition_exist(CState* s1, CState* s2)
{
	vector<CTransition*>::iterator itr = transitions.begin();

	for (itr; itr!=transitions.end(); itr++) {
		if ((*itr)->From() == s1 && (*itr)->To() == s2)
			return true;
	}

	return false;
}

vector<CString>& CModel::getVariables()
{
	return this->variables;
}

void CModel::add_variable_to_states(CString variable)
{
	CLabel label(variable, false);

	vector<CState*>::iterator itr=states.begin();
	for (itr; itr!=states.end(); itr++) {
		(*itr)->addLabel(label);
	}
}

void CModel::del_variable_from_states(CString variable)
{
	CLabel label1(variable, false);
	CLabel label2(variable, true);

	vector<CState*>::iterator itr=states.begin();
	for (itr; itr!=states.end(); itr++) {
		(*itr)->delLabel(label1);
		(*itr)->delLabel(label2);
	}
}

CSpec& CModel::getSpecification()
{
	return specification;
}

void CModel::find_satisfies_Spec(CString& f, vector<CState*>& states_result) 
{
	//
	// clear all states
	//
	vector<CState*>::iterator itr = states.begin();
	for (itr; itr!=states.end(); itr++) {
		(*itr)->set_topo(CState::None);
	}

	find_satisfies_EG(f, states);
}

void CModel::find_satisfies_EX(CString& f, vector<CState*>& states_result) 
{
}

void CModel::find_satisfies_EU(CString& f, CString& g, vector<CState*>& states_result) 
{
}

void CModel::find_satisfies_EG(CString& f, vector<CState*>& states_result) 
{
	CDag graph;

	CLabel label(f, false);
	bool map[50][50];		// map[global_id][local_id]
	unsigned int new_id;

	for (int i=0; i<50; i++)
		for (int j=0; j<50; j++)
			map[i][j] = false;

	// find nodes hold f, set yellow
	vector<CState*>::iterator itr = states.begin();
	for (itr; itr!=states.end(); itr++) {
		if ((*itr)->hasLabel(label)) {
			(*itr)->set_topo(CState::Yellow);
			new_id = graph.create_node();
			map[(*itr)->getid()][new_id] = true;
		}
	}
	for (itr=states.begin(); itr!=states.end(); itr++) {
		vector<CState*>::iterator itr2 = states.begin();
		for (itr2; itr2!=states.end(); itr2++) {
			if ((*itr)->get_topo() == CState::Yellow && (*itr2)->get_topo() == CState::Yellow &&
				is_transition_exist(*itr, *itr2)) 
			{
					graph.create_edge(
						map_local_id(map, (*itr)->getid()), 
						map_local_id(map, (*itr2)->getid())
					);
			}
		}
	}

	// find SCC, set red
	int scc_node_count = graph.compute_scc();
	for (itr=states.begin(); itr!=states.end(); itr++) {
		for (int i=0; i<scc_node_count; i++) {
			if (graph.scc_nodes[i] == map_local_id(map, (*itr)->getid())) {
				(*itr)->set_topo(CState::Red);
			}
		}
	}

	// find nodes can reach blue or red nodes, set blue
}

unsigned int CModel::map_global_id(bool map[50][50], unsigned int local_id)
{
	for (int i=0; i<50; i++) {
		if (map[i][local_id])
			return i;
	}

	return 0;
}

unsigned int CModel::map_local_id(bool map[50][50], unsigned int global_id)
{
	for (int i=0; i<50; i++) {
		if (map[global_id][i])
			return i;
	}

	return 0;
}

///////////////////////////////////////////////////////////////////////////
// Class : CModelBuilder
///////////////////////////////////////////////////////////////////////////

CModelBuilder::CModelBuilder()
{
}

CModelBuilder::~CModelBuilder()
{
}

CModel* CModelBuilder:: BuildModel()
{
	return new CModel();
}


