// drawtool.h - interface for CDrawTool and derivatives
//
// This is a part of the Microsoft Foundation Classes C++ library.
// Copyright (c) Microsoft Corporation.  All rights reserved.
//
// This source code is only intended as a supplement to the
// Microsoft Foundation Classes Reference and related
// electronic documentation provided with the library.
// See these sources for detailed information regarding the
// Microsoft Foundation Classes product.


#ifndef __DRAWTOOL_H__
#define __DRAWTOOL_H__

#include "drawobj.h"

class CSavView;

/*
enum DrawShape
{
	selection,
	line,
	rect,
	roundRect,
	ellipse,
	poly
};
*/
enum DrawShape
{
	selection,
	line,
	ellipse
};

class CDrawTool
{
// Constructors
public:
	CDrawTool(DrawShape nDrawShape);

// Overridables
	virtual void OnLButtonDown(CSavView* pView, UINT nFlags, const CPoint& point);
	virtual void OnLButtonDblClk(CSavView* pView, UINT nFlags, const CPoint& point);
	virtual void OnLButtonUp(CSavView* pView, UINT nFlags, const CPoint& point);
	virtual void OnMouseMove(CSavView* pView, UINT nFlags, const CPoint& point);
	virtual void OnEditProperties(CSavView* pView);
	virtual void OnCancel();

// Attributes
	DrawShape m_drawShape;

	static CDrawTool* FindTool(DrawShape drawShape);
	static CPtrList c_tools;
	static CPoint c_down;
	static UINT c_nDownFlags;
	static CPoint c_last;
	static DrawShape c_drawShape;
};

class CSelectTool : public CDrawTool
{
// Constructors
public:
	CSelectTool();

// Implementation
	virtual void OnLButtonDown(CSavView* pView, UINT nFlags, const CPoint& point);
	virtual void OnLButtonDblClk(CSavView* pView, UINT nFlags, const CPoint& point);
	virtual void OnLButtonUp(CSavView* pView, UINT nFlags, const CPoint& point);
	virtual void OnMouseMove(CSavView* pView, UINT nFlags, const CPoint& point);
	virtual void OnEditProperties(CSavView* pView);
};

class CRectTool : public CDrawTool
{
// Constructors
public:
	CRectTool(DrawShape drawShape);

// Implementation
	virtual void OnLButtonDown(CSavView* pView, UINT nFlags, const CPoint& point);
	virtual void OnLButtonDblClk(CSavView* pView, UINT nFlags, const CPoint& point);
	virtual void OnLButtonUp(CSavView* pView, UINT nFlags, const CPoint& point);
	virtual void OnMouseMove(CSavView* pView, UINT nFlags, const CPoint& point);

private:
	//void drawLine(CSavView* pView);
	void drawArrowLine(CSavView* pView, CPoint& r1, CPoint& r2);
	void drawArrowLine(CSavView* pView, CDrawObj* line_from, CDrawObj* line_to);
	void drawEllipse(CSavView* pView, CPoint& r);
};

////////////////////////////////////////////////////////////////////////////

#endif // __DRAWTOOL_H__
