<?php

# OpenAPI 라이브러리 사용
require_once('../lib/openapi.php');

if (isset($_GET['keyword']) && is_string($_GET['keyword']))
{
	$result = search('book', $_GET['keyword'], array('display' => 30));
	header('content-type: application/json');

	if (!extension_loaded('JSON')) {
		require_once('JSON.php');
		$json = new Services_JSON();
		echo $json->encode($result);
	}
	else {
		echo json_encode($result);
	}
	exit;
}

?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN"
	"http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
<meta http-equiv="content-type" content="text/html; charset=utf-8" />
<title>OpenAPI Demo - 책검색</title>
<script type="text/javascript" src="prototype.js"></script>
<script type="text/javascript" src="book.js"></script>
<script type="text/javascript">
Event.observe(window, 'load', function() {
	$('book').keyword.value = '은하수를 여행하는 히치하이커를 위한 안내서';
	book();
	$('book').keyword.focus();
});
</script>
</head>
<body>
<h3><span>네이버 책 검색</span></h3>
<form id="book" method="get" action="<?=$_SERVER['PHP_SELF'];?>" onsubmit="return book();">
	<p>
		<input type="text" name="keyword" value="<?=(isset($_GET['keyword']) ? $_GET['keyword'] : '');?>" />
		<input type="submit" value="검색" />
	</p>
</form>
<ul id="bookList">
	<li>No Data</li>
</ul>
<div id="lastDate"></div>
</body>
</html>
