<?php

/**
 * 검색관련기능 - 실시간 검색어
 *
 * @category	OpenAPI
 * @package		SearchExtra
 * @author		Open Technology T/F
 * @copyright	Copyright (c) 2008 NHN Corporation. (http://www.nhncorp.com)
 * @version		0.1
 * @license		new BSD License
 */

class SE_Rank extends SearchAPI_Extra
{
	/**
	 * 쿼리에 들어갈 수 있는 문자열의 배열
	 *
	 * @var $query
	 */
	var $query = array('nexearch', 'cafe', 'blog', 'dic', 'image', 'kin', 'music', 'video', 'webkr', 'site', 'news');

	/**
	 * 생성자
	 * HTTP 요청시 사용되는 인자값 기본 설정
	 *
	 * @return void
	 */
	function SE_Rank()
	{
		parent::SearchAPI_Extra();
		$this->params['target'] = 'rank';
	}

	/**
	 * 검색 키워드를 설정
	 *
	 * @param	string $query
	 * @return	void
	 */
	function setQuery($query)
	{
		if (in_array($query, $this->query) && is_string($query))
		{
			parent::setQuery($query);
		}
	}
}

?>
