<?php

/**
 * 검색결과 API - 동영상 검색
 *
 * @category	OpenAPI
 * @package		Search
 * @author		Open Technology Team
 * @copyright	Copyright (c) 2008 NHN Corporation. (http://www.nhncorp.com)
 * @license		new BSD License
 */

class SearchVideo extends SearchAPI
{
	var $sort = array('sim', 'date');

	var $filter = array('all', 'high', 'normal');

	var $payment = array('all', 'free', 'charge');

	function SearchVideo()
	{
		parent::SearchAPI();
		$this->params['target'] = 'video';
	}

	function setSort($sort)
	{
		if (in_array($sort, $this->sort) && is_string($sort))
			$this->params['sort'] = $sort;
	}

	function getSort()
	{
		return $this->params['sort'];
	}

	function setFilter($filter)
	{
		if (in_array($filter, $this->filter) && is_string($filter))
			$this->params['filter'] = $sort;
	}

	function getFilter()
	{
		return $this->params['filter'];
	}

	function setPayment($payment)
	{
		if (in_array($payment, $this->payment) && is_string($payment))
			$this->params['payment'] = $payment;
	}

	function getPayment()
	{
		return $this->params['payment'];
	}
}

?>
