{
   This program is free software; you can redistribute it and/or
  modify it under the terms of the GNU General Public License
  as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
}
unit Ufrmoption;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, Buttons, ComCtrls, menus, Spin, ExtCtrls,
  UnViewColorBox;

type
  Tfrmoption = class(TForm)
    PageControl1: TPageControl;
    TabSheet1: TTabSheet;
    BitBtn2: TBitBtn;
    BitBtn1: TBitBtn;
    c_viewcolor: TCheckBox;
    Label19: TLabel;
    c_screencapture_hotkey: THotKey;
    Button7: TButton;
    Label1: TLabel;
    Label15: TLabel;
    c_defaultviewcolor: TnViewColorBox;
    BitBtn3: TBitBtn;
    TabSheet2: TTabSheet;
    c_enableballoon: TCheckBox;
    c_enablefilehint: TCheckBox;
    Label13: TLabel;
    c_filehintdelay: TSpinEdit;
    Label14: TLabel;
    Label2: TLabel;
    c_toolbarshrinkmode: TComboBox;
    Label3: TLabel;
    c_undomaxcount: TSpinEdit;
    keepratio: TCheckBox;
    enablelastratio: TCheckBox;
    Label4: TLabel;
    c_ctrlmovepitch: TSpinEdit;
    Label5: TLabel;
    c_shiftmovepitch: TSpinEdit;
    c_keepselectdraw: TCheckBox;
    Label6: TLabel;
    c_listthumbsize: TSpinEdit;
    procedure FormCreate(Sender: TObject);
    procedure BitBtn2Click(Sender: TObject);
    procedure FormShortCut(var Msg: TWMKey; var Handled: Boolean);
    procedure Button7Click(Sender: TObject);
    procedure BitBtn3Click(Sender: TObject);
    procedure keepratioClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  frmoption: Tfrmoption;

implementation
uses Uconfig, Ufrmmain;
{$R *.dfm}

procedure Tfrmoption.FormCreate(Sender: TObject);
begin
  self.PageControl1.ActivePageIndex:=0;

  c_viewcolor.Checked:=config.c_viewcolor;
  c_screencapture_hotkey.HotKey:=TextToShortcut(config.c_screencapture_hotkey);
  c_enablefilehint.Checked:=config.c_enablefilehint;
  c_filehintdelay.Value:=config.c_filehintdelay;
  c_defaultviewcolor.Selected:=config.c_defaultviewcolor;
  c_enableballoon.Checked:=config.c_enableballoon;
  c_toolbarshrinkmode.ItemIndex:=config.c_toolbarshrinkmode;
  c_undomaxcount.Value:=config.c_undomaxcount;
  keepratio.Checked:=config.keepratio;
  keepratioClick(nil);
  enablelastratio.Checked:=config.enablelastratio;
  c_ctrlmovepitch.Value:=config.c_ctrlmovepitch;
  c_shiftmovepitch.Value:=config.c_shiftmovepitch;
  c_keepselectdraw.Checked:=config.c_keepselectdraw;
  c_listthumbsize.Value:=config.c_listthumbsize;
end;

procedure Tfrmoption.BitBtn2Click(Sender: TObject);
begin
  config.c_viewcolor:=c_viewcolor.Checked;
  config.c_screencapture_hotkey:=ShortCutToText(c_screencapture_hotkey.HotKey);
  config.c_enablefilehint:=c_enablefilehint.Checked;
  config.c_filehintdelay:=c_filehintdelay.Value;
  config.c_defaultviewcolor:=c_defaultviewcolor.Selected;
  config.c_enableballoon:=c_enableballoon.Checked;
  config.c_toolbarshrinkmode:=c_toolbarshrinkmode.ItemIndex;
  config.c_undomaxcount:=c_undomaxcount.Value;
  config.keepratio:=keepratio.Checked;
  config.enablelastratio:=enablelastratio.Checked;
  config.c_ctrlmovepitch:=c_ctrlmovepitch.Value;
  config.c_shiftmovepitch:=c_shiftmovepitch.Value;
  config.c_keepselectdraw:=c_keepselectdraw.Checked;
  config.c_listthumbsize:=c_listthumbsize.Value;
end;

procedure Tfrmoption.FormShortCut(var Msg: TWMKey; var Handled: Boolean);
var
  shcut,keystr:string;
begin
  if c_screencapture_hotkey.Focused then
  else
    exit;
  case Msg.CharCode of
    8,32,46: begin
      if (GetKeyState(VK_SHIFT) < 0) then
        keystr:='SHIFT+';
      if (GetKeyState(VK_CONTROL) < 0) then
        keystr:=keystr+'CTRL+';
      if (GetKeyState(VK_MENU) < 0) then
        keystr:=keystr+'ALT+';
      shcut:=shortcuttotext(Msg.CharCode);
      if c_screencapture_hotkey.Focused then
        c_screencapture_hotkey.HotKey:=texttoshortcut(keystr+shcut);
      Handled:=true;
    end;
  end;
end;

procedure Tfrmoption.Button7Click(Sender: TObject);
var
  shortcut:Tshortcut;
  lVKey: word;
  lvShift: TShiftstate;
  lModifier: UINT;
begin
  shortcut:=c_screencapture_hotkey.HotKey;
  lModifier := 0;
  ShortcutToKey(shortcut, lvKey, lvShift);
  if ssShift in lvShift  then lModifier := lModifier or MOD_SHIFT;
  if ssAlt in lvShift then lModifier := lModifier or MOD_ALT;
  if ssCtrl in lvShift then lModifier := lModifier or MOD_CONTROL;

  if RegisterHotKey(Handle,1,lModifier,LOBYTE(lVKey)) then
    MessageDlg('밡մϴ.',mtinformation, [mbok],0)
  else
    MessageDlg('  ϴ.',mtError, [mbok],0);
  UnregisterHotKey(Handle, 1);
end;

procedure Tfrmoption.BitBtn3Click(Sender: TObject);
begin
  c_viewcolor.Checked:=true;
  c_screencapture_hotkey.HotKey:=TextToShortcut('F11');
  c_enablefilehint.Checked:=true;
  c_filehintdelay.Value:=350;
  c_defaultviewcolor.Selected:=clAppWorkSpace;
  c_enableballoon.Checked:=true;
  c_toolbarshrinkmode.ItemIndex:=2;
  c_undomaxcount.Value:=50;
  keepratio.Checked:=false;
  enablelastratio.Checked:=true;
  c_ctrlmovepitch.Value:=1;
  c_shiftmovepitch.Value:=5;
  c_keepselectdraw.Checked:=true;
  c_listthumbsize.Value:=80;
end;

procedure Tfrmoption.keepratioClick(Sender: TObject);
begin
  enablelastratio.Enabled:=keepratio.Checked;
end;

end.
