{

   This program is free software; you can redistribute it and/or
  modify it under the terms of the GNU General Public License
  as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
}
unit UConfig;

interface

uses
  Windows, Forms, SysUtils, ComCtrls, inifiles, UFunction, graphics;

type
  TSimpleConfig = class(TObject)
  public
    lastvalue_string:string;
    lastvalue_integer:integer;
    
    window_left,window_top,window_width,window_height:integer;
    window_max:boolean;
    lastpath,lastdir:string;
    c_uselastdir:boolean;
    ratio,userratio:integer;
    c_keepratio:boolean;
    thumbSharpen:boolean;
    thumbeffect:integer;
    thumbsize:integer;
    thumbshowicon:boolean;
    thumbspace:integer;

    vieweffect:integer;
    ShellTree1width,listview1width,listview1colwidth:integer;
    sortcolumn:integer;
    sortreverseorder:boolean;
    selectmode:boolean;
    viewstyle:integer;

    c_lastworkselect,c_lastselfiletype,c_lastthumbsize:integer;
    c_existmethod:integer;
    c_existnoanswer:boolean;
    c_thumblistarrange:integer;
    c_thumbmaxfilesize,c_thumbbitmapmaxsize:integer;
    c_resize_keepratio:boolean;
    c_resize_method:integer;
    c_viewcolor,c_defaultviewcolor:integer;
    c_vieweffectspeed:integer;
    c_enablefilehint:boolean;
    c_filehintdelay:integer;
    c_showhidden:boolean;

    //print
    c_print_title,c_print_center,c_print_fitpage:boolean;
    c_print_left,c_print_top,c_print_width,c_print_height:integer;
    c_print_max:boolean;
    c_print_zoom:integer;

    c_pixelcolorview:boolean;
    c_thumbpreview:boolean;
    c_thumbpreviewcolor,c_thumbpreviewsize,c_thumbpreviewalpha:integer;

    c_cacheenable2:boolean;
    c_cachetype:integer;
    c_cachelimitcount,c_cachelimitsize2:integer;
    c_displayondrag:integer;

    c_lastfindword:string;
    c_dialogpreview:boolean;
    c_enablerenameclick:boolean;
    c_lastoptactiveindex:integer;

    procedure Initialize;
    procedure LoadFromFile(const FileName: String);
    procedure SaveToFile(const FileName: String);

    procedure setvaluebystring(name,value:string);
    function getvaluebystring(name:string;default:string=''):string;
    procedure setvaluebyinteger(name:string;value:integer);
    function getvaluebyinteger(name:string;default:integer=0):integer;
  end;

var
  Config: TSimpleConfig;

implementation
uses Uregistry, Ufrmmain;

procedure TSimpleConfig.setvaluebystring(name,value:string);
begin
  RegSetString(HKEY_CURRENT_USER,'software\'+thisregname+'\'+name,value);
end;

function TSimpleConfig.getvaluebystring(name:string;default:string=''):string;
begin
  result:=default;
  RegGetString(HKEY_CURRENT_USER,'software\'+thisregname+'\'+name,result);
  lastvalue_string:=result;
end;

procedure TSimpleConfig.setvaluebyinteger(name:string;value:integer);
var
  v:cardinal;
begin
  v:=value;
  RegSetDWORD(HKEY_CURRENT_USER,'software\'+thisregname+'\'+name,v);
end;

function TSimpleConfig.getvaluebyinteger(name:string;default:integer=0):integer;
var
  v:cardinal;
begin
  v:=default;
  RegGetDWORD(HKEY_CURRENT_USER,'software\'+thisregname+'\'+name,v);
  result:=v;
  lastvalue_integer:=result;
end;

procedure TSimpleConfig.Initialize;
begin
  window_left:=10;window_top:=10;window_width:=750;window_height:=450;
  lastpath:='';
  ratio:=100;
  thumbSharpen:=false;
  thumbsize:=100;
  thumbshowicon:=true;
  thumbspace:=30;
  vieweffect:=0;
  ShellTree1width:=180;
  listview1width:=250;
end;

procedure TSimpleConfig.LoadFromFile(const FileName: String);
var
  Ini: TInifile;
  i:integer;
begin
  Ini := TInifile.Create(FileName);
  try try
    window_left:=Ini.ReadInteger('Config', 'window_left', window_left);
    window_top:=Ini.ReadInteger('Config', 'window_top', window_top);
    window_width:=Ini.ReadInteger('Config', 'window_width', window_width);
    window_height:=Ini.ReadInteger('Config', 'window_height', window_height);
    window_max:=Ini.ReadBool('Config', 'window_max', false);
    lastpath:=Ini.ReadString('Config', 'lastpath', lastpath);
    lastdir:=Ini.ReadString('Config', 'lastdir', '');
    c_uselastdir:=Ini.ReadBool('Config', 'c_uselastdir', false);
    ratio:=Ini.ReadInteger('Config', 'ratio', ratio);
    userratio:=Ini.ReadInteger('Config', 'userratio', 100);
    c_keepratio:=Ini.ReadBool('Config', 'c_keepratio', false);
    thumbSharpen:=Ini.ReadBool('Config', 'thumbSharpen', thumbSharpen);
    thumbeffect:=Ini.ReadInteger('Config', 'thumbeffect', 1);
    if (thumbeffect<0) or (thumbeffect>2) then thumbeffect:=1;
    thumbsize:=Ini.ReadInteger('Config', 'thumbsize', thumbsize);
    thumbshowicon:=Ini.ReadBool('Config', 'thumbshowicon', thumbshowicon);
    thumbspace:=Ini.ReadInteger('Config', 'thumbspace', thumbspace);
    vieweffect:=Ini.ReadInteger('Config', 'vieweffect', vieweffect);
    ShellTree1width:=Ini.ReadInteger('Config', 'ShellTree1width', ShellTree1width);
    listview1width:=Ini.ReadInteger('Config', 'listview1width', listview1width);
    listview1colwidth:=Ini.ReadInteger('Config', 'listview1colwidth', 200);

    sortcolumn:=Ini.ReadInteger('Config', 'sortcolumn', 0);
    sortreverseorder:=Ini.ReadBool('Config', 'sortreverseorder', false);
    selectmode:=Ini.ReadBool('Config', 'selectmode', false);
    viewstyle:=Ini.ReadInteger('Config', 'viewstyle', 0);

    c_lastworkselect:=Ini.ReadInteger('Config', 'c_lastworkselect', 0);
    c_lastselfiletype:=Ini.ReadInteger('Config', 'c_lastselfiletype', 0);
    c_lastthumbsize:=Ini.ReadInteger('Config', 'c_lastthumbsize', 0);

    c_existmethod:=Ini.ReadInteger('Config', 'c_existmethod', 0);
    c_existnoanswer:=Ini.ReadBool('Config', 'c_existnoanswer', false);
    c_thumblistarrange:=Ini.ReadInteger('Config', 'c_thumblistarrange', 0);
    c_thumbmaxfilesize:=Ini.ReadInteger('Config', 'c_thumbmaxfilesize', 3);
    c_thumbbitmapmaxsize:=Ini.ReadInteger('Config', 'c_thumbbitmapmaxsize', 7);

    c_resize_keepratio:=Ini.ReadBool('Config', 'c_resize_keepratio', true);
    c_resize_method:=Ini.ReadInteger('Config', 'c_resize_method', 5);
    c_viewcolor:=Ini.ReadInteger('Config', 'c_viewcolor', $000000);
    c_defaultviewcolor:=Ini.ReadInteger('Config', 'c_defaultviewcolor', clBtnFace); //clAppWorkSpace
    c_vieweffectspeed:=Ini.ReadInteger('Config', 'c_vieweffectspeed', 25);
    c_enablefilehint:=Ini.ReadBool('Config', 'c_enablefilehint', true);
    c_filehintdelay:=Ini.ReadInteger('Config', 'c_filehintdelay', 350);
    c_showhidden:=Ini.ReadBool('Config', 'c_showhidden', false);

    c_print_title:=Ini.ReadBool('Config', 'c_print_title', true);
    c_print_center:=Ini.ReadBool('Config', 'c_print_center', true);
    c_print_fitpage:=Ini.ReadBool('Config', 'c_print_fitpage', false);
    c_print_left:=Ini.ReadInteger('Config', 'c_print_left', 0);
    c_print_top:=Ini.ReadInteger('Config', 'c_print_top', 0);
    c_print_width:=Ini.ReadInteger('Config', 'c_print_width', 0);
    c_print_height:=Ini.ReadInteger('Config', 'c_print_height', 0);
    c_print_max:=Ini.ReadBool('Config', 'c_print_max', false);
    c_print_zoom:=Ini.ReadInteger('Config', 'c_print_zoom', 100);

    c_pixelcolorview:=Ini.ReadBool('Config', 'c_pixelcolorview', true);
    c_thumbpreview:=Ini.ReadBool('Config', 'c_thumbpreview', true);
    c_thumbpreviewcolor:=Ini.ReadInteger('Config', 'c_thumbpreviewcolor', clred);
    c_thumbpreviewsize:=Ini.ReadInteger('Config', 'c_thumbpreviewsize', 150);
    c_thumbpreviewalpha:=Ini.ReadInteger('Config', 'c_thumbpreviewalpha', 150);
    c_lastfindword:=ini.ReadString('Config', 'c_lastfindword', '');
    c_dialogpreview:=Ini.ReadBool('Config', 'c_dialogpreview', true);
    c_enablerenameclick:=Ini.ReadBool('Config', 'c_enablerenameclick', true);

    c_cachetype:=Ini.ReadInteger('Config', 'c_cachetype', 0); //0:ũ 1:
    c_cachelimitsize2:=ini.ReadInteger('Config', 'c_cachelimitsize2', 40); //mega
    c_cachelimitcount:=Ini.ReadInteger('Config', 'c_cachelimitcount', 12);
    c_cacheenable2:=Ini.ReadBool('Config', 'c_cacheenable2', true);

    c_displayondrag:=Ini.ReadInteger('Config', 'c_displayondrag', 1);
    c_lastoptactiveindex:=Ini.ReadInteger('Config', 'c_lastoptactiveindex', 0);
  except
  end;
  finally
    Ini.Free;
  end;
end;

procedure TSimpleConfig.SaveToFile(const FileName: String);
var
  Ini: TInifile;
  i:integer;
begin
  ForceDirectories(ExtractFilePath(FileName));
  Ini := TInifile.Create(FileName);
  try try
    Ini.WriteInteger('Config', 'window_left', window_left);
    Ini.WriteInteger('Config', 'window_top', window_top);
    Ini.WriteInteger('Config', 'window_width', window_width);
    Ini.WriteInteger('Config', 'window_height', window_height);
    Ini.WriteBool('Config', 'window_max', window_max);
    Ini.WriteString('Config', 'lastpath', lastpath);
    Ini.WriteString('Config', 'lastdir', lastdir);
    Ini.WriteBool('Config', 'c_uselastdir', c_uselastdir);
    Ini.WriteInteger('Config', 'ratio', ratio);
    Ini.WriteInteger('Config', 'userratio', userratio);
    Ini.WriteBool('Config', 'c_keepratio', c_keepratio);
    Ini.WriteBool('Config', 'thumbSharpen', thumbSharpen);
    Ini.WriteInteger('Config', 'thumbeffect', thumbeffect);
    Ini.WriteInteger('Config', 'thumbsize', thumbsize);
    Ini.WriteBool('Config', 'thumbshowicon', thumbshowicon);
    Ini.WriteInteger('Config', 'thumbspace', thumbspace);
    Ini.WriteInteger('Config', 'vieweffect', vieweffect);
    Ini.WriteInteger('Config', 'ShellTree1width', ShellTree1width);
    Ini.WriteInteger('Config', 'listview1width', listview1width);
    Ini.WriteInteger('Config', 'listview1colwidth', listview1colwidth);

    Ini.WriteInteger('Config', 'sortcolumn', sortcolumn);
    Ini.WriteBool('Config', 'sortreverseorder', sortreverseorder);
    Ini.WriteBool('Config', 'selectmode', selectmode);
    Ini.WriteInteger('Config', 'viewstyle', viewstyle);

    Ini.WriteInteger('Config', 'c_lastworkselect', c_lastworkselect);
    Ini.WriteInteger('Config', 'c_lastselfiletype', c_lastselfiletype);
    Ini.WriteInteger('Config', 'c_lastthumbsize', c_lastthumbsize);

    Ini.WriteInteger('Config', 'c_existmethod', c_existmethod);
    Ini.WriteBool('Config', 'c_existnoanswer', c_existnoanswer);
    Ini.WriteInteger('Config', 'c_thumblistarrange', c_thumblistarrange);
    Ini.WriteInteger('Config', 'c_thumbmaxfilesize', c_thumbmaxfilesize);
    Ini.WriteInteger('Config', 'c_thumbbitmapmaxsize', c_thumbbitmapmaxsize);

    Ini.WriteBool('Config', 'c_resize_keepratio', c_resize_keepratio);
    Ini.WriteInteger('Config', 'c_resize_method', c_resize_method);
    Ini.WriteInteger('Config', 'c_viewcolor', c_viewcolor);
    Ini.WriteInteger('Config', 'c_defaultviewcolor', c_defaultviewcolor);
    Ini.WriteInteger('Config', 'c_vieweffectspeed', c_vieweffectspeed);
    Ini.WriteBool('Config', 'c_enablefilehint', c_enablefilehint);
    Ini.WriteInteger('Config', 'c_filehintdelay', c_filehintdelay);
    Ini.WriteBool('Config', 'c_showhidden', c_showhidden);

    Ini.WriteBool('Config', 'c_print_title', c_print_title);
    Ini.WriteBool('Config', 'c_print_center', c_print_center);
    Ini.WriteBool('Config', 'c_print_fitpage', c_print_fitpage);
    Ini.WriteInteger('Config', 'c_print_left', c_print_left);
    Ini.WriteInteger('Config', 'c_print_top', c_print_top);
    Ini.WriteInteger('Config', 'c_print_width', c_print_width);
    Ini.WriteInteger('Config', 'c_print_height', c_print_height);
    Ini.WriteBool('Config', 'c_print_max', c_print_max);
    Ini.WriteInteger('Config', 'c_print_zoom', c_print_zoom);

    Ini.WriteBool('Config', 'c_pixelcolorview', c_pixelcolorview);
    Ini.WriteBool('Config', 'c_thumbpreview', c_thumbpreview);
    Ini.WriteInteger('Config', 'c_thumbpreviewcolor', c_thumbpreviewcolor);
    Ini.WriteInteger('Config', 'c_thumbpreviewsize', c_thumbpreviewsize);
    Ini.WriteInteger('Config', 'c_thumbpreviewalpha', c_thumbpreviewalpha);
    ini.WriteString('Config', 'c_lastfindword', c_lastfindword);
    Ini.WriteBool('Config', 'c_dialogpreview', c_dialogpreview);
    Ini.WriteBool('Config', 'c_enablerenameclick', c_enablerenameclick);

    Ini.WriteInteger('Config', 'c_cachetype', c_cachetype);
    ini.WriteInteger('Config', 'c_cachelimitsize2', c_cachelimitsize2);
    Ini.WriteInteger('Config', 'c_cachelimitcount', c_cachelimitcount);
    Ini.WriteBool('Config', 'c_cacheenable2', c_cacheenable2);

    Ini.WriteInteger('Config', 'c_displayondrag', c_displayondrag);
    Ini.WriteInteger('Config', 'c_lastoptactiveindex', c_lastoptactiveindex);
  except
  end;
  finally
    Ini.Free;
  end;
end;

initialization
  Config := TSimpleConfig.Create;
  Config.Initialize;

finalization
  Config.Free;

end.

