{

   This program is free software; you can redistribute it and/or
  modify it under the terms of the GNU General Public License
  as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
}
unit Umainhelper;

interface
uses
  Windows, Messages, SysUtils, Dialogs, Variants, Classes, ExtCtrls;

type
  Pnavdata = ^Tnavdata;
  Tnavdata = record
    path:string;
  end;

  Tnavigate = class
  private
    Fonchange:TNotifyEvent;
    procedure clearlist;
  public
    list:tlist;
    position:integer;
    navigating:boolean;

    constructor Create;
    destructor Destroy; override;
    procedure goback;
    procedure goforward;
    procedure addnavigate(path:string);
    procedure gonavigate(idx:integer);
    function getcurrentpath:Pnavdata;
    function getidx(path:string):integer;
  published
    property onchange: TNotifyEvent read Fonchange write Fonchange;
  end;

  Pfavoritedata = ^Tfavoritedata;
  Tfavoritedata = record
    title,path:string;
  end;

  Tfavorite = class
  private
  public
    list:tlist;

    constructor Create;
    destructor Destroy; override;
    procedure load;
    procedure save;
    procedure clearlist;
  end;

  Pcachedata = ^Tcachedata;
  Tcachedata = record
    filename:string;
    stream:tmemorystream;
    fileage:integer;
    isgif:boolean;
    desc:string;
  end;

  Timgcache = class
  private
    totsize:int64;
    procedure clearlist;
  public
    list:tlist;

    constructor Create;
    destructor Destroy; override;
    procedure addcache(data:Pcachedata);
    function findcache(filename:string):Pcachedata;
    procedure clear;
    function gettotsize:int64;
  end;
{
  Pimgconfrec = ^Timgconfrec;
  Timgconfrec = record
    filename:string;
    transform:integer;
  end;

  Timgconfig = class
  private
    procedure clearlist;
  public
    list:tlist;
    lastpath:string;

    constructor Create;
    destructor Destroy; override;
    procedure load(dir:string);
    procedure save(dir:string);
    procedure addconfig_transform(filename:string;transform:integer);
    function getconfig_transform(filename:string):Pimgconfrec;
  end;
}
var
  navigate:Tnavigate;
  favorite:Tfavorite;
  imgcache:Timgcache;

implementation

uses Ufunction, Uconfig;

{Timgconfig}
{
constructor Timgconfig.Create;
begin
  list:=tlist.Create;
end;

destructor Timgconfig.Destroy;
begin
  clearlist;
  list.Free;
end;

procedure Timgconfig.clearlist;
var
  data:Pimgconfrec;
  i:integer;
begin
  for i:=0 to list.Count-1 do begin
    data:=Pimgconfrec(list.Items[i]);
    dispose(data);
  end;
  list.Clear;
end;

procedure Timgconfig.load(dir:string);
var
  s:string;
  strlist,strlist2:tstringlist;
  i:integer;
  data:Pimgconfrec;
begin
  clearlist;
  dir:=trim(dir);
  if dir='' then exit;
  if dir[length(dir)]<>'\' then dir:=dir+'\';
  s:=dir+'nviewconfig.dat';
  if sysutils.FileExists(s)=false then exit;
  strlist:=tstringlist.Create;
  strlist2:=tstringlist.Create;
  try
    strlist.LoadFromFile(s);
    for i:=0 to strlist.Count-1 do begin
      s:=strlist.Strings[i];
      strlist2.Clear;
      SplitString(s,strlist2,#1);
      if strlist2.Count<>2 then continue;
      new(data);
      data.filename:=strlist2.Strings[0];
      data.transform:=strtointdef(strlist2.Strings[1],-1);
      list.Add(data);
    end;
  finally
    strlist.Free;
    strlist2.Free;
  end;
end;

procedure Timgconfig.save(dir:string);
var
  i:integer;
  data:Pimgconfrec;
  s,s1:string;
  strlist:Tstringlist;
begin
  if list.Count=0 then exit;
  dir:=trim(dir);
  if dir='' then exit;
  if dir[length(dir)]<>'\' then dir:=dir+'\';
  s:=dir+'nviewconfig.dat';
  strlist:=Tstringlist.Create;
  try
    for i:=0 to list.Count-1 do begin
      data:=Pimgconfrec(list.Items[i]);
      s1:=data.filename+#1+inttostr(data.transform);
      strlist.Add(s1);
    end;
    strlist.SaveToFile(s);
  finally
    strlist.Free;
  end;
end;

procedure Timgconfig.addconfig_transform(filename:string;transform:integer);
var
  i:integer;
  data:Pimgconfrec;
begin
  filename:=sysutils.ExtractFileName(filename);
  for i:=0 to list.Count-1 do begin
    data:=Pimgconfrec(list.Items[i]);
    if comparetext(data.filename,filename)=0 then begin
      data.transform:=transform;
      exit;
    end;
  end;
  new(data);
  data.filename:=filename;
  data.transform:=transform;
  list.Add(data);
end;

function Timgconfig.getconfig_transform(filename:string):Pimgconfrec;
var
  i:integer;
  data:Pimgconfrec;
begin
  result:=nil;
  filename:=sysutils.ExtractFileName(filename);
  for i:=0 to list.Count-1 do begin
    data:=Pimgconfrec(list.Items[i]);
    if comparetext(data.filename,filename)=0 then begin
      result:=data;
      break;
    end;
  end;
end;
}
{Timgcache}
constructor Timgcache.Create;
begin
  list:=tlist.Create;
  totsize:=0;
end;

destructor Timgcache.Destroy;
begin
  clearlist;
  list.Free;
end;

procedure Timgcache.clearlist;
var
  data:Pcachedata;
  i:integer;
begin
  for i:=0 to list.Count-1 do begin
    data:=Pcachedata(list.Items[i]);
    data.stream.Free;
    dispose(data);
  end;
  list.Clear;
  totsize:=0;
end;

procedure Timgcache.clear;
begin
  clearlist;
end;

function Timgcache.gettotsize:int64;
begin
  result:=self.totsize;
end;

procedure Timgcache.addcache(data:Pcachedata);
var
  data2:Pcachedata;
begin
  if config.c_cachetype=1 then begin
    if list.Count>config.c_cachelimitcount then begin
      data2:=Pcachedata(list.Items[0]);
      totsize:=totsize-data2.stream.Size;
      if totsize<0 then totsize:=0;
      data2.stream.Free;
      list.Delete(0);
    end;
  end else begin
    while totsize>(config.c_cachelimitsize2*1024*1024) do begin
      if list.Count=0 then break;
      data2:=Pcachedata(list.Items[0]);
      totsize:=totsize-data2.stream.Size;
      if totsize<0 then totsize:=0;
      data2.stream.Free;
      list.Delete(0);
    end;
  end;
  list.Add(data);
  totsize:=totsize+data.stream.Size;
end;

function Timgcache.findcache(filename:string):Pcachedata;
var
  i:integer;
  data:Pcachedata;
  t:integer;
begin
  result:=nil;
  if config.c_cacheenable2=false then exit;
  t:=sysutils.FileAge(filename);
  for i:=0 to list.Count-1 do begin
    data:=Pcachedata(list.Items[i]);
    if (comparetext(data.filename,filename)=0) and (data.fileage=t) then begin
      result:=data;
      break;
    end;
  end;
end;

{Tnavigate}
constructor Tnavigate.Create;
var
  strlist,strlist2:tstringlist;
  navdata:Pnavdata;
  s:String;
  i:integer;
begin
  position:=-1;
  navigating:=false;
  list:=tlist.Create;
{
  strlist:=tstringlist.Create;
  strlist2:=tstringlist.Create;
  try
    if sysutils.FileExists(GetAppDirectory+'navigate.dat')=false then exit;
    strlist.LoadFromFile(GetAppDirectory+'navigate.dat');
    for i:=0 to strlist.Count-2 do begin
      strlist2.Clear;
      SplitString(strlist.Strings[i],strlist2,#1);
      if strlist2.Count<>1 then continue;
      new(navdata);
      navdata.path:=strlist2.Strings[0];
      list.Add(navdata);
    end;
    position:=strtointdef(strlist.Strings[strlist.Count-1],list.Count-1);
  finally
    strlist.Free;
    strlist2.Free;
  end;}
end;

destructor Tnavigate.Destroy;
var
  i:integer;
  strlist:tstringlist;
  navdata:Pnavdata;
  s:String;
begin
{  strlist:=tstringlist.Create;
  try
    for i:=0 to list.Count-1 do begin
      navdata:=Pnavdata(list.Items[i]);
      s:=navdata.path;
      strlist.Add(s);
    end;
    strlist.Add(inttostr(position));
    strlist.SaveToFile(GetAppDirectory+'navigate.dat');
  finally
    strlist.Free;
  end;}
  clearlist;
  list.Free;
end;

procedure Tnavigate.clearlist;
var
  i:integer;
begin
  for i:=0 to list.Count-1 do
    dispose(Pnavdata(list.Items[i]));
  list.Clear;
end;

procedure Tnavigate.goback;
begin
  dec(position);
  if position<0 then position:=0;
  if assigned(Fonchange) then Fonchange(self);
end;

procedure Tnavigate.goforward;
begin
  inc(position);
  if position>list.Count-1 then position:=list.Count-1;
  if assigned(Fonchange) then Fonchange(self);
end;

procedure Tnavigate.gonavigate(idx:integer);
begin
  position:=idx;
  if assigned(Fonchange) then Fonchange(self);
end;

procedure Tnavigate.addnavigate(path:string);
var
  navdata:Pnavdata;
  i:integer;
begin
  if navigating then exit;
  for i:=list.Count-1 downto position+1 do begin
    dispose(Pnavdata(list.Items[i]));
    list.Delete(i);
  end;
  new(navdata);
  navdata.path:=path;
  list.Add(navdata);
  position:=list.Count-1;
  if assigned(Fonchange) then Fonchange(self);
end;

function Tnavigate.getcurrentpath:Pnavdata;
begin
  result:=Pnavdata(list.Items[position]);
end;

function Tnavigate.getidx(path:string):integer;
var
  i:integer;
begin
  result:=-1;
  for i:=0 to list.Count-1 do
    if comparetext(Pnavdata(list.Items[i]).path,path)=0 then begin
       result:=i;
       break;
    end;
end;

{Tfavorite}
constructor Tfavorite.Create;
begin
  list:=tlist.Create;
  load;
end;

destructor Tfavorite.Destroy;
begin
  clearlist;
  list.Free;
end;

procedure Tfavorite.clearlist;
var
  i:integer;
begin
  for i:=0 to list.Count-1 do
    dispose(Pfavoritedata(list.Items[i]));
  list.Clear;
end;

procedure Tfavorite.load;
var
  strlist,strlist2:tstringlist;
  i:integer;
  s:String;
  data:Pfavoritedata;
begin
  strlist:=tstringlist.Create;
  strlist2:=tstringlist.Create;
  try
    s:=GetAppDirectory+'favorite.dat';
    if sysutils.FileExists(s)=false then exit;
    strlist.LoadFromFile(s);
    for i:=0 to strlist.Count-1 do begin
      strlist2.Clear;
      SplitString(strlist.Strings[i],strlist2,#1);
      if strlist2.Count<>2 then continue;
      new(data);
      data.title:=strlist2.Strings[0];
      data.path:=strlist2.Strings[1];
      list.Add(data);
    end;
  finally
    strlist.Free;
    strlist2.Free;
  end;
end;

procedure Tfavorite.save;
var
  strlist:tstringlist;
  i:integer;
  s:String;
  data:Pfavoritedata;
begin
  strlist:=tstringlist.Create;
  try
    for i:=0 to list.Count-1 do begin
      data:=Pfavoritedata(list.Items[i]);
      s:=data.title+#1+data.path;
      strlist.Add(s);
    end;
    s:=GetAppDirectory+'favorite.dat';
    strlist.SaveToFile(s);
  finally
    strlist.Free;
  end;
end;

end.
