unit UAdobeFrame;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  Couleur, ComCtrls, StdCtrls, ExtCtrls, Spin;

const  
  RectGAdobe: TRect = (Left:35;Top:16;right:35+256;bottom:16+7);

  RectRAdobe: TRect = (Left:35;Top:65;Right:35+256;Bottom:65+7);
  RectVAdobe: TRect = (Left:35;Top:89;Right:35+256;Bottom:89+7);
  RectBAdobe: TRect = (Left:35;Top:113;right:35+256;bottom:113+7);

  RectTAdobe: TRect = (Left:35;Top:160;Right:35+256;Bottom:160+7);
  RectSAdobe: TRect = (Left:35;Top:185;Right:35+256;Bottom:185+7);
  RectLAdobe: TRect = (Left:35;Top:209;right:35+256;bottom:209+7);
  RectCoul : TRect =(Left:1;Top:333;right:347;bottom:360);

type
  TLigne = array of byte;
  TClicZoneAdobe = (CZAdobeNone,CZAdobeG,CZAdobeR,CZAdobeV,CZAdobeB,CZAdobeT,CZAdobeS,CZAdobeL);


  TFrameAdobe = class(TFrame)
    SpGAdobe: TSpinEdit;
    SpRAdobe: TSpinEdit;
    SpVAdobe: TSpinEdit;
    SpBAdobe: TSpinEdit;
    SpTAdobe: TSpinEdit;
    SpSAdobe: TSpinEdit;
    SpLAdobe: TSpinEdit;
    ImageFond: TImage;
    Edit1: TEdit;
    procedure ImageFondMouseDown(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure ImageFondMouseUp(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure SpGAdobeKeyDown(Sender: TObject; var Key: Word;
      Shift: TShiftState);
    procedure SpGAdobeKeyPress(Sender: TObject; var Key: Char);
    procedure SpGAdobeChange(Sender: TObject);
    procedure SpRVBAdobeChange(Sender: TObject);
    procedure SpTSLAdobeChange(Sender: TObject);
    procedure ImageFondMouseMove(Sender: TObject; Shift: TShiftState; X,
      Y: Integer);
  private
    { Dclarations prives }
    RVB_ : TRVB;
    G : integer;
    _G : integer;
    ClickImg : TClicZoneAdobe;
    Tri : TRVB;
    Gris : Byte;
    procedure DrawAdobeRVB;
    procedure DrawAdobeTSL;
    procedure DrawTriangleGris;
    procedure DrawGris;
    procedure Calculate;
    function ClickDans(const R : TRect;X,Y : Integer) : Boolean;
    procedure DesactiveOnChange;
    procedure ActiveOnChange;
    procedure MAJValeur;
    procedure GestionSouris(X,Y : Integer);
    procedure DrawTriangle;
    procedure DrawCoul;
  public
    { Dclarations publiques }
    Couleur : TCouleur;
    procedure HideTriAngle;
    procedure InitAdobe;
    procedure CreateFrame;
    procedure FreeFrame;
    procedure MAJCoul;
  end;

implementation

{$R *.dfm}

{ TFrameAdobe }

procedure TFrameAdobe.CreateFrame;
var
  Temp : TRVB;
begin
  Couleur := TCouleur.Create;
  Temp.R := 0;
  Temp.V := 0;
  Temp.B := 0;
  Couleur.RVB := Temp;
  Brush.Style := bsClear;
end;

procedure TFrameAdobe.DrawCoul;
begin
  ImageFond.Canvas.Brush.Color := Couleur.Color;
  ImageFond.Canvas.Pen.Color := Couleur.Color;
  Rectangle(ImageFond.Canvas.Handle,RectCoul.Left,RectCoul.Top,RectCoul.Right+1,RectCoul.Bottom+1);
end;

procedure TFrameAdobe.DrawAdobeRVB;
var
  I, J : Integer;
  PLigneR : pointer;
  PLigneV : pointer;
  PLigneB : pointer;
  PLigneR2 : pointer;
  PLigneV2 : pointer;
  PLigneB2 : pointer;
  T1,T2,T3 :TLigne;
  T1_,T2_,T3_ :TLigne;

begin
  PLigneR := ImageFond.Picture.Bitmap.ScanLine[RectRAdobe.Top];
  PLigneV := ImageFond.Picture.Bitmap.ScanLine[RectVAdobe.Top];
  PLigneB := ImageFond.Picture.Bitmap.ScanLine[RectBAdobe.Top];
  T1 := TLigne(@TLigne(PLigneR)[RectRAdobe.Left*3]);
  T2 := TLigne(@TLigne(PLigneV)[RectVAdobe.Left*3]);
  T3 := TLigne(@TLigne(PLigneB)[RectBAdobe.Left*3]);
  for I := 0 to 255 do
  begin
    T1[I*3] := Couleur.RVB.B; //B
    T1[I*3 + 1] := Couleur.RVB.V; //V
    T1[I*3 + 2] := I;//R
//    Adobe RVB Vert
    T2[I*3] := Couleur.RVB.B; //B
    T2[I*3 + 1] := I; //V
    T2[I*3 + 2] := Couleur.RVB.R;//R
//    Adobe RVB Bleu
    T3[I*3] := I; //B
    T3[I*3 + 1] := Couleur.RVB.V; //V
    T3[I*3 + 2] := Couleur.RVB.R;//R
  end;

  for J := 1 to 6 do
  begin
    PLigneR2 := ImageFond.Picture.Bitmap.ScanLine[RectRAdobe.Top+J];
    PLigneV2 := ImageFond.Picture.Bitmap.ScanLine[RectVAdobe.Top+J];
    PLigneB2 := ImageFond.Picture.Bitmap.ScanLine[RectBAdobe.Top+J];

    T1_ := TLigne(@TLigne(PLigneR2)[RectRAdobe.Left*3]);;
    T2_ := TLigne(@TLigne(PLigneV2)[RectVAdobe.Left*3]);;
    T3_ := TLigne(@TLigne(PLigneB2)[RectBAdobe.Left*3]);;

    Move(T1[0],T1_[0],256*3);
    Move(T2[0],T2_[0],256*3);
    Move(T3[0],T3_[0],256*3);
  end;
end;

procedure TFrameAdobe.DrawAdobeTSL;
var
  I, J : Integer;
  Coul : TCouleur;
  TSV : TTSV;
  PLigneT : pointer;
  PLigneS : pointer;
  PLigneL : pointer;
  PLigneT2 : pointer;
  PLigneS2 : pointer;
  PLigneL2 : pointer;
  T1,T2,T3 :TLigne;
  T1_,T2_,T3_ :TLigne;
begin
//  S := 0.1;
//  L := 0.5;
  Coul := TCouleur.Create;
  PLigneT := ImageFond.Picture.Bitmap.ScanLine[RectTAdobe.Top];
  PLigneS := ImageFond.Picture.Bitmap.ScanLine[RectSAdobe.Top];
  PLigneL := ImageFond.Picture.Bitmap.ScanLine[RectLAdobe.Top];
  T1 := TLigne(@TLigne(PLigneT)[RectTAdobe.Left*3]);
  T2 := TLigne(@TLigne(PLigneS)[RectSAdobe.Left*3]);
  T3 := TLigne(@TLigne(PLigneL)[RectLAdobe.Left*3]);

  for I := 0 to 255 do
  begin
    Coul.Assign(Couleur);

    TSV.T := round(359*I/255);//360
    TSV.S := 100;
    TSV.V := 100;
    Coul.TSV := TSV;
    //Teinte
    T1[I*3] := Coul.RVB.B;
    T1[I*3 + 1] := Coul.RVB.V;
    T1[I*3 + 2] := Coul.RVB.R;

    //Saturation
    TSV := Couleur.TSV;
    TSV.S := 100*I/255;
    Coul.TSV := TSV;
    T2[I*3] := Coul.RVB.B;
    T2[I*3 + 1] := Coul.RVB.V;
    T2[I*3 + 2] := Coul.RVB.R;

    //Variation
    TSV := Couleur.TSV;
    TSV.V := 100*I/255;
    Coul.TSV := TSV;
    T3[I*3] := Coul.RVB.B;
    T3[I*3 + 1] := Coul.RVB.V;
    T3[I*3 + 2] := Coul.RVB.R;
  end;
  for J := 0 to 6 do
  begin
    PLigneT2 := ImageFond.Picture.Bitmap.ScanLine[RectTAdobe.Top+J];
    PLigneS2 := ImageFond.Picture.Bitmap.ScanLine[RectSAdobe.Top+J];
    PLigneL2 := ImageFond.Picture.Bitmap.ScanLine[RectLAdobe.Top+J];
    T1_ := TLigne(@TLigne(PLigneT2)[RectTAdobe.Left*3]);;
    T2_ := TLigne(@TLigne(PLigneS2)[RectSAdobe.Left*3]);;
    T3_ := TLigne(@TLigne(PLigneL2)[RectLAdobe.Left*3]);;

    Move(T1[0],T1_[0],256*3);
    Move(T2[0],T2_[0],256*3);
    Move(T3[0],T3_[0],256*3);
  end;
  Coul.Free;
end;

procedure TFrameAdobe.DrawGris;
var
  I, J : Integer;
  PLigneG : pointer;
  PLigne : pointer;
  L1,L2 : TLigne;
begin
  PLigneG := ImageFond.Picture.Bitmap.ScanLine[RectGAdobe.Top];
  L1 := TLigne(@TLigne(PLigneG)[RectGAdobe.Left*3]);
  for I := 0 to 255 do
  begin
//    Adobe RVB Rouge
    L1[I*3    ] := I;
    L1[I*3 + 1] := I;
    L1[I*3 + 2] := I;
  end;
  for J := 1 to 6 do
  begin
    PLigne := ImageFond.Picture.Bitmap.ScanLine[RectGAdobe.Top+J];
    L2 := TLigne(@TLigne(PLigne)[RectGAdobe.Left*3]);;
    Move(L1[0],L2[0],256*3);
  end;
end;

procedure TFrameAdobe.DrawTriangle;
  procedure DrawTri(X,Y : Integer);
  var
    PLigne1 : pointer;
    PLigne2 : pointer;
    PLigne3: pointer;
    PLigne4: pointer;
    PLigne5: pointer;
    PLigne6: pointer;
    T1,T2,T3,T4,T5,T6 :TLigne;
    I : Integer;
  begin
    PLigne1 := ImageFond.Picture.Bitmap.ScanLine[Y];
    PLigne2 := ImageFond.Picture.Bitmap.ScanLine[Y+1];
    PLigne3 := ImageFond.Picture.Bitmap.ScanLine[Y+2];
    PLigne4 := ImageFond.Picture.Bitmap.ScanLine[Y+3];
    PLigne5 := ImageFond.Picture.Bitmap.ScanLine[Y+4];
    PLigne6 := ImageFond.Picture.Bitmap.ScanLine[Y+5];
    T1 := TLigne(PLigne1);
    T1[X*3]:=Tri.B;
    T1[(X*3)+1]:=Tri.V;
    T1[(X*3)+2]:=Tri.R;
    T2 := TLigne(PLigne2);
    T2[(X-1)*3]:=Tri.B;
    T2[(X-1)*3+1]:=Tri.V;
    T2[(X-1)*3+2]:=Tri.R;
    T2[(X+1)*3]:=Tri.B;
    T2[(X+1)*3+1]:=Tri.V;
    T2[(X+1)*3+2]:=Tri.R;
    T3 := TLigne(PLigne3);
    T3[(X-2)*3]:=Tri.B;
    T3[(X-2)*3+1]:=Tri.V;
    T3[(X-2)*3+2]:=Tri.R;
    T3[(X+2)*3]:=Tri.B;
    T3[(X+2)*3+1]:=Tri.V;
    T3[(X+2)*3+2]:=Tri.R;
    T4 := TLigne(PLigne4);
    T4[(X-3)*3]:=Tri.B;
    T4[(X-3)*3+1]:=Tri.V;
    T4[(X-3)*3+2]:=Tri.R;
    T4[(X+3)*3]:=Tri.B;
    T4[(X+3)*3+1]:=Tri.V;
    T4[(X+3)*3+2]:=Tri.R;
    T5 := TLigne(PLigne5);
    T5[(X-4)*3]:=Tri.B;
    T5[(X-4)*3+1]:=Tri.V;
    T5[(X-4)*3+2]:=Tri.R;
    T5[(X+4)*3]:=Tri.B;
    T5[(X+4)*3+1]:=Tri.V;
    T5[(X+4)*3+2]:=Tri.R;
    T6 := TLigne(PLigne6);
    for I := -5 to 5 do
    begin
      T6[(X+I)*3]:=Tri.B;
      T6[(X+I)*3+1]:=Tri.V;
      T6[(X+I)*3+2]:=Tri.R;
    end;
  end;
begin
  //RVB
  DrawTri(RectRAdobe.Left+Couleur.RVB.R,RectRAdobe.Bottom+1);
  DrawTri(RectVAdobe.Left+Couleur.RVB.V,RectVAdobe.Bottom+1);
  DrawTri(RectBAdobe.Left+Couleur.RVB.B,RectBAdobe.Bottom+1);
  //TSV
  DrawTri(RectRAdobe.Left+Round(255*Couleur.TSV.T/359),RectTAdobe.Bottom+1);//360
  DrawTri(RectVAdobe.Left+Round(255*Couleur.TSV.S/100),RectSAdobe.Bottom+1);
  DrawTri(RectBAdobe.Left+Round(255*Couleur.TSV.V/100),RectLAdobe.Bottom+1);

end;

procedure TFrameAdobe.FreeFrame;
begin
  Couleur.Free;
end;

procedure TFrameAdobe.InitAdobe;
  procedure drawContour(R : TRect; T : string);
  var
    RT : TRect;
  begin
    ImageFond.Canvas.Pen.Color := clwhite;
    Rectangle(ImageFond.Canvas.Handle,R.Left+1,R.Top+7,R.Right,R.Bottom);
    ImageFond.Canvas.Pen.Color := ColorToRGB(clAppWorkSpace);
    Rectangle(ImageFond.Canvas.Handle,R.Left,R.Top+6,R.Right-1,R.Bottom-1);
    ImageFond.Canvas.Brush.Style := bsSolid;
    ImageFond.Canvas.Brush.Color := ColorToRGB(clBtnFace);
    RT := Rect(R.Left+10,R.Top,Left+11+ImageFond.Canvas.TextWidth(T),R.Top+20);
    DrawText(ImageFond.Canvas.Handle,PChar(T),Length(T),RT,DT_LEFT+DT_TOP);
    ImageFond.Canvas.Brush.Style := bsClear;
  end;

  procedure drawContour2(R : TRect;C : TCanvas);
  begin
    C.Brush.Style := bsClear;
    C.Pen.Color := $FFFFFF;
    Rectangle(C.Handle,R.Left-2,R.Top-2,R.Right+3,R.Bottom+3);
    C.Pen.Color := $808080;
    Rectangle(C.Handle,R.Left-2,R.Top-2,R.Right+2,R.Bottom+2);
    C.Pen.Color := $FFFFFF;
    Rectangle(C.Handle,R.Left-1,R.Top-1,R.Right+3,R.Bottom+3);
    C.Pen.Color := $0;
    Rectangle(C.Handle,R.Left-1,R.Top-1,R.Right+2,R.Bottom+2);
  end;

var
  Temp : TRVB;
  R : TRect;
begin
  ClickImg := CZAdobeNone;
  Edit1.Text := IntToStr(GettickCount);
  ImageFond.Picture.Bitmap.Width := ImageFond.Width;
  ImageFond.Picture.Bitmap.Height := ImageFond.Height;
  ImageFond.Picture.Bitmap.PixelFormat := pf24bit;
  ImageFond.Canvas.Pen.Color := ColorToRGB(clBtnFace);
  ImageFond.Canvas.Brush.Color := ColorToRGB(clBtnFace);
  Rectangle(ImageFond.Canvas.Handle,0,0,ImageFond.Width,ImageFond.Height);
  ImageFond.Canvas.Brush.Style := bsClear;
  R := Rect(16,13,24,30);
  DrawText(ImageFond.Canvas.Handle,'G',1,R,DT_CENTER);
  R := Rect(16,62,24,80);
  DrawText(ImageFond.Canvas.Handle,'R',1,R,DT_CENTER);
  R := Rect(16,86,24,100);
  DrawText(ImageFond.Canvas.Handle,'V',1,R,DT_CENTER);
  R := Rect(16,110,24,130);
  DrawText(ImageFond.Canvas.Handle,'B',1,R,DT_CENTER);
  R := Rect(16,157,24,175);
  DrawText(ImageFond.Canvas.Handle,'T',1,R,DT_CENTER);
  R := Rect(16,182,24,196);
  DrawText(ImageFond.Canvas.Handle,'S',1,R,DT_CENTER);
  R := Rect(16,206,24,230);
  DrawText(ImageFond.Canvas.Handle,'L',1,R,DT_CENTER);
  drawContour(Rect(0,0,350,38), '');
  drawContour(Rect(0,39,350,135), 'RGB ');
  drawContour(Rect(0,135,350,231), 'HSL ');
  drawContour2(RectCoul,ImageFond.Canvas);
  Temp.R := 0;
  Temp.V := 0;
  Temp.B := 0;
  Tri := Temp;
  Couleur.RVB := Temp;
  DrawGris;
  Calculate;
  Edit1.Text := IntToStr(GettickCount - StrToInt(Edit1.Text));
end;

procedure TFrameAdobe.Calculate;
begin
  DrawAdobeRVB();
  DrawAdobeTSL();
  DrawTriangle();
  DrawTriangleGris;
  DrawCoul;
  ImageFond.Picture.Bitmap.Modified := True;
end;

procedure TFrameAdobe.ImageFondMouseDown(Sender: TObject;
  Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
begin
  if ClickDans(RectGAdobe,X,Y) then
    ClickImg := CZAdobeG
  else if ClickDans(RectRAdobe,X,Y) then
    ClickImg := CZAdobeR
  else if ClickDans(RectVAdobe,X,Y) then
    ClickImg := CZAdobeV
  else if ClickDans(RectBAdobe,X,Y) then
    ClickImg := CZAdobeB
  else if ClickDans(RectTAdobe,X,Y) then
    ClickImg := CZAdobeT
  else if ClickDans(RectSadobe,X,Y) then
    ClickImg := CZAdobeS
  else if ClickDans(RectLAdobe,X,Y) then
    ClickImg := CZAdobeL
  else
    ClickImg := CZAdobeNone;
  GestionSouris(X,Y);
end;

function TFrameAdobe.ClickDans(const R: TRect;X,Y : Integer): Boolean;
begin
  Result := ((X>=R.Left)and(X<=R.Right))and((Y>=R.Top)and(Y<=R.Bottom));
end;

procedure TFrameAdobe.ImageFondMouseUp(Sender: TObject;
  Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
begin
  if mbLeft=Button then
    GestionSouris(X,Y);
  ClickImg := CZAdobeNone;
end;

procedure TFrameAdobe.SpGAdobeKeyDown(Sender: TObject; var Key: Word;
  Shift: TShiftState);
begin
  if Key = VK_SUBTRACT then
    Key := 0;
end;

procedure TFrameAdobe.SpGAdobeKeyPress(Sender: TObject; var Key: Char);
begin
  if (Key='-')or(Key='+') then
    Key := #0;
end;

procedure TFrameAdobe.SpGAdobeChange(Sender: TObject);
var
  RVB : TRVB;
begin
  if TSpinEdit(Sender).Text<>'' then
  begin
    HideTriAngle;
    if TSpinEdit(Sender).Value > 255 then
      TSpinEdit(Sender).Value := 255;
    RVB.R := SpGAdobe.Value;
    RVB.V:= SpGAdobe.Value;
    RVB.B:= SpGAdobe.Value;
    Couleur.RVB := RVB;
    DesactiveOnChange ;
    SpRAdobe.Value := Couleur.RVB.R;
    SpVAdobe.Value := Couleur.RVB.V;
    SpBAdobe.Value:= Couleur.RVB.B;
    SpTAdobe.Value:= Couleur.TSV.T;
    Gris := RVB.R;
    SpSAdobe.Value:= Round(Couleur.TSV.S);
    SpLAdobe.Value:= Round(Couleur.TSV.V);
    ActiveOnChange;

    Calculate;
  end;
end;

procedure TFrameAdobe.DesactiveOnChange;
begin
  SpGAdobe.OnChange := nil;
  SpRAdobe.OnChange := nil;
  SpVAdobe.OnChange := nil;
  SpBAdobe.OnChange := nil;
  SpTAdobe.OnChange := nil;
  SpSAdobe.OnChange := nil;
  SpLAdobe.OnChange := nil;
end;

procedure TFrameAdobe.ActiveOnChange;
begin
  SpGAdobe.Modified := true;
  SpRAdobe.Modified := true;
  SpVAdobe.Modified := true;
  SpBAdobe.Modified := true;
  SpTAdobe.Modified := true;
  SpSAdobe.Modified := true;
  SpLAdobe.Modified := true;



  SpGAdobe.OnChange := SpGAdobeChange;
  SpRAdobe.OnChange := SpRVBAdobeChange;
  SpVAdobe.OnChange := SpRVBAdobeChange;
  SpBAdobe.OnChange := SpRVBAdobeChange;
  SpTAdobe.OnChange := SpTSLAdobeChange;
  SpSAdobe.OnChange := SpTSLAdobeChange;
  SpLAdobe.OnChange := SpTSLAdobeChange;
end;

procedure TFrameAdobe.SpRVBAdobeChange(Sender: TObject);
var
  RVB : TRVB;
begin
  if TSpinEdit(Sender).Text<>'' then
  begin
    HideTriAngle;
    if TSpinEdit(Sender).Value > 255 then
      TSpinEdit(Sender).Value := 255;
    RVB.R := SpRAdobe.Value;
    RVB.V:= SpVAdobe.Value;
    RVB.B:= SpBAdobe.Value;
    Couleur.RVB := RVB;
    DesactiveOnChange ;
    SpTAdobe.Value:= Couleur.TSV.T;
    SpSAdobe.Value:= Round(Couleur.TSV.S);
    SpLAdobe.Value:= Round(Couleur.TSV.V);
    ActiveOnChange;
    Calculate;
  end;
end;

procedure TFrameAdobe.SpTSLAdobeChange(Sender: TObject);
var
  TSV : TTSV;
begin
  if TSpinEdit(Sender).Text<>'' then
  begin
    HideTriAngle;
    if TSpinEdit(Sender).Value >TSpinEdit(Sender).MaxValue  then
      TSpinEdit(Sender).Value := TSpinEdit(Sender).MaxValue;
    TSV.T := SpTAdobe.Value;
    TSV.S := SpSAdobe.Value;
    TSV.V := SpLAdobe.Value;
    Couleur.TSV:= TSV;
    DesactiveOnChange ;
    SpRAdobe.Value := Couleur.RVB.R;
    SpVAdobe.Value := Couleur.RVB.V;
    SpBAdobe.Value:= Couleur.RVB.B;
    ActiveOnChange;
    Calculate;
  end;
end;

procedure TFrameAdobe.ImageFondMouseMove(Sender: TObject;
  Shift: TShiftState; X, Y: Integer);
begin
  GestionSouris(X,Y);
end;

procedure TFrameAdobe.MAJValeur;
begin
  if (Couleur.RVB.R = Couleur.RVB.V)and(Couleur.RVB.R = Couleur.RVB.B) then
    Gris := Couleur.RVB.R;
  SpGAdobe.Value := Gris;
  SpRAdobe.Value := Couleur.RVB.R;
  SpVAdobe.Value := Couleur.RVB.V;
  SpBAdobe.Value:= Couleur.RVB.B;
  SpTAdobe.Value:= Couleur.TSV.T;
  SpSAdobe.Value:= Round(Couleur.TSV.S);
  SpLAdobe.Value:= Round(Couleur.TSV.V);
end;

procedure TFrameAdobe.HideTriAngle;
begin
  Tri.R := ColorToRGB(clBtnFace)and $FF;
  Tri.V := (ColorToRGB(clBtnFace)shr 8) and $FF;
  Tri.B := (ColorToRGB(clBtnFace)shr 16) and $FF;
  DrawTriangle;
  DrawTriangleGris;
  Tri.R := 0;
  Tri.V := 0;
  Tri.B := 0;
end;

procedure TFrameAdobe.GestionSouris(X, Y: Integer);
var
  RVB : TRVB;
  TSV : TTSV;
  C_X,C_Y : Integer;
begin
  case ClickImg of
    CZAdobeG : begin
      C_X := X;
      C_Y := Y;
      if C_X<RectGAdobe.Left then
        C_X:= RectGAdobe.Left
      else
      if C_X>RectGAdobe.Right-1 then
        C_X:= RectGAdobe.Right-1;
      HideTriAngle;
      RVB.R := C_X - RectGAdobe.Left;
      RVB.V := RVB.R;
      RVB.B := RVB.R;
      Couleur.RVB := RVB;
      Gris := RVB.R;
      MAJCoul;
    end;
    CZAdobeR : begin
      C_X := X;
      C_Y := Y;
      if C_X<RectRAdobe.Left then
        C_X:= RectRAdobe.Left
      else
      if C_X>RectRAdobe.Right-1 then
        C_X:= RectRAdobe.Right-1;
      HideTriAngle;
      RVB.R := C_X - RectRAdobe.Left;
      RVB.V := Couleur.RVB.V;
      RVB.B := Couleur.RVB.B;
      Couleur.RVB := RVB;
      MAJCoul;
    end;
    CZAdobeV : begin
      C_X := X;
      C_Y := Y;
      if C_X<RectVAdobe.Left then
        C_X:= RectVAdobe.Left
      else
      if C_X>RectVAdobe.Right-1 then
        C_X:= RectVAdobe.Right-1;
      HideTriAngle;
      RVB.R := Couleur.RVB.R;
      RVB.V := C_X - RectVAdobe.Left;
      RVB.B := Couleur.RVB.B;
      Couleur.RVB := RVB;
      MAJCoul;
    end;
    CZAdobeB : begin
      C_X := X;
      C_Y := Y;
      if C_X<RectBAdobe.Left then
        C_X:= RectBAdobe.Left
      else
      if C_X>RectBAdobe.Right-1 then
        C_X:= RectBAdobe.Right-1;
      HideTriAngle;
      RVB.R := Couleur.RVB.R;
      RVB.V := Couleur.RVB.V;
      RVB.B := C_X - RectBAdobe.Left;
      Couleur.RVB := RVB;
      MAJCoul;
    end;
    CZAdobeT : begin
      C_X := X;
      C_Y := Y;
      if C_X<RectTAdobe.Left then
        C_X:= RectTAdobe.Left
      else
      if C_X>RectTAdobe.Right-1 then
        C_X:= RectTAdobe.Right-1;
      HideTriAngle;
      TSV.T:=  Round(359*(C_X - RectBAdobe.Left)/255);
      TSV.S := Couleur.TSV.S;
      TSV.V := Couleur.TSV.V;
      Couleur.TSV := TSV;
      MAJCoul;
    end;
    CZAdobeS : begin
      C_X := X;
      C_Y := Y;
      if C_X<RectSAdobe.Left then
        C_X:= RectSAdobe.Left
      else
      if C_X>RectSAdobe.Right-1 then
        C_X:= RectSAdobe.Right-1;
      HideTriAngle;
      TSV.T := Couleur.TSV.T;
      TSV.S := Round(100*(C_X - RectBAdobe.Left)/255);
      TSV.V := Couleur.TSV.V;
      Couleur.TSV := TSV;
      MAJCoul;
    end;
    CZAdobeL : begin
      C_X := X;
      C_Y := Y;
      if C_X<RectVAdobe.Left then
        C_X:= RectVAdobe.Left
      else
      if C_X>RectVAdobe.Right-1 then
        C_X:= RectVAdobe.Right-1;
      HideTriAngle;
      TSV.T := Couleur.TSV.T;
      TSV.S := Couleur.TSV.S;
      TSV.V := Round(100*(C_X - RectBAdobe.Left)/255);
      Couleur.TSV := TSV;
      MAJCoul;
    end;
  end;
end;

procedure TFrameAdobe.DrawTriangleGris;
  procedure DrawTri(X,Y : Integer);
  var
    PLigne1 : pointer;
    PLigne2 : pointer;
    PLigne3: pointer;
    PLigne4: pointer;
    PLigne5: pointer;
    PLigne6: pointer;
    T1,T2,T3,T4,T5,T6 :TLigne;
    I : Integer;
  begin
    PLigne1 := ImageFond.Picture.Bitmap.ScanLine[Y];
    PLigne2 := ImageFond.Picture.Bitmap.ScanLine[Y+1];
    PLigne3 := ImageFond.Picture.Bitmap.ScanLine[Y+2];
    PLigne4 := ImageFond.Picture.Bitmap.ScanLine[Y+3];
    PLigne5 := ImageFond.Picture.Bitmap.ScanLine[Y+4];
    PLigne6 := ImageFond.Picture.Bitmap.ScanLine[Y+5];
    T1 := TLigne(PLigne1);
    T1[X*3]:=Tri.B;
    T1[(X*3)+1]:=Tri.V;
    T1[(X*3)+2]:=Tri.R;
    T2 := TLigne(PLigne2);
    T2[(X-1)*3]:=Tri.B;
    T2[(X-1)*3+1]:=Tri.V;
    T2[(X-1)*3+2]:=Tri.R;
    T2[(X+1)*3]:=Tri.B;
    T2[(X+1)*3+1]:=Tri.V;
    T2[(X+1)*3+2]:=Tri.R;
    T3 := TLigne(PLigne3);
    T3[(X-2)*3]:=Tri.B;
    T3[(X-2)*3+1]:=Tri.V;
    T3[(X-2)*3+2]:=Tri.R;
    T3[(X+2)*3]:=Tri.B;
    T3[(X+2)*3+1]:=Tri.V;
    T3[(X+2)*3+2]:=Tri.R;
    T4 := TLigne(PLigne4);
    T4[(X-3)*3]:=Tri.B;
    T4[(X-3)*3+1]:=Tri.V;
    T4[(X-3)*3+2]:=Tri.R;
    T4[(X+3)*3]:=Tri.B;
    T4[(X+3)*3+1]:=Tri.V;
    T4[(X+3)*3+2]:=Tri.R;
    T5 := TLigne(PLigne5);
    T5[(X-4)*3]:=Tri.B;
    T5[(X-4)*3+1]:=Tri.V;
    T5[(X-4)*3+2]:=Tri.R;
    T5[(X+4)*3]:=Tri.B;
    T5[(X+4)*3+1]:=Tri.V;
    T5[(X+4)*3+2]:=Tri.R;
    T6 := TLigne(PLigne6);
    for I := -5 to 5 do
    begin
      T6[(X+I)*3]:=Tri.B;
      T6[(X+I)*3+1]:=Tri.V;
      T6[(X+I)*3+2]:=Tri.R;
    end;
  end;
begin
  //RVB
  DrawTri(RectGAdobe.Left+Gris,RectGAdobe.Bottom+1);
end;

procedure TFrameAdobe.MAJCoul;
begin
  DesactiveOnChange ;
  MAJValeur;
  ActiveOnChange;
  Calculate;
end;

end.

