{
   This program is free software; you can redistribute it and/or
  modify it under the terms of the GNU General Public License
  as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
}
unit Ufrmfolder;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, ComCtrls, StdCtrls, ShellCtrls, Ufrmgetmosaic;

type
  Pfolderrec = ^Tfolderrec;
  Tfolderrec = record
    name,path:string;
    iscache:boolean;
  end;

  Tfrmfolder = class(TForm)
    Button1: TButton;
    Button2: TButton;
    TreeView1: TTreeView;
    Button3: TButton;
    Label1: TLabel;
    Label2: TLabel;
    Button4: TButton;
    procedure Button3Click(Sender: TObject);
    procedure JamShellTree1DblClick(Sender: TObject);
    procedure FormShow(Sender: TObject);
    procedure TreeView1Deletion(Sender: TObject; Node: TTreeNode);
    procedure TreeView1DblClick(Sender: TObject);
    procedure Button4Click(Sender: TObject);
  private
    { Private declarations }
    procedure getlist();
  public
    { Public declarations }
    fragfolder:string;
  end;

var
  frmfolder: Tfrmfolder;

implementation
uses Ufunction, shellapi;

{$R *.dfm}

procedure Tfrmfolder.Button3Click(Sender: TObject);
var
  s:String;
begin
  s:=GetAppDirectory+'mosaic_images';
  ShellExecute(Application.Handle, 'open', PChar(s), nil, nil, SW_NORMAL);
end;

procedure Tfrmfolder.JamShellTree1DblClick(Sender: TObject);
begin
  self.ModalResult:=mrok;
end;

procedure Tfrmfolder.FormShow(Sender: TObject);
begin
  getlist();
end;

procedure Tfrmfolder.getlist();
 function getfilecount(dir:string):integer;
 var
  SR: TSearchRec;
 begin
  result:=0;
  if FindFirst(dir+'*.jpg', faAnyFile, SR) = 0 then
   repeat
     if (SR.Attr <> faDirectory) and (SR.Name[1] <> '.') then begin
       inc(result);
     end;
   Until (FindNext(SR)<>0);
  FindClose(SR);
 end;
var
  SR: TSearchRec;
  c:integer;
  treenode:Ttreenode;
  folderrec:Pfolderrec;
begin
  if (length(fragfolder)>0) and (fragfolder[length(fragfolder)]<>'\') then
    fragfolder:=fragfolder+'\';
  if FindFirst(fragfolder+'*.*', faAnyFile, SR) = 0 then
   repeat
     if (sr.Name <> '.') and (sr.Name <> '..') then begin
       if (sr.Attr and faDirectory) = faDirectory then begin
         new(folderrec);
         folderrec.name:=sr.Name;
         folderrec.path:=fragfolder+'\'+sr.Name;
//         c:=getfilecount(folderrec.path+'\');
//         treenode:=TreeView1.Items.AddChild(nil,format('%s (%d)',[sr.Name,c]));
         folderrec.iscache:=sysutils.FileExists(folderrec.path+'\color.ini');
         if folderrec.iscache then
           treenode:=TreeView1.Items.AddChild(nil,sr.Name+' (ĳ)')
         else
           treenode:=TreeView1.Items.AddChild(nil,sr.Name);
         treenode.Data:=folderrec;
         treenode.ImageIndex:=GetIconIndex(GetAppDirectory, 0);
         treenode.SelectedIndex:=GetIconIndex(GetAppDirectory, 0);
       end;
     end;
   Until (FindNext(SR)<>0);
  FindClose(SR);

  if TreeView1.Items.Count>0 then
    TreeView1.Items.GetFirstNode.Selected:=true;
  TreeView1.SetFocus;
end;

procedure Tfrmfolder.TreeView1Deletion(Sender: TObject; Node: TTreeNode);
begin
  dispose(Pfolderrec(Node.Data));
end;

procedure Tfrmfolder.TreeView1DblClick(Sender: TObject);
begin
  if self.TreeView1.Selected<>nil then
    self.ModalResult:=mrok;
end;

procedure Tfrmfolder.Button4Click(Sender: TObject);
begin
  frmgetmosaic:=Tfrmgetmosaic.Create(self);
  try
    frmgetmosaic.ShowModal;
    TreeView1.Items.Clear;
    getlist();
  finally
    frmgetmosaic.Free;
  end;
end;

end.
