{

   This program is free software; you can redistribute it and/or
  modify it under the terms of the GNU General Public License
  as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
}
unit UfrmEffect_Color;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, UfrmEffectBase, StdCtrls, ComCtrls, Spin, GR32_Filters;

type
  TfrmEffect_Color = class(TfrmEffectBase)
    PageControl2: TPageControl;
    TabSheet4: TTabSheet;
    Label2: TLabel;
    Label4: TLabel;
    Label5: TLabel;
    TrackBar4: TTrackBar;
    TrackBar5: TTrackBar;
    TrackBar6: TTrackBar;
    SpinEdit1: TSpinEdit;
    SpinEdit2: TSpinEdit;
    SpinEdit3: TSpinEdit;
    TabSheet5: TTabSheet;
    Label6: TLabel;
    Label8: TLabel;
    Label9: TLabel;
    TrackBar7: TTrackBar;
    TrackBar8: TTrackBar;
    TrackBar9: TTrackBar;
    TabSheet6: TTabSheet;
    Label10: TLabel;
    Label11: TLabel;
    Label12: TLabel;
    Label13: TLabel;
    TrackBar10: TTrackBar;
    TrackBar11: TTrackBar;
    TrackBar12: TTrackBar;
    TrackBar13: TTrackBar;
    SpinEdit4: TSpinEdit;
    SpinEdit5: TSpinEdit;
    SpinEdit6: TSpinEdit;
    SpinEdit7: TSpinEdit;
    SpinEdit8: TSpinEdit;
    SpinEdit9: TSpinEdit;
    SpinEdit10: TSpinEdit;
    Button1: TButton;
    procedure TrackBar4Change(Sender: TObject);
    procedure TrackBar9Change(Sender: TObject);
    procedure TrackBar10Change(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure FormShow(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure Button1Click(Sender: TObject);
    procedure SpinEdit1Change(Sender: TObject);
    procedure SpinEdit4Change(Sender: TObject);
    procedure SpinEdit7Change(Sender: TObject);
  private
    { Private declarations }
    procedure set_effectapply;
    procedure ok_select; override;
    procedure imageprocess(var src:tbitmap);
  public
    { Public declarations }
  end;

var
  frmEffect_Color: TfrmEffect_Color;

implementation

uses im_Effects, Uconfig, Ufrmmain, Ufunction;
{$R *.dfm}

procedure TfrmEffect_Color.TrackBar9Change(Sender: TObject);
begin
  imagepreview1.bitmap.Assign(thumb_bitmap32);
  SpinEdit4.Text:=inttostr(trackbar9.Position);
  SpinEdit5.Text:=inttostr(trackbar8.Position);
  SpinEdit6.Text:=inttostr(trackbar7.Position);
  Effect_incdecHSL(imagepreview1.Bitmap,trackbar9.Position,trackbar8.Position,trackbar7.Position);
end;

procedure TfrmEffect_Color.TrackBar10Change(Sender: TObject);
begin
  imagepreview1.bitmap.Assign(thumb_bitmap32);
  SpinEdit7.Text:=inttostr(trackbar10.Position);
  SpinEdit8.Text:=inttostr(trackbar11.Position);
  SpinEdit9.Text:=inttostr(trackbar12.Position);
  SpinEdit10.Text:=inttostr(trackbar13.Position);
  Effect_incdecCMYK(imagepreview1.bitmap,trackbar10.Position,trackbar11.Position,
         trackbar12.Position,trackbar13.Position);
end;

procedure TfrmEffect_Color.FormCreate(Sender: TObject);
begin
  inherited;
  PanelPreView.Align:=alLeft;
  PageControl2.Align:=alclient;
  PageControl2.ActivePageIndex:=config.getvaluebyinteger('color_selectpage');

  Button1.Left:=PageControl2.Left+10;
  Button1.Top:=PageControl2.Height-Button1.Height-10;
end;

procedure TfrmEffect_Color.FormShow(Sender: TObject);
begin
  make_thumbimage;
  imagepreview1.Bitmap.Assign(thumb_bitmap32);

  applyselect.Visible:=not frmmain.is_layerselected;
end;

procedure TfrmEffect_Color.TrackBar4Change(Sender: TObject);
begin
  imagepreview1.Bitmap.Assign(thumb_bitmap32);
  SpinEdit1.Text:=inttostr(trackbar4.Position);
  SpinEdit2.Text:=inttostr(trackbar5.Position);
  SpinEdit3.Text:=inttostr(trackbar6.Position);
  Effect_incdecRGB(imagepreview1.Bitmap,trackbar4.Position,trackbar5.Position,trackbar6.Position);
end;

procedure TfrmEffect_Color.set_effectapply;
begin
  Effect_incdecRGB(org_bitmap32,trackbar4.Position,trackbar5.Position,trackbar6.Position);
  Effect_incdecHSL(org_bitmap32,trackbar9.Position,trackbar8.Position,trackbar7.Position);
  Effect_incdecCMYK(org_bitmap32,trackbar10.Position,trackbar11.Position,
          trackbar12.Position,trackbar13.Position);
end;

procedure TfrmEffect_Color.ok_select;
begin
  config.setvaluebyinteger('color_value4',Trackbar4.Position);
  config.setvaluebyinteger('color_value5',Trackbar5.Position);
  config.setvaluebyinteger('color_value6',Trackbar6.Position);
  config.setvaluebyinteger('color_value9',Trackbar9.Position);
  config.setvaluebyinteger('color_value8',Trackbar8.Position);
  config.setvaluebyinteger('color_value7',Trackbar7.Position);
  config.setvaluebyinteger('color_value10',Trackbar10.Position);
  config.setvaluebyinteger('color_value11',Trackbar11.Position);
  config.setvaluebyinteger('color_value12',Trackbar12.Position);
  config.setvaluebyinteger('color_value13',Trackbar13.Position);

  if applyselect.ItemIndex=0 then begin
    Screen.Cursor:=crHourglass;
    try
      set_effectapply;
      imagepreview1.Bitmap.Assign(org_bitmap32);
    finally
      screen.Cursor:=crdefault;
    end;
    exit;
  end;

  frmmain.apply_listimages(applyselect.ItemIndex=1,imageprocess,etColor,self.Caption);
  self.ModalResult:=mrcancel;
end;

procedure TfrmEffect_Color.imageprocess(var src:tbitmap);
begin
  org_bitmap32.Assign(src);
  set_effectapply;
  org_bitmap32.AssignTo24(src);
end;

procedure TfrmEffect_Color.FormDestroy(Sender: TObject);
begin
  inherited;
  config.setvaluebyinteger('color_selectpage',PageControl2.ActivePageIndex);
end;

procedure TfrmEffect_Color.Button1Click(Sender: TObject);
begin
  config.getvaluebyinteger('color_value4',0);
  Trackbar4.Position:=config.lastvalue_integer;
  config.getvaluebyinteger('color_value5',0);
  Trackbar5.Position:=config.lastvalue_integer;
  config.getvaluebyinteger('color_value6',0);
  Trackbar6.Position:=config.lastvalue_integer;

  config.getvaluebyinteger('color_value9',0);
  Trackbar9.Position:=config.lastvalue_integer;
  config.getvaluebyinteger('color_value8',0);
  Trackbar8.Position:=config.lastvalue_integer;
  config.getvaluebyinteger('color_value7',0);
  Trackbar7.Position:=config.lastvalue_integer;

  config.getvaluebyinteger('color_value10',0);
  Trackbar10.Position:=config.lastvalue_integer;
  config.getvaluebyinteger('color_value11',0);
  Trackbar11.Position:=config.lastvalue_integer;
  config.getvaluebyinteger('color_value12',0);
  Trackbar12.Position:=config.lastvalue_integer;
  config.getvaluebyinteger('color_value13',0);
  Trackbar13.Position:=config.lastvalue_integer;

  PageControl2.ActivePageIndex:=config.getvaluebyinteger('color_selectpage');  
end;

procedure TfrmEffect_Color.SpinEdit1Change(Sender: TObject);
begin
  if isvalidinteger(SpinEdit1.Text) then trackbar4.Position:=round(SpinEdit1.Value);
  if isvalidinteger(SpinEdit2.Text) then trackbar5.Position:=round(SpinEdit2.Value);
  if isvalidinteger(SpinEdit3.Text) then trackbar6.Position:=round(SpinEdit3.Value);
end;

procedure TfrmEffect_Color.SpinEdit4Change(Sender: TObject);
begin
  if isvalidinteger(SpinEdit4.Text) then trackbar9.Position:=round(SpinEdit4.Value);
  if isvalidinteger(SpinEdit5.Text) then trackbar8.Position:=round(SpinEdit5.Value);
  if isvalidinteger(SpinEdit6.Text) then trackbar7.Position:=round(SpinEdit6.Value);
end;

procedure TfrmEffect_Color.SpinEdit7Change(Sender: TObject);
begin
  if isvalidinteger(SpinEdit7.Text) then trackbar10.Position:=round(SpinEdit7.Value);
  if isvalidinteger(SpinEdit8.Text) then trackbar11.Position:=round(SpinEdit8.Value);
  if isvalidinteger(SpinEdit9.Text) then trackbar12.Position:=round(SpinEdit9.Value);
  if isvalidinteger(SpinEdit10.Text) then trackbar13.Position:=round(SpinEdit10.Value);
end;

end.
