unit Ufrmrename;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, Buttons, RegExpr;

type
  Tfrmrename = class(TForm)
    RadioButton1: TRadioButton;
    RadioButton2: TRadioButton;
    BitBtn1: TBitBtn;
    BitBtn2: TBitBtn;
    Edit1: TEdit;
    Label1: TLabel;
    Label2: TLabel;
    Edit2: TEdit;
    Edit3: TEdit;
    Label3: TLabel;
    procedure BitBtn1Click(Sender: TObject);
    procedure FormCreate(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
    renameok:boolean;
  end;

var
  frmrename: Tfrmrename;

implementation
uses Uregistry, Ufrmmain;

{$R *.dfm}

procedure Tfrmrename.BitBtn1Click(Sender: TObject);
var
  RegEx:TRegExpr;
  s:string;
  k:integer;

  procedure find(dir:string);
  var
    SR:TSearchRec;
    s,s1:string;
  begin
    if FindFirst(dir+'*.*', faAnyFile, SR) = 0 then
     repeat
       if (sr.Name <> '.') and (sr.Name <> '..') then
         if (sr.Attr and faDirectory) = faDirectory then begin
           if self.RadioButton2.Checked then
             find(dir+sr.Name+'\');
         end else begin
           RegEx.Expression:=edit1.Text;
           if RegEx.Exec(sr.Name) then begin
             s1:=RegEx.Replace(sr.Name, edit2.Text, true);
             if windows.MoveFile(pchar(dir+sr.Name),pchar(dir+s1)) then
               inc(k);
           end;
         end;
     Until (FindNext(SR)<>0);
    FindClose(SR);
  end;

begin
  if (edit1.Text='') or (edit2.Text='') then begin
    MessageDlg(' ׸ Էּ.',mtInformation, [mbOk], 0);
    exit;
  end;
  RegSetString(HKEY_CURRENT_USER, 'software\'+thisregname+'\rename_findstr', edit1.Text);
  RegSetString(HKEY_CURRENT_USER, 'software\'+thisregname+'\rename_replacestr', edit2.Text);
  RegEx:=TRegExpr.Create;
  try
    s:=edit3.Text;
    if s[length(s)]<>'\' then s:=s+'\';
    k:=0;
    find(s);
    MessageDlg(format('%d  ߽ϴ.',[k]),mtInformation, [mbOk], 0);
    if k>0 then renameok:=true;
  finally
    RegEx.Free;
  end;
end;

procedure Tfrmrename.FormCreate(Sender: TObject);
var
  s:string;
begin
  renameok:=false;
  RegGetString(HKEY_CURRENT_USER, 'software\'+thisregname+'\rename_findstr', s);
  if s='' then s:='̹((.*)jpg)';
  edit1.Text:=s;
  s:='';
  RegGetString(HKEY_CURRENT_USER, 'software\'+thisregname+'\rename_replacestr', s);
  if s='' then s:='$1';
  edit2.Text:=s;
end;

end.
