{

   This program is free software; you can redistribute it and/or
  modify it under the terms of the GNU General Public License
  as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
}
unit Ufrmresize;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, Spin, Buttons, ComCtrls;

type
  Tfrmresize = class(TForm)
    SpinEdit1: TSpinEdit;
    SpinEdit2: TSpinEdit;
    Label1: TLabel;
    Label2: TLabel;
    CheckBox1: TCheckBox;
    TypeCombo: TComboBox;
    Label3: TLabel;
    BitBtn1: TBitBtn;
    BitBtn2: TBitBtn;
    procedure FormCreate(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure FormShow(Sender: TObject);
    procedure SpinEdit1KeyUp(Sender: TObject; var Key: Word;
      Shift: TShiftState);
    procedure SpinEdit2KeyUp(Sender: TObject; var Key: Word;
      Shift: TShiftState);
  private
    { Private declarations }
    orgwidth,orgheight:integer;
  public
    { Public declarations }
  end;

var
  frmresize: Tfrmresize;

implementation
uses Uconfig;
{$R *.dfm}

procedure Tfrmresize.FormCreate(Sender: TObject);
begin
  CheckBox1.Checked:=config.c_resize_keepratio;
  TypeCombo.ItemIndex:=config.c_resize_method;
end;

procedure Tfrmresize.FormDestroy(Sender: TObject);
begin
  config.c_resize_keepratio:=CheckBox1.Checked;
  config.c_resize_method:=TypeCombo.ItemIndex;
end;

procedure Tfrmresize.FormShow(Sender: TObject);
begin
  orgwidth:=SpinEdit1.Value;
  orgheight:=SpinEdit2.Value;
end;

procedure Tfrmresize.SpinEdit1KeyUp(Sender: TObject; var Key: Word;
  Shift: TShiftState);
begin
  if CheckBox1.Checked then
    SpinEdit2.Value:=round(SpinEdit1.Value*orgheight / orgwidth);
end;

procedure Tfrmresize.SpinEdit2KeyUp(Sender: TObject; var Key: Word;
  Shift: TShiftState);
begin
  if CheckBox1.Checked then
    SpinEdit1.Value:=round(SpinEdit2.Value*orgwidth / orgheight);
end;

end.
