unit Ufrmsaveopt;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, ComCtrls, StdCtrls, ExtCtrls, FreeImage, Buttons, Spin;

type
  Tfrmsaveopt = class(TForm)
    PageControl1: TPageControl;
    TabSheet1: TTabSheet;
    TabSheet2: TTabSheet;
    RadioGroup1: TRadioGroup;
    RadioGroup2: TRadioGroup;
    RadioGroup3: TRadioGroup;
    TabSheet3: TTabSheet;
    CheckBox1: TCheckBox;
    BitBtn2: TBitBtn;
    BitBtn1: TBitBtn;
    RadioGroup4: TRadioGroup;
    CheckBox2: TCheckBox;
    TabSheet4: TTabSheet;
    RadioGroup5: TRadioGroup;
    CheckBox3: TCheckBox;
    Button1: TButton;
    CheckBox4: TCheckBox;
    SpinEdit1: TSpinEdit;
    procedure FormShow(Sender: TObject);
    procedure BitBtn2Click(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure Button1Click(Sender: TObject);
    procedure RadioGroup5Click(Sender: TObject);
    procedure RadioGroup2Click(Sender: TObject);
    procedure CheckBox4Click(Sender: TObject);
  private
    { Private declarations }
    selectflag:integer;    
    procedure set_control();
  public
    { Public declarations }
    selectformat:FREE_IMAGE_FORMAT;
  end;

  function get_reg_saveopt_flag(format:FREE_IMAGE_FORMAT;default:boolean):integer;

var
  frmsaveopt: Tfrmsaveopt;

implementation
uses Uconfig, Uregistry;
{$R *.dfm}

procedure setvaluebyinteger2(name:string;value:integer);
var
  v:cardinal;
begin
  v:=value;
  RegSetDWORD(HKEY_CURRENT_USER,'software\nSeries\nView\'+name,v);
end;

function getvaluebyinteger2(name:string;default:integer=0):integer;
var
  v:cardinal;
begin
  v:=default;
  RegGetDWORD(HKEY_CURRENT_USER,'software\nSeries\nView\'+name,v);
  result:=v;
end;

function get_reg_saveopt_flag(format:FREE_IMAGE_FORMAT;default:boolean):integer;
begin
  result:=0;
  if default then begin
   case format of
    FIF_BMP: result:=0;
    FIF_JPEG: result:=JPEG_QUALITYGOOD or JPEG_SUBSAMPLING_420;
    FIF_PNG: result:=PNG_Z_DEFAULT_COMPRESSION;
    FIF_TIFF: result:=0;
   end;
  end else begin
   case format of
    FIF_BMP: result:=getvaluebyinteger2('saveopt_bmp',0);
    FIF_JPEG: result:=getvaluebyinteger2('saveopt_jpeg',JPEG_QUALITYGOOD or JPEG_SUBSAMPLING_420);
    FIF_PNG: result:=getvaluebyinteger2('saveopt_png',PNG_Z_DEFAULT_COMPRESSION);
    FIF_TIFF: result:=getvaluebyinteger2('saveopt_tiff',0);
   end;
  end;
  if result<0 then result:=0;
end;

procedure Tfrmsaveopt.FormShow(Sender: TObject);
var
  i:integer;
begin
  for i:=0 to self.PageControl1.PageCount-1 do
    self.PageControl1.Pages[i].TabVisible:=false;

  selectflag:=get_reg_saveopt_flag(selectformat,false);
  set_control();
end;

procedure Tfrmsaveopt.set_control();
var
  flag:integer;
begin
  case selectformat of
    FIF_BMP:begin
      PageControl1.Pages[0].TabVisible:=true;
      self.RadioGroup1.ItemIndex:=selectflag;
    end;
    FIF_JPEG:begin
      PageControl1.Pages[1].TabVisible:=true;
      self.CheckBox1.Checked:=selectflag and JPEG_PROGRESSIVE=JPEG_PROGRESSIVE;

      if selectflag and JPEG_SUBSAMPLING_411=JPEG_SUBSAMPLING_411 then
        RadioGroup3.ItemIndex:=0
      else if selectflag and JPEG_SUBSAMPLING_420=JPEG_SUBSAMPLING_420 then
        RadioGroup3.ItemIndex:=1
      else if selectflag and JPEG_SUBSAMPLING_422=JPEG_SUBSAMPLING_422 then
        RadioGroup3.ItemIndex:=2
      else if selectflag and JPEG_SUBSAMPLING_444=JPEG_SUBSAMPLING_444 then
        RadioGroup3.ItemIndex:=3;

      self.CheckBox4.Checked:=false;
      if selectflag and JPEG_QUALITYSUPERB=JPEG_QUALITYSUPERB then
        RadioGroup2.ItemIndex:=0
      else if selectflag and JPEG_QUALITYGOOD=JPEG_QUALITYGOOD then
        RadioGroup2.ItemIndex:=1
      else if selectflag and JPEG_QUALITYNORMAL=JPEG_QUALITYNORMAL then
        RadioGroup2.ItemIndex:=2
      else if selectflag and JPEG_QUALITYAVERAGE=JPEG_QUALITYAVERAGE then
        RadioGroup2.ItemIndex:=3
      else if selectflag and JPEG_QUALITYBAD=JPEG_QUALITYBAD then
        RadioGroup2.ItemIndex:=4
      else begin
        self.CheckBox4.Checked:=true;
        flag:=selectflag;
        if selectflag and JPEG_PROGRESSIVE=JPEG_PROGRESSIVE then
          flag:=flag xor JPEG_PROGRESSIVE;
        if flag and JPEG_SUBSAMPLING_411=JPEG_SUBSAMPLING_411 then
          flag:=flag xor JPEG_SUBSAMPLING_411
        else if flag and JPEG_SUBSAMPLING_420=JPEG_SUBSAMPLING_420 then
          flag:=flag xor JPEG_SUBSAMPLING_420
        else if flag and JPEG_SUBSAMPLING_422=JPEG_SUBSAMPLING_422 then
          flag:=flag xor JPEG_SUBSAMPLING_422
        else if flag and JPEG_SUBSAMPLING_444=JPEG_SUBSAMPLING_444 then
          flag:=flag xor JPEG_SUBSAMPLING_444;
        self.SpinEdit1.Value:=flag;
        CheckBox4Click(nil);
      end;

    end;
    FIF_PNG:begin
      PageControl1.Pages[2].TabVisible:=true;
      if selectflag and PNG_Z_BEST_SPEED=PNG_Z_BEST_SPEED then
        RadioGroup4.ItemIndex:=0
      else if selectflag and PNG_Z_DEFAULT_COMPRESSION=PNG_Z_DEFAULT_COMPRESSION then
        RadioGroup4.ItemIndex:=1
      else if selectflag and PNG_Z_BEST_COMPRESSION=PNG_Z_BEST_COMPRESSION then
        RadioGroup4.ItemIndex:=2
      else if selectflag and PNG_Z_NO_COMPRESSION=PNG_Z_NO_COMPRESSION then
        RadioGroup4.ItemIndex:=3;

      self.CheckBox2.Checked:=selectflag and PNG_INTERLACED=PNG_INTERLACED;
    end;
    FIF_TIFF:begin
      PageControl1.Pages[3].TabVisible:=true;

      if selectflag=0 then
        RadioGroup5.ItemIndex:=0
      else if selectflag and TIFF_PACKBITS=TIFF_PACKBITS then
        RadioGroup5.ItemIndex:=1
      else if selectflag and TIFF_DEFLATE=TIFF_DEFLATE then
        RadioGroup5.ItemIndex:=2
      else if selectflag and TIFF_ADOBE_DEFLATE=TIFF_ADOBE_DEFLATE then
        RadioGroup5.ItemIndex:=3
      else if selectflag and TIFF_NONE=TIFF_NONE then
        RadioGroup5.ItemIndex:=4
      else if selectflag and TIFF_CCITTFAX3=TIFF_CCITTFAX3 then
        RadioGroup5.ItemIndex:=5
      else if selectflag and TIFF_CCITTFAX4=TIFF_CCITTFAX4 then
        RadioGroup5.ItemIndex:=6
      else if selectflag and TIFF_LZW=TIFF_LZW then
        RadioGroup5.ItemIndex:=7
      else if selectflag and TIFF_JPEG=TIFF_JPEG then
        RadioGroup5.ItemIndex:=8;

      self.CheckBox3.Checked:=(selectflag>0) and (selectflag and TIFF_CMYK=TIFF_CMYK);
      RadioGroup5Click(nil);

    end;
  end;
end;

procedure Tfrmsaveopt.BitBtn2Click(Sender: TObject);
var
  i:integer;
begin
  selectflag:=0;
  case selectformat of
    FIF_BMP:begin
      selectflag:=RadioGroup1.ItemIndex;
      setvaluebyinteger2('saveopt_bmp',selectflag);
    end;
    FIF_JPEG:begin
      if self.CheckBox4.Checked then
        selectflag:=self.SpinEdit1.Value
      else
        case RadioGroup2.ItemIndex of
          0: selectflag:=JPEG_QUALITYSUPERB;
          1: selectflag:=JPEG_QUALITYGOOD;
          2: selectflag:=JPEG_QUALITYNORMAL;
          3: selectflag:=JPEG_QUALITYAVERAGE;
          4: selectflag:=JPEG_QUALITYBAD;
        end;
      if CheckBox1.Checked then selectflag:=selectflag or JPEG_PROGRESSIVE;
      case RadioGroup3.ItemIndex of
        0: selectflag:=selectflag or JPEG_SUBSAMPLING_411;
        1: selectflag:=selectflag or JPEG_SUBSAMPLING_420;
        2: selectflag:=selectflag or JPEG_SUBSAMPLING_422;
        3: selectflag:=selectflag or JPEG_SUBSAMPLING_444;
      end;
      setvaluebyinteger2('saveopt_jpeg',selectflag);
    end;
    FIF_PNG:begin
      case RadioGroup4.ItemIndex of
        0: selectflag:=PNG_Z_BEST_SPEED;
        1: selectflag:=PNG_Z_DEFAULT_COMPRESSION;
        2: selectflag:=PNG_Z_BEST_COMPRESSION;
        3: selectflag:=PNG_Z_NO_COMPRESSION;
      end;
      if CheckBox2.Checked then selectflag:=selectflag or PNG_INTERLACED;
      setvaluebyinteger2('saveopt_png',selectflag);
    end;
    FIF_TIFF:begin
      case RadioGroup5.ItemIndex of
        0: selectflag:=0;
        1: selectflag:=TIFF_PACKBITS;
        2: selectflag:=TIFF_DEFLATE;
        3: selectflag:=TIFF_ADOBE_DEFLATE;
        4: selectflag:=TIFF_NONE;
        5: selectflag:=TIFF_CCITTFAX3;
        6: selectflag:=TIFF_CCITTFAX4;
        7: selectflag:=TIFF_LZW;
        8: selectflag:=TIFF_JPEG;
      end;
      if (selectflag>0) and CheckBox3.Checked then
        selectflag:=selectflag or TIFF_CMYK;
      setvaluebyinteger2('saveopt_tiff',selectflag);

    end;
  end;
end;

procedure Tfrmsaveopt.FormCreate(Sender: TObject);
begin
  selectflag:=0;
end;

procedure Tfrmsaveopt.Button1Click(Sender: TObject);
begin
  selectflag:=get_reg_saveopt_flag(selectformat,true);
  set_control();
end;

procedure Tfrmsaveopt.RadioGroup5Click(Sender: TObject);
begin
  self.CheckBox3.Enabled:=not (RadioGroup5.ItemIndex=0);
end;

procedure Tfrmsaveopt.RadioGroup2Click(Sender: TObject);
begin
  case RadioGroup2.ItemIndex of
    0: SpinEdit1.Value:=100;
    1: SpinEdit1.Value:=75;
    2: SpinEdit1.Value:=50;
    3: SpinEdit1.Value:=25;
    4: SpinEdit1.Value:=10;
  end;
end;

procedure Tfrmsaveopt.CheckBox4Click(Sender: TObject);
begin
  self.RadioGroup2.Enabled:=not CheckBox4.Checked;
  if CheckBox4.Checked and (RadioGroup2.ItemIndex<0) then
    RadioGroup2.ItemIndex:=1;
end;

end.
