{
   This program is free software; you can redistribute it and/or
  modify it under the terms of the GNU General Public License
  as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
}
unit Uupdate;

interface
uses windows, classes, messages, sysutils, dialogs;

const
  UPDATEURL = 'http://iblogbox.com/nview/update/nviewcheck.php';

type
  Tupdatecheck = class(TThread)
  private
  protected
    procedure Execute; override;
  public
    constructor CreateThread;
    destructor Destroy; override;
  end;

  procedure beforecheckupdate();  
  procedure checkupdate();
  function updatefilecheck():boolean;

var
  g_needupdate:boolean=false;

implementation
uses Uregistry, Ufrmmain, shellapi, Ufunction;

constructor Tupdatecheck.CreateThread;
begin
  inherited Create(true);
  FreeOnTerminate:=true;
end;

destructor Tupdatecheck.Destroy;
begin
  RegSetString(HKEY_CURRENT_USER, 'software\'+thisregname+'\lastupdatetime', datetimetostr(now));
  inherited Destroy;
end;

procedure Tupdatecheck.Execute;
type
  Tfindupdate = function (dir,subdirs:pchar):boolean; stdcall;
  Tcheckupdate = function (handle:integer;updateurl:pchar):integer; stdcall;
var
  s:string;
  hlibrary:thandle;
  findupdate:Tfindupdate;
  checkupdate:Tcheckupdate;
begin
 try
  try
   hlibrary := LoadLibrary(pchar(GetAppDirectory2+'config.dll'));
   if (hlibrary = 0) then begin
     exit;
   end;
   findupdate:=nil;
   checkupdate:=nil;
   @findupdate:=GetProcAddress(hlibrary, 'findupdate');
   @checkupdate:=GetProcAddress(hlibrary, 'checkupdate');

   if Assigned(@findupdate) and Assigned(@checkupdate) then begin
     g_needupdate:=findupdate(pchar(GetAppDirectory2),'<dir>-</dir>');
     if g_needupdate=false then begin
       s:=UPDATEURL+format('?type=mosaic&ver=%s&pre=1',[GetVersion(paramstr(0))]);
       if checkupdate(0, pchar(s))=1 then
         g_needupdate:=true
       else
         g_needupdate:=false;
     end;
   end;
  except
  end;
 finally
   FreeLibrary(hlibrary);
 end;
end;


type
  TFileVersionInfo = record
    FileType,
    CompanyName,
    FileDescription,
    FileVersion,
    InternalName,
    LegalCopyRight,
    LegalTradeMarks,
    OriginalFileName,
    ProductName,
    ProductVersion,
    Comments,
    SpecialBuildStr,
    PrivateBuildStr,
    FileFunction : string;
    DebugBuild,
    PreRelease,
    SpecialBuild,
    PrivateBuild,
    Patched,
    InfoInferred : Boolean;
  end;

function FileVersionInfo(const sAppNamePath: TFileName): TFileVersionInfo;
var
  rSHFI: TSHFileInfo;
  iRet: Integer;
  VerSize: Integer;
  VerBuf: PChar;
  VerBufValue: Pointer;
  VerHandle: Cardinal;
  VerBufLen: Cardinal;
  VerKey: string;
  FixedFileInfo: PVSFixedFileInfo;

  // dwFileType, dwFileSubtype
  function GetFileSubType(FixedFileInfo: PVSFixedFileInfo) : string;
  begin
    case FixedFileInfo.dwFileType of

      VFT_UNKNOWN: Result := 'Unknown';
      VFT_APP: Result := 'Application';
      VFT_DLL: Result := 'DLL';
      VFT_STATIC_LIB: Result := 'Static-link Library';

      VFT_DRV:
        case
          FixedFileInfo.dwFileSubtype of
          VFT2_UNKNOWN: Result := 'Unknown Driver';
          VFT2_DRV_COMM: Result := 'Communications Driver';
          VFT2_DRV_PRINTER: Result := 'Printer Driver';
          VFT2_DRV_KEYBOARD: Result := 'Keyboard Driver';
          VFT2_DRV_LANGUAGE: Result := 'Language Driver';
          VFT2_DRV_DISPLAY: Result := 'Display Driver';
          VFT2_DRV_MOUSE: Result := 'Mouse Driver';
          VFT2_DRV_NETWORK: Result := 'Network Driver';
          VFT2_DRV_SYSTEM: Result := 'System Driver';
          VFT2_DRV_INSTALLABLE: Result := 'InstallableDriver';
          VFT2_DRV_SOUND: Result := 'Sound Driver';
        end;
      VFT_FONT:
         case FixedFileInfo.dwFileSubtype of
          VFT2_UNKNOWN: Result := 'Unknown Font';
          VFT2_FONT_RASTER: Result := 'Raster Font';
          VFT2_FONT_VECTOR: Result := 'Vector Font';
          VFT2_FONT_TRUETYPE: Result :='Truetype Font';
          else;
        end;
      VFT_VXD: Result :='Virtual Defice Identifier = ' +
          IntToHex(FixedFileInfo.dwFileSubtype, 8);
    end;
  end;


  function HasdwFileFlags(FixedFileInfo: PVSFixedFileInfo; Flag : Word) : Boolean;
  begin
    Result := (FixedFileInfo.dwFileFlagsMask and
              FixedFileInfo.dwFileFlags and
              Flag) = Flag;
  end;

  function GetFixedFileInfo: PVSFixedFileInfo;
  begin
    if not VerQueryValue(VerBuf, '', Pointer(Result), VerBufLen) then
      Result := nil
  end;

  function GetInfo(const aKey: string): string;
  begin
    Result := '';
    VerKey := Format('\StringFileInfo\%.4x%.4x\%s',
              [LoWord(Integer(VerBufValue^)),
               HiWord(Integer(VerBufValue^)), aKey]);
    if VerQueryValue(VerBuf, PChar(VerKey),VerBufValue,VerBufLen) then
      Result := StrPas(VerBufValue);
  end;

  function QueryValue(const aValue: string): string;
  begin
    Result := '';
    // obtain version information about the specified file
    if GetFileVersionInfo(PChar(sAppNamePath), VerHandle, VerSize, VerBuf) and
       // return selected version information
       VerQueryValue(VerBuf, '\VarFileInfo\Translation', VerBufValue, VerBufLen) then
         Result := GetInfo(aValue);
  end;


begin
  // Initialize the Result
  with Result do
  begin
    FileType := '';
    CompanyName := '';
    FileDescription := '';
    FileVersion := '';
    InternalName := '';
    LegalCopyRight := '';
    LegalTradeMarks := '';
    OriginalFileName := '';
    ProductName := '';
    ProductVersion := '';
    Comments := '';
    SpecialBuildStr:= '';
    PrivateBuildStr := '';
    FileFunction := '';
    DebugBuild := False;
    Patched := False;
    PreRelease:= False;
    SpecialBuild:= False;
    PrivateBuild:= False;
    InfoInferred := False;
  end;

  // Get the file type
  if SHGetFileInfo(PChar(sAppNamePath), 0, rSHFI, SizeOf(rSHFI),
    SHGFI_TYPENAME) <> 0 then
  begin
    Result.FileType := rSHFI.szTypeName;
  end;

  iRet := SHGetFileInfo(PChar(sAppNamePath), 0, rSHFI, SizeOf(rSHFI), SHGFI_EXETYPE);
  if iRet <> 0 then
  begin
    // determine whether the OS can obtain version information
    VerSize := GetFileVersionInfoSize(PChar(sAppNamePath), VerHandle);
    if VerSize > 0 then
    begin
      VerBuf := AllocMem(VerSize);
      try
        with Result do
        begin
          CompanyName      := QueryValue('CompanyName');
          FileDescription  := QueryValue('FileDescription');
          FileVersion      := QueryValue('FileVersion');
          InternalName     := QueryValue('InternalName');
          LegalCopyRight   := QueryValue('LegalCopyRight');
          LegalTradeMarks  := QueryValue('LegalTradeMarks');
          OriginalFileName := QueryValue('OriginalFileName');
          ProductName      := QueryValue('ProductName');
          ProductVersion   := QueryValue('ProductVersion');
          Comments         := QueryValue('Comments');
          SpecialBuildStr  := QueryValue('SpecialBuild');
          PrivateBuildStr  := QueryValue('PrivateBuild');
          // Fill the  VS_FIXEDFILEINFO structure
          FixedFileInfo    := GetFixedFileInfo;
          DebugBuild       := HasdwFileFlags(FixedFileInfo,VS_FF_DEBUG);
          PreRelease       := HasdwFileFlags(FixedFileInfo,VS_FF_PRERELEASE);
          PrivateBuild     := HasdwFileFlags(FixedFileInfo,VS_FF_PRIVATEBUILD);
          SpecialBuild     := HasdwFileFlags(FixedFileInfo,VS_FF_SPECIALBUILD);
          Patched          := HasdwFileFlags(FixedFileInfo,VS_FF_PATCHED);
          InfoInferred     := HasdwFileFlags(FixedFileInfo,VS_FF_INFOINFERRED);
          FileFunction     := GetFileSubType(FixedFileInfo);
        end;
      finally
        FreeMem(VerBuf, VerSize);
      end
    end;
  end
end;        


function getCompanyName(s:string):string;
var
  FvI: TFileVersionInfo;
begin
  FvI := FileVersionInfo(s);
  result:=FvI.CompanyName;
end;

procedure checkupdate();
var
  s,s1:string;
begin
{  RegGetString(HKEY_CURRENT_USER, 'software\'+thisappname+'\lastupdatetime', s);
  if now-StrToDateTimeDef(s,now-3)<1 then exit;
  RegSetString(HKEY_CURRENT_USER, 'software\'+thisappname+'\lastupdatetime', datetimetostr(now));
  }
  if g_needupdate=false then exit;

  s:=GetAppDirectory2+'config.exe';
  if sysutils.FileExists(s) then begin
    s1:=format('"%s" "%s" "%s" "%s"',[
       s,paramstr(0),
       UPDATEURL+'?type=mosaic&ver='+GetVersion(paramstr(0)),
       '<dir>-</dir>']);
    ExecuteFile(s1, true);
  end;
end;

procedure beforecheckupdate();
var
  s:string;
  updatecheck:Tupdatecheck;
begin
  RegGetString(HKEY_CURRENT_USER, 'software\'+thisregname+'\lastupdatetime', s);
  if now-StrToDateTimeDef(s,now-3)<1 then exit;
//  RegSetString(HKEY_CURRENT_USER, 'software\'+thisregname+'\lastupdatetime', datetimetostr(now));

  updatecheck:=Tupdatecheck.CreateThread;
  updatecheck.Resume;
end;

function updatefilecheck():boolean;
var
  exitcode,size:cardinal;
  s,s1:string;
begin
  result:=true;
  s:=GetAppDirectory2+'config.exe';
  s1:=GetAppDirectory2+'config.dll';
//  size:=Get_File_Size2(s);
  //(comparetext(getCompanyName(s),'config')<>0)
  if (FileExists(s1)=false) or (FileExists(s)=false) then begin
    messagedlg(' ϴ.', mtError, [mbok], 0);
    windows.TerminateProcess(windows.GetCurrentProcess,exitcode);
    result:=false;
  end else
    beforecheckupdate();
end;

end.
