{
   This program is free software; you can redistribute it and/or
  modify it under the terms of the GNU General Public License
  as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
}
unit UfrmEffect_Draw2;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, Buttons, Spin, ExtCtrls, UfrmEffect_Draw,
  UnViewColorBox, UfrmEffectBase;

type
  TfrmEffect_Draw2 = class(TForm)
    ComboBox1: TComboBox;
    ColorBox1: TnViewColorBox;
    Label1: TLabel;
    Label2: TLabel;
    SpinEdit1: TSpinEdit;
    Label3: TLabel;
    CheckBox1: TCheckBox;
    Label4: TLabel;
    ColorBox2: TnViewColorBox;
    BitBtn2: TBitBtn;
    BitBtn1: TBitBtn;
    CheckBox2: TCheckBox;
    procedure FormShow(Sender: TObject);
    procedure ComboBox1Change(Sender: TObject);
    procedure FormCreate(Sender: TObject);
  private
    { Private declarations }
    changing:boolean;
  public
    { Public declarations }
    PBalloonRec1:PBalloonRec;
    frmEffect_Balloon:TfrmEffectBase;
  end;

var
  frmEffect_Draw2: TfrmEffect_Draw2;

implementation

{$R *.dfm}

procedure TfrmEffect_Draw2.FormShow(Sender: TObject);
begin
  ComboBox1.ItemIndex:=integer(PBalloonRec1.drawtype);
  ColorBox1.Selected:=PBalloonRec1.drawcolor;
  SpinEdit1.Value:=PBalloonRec1.drawwidth;
  CheckBox1.Checked:=PBalloonRec1.drawfill;
  ColorBox2.Selected:=PBalloonRec1.drawfillcolor;
  CheckBox2.Checked:=PBalloonRec1.drawcaption;

  changing:=true;

  ComboBox1Change(nil);
end;

procedure TfrmEffect_Draw2.ComboBox1Change(Sender: TObject);
begin
  if changing=false then exit;
  PBalloonRec1.drawtype:=Tdrawtype(ComboBox1.ItemIndex);
  PBalloonRec1.drawcolor:=ColorBox1.Selected;
  PBalloonRec1.drawwidth:=SpinEdit1.Value;
  PBalloonRec1.drawfill:=CheckBox1.Checked;
  PBalloonRec1.drawfillcolor:=ColorBox2.Selected;
  PBalloonRec1.drawcaption:=CheckBox2.Checked;

  frmEffect_Balloon.imagepreview1.Invalidate;

  ColorBox1.Enabled:=PBalloonRec1.drawtype<>dtnone;
  SpinEdit1.Enabled:=PBalloonRec1.drawtype<>dtnone;
  CheckBox1.Enabled:=PBalloonRec1.drawtype<>dtnone;
  ColorBox2.Enabled:=PBalloonRec1.drawtype<>dtnone;
end;

procedure TfrmEffect_Draw2.FormCreate(Sender: TObject);
begin
  changing:=false;
end;

end.
