{
   This program is free software; you can redistribute it and/or
  modify it under the terms of the GNU General Public License
  as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
}
unit Ufrmoption;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, Buttons, Spin, jpeg, ExtCtrls, gr32, ComCtrls;

type
  Tfrmoption = class(TForm)
    Button4: TButton;
    Button5: TButton;
    Button1: TButton;
    PageControl1: TPageControl;
    TabSheet1: TTabSheet;
    TabSheet2: TTabSheet;
    GroupBox1: TGroupBox;
    Label1: TLabel;
    Label3: TLabel;
    c_mosaicsize: TSpinEdit;
    GroupBox2: TGroupBox;
    Label2: TLabel;
    Label4: TLabel;
    Label6: TLabel;
    Image1: TImage;
    Image2: TImage;
    Image3: TImage;
    Label5: TLabel;
    c_mosaicimgsize: TSpinEdit;
    c_mosaicresize: TComboBox;
    c_closeprompt: TCheckBox;
    Label7: TLabel;
    c_backcolor: TColorBox;
    procedure FormCreate(Sender: TObject);
    procedure Button4Click(Sender: TObject);
    procedure Button1Click(Sender: TObject);
    procedure c_mosaicresizeChange(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  frmoption: Tfrmoption;

implementation
uses shellapi, Uconfig, Ufunction, Umainhelper;
{$R *.dfm}

procedure Tfrmoption.FormCreate(Sender: TObject);
begin
  self.PageControl1.ActivePageIndex:=0;
  
  c_closeprompt.Checked:=config.c_closeprompt;
  c_mosaicsize.Value:=config.c_mosaicsize;
  c_mosaicimgsize.Value:=config.c_mosaicimgsize;
  c_mosaicresize.ItemIndex:=config.c_mosaicresize;
  c_mosaicresizeChange(nil);
  c_backcolor.Selected:=config.c_backcolor;
end;

procedure Tfrmoption.Button4Click(Sender: TObject);
begin
  config.c_closeprompt:=c_closeprompt.Checked;
  config.c_mosaicsize:=c_mosaicsize.Value;
  config.c_mosaicimgsize:=c_mosaicimgsize.Value;
  config.c_mosaicresize:=c_mosaicresize.ItemIndex;
  config.c_backcolor:=c_backcolor.Selected;
end;

procedure Tfrmoption.Button1Click(Sender: TObject);
begin
  c_closeprompt.Checked:=true;
  c_mosaicsize.Value:=9;
  c_mosaicimgsize.Value:=25;
  c_backcolor.Selected:=clAppWorkSpace;
  c_mosaicresize.ItemIndex:=1;
end;

procedure Tfrmoption.c_mosaicresizeChange(Sender: TObject);
var
  bmp,bmp2:tbitmap32;
  w,h:integer;
begin
  bmp:=tbitmap32.Create;
  bmp2:=tbitmap32.Create;
  try
    bmp.Assign(image1.Picture.Bitmap);

    w:=55;//image1.Picture.Bitmap.Width;
    h:=55;//image1.Picture.Bitmap.Height;
    Resample(bmp, bmp2, w, h, TStretchFilter(c_mosaicresize.ItemIndex));
    image2.Picture.Bitmap.Width:=w;
    image2.Picture.Bitmap.Height:=h;
    bmp2.AssignTo(image2.Picture.Bitmap);
    image2.Invalidate;
  finally
    bmp.Free;
    bmp2.Free;
  end;
end;

end.


