{
   This program is free software; you can redistribute it and/or
  modify it under the terms of the GNU General Public License
  as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
}
unit Ufrmresize;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, Spin;

type
  Tfrmresize = class(TForm)
    Button1: TButton;
    Button2: TButton;
    SpinEdit1: TSpinEdit;
    SpinEdit2: TSpinEdit;
    Label6: TLabel;
    c_mosaicresize: TComboBox;
    CheckBox1: TCheckBox;
    Label1: TLabel;
    Label2: TLabel;
    Label3: TLabel;
    procedure SpinEdit1Exit(Sender: TObject);
    procedure SpinEdit2Exit(Sender: TObject);
    procedure FormShow(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure Button1Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
    src_w,src_h:integer;
  end;

var
  frmresize: Tfrmresize;

implementation
uses Uconfig;

{$R *.dfm}

procedure Tfrmresize.SpinEdit1Exit(Sender: TObject);
begin
  if self.CheckBox1.Checked then
    SpinEdit2.Value:=round(SpinEdit1.Value*src_h/src_w);
end;

procedure Tfrmresize.SpinEdit2Exit(Sender: TObject);
begin
  if self.CheckBox1.Checked then
    SpinEdit1.Value:=round(SpinEdit2.Value*src_w/src_h);
end;

procedure Tfrmresize.FormShow(Sender: TObject);
begin
  self.Label3.Caption:=format(' X = %d X %d',[src_w,src_h]);

  self.CheckBox1.Checked:=config.c_resizekeepratio;
  self.SpinEdit1.Value:=config.c_resizewidth;
  if SpinEdit1.Value=0 then SpinEdit1.Value:=src_w;
  self.SpinEdit2.Value:=config.c_resizeheight;
  if SpinEdit2.Value=0 then SpinEdit2.Value:=src_h;
  if CheckBox1.Checked then
    SpinEdit2.Value:=round(SpinEdit1.Value*src_h/src_w);

  self.c_mosaicresize.ItemIndex:=config.c_resizekind;
end;

procedure Tfrmresize.FormClose(Sender: TObject; var Action: TCloseAction);
begin
  config.c_resizekeepratio:=self.CheckBox1.Checked;
  config.c_resizewidth:=self.SpinEdit1.Value;
  config.c_resizeheight:=self.SpinEdit2.Value;
  config.c_resizekind:=self.c_mosaicresize.ItemIndex;
end;

procedure Tfrmresize.Button1Click(Sender: TObject);
begin
  if CheckBox1.Checked then
    SpinEdit2.Value:=round(SpinEdit1.Value*src_h/src_w);
end;

end.
