{
   This program is free software; you can redistribute it and/or
  modify it under the terms of the GNU General Public License
  as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
}
unit Uconfig;

interface

uses
  Windows, Forms, Classes, SysUtils, ComCtrls, inifiles, EmbeddedWB, graphics;

type
  TSimpleConfig = class(TObject)
  public
    c_closeprompt:boolean;
    c_mosaicsize,c_mosaicimgsize,c_mosaicresize:integer;
    c_lastdir:string;
    c_selectfetchidx,c_selectfetchcount:integer;
    c_fetchkeyword1,c_fetchkeyword2:String;

    c_resizekeepratio:boolean;
    c_resizewidth,c_resizeheight,c_resizekind:integer;

    c_webviewer_srcfile,c_webviewer_destfolder,c_webviewer_title:string;
    c_webviewer_thumbsize:integer;

    c_dialog_preview:boolean;
    c_backcolor:integer;

    procedure Initialize;
    procedure LoadFromFile(const FileName: String);
    procedure SaveToFile(const FileName: String);
  end;

var
  Config: TSimpleConfig;

implementation

uses Ufunction, UfrmMain;

procedure TSimpleConfig.Initialize;
begin
end;

procedure TSimpleConfig.LoadFromFile(const FileName: String);
var
  Ini: TInifile;
  i,j:integer;
  s,value:string;
  strlist:tstringlist;
begin
  Ini:= TInifile.Create(FileName);
  try try
    with frmMain do begin
      Left:=Ini.ReadInteger('Config', 'window_left', 10);
      Top:=Ini.ReadInteger('Config', 'window_top', 10);
      Width:=Ini.ReadInteger('Config', 'window_width', 750);
      Height:=Ini.ReadInteger('Config', 'window_height', 550);
      if Ini.ReadBool('Config', 'window_max', false) then
        WindowState:=wsMaximized;
    end;

    c_closeprompt:=Ini.ReadBool('Config', 'c_closeprompt', true);
    c_mosaicsize:=Ini.ReadInteger('Config', 'c_mosaicsize', 9);
    c_mosaicimgsize:=Ini.ReadInteger('Config', 'c_mosaicimgsize', 25);
    c_mosaicresize:=Ini.ReadInteger('Config', 'c_mosaicresize', 1);
    c_lastdir:=Ini.ReadString('Config', 'c_lastdir', '');
    c_selectfetchidx:=Ini.ReadInteger('Config', 'c_selectfetchidx', 0);
    c_selectfetchcount:=Ini.ReadInteger('Config', 'c_selectfetchcount', 1000);
    c_fetchkeyword1:=Ini.ReadString('Config', 'c_fetchkeyword1', 'ī');
    c_fetchkeyword2:=Ini.ReadString('Config', 'c_fetchkeyword2', 'ī');

    c_resizekeepratio:=Ini.ReadBool('Config', 'c_resizekeepratio', true);
    c_resizewidth:=Ini.ReadInteger('Config', 'c_resizewidth', 0);
    c_resizeheight:=Ini.ReadInteger('Config', 'c_resizeheight', 0);
    c_resizekind:=Ini.ReadInteger('Config', 'c_resizekind', 1);

    c_webviewer_srcfile:=Ini.ReadString('Config', 'c_webviewer_srcfile', '');
    c_webviewer_destfolder:=Ini.ReadString('Config', 'c_webviewer_destfolder', '');
    c_webviewer_title:=Ini.ReadString('Config', 'c_webviewer_title', '');
    c_webviewer_thumbsize:=Ini.ReadInteger('Config', 'c_webviewer_thumbsize', 250);

    c_dialog_preview:=Ini.ReadBool('Config', 'c_dialog_preview', true);
    c_backcolor:=Ini.ReadInteger('Config', 'c_backcolor', clAppWorkSpace);

  except
  end;
  finally
    Ini.Free;
  end;
end;

procedure TSimpleConfig.SaveToFile(const FileName: String);
var
  Ini: TInifile;
  i:integer;
  s,value:string;
begin
  ForceDirectories(ExtractFilePath(FileName));
  Ini := TInifile.Create(FileName);
  try try
    with frmMain do begin
      if WindowState=wsNormal then begin
        Ini.WriteInteger('Config', 'window_left', Left);
        Ini.WriteInteger('Config', 'window_top', Top);
        Ini.WriteInteger('Config', 'window_width', Width);
        Ini.WriteInteger('Config', 'window_height', Height);
        Ini.WriteBool('Config', 'window_max', false);
      end else if wsMaximized=wsMaximized then
        Ini.WriteBool('Config', 'window_max', true)
      else
        Ini.WriteBool('Config', 'window_max', false);
    end;

    Ini.WriteBool('Config', 'c_closeprompt', c_closeprompt);
    Ini.WriteInteger('Config', 'c_mosaicsize', c_mosaicsize);
    Ini.WriteInteger('Config', 'c_mosaicimgsize', c_mosaicimgsize);
    Ini.WriteInteger('Config', 'c_mosaicresize', c_mosaicresize);
    Ini.WriteString('Config', 'c_lastdir', c_lastdir);
    Ini.WriteInteger('Config', 'c_selectfetchidx', c_selectfetchidx);
    Ini.WriteInteger('Config', 'c_selectfetchcount', c_selectfetchcount);
    Ini.WriteString('Config', 'c_fetchkeyword1', c_fetchkeyword1);
    Ini.WriteString('Config', 'c_fetchkeyword2', c_fetchkeyword2);

    Ini.WriteBool('Config', 'c_resizekeepratio', c_resizekeepratio);
    Ini.WriteInteger('Config', 'c_resizewidth', c_resizewidth);
    Ini.WriteInteger('Config', 'c_resizeheight', c_resizeheight);
    Ini.WriteInteger('Config', 'c_resizekind', c_resizekind);

    Ini.WriteString('Config', 'c_webviewer_srcfile', c_webviewer_srcfile);
    Ini.WriteString('Config', 'c_webviewer_destfolder', c_webviewer_destfolder);
    Ini.WriteString('Config', 'c_webviewer_title', c_webviewer_title);
    Ini.WriteInteger('Config', 'c_webviewer_thumbsize', c_webviewer_thumbsize);
    Ini.WriteBool('Config', 'c_dialog_preview', c_dialog_preview);
    Ini.WriteInteger('Config', 'c_backcolor', c_backcolor);
 except
  end;
  finally
    Ini.Free;
  end;
end;

initialization
  Config := TSimpleConfig.Create;
  Config.Initialize;

finalization
  Config.Free;

end.

