{

   This program is free software; you can redistribute it and/or
  modify it under the terms of the GNU General Public License
  as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
}
unit UfrmEffect_Rotate;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, UfrmEffectBase, im_Basic, StdCtrls, Spin, ExtCtrls, Buttons,
  UnViewColorBox;

type
  TfrmEffect_Rotate = class(TfrmEffectBase)
    Panel1: TPanel;
    Label7: TLabel;
    ValueGroup: TRadioGroup;
    SpinEdit1: TSpinEdit;
    Button1: TButton;
    Button2: TButton;
    ColorBox1: TnViewColorBox;
    bsSkinStdLabel2: TLabel;
    CheckBox1: TCheckBox;
    procedure SpinEdit1Change(Sender: TObject);
    procedure ValueGroupClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure FormShow(Sender: TObject);
    procedure Button1Click(Sender: TObject);
    procedure Button2Click(Sender: TObject);
    procedure ColorBox1Change(Sender: TObject);
    procedure CheckBox1Click(Sender: TObject);
  private
    { Private declarations }
    lastaction:integer;
    procedure ok_select; override;
    procedure imageprocess(var src:tbitmap);
    procedure set_effectapply;
  public
    { Public declarations }
    fiximage:boolean;
  end;

var
  frmEffect_Rotate: TfrmEffect_Rotate;

implementation
uses Uconfig, UfrmMain;
{$R *.dfm}

procedure TfrmEffect_Rotate.SpinEdit1Change(Sender: TObject);
var
  i:integer;
begin
  imagepreview1.bitmap.Assign(thumb_bitmap32);
  if self.CheckBox1.Checked or fiximage then
    im_Basic.ImageRotate(imagepreview1.bitmap,SpinEdit1.Value,ColorBox1.Selected)
  else
    im_Basic.imagerotate2(imagepreview1.bitmap,SpinEdit1.Value,ColorBox1.Selected);
  lastaction:=1;
end;

procedure TfrmEffect_Rotate.ValueGroupClick(Sender: TObject);
begin
  case ValueGroup.ItemIndex of
    0:SpinEdit1.Value:=0;
    1:SpinEdit1.Value:=90;
    2:SpinEdit1.Value:=180;
    3:SpinEdit1.Value:=270;
   end;
   SpinEdit1Change(self);
end;

procedure TfrmEffect_Rotate.FormCreate(Sender: TObject);
begin
  inherited;
  PanelPreView.Width:=250;
  PanelPreView.Align:=alLeft;
  Panel1.Align:=alClient;

  lastaction:=0;
  fiximage:=false;
end;

procedure TfrmEffect_Rotate.FormShow(Sender: TObject);
var
  c:integer;
begin
  ColorBox1.Selected:=config.getvaluebyinteger('rotate_backcolor',clblack);

  make_thumbimage;
  imagepreview1.Bitmap.Assign(thumb_bitmap32);

  config.getvaluebyinteger('rotate_lastaction');
  if config.lastvalue_integer=1 then begin
    c:=config.getvaluebyinteger('rotate_angle');
    case c of
      0:ValueGroup.ItemIndex:=0;
      90:ValueGroup.ItemIndex:=1;
      180:ValueGroup.ItemIndex:=2;
      270:ValueGroup.ItemIndex:=3;
      else
        SpinEdit1.Value:=c;
    end;
  end;

  applyselect.Visible:=not frmmain.is_layerselected;
  CheckBox1.Checked:=boolean(config.getvaluebyinteger('rotate_fit',0));

  if fiximage then self.CheckBox1.Enabled:=false;
end;

procedure TfrmEffect_Rotate.Button1Click(Sender: TObject);
begin
  imagepreview1.bitmap.Assign(thumb_bitmap32);
  imagefliphoriz(imagepreview1.bitmap);
  lastaction:=2;
end;

procedure TfrmEffect_Rotate.Button2Click(Sender: TObject);
begin
  imagepreview1.bitmap.Assign(thumb_bitmap32);
  imageflipvert(imagepreview1.bitmap);
  lastaction:=3;
end;

procedure TfrmEffect_Rotate.set_effectapply;
begin
  case lastaction of
    1:begin
      if self.CheckBox1.Checked or fiximage then
        im_Basic.ImageRotate(org_bitmap32,SpinEdit1.Value,ColorBox1.Selected)
      else
        im_Basic.imagerotate2(org_bitmap32,SpinEdit1.Value,ColorBox1.Selected);
    end;
    2:imagefliphoriz(org_bitmap32);
    3:imageflipvert(org_bitmap32);
  end;
end;

procedure TfrmEffect_Rotate.ok_select;
begin
  config.setvaluebyinteger('rotate_lastaction',lastaction);
  config.setvaluebyinteger('rotate_angle',SpinEdit1.Value);
  config.setvaluebyinteger('rotate_backcolor',ColorBox1.Selected);
  config.setvaluebyinteger('rotate_fit',integer(CheckBox1.Checked));

  if applyselect.ItemIndex=0 then begin
    Screen.Cursor:=crHourglass;
    try
      set_effectapply;
      imagepreview1.Bitmap.Assign(org_bitmap32);
    finally
      screen.Cursor:=crdefault;
    end;
    exit;
  end;

  frmmain.apply_listimages(applyselect.ItemIndex=1,imageprocess,etRotate,self.Caption);
  self.ModalResult:=mrcancel;
end;

procedure TfrmEffect_Rotate.imageprocess(var src:tbitmap);
begin
  org_bitmap32.Assign(src);
  set_effectapply;
  org_bitmap32.AssignTo24(src);
end;

procedure TfrmEffect_Rotate.ColorBox1Change(Sender: TObject);
begin
  SpinEdit1Change(nil);
end;

procedure TfrmEffect_Rotate.CheckBox1Click(Sender: TObject);
begin
  SpinEdit1Change(self);
end;

end.
