unit UColorForm;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, ComCtrls, StdCtrls, ExtCtrls, Buttons, Couleur, Spin, UPSPFrame,
  UAdobeFrame, ToolWin, ImgList, UAdobeFrame2, UPersoFrame, Menus;
const
  LibEpsilon: Real=1E-8;
  LibRadian: Real=3.1415926536/180;
  RectPSP: TRect = (Left:44;Top:44;right:150;bottom:150);
  MaxPixelCount   =  32768;

type

  TColorForm = class(TForm)
    Panel8: TPanel;
    FramePSP: TFramePSP;
    FrameAdobe1: TFrameAdobe;
    TBChoice: TToolBar;
    TBAdobe: TToolButton;
    ILSoft: TImageList;
    TBPsp: TToolButton;
    FrameAdobe2: TFrameAdobe2;
    TBAdobe2: TToolButton;
    TBPerso: TToolButton;
    ColorDialog1: TColorDialog;
    FramePerso: TFramePerso;
    PMCouleur: TPopupMenu;
    Ajoutgnral1: TMenuItem;
    Ajoutspcifique1: TMenuItem;
    ToolBar1: TToolBar;
    TBuPerso: TToolButton;
    ImageList1: TImageList;
    SpeedButton1: TBitBtn;
    SpeedButton2: TBitBtn;
    procedure FormCreate(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure TBClick(Sender: TObject);
    procedure SpeedButton1Click(Sender: TObject);
    procedure SpeedButton2Click(Sender: TObject);
    procedure Ajoutspcifique1Click(Sender: TObject);
    procedure Ajoutgnral1Click(Sender: TObject);
    procedure FormKeyDown(Sender: TObject; var Key: Word;
      Shift: TShiftState);
    procedure TBuPersoClick(Sender: TObject);
  private
    FCouleur: TCouleur;
    MemuRapide : Integer;
    { Dclarations prives }
    procedure HideFrame;
    procedure SetCouleur(const Value: TCouleur);
  public
    { Dclarations publiques }
    OldCouleur : TColor;
    constructor Create(AOwner: TComponent); override;
    destructor Destroy; override;
  published
    property Couleur : TCouleur read FCouleur write SetCouleur;
  end;

implementation

{$R *.dfm}

procedure TColorForm.FormCreate(Sender: TObject);
begin
  self.Width:=358;
end;

procedure TColorForm.FormDestroy(Sender: TObject);
begin
//
end;

procedure TColorForm.HideFrame;
begin
  if FrameAdobe1.Visible then
    FCouleur.Assign(FrameAdobe1.Couleur)
  else
  if FrameAdobe2.Visible then
    FCouleur.Assign(FrameAdobe2.Couleur)
  else
  if FramePSP.Visible then
    FCouleur.Assign(FramePSP.Couleur)
  else
  if FramePerso.Visible then
    FCouleur.Assign(FramePerso.Couleur);

  FramePSP.Hide;
  FrameAdobe1.Hide;
  FrameAdobe2.Hide;
  FramePerso.Hide;
end;

procedure TColorForm.TBClick(Sender: TObject);
begin
  if TToolButton(Sender).Down then
  begin
    HideFrame;
    case TToolButton(Sender).Tag of
      0 : begin
        TBuPerso.Enabled := True;
        FramePSP.DrawMark;
        FramePSP.Couleur.Assign(FCouleur);
        FramePSP.MAJCoul;
        FramePSP.Show;
      end;
      1 : begin
        TBuPerso.Enabled := True;
        FrameAdobe1.HideTriangle;
        FrameAdobe1.Couleur.Assign(FCouleur);
        FrameAdobe1.MAJCoul;
        FrameAdobe1.Show;
      end;
      2 : begin
        TBuPerso.Enabled := True;
        FrameAdobe2.DrawCur;
        FrameAdobe2.Couleur.Assign(FCouleur);
        FrameAdobe2.MAJCoul;
        FrameAdobe2.Show;
      end;
      4 : begin
        TBuPerso.Enabled := False;
        FramePerso.Show;
      end;
    end;
  end;
end;

procedure TColorForm.SpeedButton1Click(Sender: TObject);
begin
  if FramePSP.Visible then
    FCouleur.Assign(FramePSP.Couleur)
  else
  if FrameAdobe1.Visible then
    FCouleur.Assign(FrameAdobe1.Couleur)
  else
  if FrameAdobe2.Visible then
    FCouleur.Assign(FrameAdobe2.Couleur)
  else
  if FramePerso.Visible then
    FCouleur.Assign(FramePerso.Couleur);
  OldCouleur := Couleur.Color;
  FramePSP.OldColor := OldCouleur;
  ModalResult := mrOk;
end;

procedure TColorForm.SpeedButton2Click(Sender: TObject);
begin
  Couleur.Color := OldCouleur;
  ModalResult := mrCancel;
end;

constructor TColorForm.Create(AOwner: TComponent);
begin
  inherited Create(AOwner);
  FCouleur := TCouleur.Create;
  if not(csDesigning in ComponentState) then
  begin
    OldCouleur := clBlack;
    FramePSP.OldColor := OldCouleur;
    FramePSP.CreateFrame;
    FrameAdobe1.CreateFrame;
    FrameAdobe2.CreateFrame;
    FramePerso.CreateFrame;

    FramePSP.InitPSP;
    FrameAdobe1.InitAdobe;
    FrameAdobe2.InitAdobe2;
    FramePerso.InitPerso;
  end;
  MemuRapide := 1;
end;

destructor TColorForm.Destroy;
begin
  if not(csDesigning in ComponentState) then
  begin
    FramePerso.FreeFrame;
    FrameAdobe2.FreeFrame;
    FrameAdobe1.FreeFrame;
    FramePSP.FreeFrame;
  end;
  FCouleur.Free;
  inherited;
end;

procedure TColorForm.SetCouleur(const Value: TCouleur);
begin
  FCouleur.Assign(Value);
  if TBAdobe.Down then
  begin
    FrameAdobe1.HideTriangle;
    FrameAdobe1.Couleur.Assign(FCouleur);
    FrameAdobe1.MAJCoul;
    FrameAdobe1.Show;
  end
  else
  if TBAdobe2.Down then
  begin
    FrameAdobe2.DrawCur;
    FrameAdobe2.Couleur.Assign(FCouleur);
    FrameAdobe2.MAJCoul;
    FrameAdobe2.Show;
  end
  else
  if TBPsp.Down then
  begin
    FramePSP.DrawMark;
    FramePSP.Couleur.Assign(FCouleur);
    FramePSP.MAJCoul;
    FramePSP.Show;
  end;

end;

procedure TColorForm.Ajoutspcifique1Click(Sender: TObject);
var
  I       : Integer;
  Trouver : Boolean;
begin
  MemuRapide := 1;
  if FrameAdobe1.Visible then
    FCouleur.Assign(FrameAdobe1.Couleur)
  else
  if FrameAdobe2.Visible then
    FCouleur.Assign(FrameAdobe2.Couleur)
  else
  if FramePSP.Visible then
    FCouleur.Assign(FramePSP.Couleur);


  I := 0;
  Trouver := False;
  while (I<FramePerso.GBSpe.ControlCount)and(Trouver=False) do
  begin
    if FramePerso.GBSpe.Controls[I] is Timage then
    begin
      if TImage(FramePerso.GBSpe.Controls[I]).Enabled=False then
      begin
        Trouver := True;
        TImage(FramePerso.GBSpe.Controls[I]).Enabled := True;
        TImage(FramePerso.GBSpe.Controls[I]).Tag := FCouleur.Color;
        TImage(FramePerso.GBSpe.Controls[I]).Canvas.Brush.Color := FCouleur.Color;
        FramePerso.ImageClick(TImage(FramePerso.GBSpe.Controls[I]));
      end

    end;
    Inc(I);
  end;
  if not Trouver then
  begin
    if MessageBox(Handle,PChar('Il n''y a plus de place, Voulez-vous que la couleur prenne la premire position dans la grille ?'+#13+' Pour effacer le contenu d''une case placez-vous dessus et appuyer sur la touche Supprimer.'),PChar('Attention'),MB_ICONWARNING or MB_YESNO)=IDYES then
    begin
      TImage(FramePerso.GBSpe.Controls[0]).Tag := FCouleur.Color;
      TImage(FramePerso.GBSpe.Controls[0]).Canvas.Brush.Color := FCouleur.Color;
      FramePerso.ImageClick(TImage(FramePerso.GBSpe.Controls[0]));
    end;  
  end;
end;

procedure TColorForm.Ajoutgnral1Click(Sender: TObject);
var
  I       : Integer;
  Trouver : Boolean;
begin
  MemuRapide := 2;
  if FrameAdobe1.Visible then
    FCouleur.Assign(FrameAdobe1.Couleur)
  else
  if FrameAdobe2.Visible then
    FCouleur.Assign(FrameAdobe2.Couleur)
  else
  if FramePSP.Visible then
    FCouleur.Assign(FramePSP.Couleur);


  I := 0;
  Trouver := False;
  while (I<FramePerso.GBGen.ControlCount)and(Trouver=False) do
  begin
    if FramePerso.GBGen.Controls[I] is Timage then
    begin
      if TImage(FramePerso.GBGen.Controls[I]).Enabled=False then
      begin
        Trouver := True;
        TImage(FramePerso.GBGen.Controls[I]).Enabled := True;
        TImage(FramePerso.GBGen.Controls[I]).Tag := FCouleur.Color;
        TImage(FramePerso.GBGen.Controls[I]).Canvas.Brush.Color := FCouleur.Color;
        FramePerso.ImageClick(TImage(FramePerso.GBGen.Controls[I]));
      end

    end;
    Inc(I);
  end;
  if not Trouver then
  begin
    if MessageBox(Handle,PChar('Il n''y a plus de place, Voulez-vous que la couleur prenne la premire position dans la grille ?'+#13+' Pour effacer le contenu d''une case placez-vous dessus et appuyer sur la touche Supprimer.'),PChar('Attention'),MB_ICONWARNING or MB_YESNO)=IDYES then
    begin
      TImage(FramePerso.GBGen.Controls[0]).Tag := FCouleur.Color;
      TImage(FramePerso.GBGen.Controls[0]).Canvas.Brush.Color := FCouleur.Color;
      FramePerso.ImageClick(TImage(FramePerso.GBGen.Controls[0]));
    end;  
  end;
end;

procedure TColorForm.FormKeyDown(Sender: TObject; var Key: Word;
  Shift: TShiftState);
var
  I : Integer;
begin
  if (Key=VK_DELETE)and(FramePerso.Visible)then
  begin
    for I := 0 to FramePerso.GBGen.ControlCount-1 do
      if FramePerso.GBGen.Controls[I]=FramePerso.Old then
      begin
        FramePerso.Old.Tag := -1;
        FramePerso.Old.Canvas.Brush.Color := clWhite;
        FramePerso.DrawCoul(FramePerso.Old);
        FramePerso.Old.Enabled := False;
        FramePerso.Old := nil;
      end;
    for I := 0 to FramePerso.GBSpe.ControlCount-1 do
      if FramePerso.GBSpe.Controls[I]=FramePerso.Old then
      begin
        FramePerso.Old.Tag := -1;
        FramePerso.Old.Canvas.Brush.Color := clWhite;
        FramePerso.DrawCoul(FramePerso.Old);
        FramePerso.Old.Enabled := False;
        FramePerso.Old := nil;
      end;
  end;
end;

procedure TColorForm.TBuPersoClick(Sender: TObject);
begin
{
 case MemuRapide of
   1 : Ajoutspcifique1Click(Sender);
   2 : Ajoutgnral1Click(Sender);
 end;}
end;

end.
