// AnimationControlDlg.cpp : implementation file
//

#include "stdafx.h"
#include "LittleMeshViewr.h"
#include "AnimationControlDlg.h"
#include "MainFrm.h"
#include "LittleMeshViewrDoc.h"


// CAnimationControlDlg dialog


IMPLEMENT_DYNAMIC(CAnimationControlDlg, CDialog)

CAnimationControlDlg::CAnimationControlDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CAnimationControlDlg::IDD, pParent)
{
	m_bPlayStatePlayButton = true;
	m_pDocument = (CLittleMeshViewrDoc*)(((CMainFrame*)theApp.GetMainWnd())->GetActiveDocument());
	m_cLoopState = STATE_PLAYONCE;
	m_strLoopStateString[STATE_PLAYONCE] = L"1 ->";
	m_strLoopStateString[STATE_LOOP_ONEANIMATION] = L"1 <->";
	m_strLoopStateString[STATE_ALLANIMATION] = L"All ->";
	m_strLoopStateString[STATE_LOOP_ALLANIMATION] = L"All <->";
	m_fAnimationTimeSpeedValue = 1.0f;
	m_fPrevAnimationPlayTime = 0.0f;
	m_fAnimationTimeLength = 0.0f;
	m_nPrevTimeBarPosition = 0;
}

CAnimationControlDlg::~CAnimationControlDlg()
{
	m_pDocument = NULL;
}

void CAnimationControlDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	DDX_Control(pDX, IDC_ANIMATIONTIME_SLIDE, m_ctrlTimeBar);
}


BEGIN_MESSAGE_MAP(CAnimationControlDlg, CDialog)
	ON_BN_CLICKED(IDC_QUICK_PLAYANIMATION_BUTTON, &CAnimationControlDlg::OnBnClickedQuickPlayanimationButton)
	ON_BN_CLICKED(IDC_QUICK_STOPANIMATION_BUTTON, &CAnimationControlDlg::OnBnClickedQuickStopanimationButton)
	ON_CBN_SELCHANGE(IDC_QUICK_ANIMATIONNAME_COMBOBOX, &CAnimationControlDlg::OnCbnSelchangeQuickAnimationnameCombobox)
	ON_LBN_SELCHANGE(IDC_ANIMATIONNAME_LIST, &CAnimationControlDlg::OnLbnSelchangeAnimationnameList)
	ON_BN_CLICKED(IDC_LOOPINGOPTION_BUTTON, &CAnimationControlDlg::OnBnClickedLoopingoptionButton)
//	ON_WM_CREATE()
//	ON_WM_SHOWWINDOW()
ON_NOTIFY(UDN_DELTAPOS, IDC_ANIMATIONSPEED_SPINBUTTON, &CAnimationControlDlg::OnDeltaposAnimationspeedSpinbutton)
ON_NOTIFY(NM_CUSTOMDRAW, IDC_ANIMATIONTIME_SLIDE, &CAnimationControlDlg::OnNMCustomdrawAnimationtimeSlide)
ON_NOTIFY(NM_RELEASEDCAPTURE, IDC_ANIMATIONTIME_SLIDE, &CAnimationControlDlg::OnNMReleasedcaptureAnimationtimeSlide)
ON_WM_HSCROLL()
ON_BN_CLICKED(IDC_ADDSKELETON_BUTTON, &CAnimationControlDlg::OnBnClickedAddskeletonButton)
ON_BN_CLICKED(IDC_MOTIONBLENDING_CHECKBOX, &CAnimationControlDlg::OnBnClickedMotionblendingCheckbox)
END_MESSAGE_MAP()


// CAnimationControlDlg message handlers

void CAnimationControlDlg::OnBnClickedQuickPlayanimationButton()
{
	// TODO: Add your control notification handler code here
	if(m_bPlayStatePlayButton)
	{
		m_pDocument->PlayAnimation();
		GetDlgItem(IDC_QUICK_PLAYANIMATION_BUTTON)->SetWindowTextW(L"Pause");
	}
	else
	{
		m_pDocument->PauseAnimation();
		GetDlgItem(IDC_QUICK_PLAYANIMATION_BUTTON)->SetWindowTextW(L"Play");
	}

	m_bPlayStatePlayButton = !m_bPlayStatePlayButton;
}

void CAnimationControlDlg::OnBnClickedQuickStopanimationButton()
{
	// TODO: Add your control notification handler code here
	m_pDocument->StopAnimation();

	GetDlgItem(IDC_QUICK_PLAYANIMATION_BUTTON)->SetWindowTextW(L"Play");
	m_bPlayStatePlayButton = true;
}

void CAnimationControlDlg::OnCbnSelchangeQuickAnimationnameCombobox()
{
	// TODO: Add your control notification handler code here
	wchar_t szAnimationName[64] = {0,};

	CComboBox* pNameListCombo = 
		(CComboBox*)(GetDlgItem(IDC_QUICK_ANIMATIONNAME_COMBOBOX));
	pNameListCombo->GetWindowTextW(szAnimationName,64);

	CListBox* pNameListBox = 
		(CListBox*)(GetDlgItem(IDC_ANIMATIONNAME_LIST));
	pNameListBox->SelectString(0,szAnimationName);

	USES_CONVERSION;
	std::string strNewName = W2A(szAnimationName);
	m_pDocument->SelectAnimation(strNewName.c_str());

	GetDlgItem(IDC_QUICK_PLAYANIMATION_BUTTON)->SetWindowTextW(L"Pause");
	m_bPlayStatePlayButton = false;
	m_pDocument->PlayAnimation();
}

void CAnimationControlDlg::InitAnimationList(std::wstring* pAnimationNames, int nCount)
{
	CComboBox* pNameListCombo = 
		(CComboBox*)(GetDlgItem(IDC_QUICK_ANIMATIONNAME_COMBOBOX));
	CListBox* pNameListBox = 
		(CListBox*)(GetDlgItem(IDC_ANIMATIONNAME_LIST));
	for(int i=0; i<nCount; ++i)
	{
		pNameListCombo->AddString(pAnimationNames[i].c_str());
		pNameListBox->AddString(pAnimationNames[i].c_str());
	}
	pNameListCombo->SelectString(0,pAnimationNames[0].c_str());
	pNameListBox->SelectString(0,pAnimationNames[0].c_str());

	USES_CONVERSION;
	std::string strNewName = W2A(pAnimationNames[0].c_str());
	m_pDocument->SelectAnimation(strNewName.c_str());

	GetDlgItem(IDC_QUICK_PLAYANIMATION_BUTTON)->SetWindowTextW(L"Play");
	m_bPlayStatePlayButton = true;

	m_fAnimationTimeSpeedValue = 1.0f;
	CWnd* pBuddy = ((CSpinButtonCtrl*)GetDlgItem(IDC_ANIMATIONSPEED_SPINBUTTON))->GetBuddy();
	wchar_t strNewValue[10] = {0,};
	swprintf(strNewValue,L"%.1f",m_fAnimationTimeSpeedValue);
	pBuddy->SetWindowTextW(strNewValue);
	m_pDocument->ChangeAnimationSpeedFactor(m_fAnimationTimeSpeedValue);
}

void CAnimationControlDlg::ResetAnimationList()
{
	CComboBox* pNameListCombo = 
		(CComboBox*)(GetDlgItem(IDC_QUICK_ANIMATIONNAME_COMBOBOX));
	pNameListCombo->ResetContent();

	CListBox* pNameListBox = 
		(CListBox*)(GetDlgItem(IDC_ANIMATIONNAME_LIST));
	pNameListBox->ResetContent();
}

void CAnimationControlDlg::OnCancel()
{
	// TODO: Add your specialized code here and/or call the base class

	//CDialog::OnCancel();
}

void CAnimationControlDlg::OnOK()
{
	// TODO: Add your specialized code here and/or call the base class

	//CDialog::OnOK();
}

void CAnimationControlDlg::OnLbnSelchangeAnimationnameList()
{
	// TODO: Add your control notification handler code here
	wchar_t szAnimationName[64] = {0,};

	CListBox* pNameListBox = 
		(CListBox*)(GetDlgItem(IDC_ANIMATIONNAME_LIST));
	pNameListBox->GetText(pNameListBox->GetCurSel(),szAnimationName);

	CComboBox* pNameListCombo = 
		(CComboBox*)(GetDlgItem(IDC_QUICK_ANIMATIONNAME_COMBOBOX));
	pNameListCombo->SelectString(0,szAnimationName);

	USES_CONVERSION;
	std::string strNewName = W2A(szAnimationName);
	m_pDocument->SelectAnimation(strNewName.c_str());

	GetDlgItem(IDC_QUICK_PLAYANIMATION_BUTTON)->SetWindowTextW(L"Pause");
	m_bPlayStatePlayButton = false;
	m_pDocument->PlayAnimation();
}

void CAnimationControlDlg::OnPlayingAnimationState(bool bState)
{
	if(m_bPlayStatePlayButton != bState)
	{
		m_bPlayStatePlayButton = bState;
		GetDlgItem(IDC_QUICK_PLAYANIMATION_BUTTON)->SetWindowTextW(L"Play");
	}
}

void CAnimationControlDlg::OnBnClickedLoopingoptionButton()
{
	// TODO: Add your control notification handler code here
	if(m_cLoopState < STATE_LOOP_ONEANIMATION)
	{
		m_cLoopState++;
	}
	else
	{
		m_cLoopState = STATE_PLAYONCE;
	}
	GetDlgItem(IDC_LOOPINGOPTION_BUTTON)->SetWindowTextW(m_strLoopStateString[m_cLoopState].c_str());
}

BOOL CAnimationControlDlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	// TODO:  Add extra initialization here
	GetDlgItem(IDC_LOOPINGOPTION_BUTTON)->SetWindowTextW(m_strLoopStateString[m_cLoopState].c_str());

	GetDlgItem(IDC_ANIMATIONSPEED_EDIT)->SetWindowTextW(L"1.000");

	((CSpinButtonCtrl*)GetDlgItem(IDC_ANIMATIONSPEED_SPINBUTTON))->SetBuddy(GetDlgItem(IDC_ANIMATIONSPEED_EDIT));
	((CSpinButtonCtrl*)GetDlgItem(IDC_ANIMATIONSPEED_SPINBUTTON))->SetRange(0,10);

	return TRUE;  // return TRUE unless you set the focus to a control
	// EXCEPTION: OCX Property Pages should return FALSE
}

void CAnimationControlDlg::SetAnimationTimeLength(float fTimeLength)
{
	m_fAnimationTimeLength = fTimeLength;
	fTimeLength *= 100;
	m_ctrlTimeBar.SetRange(0,(int)fTimeLength);
	m_ctrlTimeBar.SetPos(0);
	m_ctrlTimeBar.SetRedraw();

	wchar_t strNewValue[64] = {0,};
	swprintf(strNewValue,L"%.2f / %.2f",0.00,m_fAnimationTimeLength);
	GetDlgItem(IDC_CURRENTPLAYINGTIME_STATIC)->SetWindowTextW(strNewValue);
}

void CAnimationControlDlg::SetCurrentAnimationTime(float fCurrentTime)
{
	if(fCurrentTime != m_fPrevAnimationPlayTime)
	{
		m_ctrlTimeBar.SetPos((int)(fCurrentTime*100));
		m_ctrlTimeBar.SetRedraw();

		wchar_t strNewValue[64] = {0,};
		swprintf(strNewValue,L"%.2f / %.2f",fCurrentTime,m_fAnimationTimeLength);
		GetDlgItem(IDC_CURRENTPLAYINGTIME_STATIC)->SetWindowTextW(strNewValue);

		m_fPrevAnimationPlayTime = fCurrentTime;
	}
}

char CAnimationControlDlg::GetLoopState()
{
	return m_cLoopState;
}

void CAnimationControlDlg::OnDeltaposAnimationspeedSpinbutton(NMHDR *pNMHDR, LRESULT *pResult)
{
	LPNMUPDOWN pNMUpDown = reinterpret_cast<LPNMUPDOWN>(pNMHDR);
	// TODO: Add your control notification handler code here

	m_fAnimationTimeSpeedValue = m_fAnimationTimeSpeedValue + (pNMUpDown->iDelta * 0.1);

	if(m_fAnimationTimeSpeedValue < 0.1)
	{
		m_fAnimationTimeSpeedValue = 0.1;
	}
	else if(m_fAnimationTimeSpeedValue > 10.0)
	{
		m_fAnimationTimeSpeedValue = 10.0;
	}

	CWnd* pBuddy = ((CSpinButtonCtrl*)GetDlgItem(IDC_ANIMATIONSPEED_SPINBUTTON))->GetBuddy();
	wchar_t strNewValue[10] = {0,};
	swprintf(strNewValue,L"%.1f",m_fAnimationTimeSpeedValue);
	pBuddy->SetWindowTextW(strNewValue);

	m_pDocument->ChangeAnimationSpeedFactor(m_fAnimationTimeSpeedValue);

	*pResult = 0;
}

void CAnimationControlDlg::OnNMCustomdrawAnimationtimeSlide(NMHDR *pNMHDR, LRESULT *pResult)
{
	LPNMCUSTOMDRAW pNMCD = reinterpret_cast<LPNMCUSTOMDRAW>(pNMHDR);
	// TODO: Add your control notification handler code here
	*pResult = 0;
}

void CAnimationControlDlg::OnNMReleasedcaptureAnimationtimeSlide(NMHDR *pNMHDR, LRESULT *pResult)
{
	// TODO: Add your control notification handler code here
	*pResult = 0;
}

void CAnimationControlDlg::OnHScroll(UINT nSBCode, UINT nPos, CScrollBar* pScrollBar)
{
	// TODO: Add your message handler code here and/or call default

	if(nSBCode == TB_THUMBTRACK)
	{
		int nPos = ((CSliderCtrl*)pScrollBar)->GetPos();
		if(nPos != m_nPrevTimeBarPosition)
		{
			float fTimePosition = 0.0f;
			// Animation time is float type(1.083333). But our control use integer.(1.08)
			// so, check integer max value.
			if(nPos >= ((CSliderCtrl*)pScrollBar)->GetRangeMax())
			{
				fTimePosition = m_fAnimationTimeLength;
			}
			else
			{
				fTimePosition = nPos * 0.01;
			}
			m_pDocument->SetAnimationTimePosition(fTimePosition);

			m_nPrevTimeBarPosition = nPos;
		}
	}

	CDialog::OnHScroll(nSBCode, nPos, pScrollBar);
}

void CAnimationControlDlg::OnBnClickedAddskeletonButton()
{
	// TODO: Add your control notification handler code here
	//MessageBoxW(L"Next version :)");

	wchar_t szFilters[128] = L"Skeleton Files (*.skeleton)|*.skelton|All Files (*.*)|*.*||";

	// Create an Open dialog; the default file name extension is ".my".
	CFileDialog fileDlg(TRUE, L"skelton", L"*.skeleton", OFN_FILEMUSTEXIST|OFN_HIDEREADONLY|OFN_ENABLESIZING, szFilters, this);

	wchar_t szWorkingDir[256] = {0,};
	::GetCurrentDirectory(256,szWorkingDir);

	// Display the file dialog. When user clicks OK, fileDlg.DoModal() 
	// returns IDOK.
	CString fileName;
	if( fileDlg.DoModal() == IDOK )
	{
		fileName = fileDlg.GetFileName();

		::SetCurrentDirectory(szWorkingDir);

		USES_CONVERSION;
		std::string strFileName = W2A(fileName.GetBuffer());
		m_pDocument->AddSkeletonFile(strFileName.c_str());
	}
	else
	{
		::SetCurrentDirectory(szWorkingDir);
	}
}

void CAnimationControlDlg::OnBnClickedMotionblendingCheckbox()
{
	// TODO: Add your control notification handler code here
}

void CAnimationControlDlg::SetDialogControlsEnable(BOOL bEnable)
{
	GetDlgItem(IDC_QUICK_ANIMATIONNAME_COMBOBOX)->EnableWindow(bEnable);
	GetDlgItem(IDC_QUICK_PLAYANIMATION_BUTTON)->EnableWindow(bEnable);
	GetDlgItem(IDC_QUICK_STOPANIMATION_BUTTON)->EnableWindow(bEnable);
	GetDlgItem(IDC_LOOPINGOPTION_BUTTON)->EnableWindow(bEnable);
	GetDlgItem(IDC_ANIMATIONSPEED_SPINBUTTON)->EnableWindow(bEnable);
	GetDlgItem(IDC_ANIMATIONTIME_SLIDE)->EnableWindow(bEnable);
	GetDlgItem(IDC_ANIMATIONNAME_LIST)->EnableWindow(bEnable);
	GetDlgItem(IDC_ADDSKELETON_BUTTON)->EnableWindow(bEnable);
}
