// LittleMeshViewr.cpp : Defines the class behaviors for the application.
//

#include "stdafx.h"
#include "LittleMeshViewr.h"
#include "MainFrm.h"

#include "LittleMeshViewrDoc.h"
#include "LittleMeshViewrView.h"
#include <mmsystem.h>

//#ifdef _DEBUG
//#define new DEBUG_NEW
//#endif


// CLittleMeshViewrApp

BEGIN_MESSAGE_MAP(CLittleMeshViewrApp, CWinApp)
	ON_COMMAND(ID_APP_ABOUT, &CLittleMeshViewrApp::OnAppAbout)
	// Standard file based document commands
	ON_COMMAND(ID_FILE_NEW, &CWinApp::OnFileNew)
	ON_COMMAND(ID_FILE_OPEN, &CWinApp::OnFileOpen)
END_MESSAGE_MAP()


// CLittleMeshViewrApp construction

CLittleMeshViewrApp::CLittleMeshViewrApp()
{
	// TODO: add construction code here,
	// Place all significant initialization in InitInstance
	m_pOgreRoot = NULL;
	m_dwPrevFrameTime = 0;
}


// The one and only CLittleMeshViewrApp object

CLittleMeshViewrApp theApp;


// CLittleMeshViewrApp initialization

BOOL CLittleMeshViewrApp::InitInstance()
{
	// InitCommonControlsEx() is required on Windows XP if an application
	// manifest specifies use of ComCtl32.dll version 6 or later to enable
	// visual styles.  Otherwise, any window creation will fail.
	INITCOMMONCONTROLSEX InitCtrls;
	InitCtrls.dwSize = sizeof(InitCtrls);
	// Set this to include all the common control classes you want to use
	// in your application.
	InitCtrls.dwICC = ICC_WIN95_CLASSES;
	InitCommonControlsEx(&InitCtrls);

	CWinApp::InitInstance();

	_CrtSetReportMode( _CRT_WARN, _CRTDBG_MODE_FILE ); 
	_CrtSetReportFile( _CRT_WARN, _CRTDBG_FILE_STDERR );

	if(InitOgre() == false)
	{
		return FALSE;
	}

	// Initialize OLE libraries
	if (!AfxOleInit())
	{
		AfxMessageBox(IDP_OLE_INIT_FAILED);
		return FALSE;
	}
	AfxEnableControlContainer();
	// Standard initialization
	// If you are not using these features and wish to reduce the size
	// of your final executable, you should remove from the following
	// the specific initialization routines you do not need
	// Change the registry key under which our settings are stored
	// TODO: You should modify this string to be something appropriate
	// such as the name of your company or organization
	SetRegistryKey(_T("Local AppWizard-Generated Applications"));
	LoadStdProfileSettings(4);  // Load standard INI file options (including MRU)
	// Register the application's document templates.  Document templates
	//  serve as the connection between documents, frame windows and views
	CSingleDocTemplate* pDocTemplate;
	pDocTemplate = new CSingleDocTemplate(
		IDR_MAINFRAME,
		RUNTIME_CLASS(CLittleMeshViewrDoc),
		RUNTIME_CLASS(CMainFrame),       // main SDI frame window
		RUNTIME_CLASS(CLittleMeshViewrView));
	if (!pDocTemplate)
		return FALSE;
	AddDocTemplate(pDocTemplate);



	// Parse command line for standard shell commands, DDE, file open
	CCommandLineInfo cmdInfo;
	ParseCommandLine(cmdInfo);


	// Dispatch commands specified on the command line.  Will return FALSE if
	// app was launched with /RegServer, /Register, /Unregserver or /Unregister.
	if (!ProcessShellCommand(cmdInfo))
		return FALSE;

	// The one and only window has been initialized, so show and update it
	m_pMainWnd->ShowWindow(SW_SHOW);
	m_pMainWnd->UpdateWindow();
	// call DragAcceptFiles only if there's a suffix
	//  In an SDI app, this should occur after ProcessShellCommand
	return TRUE;
}



// CAboutDlg dialog used for App About

class CAboutDlg : public CDialog
{
public:
	CAboutDlg();

// Dialog Data
	enum { IDD = IDD_ABOUTBOX };

protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support

// Implementation
protected:
	DECLARE_MESSAGE_MAP()
};

CAboutDlg::CAboutDlg() : CDialog(CAboutDlg::IDD)
{
}

void CAboutDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
}

BEGIN_MESSAGE_MAP(CAboutDlg, CDialog)
END_MESSAGE_MAP()

// App command to run the dialog
void CLittleMeshViewrApp::OnAppAbout()
{
	CAboutDlg aboutDlg;
	aboutDlg.DoModal();
}


// CLittleMeshViewrApp message handlers



void CLittleMeshViewrApp::SetupResources(String resourceFileName)
{
	//
	// Setup paths to all resources
	//
	Ogre::ConfigFile cf;
	cf.load(resourceFileName);
	// Go through all sections & settings in the file
	Ogre::ConfigFile::SectionIterator seci = cf.getSectionIterator();
	Ogre::String secName, typeName, archName;
	while (seci.hasMoreElements())
	{
		secName = seci.peekNextKey();
		Ogre::ConfigFile::SettingsMultiMap *settings = seci.getNext();
		Ogre::ConfigFile::SettingsMultiMap::iterator i;
		for (i = settings->begin(); i != settings->end(); ++i)
		{
			typeName = i->first;
			archName = i->second;
			Ogre::ResourceGroupManager::getSingleton().addResourceLocation(
				archName, typeName, secName);
		}
	}
}
//
// 쿡 밡 RenderSystem ̸
// "Direct3D9 Rendering SubSystem"
// "OpenGL Rendering Subsystem"
//
Ogre::RenderSystem* CLittleMeshViewrApp::SelectRenderSystem(Ogre::String searchString)
{
	Ogre::RenderSystemList::iterator pRend = m_pOgreRoot->getAvailableRenderers()->begin();
	while (pRend != m_pOgreRoot->getAvailableRenderers()->end())
	{
		Ogre::String rName = (*pRend)->getName();
		if (rName == searchString)      // match found
			return (*pRend);
		++pRend;
	}
	return NULL;
}

void CLittleMeshViewrApp::SetupRenderSystem(Ogre::RenderSystem *pRenderSystem)
{
	ASSERT(pRenderSystem);
	//
	// Some standard rendering system configurations
	//
	pRenderSystem->setConfigOption("Full Screen", "No");
	pRenderSystem->setConfigOption("VSync", "Yes");
	// Set the rendering system.
	m_pOgreRoot->setRenderSystem(pRenderSystem);
}

bool CLittleMeshViewrApp::InitOgre()
{
	// Create Ogre::Root object
	m_pOgreRoot = new Ogre::Root("plugins.cfg", "Ogre.cfg", "Ogre.log");
	SetupResources("resources.cfg");

	Ogre::RenderSystem *rsys = SelectRenderSystem("Direct3D9 Rendering Subsystem");
	if(NULL == rsys)
	{
		// if the proper one is not found
		return false;
	}

	SetupRenderSystem(rsys);

	//
	// Initialize the system, but don't create a render window.
	// ڰ false  ߿.
	//
	m_pOgreRoot->initialise(false);
	return true;
}

void CLittleMeshViewrApp::SetupOgre(HWND hWnd, int nWidth, int nHeight)
{
	//
	// Create a render window
	//
	if(NULL == m_pOgreRoot)
	{
		return;
	}

	NameValuePairList options;
	options["externalWindowHandle"] = StringConverter::toString((size_t)hWnd);
	m_pRenderWindow = m_pOgreRoot->createRenderWindow("LittleMewhViewer", nWidth, nHeight, false, &options);

	m_pSceneManager = m_pOgreRoot->createSceneManager(Ogre::ST_GENERIC);

	m_pSceneManager->setAmbientLight(Ogre::ColourValue(1,1,1,1));

	m_pCamera = m_pSceneManager->createCamera("camera");
    m_pCamera->setNearClipDistance(1.0);
	m_pCamera->setFarClipDistance(1000.0);

	// Create one viewport, entire window
    Ogre::Viewport* vp = m_pRenderWindow->addViewport(m_pCamera);
    vp->setBackgroundColour(Ogre::ColourValue(0,0,0));

    // Alter the camera aspect ratio to match the viewport
    m_pCamera->setAspectRatio(Ogre::Real(nWidth) / Ogre::Real(nHeight));

	m_pCamera->setPosition(0,0,0);
	m_pCamera->lookAt(0,0,0);

	//Ogre::Light* pLight = m_pSceneManager->createLight("light001");
	//pLight->setDiffuseColour(1,1,1);
	//pLight->setDirection(0,0,0);
	//pLight->setPosition(0,100,100);

	// Set default mipmap level (NB some APIs ignore this)
	Ogre::TextureManager::getSingleton().setDefaultNumMipmaps(5);
	//
	// Load resources
	//
	Ogre::ResourceGroupManager::getSingleton().initialiseAllResourceGroups();
	//
	// Create the scene
	//
	// Make window active and post an update
	m_pRenderWindow->setActive(true);
	m_pRenderWindow->update();
}

int CLittleMeshViewrApp::ExitInstance()
{
	// TODO: Add your specialized code here and/or call the base class

	if(m_pOgreRoot)
	{
		m_pRenderWindow->destroy();
		m_pSceneManager->clearScene();
		m_pOgreRoot->destroySceneManager(m_pSceneManager);
		delete m_pOgreRoot;
		m_pOgreRoot = NULL;
	}

	return CWinApp::ExitInstance();
}

BOOL CLittleMeshViewrApp::OnIdle(LONG lCount)
{
	// TODO: Add your specialized code here and/or call the base class

	if(m_pOgreRoot)
	{
		DWORD dwCurrentTime = ::timeGetTime();
		DWORD dwTimeSinceLastFrame = dwCurrentTime - m_dwPrevFrameTime;
		((CLittleMeshViewrDoc*)(((CMainFrame*)GetMainWnd())->GetActiveDocument()))->FrameProc(dwTimeSinceLastFrame);
		m_dwPrevFrameTime = dwCurrentTime;
		m_pOgreRoot->renderOneFrame();
	}

	CWinApp::OnIdle(lCount);
	return true;
}
