#include "StdAfx.h"
#include "ToolMeshManager.h"
#include "LittleMeshViewr.h"
#include "Ogre.h"

CToolMeshManager::CToolMeshManager(void)
{
	m_pMainEntity = NULL;
	m_pMainNode = NULL;
	m_nLoadedMeshCount = 0;
	m_pvecNodeList.clear();
	m_pvecNodeList.reserve(16);
}

CToolMeshManager::~CToolMeshManager(void)
{
}

void CToolMeshManager::LoadMeshFile(const char* szFileName)
{
	if(m_pMainEntity)
	{
		if(HasSkeletonAnimation())
		{
			unsigned short num_ani = m_pMainEntity->getSkeleton()->getNumAnimations();
			Ogre::StringVector strAnimationList;
			for(int i=0; i<num_ani; ++i)
			{
				Ogre::String strAnimationName = 
					m_pMainEntity->getSkeleton()->getAnimation(i)->getName();
				strAnimationList.push_back(strAnimationName);
			}

			int nAnimationCount = (int)(strAnimationList.size());
			// Do not remove first(index:0) animation.(It's default skeleton.)
			// If remove it,
			//    when load same entity you will not have any skeleton animation lsit.
			// So, remove animation from 1 to AnimationCount.(Not from 0)
			// Is it right? I don't know well... :)
			for(int i=1; i<nAnimationCount; ++i)
			{
				m_pMainEntity->getSkeleton()->removeAnimation(strAnimationList[i]);
			}
		}
		theApp.m_pSceneManager->destroyAllEntities();
	}
	if(m_pMainNode)
	{
		theApp.m_pSceneManager->destroySceneNode(m_pMainNode);
		int nNodeCount = (int)(m_pvecNodeList.size());
		for(int i=0; i<nNodeCount; ++i)
		{
			theApp.m_pSceneManager->destroySceneNode(m_pvecNodeList[i]);
		}
		m_pvecNodeList.clear();
		m_nLoadedMeshCount = 0;
	}

	m_pMainEntity = theApp.m_pSceneManager->createEntity("MainEntity",szFileName);
	m_pMainNode = theApp.m_pSceneManager->getRootSceneNode()->createChildSceneNode("MainNode");
	m_pMainNode->attachObject(m_pMainEntity);
}

void CToolMeshManager::AddMeshFile(const char* szFileName)
{
	Ogre::String strName = "Entity_";
	strName = strName + Ogre::StringConverter::toString(m_nLoadedMeshCount);
	Ogre::Entity* pEntity = theApp.m_pSceneManager->createEntity(strName,szFileName);
	Ogre::SceneNode* pNode = theApp.m_pSceneManager->getRootSceneNode()->createChildSceneNode(strName);
	pNode->attachObject(pEntity);

	int nReturnMsg = 
		MessageBox(NULL,L"share skeleton instance with main entity?",L"AddMesh",MB_YESNO);
	if(IDYES == nReturnMsg)
	{
		theApp.m_pSceneManager->getRootSceneNode()->removeChild(pNode);
		m_pMainNode->addChild(pNode);

		pEntity->shareSkeletonInstanceWith(m_pMainEntity);
	}

	m_pvecNodeList.push_back(pNode);
	m_nLoadedMeshCount++;
}

bool CToolMeshManager::HasSkeletonAnimation()
{
	return (m_pMainEntity->hasSkeleton());
}

const Ogre::Entity* CToolMeshManager::GetMainEntity()
{
	return m_pMainEntity;
}

const Ogre::SceneNode* CToolMeshManager::GetMainNode()
{
	return m_pMainNode;
}
