/**
 * 
 * @author Hahm Myung Sun (hms1475@gmail.com)
 *
 * Copyright (c) 2011 JinoTech (http://www.jinotech.com) 
 * Licensed under the LGPL v3.0 license (http://www.gnu.org/licenses/lgpl.html).
 */
///////////////////////////////////////////////////////////////////////////////
/////////////////////////
///////////////////////////////////////////////////////////////////////////////
var MAX_HISTORY_LENGTH = 50;
UndoRedoManager = function(){	
	this.undoList = new Array();	
	this.redoList = new Array();
}
UndoRedoManager.prototype.type = "UndoRedoManager";
//UndoRedoManager.prototype.addToHistory = function(node, id, isChild){
//	var data = null;	 
//	data = node && this.extractNode(node, isChild);
//	
//	this.undoList.push({'id':id, 'data':data, 'isChild':isChild});		
//}
UndoRedoManager.prototype.addToHistory = function(undo, redo){	
	this.undoList.push({'undo':undo, 'redo':redo});
	if(this.undoList.length > MAX_HISTORY_LENGTH){
		this.undoList.splice(0,1);
	}
}
UndoRedoManager.prototype.undo = function(){
	if(this.undoList.length == 0) return false;
	var history = this.undoList.pop();
	var id = history.undo && history.undo.id || history.redo.id;
	var node = jMap.getNodeById(id);
	this.redoList.push(history);
	var recoveryNode = null;
	if(history.undo){
		recoveryNode = this.recoveryNode(node, history.undo);
		recoveryNode.setFoldingExecute(recoveryNode.folded)	
	} else {
		node.removeExecute();
	}
	jMap.fireActionListener(ACTIONS.ACTION_NODE_UNDO, id, history.undo);
	jMap.layoutManager.updateTreeHeightsAndRelativeYOfWholeMap();
	return true;
}
UndoRedoManager.prototype.redo = function(){
	if(this.redoList.length == 0) return false;
	var history = this.redoList.pop();
	var id = history.redo && history.redo.id || history.undo.id;
	var node = jMap.getNodeById(id);
	this.undoList.push(history);
	var recoveryNode = null;
	if(history.redo){
		recoveryNode = this.recoveryNode(node, history.redo);
		recoveryNode.setFoldingExecute(recoveryNode.folded)	
	} else {
		node.removeExecute();
	}
	jMap.fireActionListener(ACTIONS.ACTION_NODE_REDO, id, history.redo);
	jMap.layoutManager.updateTreeHeightsAndRelativeYOfWholeMap();
	return true;
}
UndoRedoManager.prototype.extractNode = function(node, isChild){
	var data = {};
	var bodyAttr = node.body.attr();
	//delete bodyAttr["fill-opacity"];	
	delete bodyAttr.gradient;
	bodyAttr.fill = node.background_color
	bodyAttr.stroke = node.edge.color;
	bodyAttr["stroke-width"] = node.stroke_width;
	data.body = bodyAttr;
	var textAttr = node.text.attr();
	data.text = textAttr;
	var folderAttr = node.folderShape.attr();
	//delete folderAttr["fill-opacity"];
	data.folderShape = folderAttr;
	data.hyperlink = node.hyperlink && node.hyperlink.attr().href;
	data.img = node.img && node.img.attr().src;
	data.note = node.note;
	data.background_color = node.background_color;
	data.color = node.color;
	data.folded = node.folded;
	data.id = node.id;
	data.plainText = node.plainText;
	data.link = node.link;
	data.position = node.position;
	data.style = node.style;
	data.created = node.created;
	data.modified = node.modified;
	data.hgap = node.hgap;
	data.vgap = node.vgap;
	data.vshift = node.vshift;
	data.SHIFT = node.SHIFT;
	data.relYPos = node.relYPos;
	data.treeWidth = node.treeWidth;
	data.treeHeight = node.treeHeight;
	data.leftTreeWidth = node.leftTreeWidth;
	data.rightTreeWidth = node.rightTreeWidth;
	data.upperChildShift = node.upperChildShift;
	data.edge = node.edge;
	data.stroke_width = node.stroke_width;
	data.fontSize = node.fontSize;
	if(node.foreignObjEl){		
		data.foreignObject_plainHtml = node.foreignObjEl.plainHtml;
		data.foreignObject_width = node.foreignObjEl.getAttribute("width");
		data.foreignObject_height = node.foreignObjEl.getAttribute("height");
	}
	data.parentid = node.getParent() && node.getParent().id;
	data.childPosition = node.getIndexPos();
	if(isChild){
		data.child = new Array;
		if(node.getChildren().length > 0) {
			var children = node.getChildren();
			for(var i = 0; i < children.length; i++) {
				data.child.push(this.extractNode(children[i], isChild));
			}
		}		
	}	
	return data;
}
UndoRedoManager.prototype.recoveryNode = function(node, data){
	if(data.body.removed) return;
	if(!node){
		var parentNode = jMap.getNodeById(data.parentid);
		var id = null;
		var index = null;
		if(data.id) id = data.id;
		index = data.childPosition;
		node = jMap.createNodeWithCtrlExecute(parentNode, "", id, index);
		parentNode.folded && parentNode.setFoldingExecute(parentNode.folded);
		data.hyperlink && node.setHyperlinkExecute(data.hyperlink);
		data.img && node.setImageExecute(data.img);
	}
	node.body.attr(data.body);
	node.text.attr(data.text);
	node.folderShape.attr(data.folderShape);	
	node.note = data.note;
	node.background_color = data.background_color;
	node.color = data.color;
	node.folded = data.folded;
	//node.id = data.id;				
	node.plainText = data.plainText;
	node.link = data.link;
	node.position = data.position;
	node.style = data.style;
	node.created = data.created;
	node.modified = data.modified;
	node.hgap = data.hgap;
	node.vgap = data.vgap;
	node.vshift = data.vshift;
	node.SHIFT = data.SHIFT;
	node.relYPos = data.relYPos;
	node.treeWidth = data.treeWidth;
	node.treeHeight = data.treeHeight;
	node.leftTreeWidth = data.leftTreeWidth;
	node.rightTreeWidth = data.rightTreeWidth;
	node.upperChildShift = data.upperChildShift;
	node.edge = data.edge;
	node.stroke_width = data.stroke_width;
	node.fontSize = data.fontSize;
	if(data.foreignObject_plainHtml){		
		node.setForeignObjectExecute(data.foreignObject_plainHtml, 
				data.foreignObject_width, data.foreignObject_height);
	}
	if(data.child && data.child.length > 0){
		for(var i=0; i < data.child.length; i++){
			this.recoveryNode(null, data.child[i]);
		}
	}
	return node;
}
