// PreProcess.h: interface for the CPreProcess class.
//
//////////////////////////////////////////////////////////////////////

#pragma once

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include "..\Define.h"

class CPreProcess  
{
public:
	CPreProcess();
	virtual ~CPreProcess();

	
	float	GetAngle(OVR_POINT StPt,OVR_POINT EdPt);
	RECT	GetBoundingBox(OVR_POINT *pPt, int PtNum);
	int		GetPointAryBetweenTwoPoints(OVR_POINT P1,OVR_POINT P2,OVR_POINT* PtAry);

	OVR_POINT*	LinearNormalize(OVR_POINT* pOrgPt,int OrgPtNum,STROKE* pOrgStroke,
								STROKE* pNorStroke,int nStrokeNum, int& NorPtNum);
	OVR_POINT*	LinearNormalizeOnlyHorW(OVR_POINT* pOrgPt,int OrgPtNum,STROKE* pOrgStroke,
								STROKE* pNorStroke,int nStrokeNum, int& NorPtNum);
	OVR_POINT*	GetAllPtArryAndResample(OVR_POINT *pPt, int PtNum,STROKE* pStroke,
								int nStrokeNum,int* pSamPtNo, int& SamPtNum,int& NewPtNum);
	OVR_POINT*	RemoveHookFromOrg(OVR_POINT *pPt, int PtNum,STROKE* pStroke,
								STROKE* pNewStroke,int nStrokeNum,int& NewPtNum);

};
