// DrawOnlineDlg.cpp : implementation file
//

#include "stdafx.h"
#include "DrawOnline.h"
#include "DrawOnlineDlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CAboutDlg dialog used for App About

class CAboutDlg : public CDialog
{
public:
	CAboutDlg();

// Dialog Data
	//{{AFX_DATA(CAboutDlg)
	enum { IDD = IDD_ABOUTBOX };
	//}}AFX_DATA

	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CAboutDlg)
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	//}}AFX_VIRTUAL

// Implementation
protected:
	//{{AFX_MSG(CAboutDlg)
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

CAboutDlg::CAboutDlg() : CDialog(CAboutDlg::IDD)
{
	//{{AFX_DATA_INIT(CAboutDlg)
	//}}AFX_DATA_INIT
}

void CAboutDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CAboutDlg)
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CAboutDlg, CDialog)
	//{{AFX_MSG_MAP(CAboutDlg)
		// No message handlers
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CDrawOnlineDlg dialog

CDrawOnlineDlg::CDrawOnlineDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CDrawOnlineDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CDrawOnlineDlg)
	//}}AFX_DATA_INIT
	// Note that LoadIcon does not require a subsequent DestroyIcon in Win32
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
}

void CDrawOnlineDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CDrawOnlineDlg)
	DDX_Control(pDX, IDC_IN_WINDOW, m_rdInWindow);
	DDX_Control(pDX, IDC_IN_SIGNPAD, m_rdInSignPad);
	DDX_Control(pDX, IDC_PADDRAW2, m_PadDraw2);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CDrawOnlineDlg, CDialog)
	//{{AFX_MSG_MAP(CDrawOnlineDlg)
	ON_WM_SYSCOMMAND()
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	ON_BN_CLICKED(IDC_RECOG, OnRecog)
	ON_BN_CLICKED(IDC_CLEAR, OnClear)
	ON_WM_LBUTTONDOWN()
	ON_WM_LBUTTONUP()
	ON_WM_MOUSEMOVE()
	ON_BN_CLICKED(IDC_IN_WINDOW, OnInWindow)
	ON_BN_CLICKED(IDC_IN_SIGNPAD, OnInSignpad)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CDrawOnlineDlg message handlers

BOOL CDrawOnlineDlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	// Add "About..." menu item to system menu.

	// IDM_ABOUTBOX must be in the system command range.
	ASSERT((IDM_ABOUTBOX & 0xFFF0) == IDM_ABOUTBOX);
	ASSERT(IDM_ABOUTBOX < 0xF000);

	CMenu* pSysMenu = GetSystemMenu(FALSE);
	if (pSysMenu != NULL)
	{
		CString strAboutMenu;
		strAboutMenu.LoadString(IDS_ABOUTBOX);
		if (!strAboutMenu.IsEmpty())
		{
			pSysMenu->AppendMenu(MF_SEPARATOR);
			pSysMenu->AppendMenu(MF_STRING, IDM_ABOUTBOX, strAboutMenu);
		}
	}

	// Set the icon for this dialog.  The framework does this automatically
	//  when the application's main window is not a dialog
	SetIcon(m_hIcon, TRUE);			// Set big icon
	SetIcon(m_hIcon, FALSE);		// Set small icon
	
	// TODO: Add extra initialization here
	m_DrawRect = CRect(14,14,254,254);
	m_PtNum = 0;
	m_StrkNum = 0;
	m_bDown = FALSE;

	m_rdInWindow.SetCheck(BST_CHECKED);
	m_rdInSignPad.SetCheck(BST_UNCHECKED);
	
	return TRUE;  // return TRUE  unless you set the focus to a control
}

void CDrawOnlineDlg::OnSysCommand(UINT nID, LPARAM lParam)
{
	if ((nID & 0xFFF0) == IDM_ABOUTBOX)
	{
		CAboutDlg dlgAbout;
		dlgAbout.DoModal();
	}
	else
	{
		CDialog::OnSysCommand(nID, lParam);
	}
}

// If you add a minimize button to your dialog, you will need the code below
//  to draw the icon.  For MFC applications using the document/view model,
//  this is automatically done for you by the framework.

void CDrawOnlineDlg::OnPaint() 
{
	if (IsIconic())
	{
		CPaintDC dc(this); // device context for painting

		SendMessage(WM_ICONERASEBKGND, (WPARAM) dc.GetSafeHdc(), 0);

		// Center icon in client rectangle
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// Draw the icon
		dc.DrawIcon(x, y, m_hIcon);
	
	}
	else
	{
		CPaintDC dc(this); // device context for painting

		if(m_PtNum<=0) return;
		//if(m_StrkNum<=0) return;
		CBrush brush(RGB(0, 0, 0));
		CBrush* pOldBrush = dc.SelectObject(&brush);
		CPen pen(PS_SOLID,1,RGB(0,0,0));
		CPen* pOldPen = dc.SelectObject(&pen);

		OVR_POINT* pPts = m_pPt;
		int i,j,k,x,y,n,st,ed;
		OVR_POINT* pTempPt=m_pTempPt;
		
		// ׷ ü  
		for(i=0;i<m_StrkNum;i++)
		{	
			st = m_pStroke[i].stPtNo;
			ed = m_pStroke[i].edPtNo;
			for(j=st+1;j<=ed;j++){
				k = theApp.m_Recog.m_PreProcess.GetPointAryBetweenTwoPoints(pPts[j-1],pPts[j],pTempPt);
				for(n=0;n<k;n++){
					x = pTempPt[n].nX;
					y = pTempPt[n].nY;
					dc.Rectangle(CRect(x,y,(x+2),(y+2)));
				}
			}
			x = pPts[ed].nX;
			y = pPts[ed].nY;
			dc.Rectangle(CRect(x,y,(x+2),(y+2)));
		}

		//  ׸ ִ Ʈũ ǥ
		if(m_StrkNum==0) ed = 0;
		else ed = m_pStroke[m_StrkNum-1].edPtNo+1;
		if(m_PtNum>ed){
			st = m_pStroke[m_StrkNum].stPtNo;
			x = pPts[st].nX;
			y = pPts[st].nY;
			dc.Rectangle(CRect(x,y,(x+2),(y+2)));
			for(i=st+1;i<m_PtNum;i++)
			{	
				k = theApp.m_Recog.m_PreProcess.GetPointAryBetweenTwoPoints(pPts[i-1],pPts[i],pTempPt);
				for(j=0;j<k;j++){
					x = pTempPt[j].nX;
					y = pTempPt[j].nY;
					dc.Rectangle(CRect(x,y,(x+2),(y+2)));
				}
			}
			x = pPts[m_PtNum-1].nX;
			y = pPts[m_PtNum-1].nY;
			dc.Rectangle(CRect(x,y,(x+2),(y+2)));
		}
		CDialog::OnPaint();
	}
}

// The system calls this to obtain the cursor to display while the user drags
//  the minimized window.
HCURSOR CDrawOnlineDlg::OnQueryDragIcon()
{
	return (HCURSOR) m_hIcon;
}

void CDrawOnlineDlg::OnRecog() 
{
	int OrgPtNum= m_PtNum;
	int nStrkNum = m_StrkNum;

	if(nStrkNum>= MAXSTROKENUM){
		nStrkNum = MAXSTROKENUM-1;
		OrgPtNum = m_pStroke[nStrkNum-1].edPtNo+1;
	}
	WORD r = theApp.m_Recog.Recog(m_pPt,OrgPtNum,m_pStroke,nStrkNum);
	SetHuboList();
}
void CDrawOnlineDlg::SetHuboList() 
{
	CListCtrl* pList = (CListCtrl*)GetDlgItem(IDC_HUBO_LIST);
	pList->DeleteAllItems();
	BOOL b = pList->Arrange(LVA_ALIGNLEFT);
	HuboAry* pHubo = &(theApp.m_Recog.m_Hubo);
	WORD cd[2];cd[1]=0;
	for(int i=0;i<pHubo->Num;i++){
		cd[0] = pHubo->Hubo[i].Code;
		pList->InsertItem(i,(LPCTSTR)cd);
	}
}

void CDrawOnlineDlg::OnClear() 
{
	m_PtNum =0;
	m_StrkNum =0;
	m_bDown = FALSE;
	Invalidate();
}

void CDrawOnlineDlg::OnLButtonDown(UINT nFlags, CPoint point) 
{
	if (!m_DrawRect.PtInRect(point))
	{
		return;
	}
	if(m_StrkNum>= MAXSTROKENUM) return;
	if(m_PtNum>= MAXPTNUM/2) return;
	
	m_bDown = TRUE;
	m_pStroke[m_StrkNum].stPtNo = m_PtNum;
	m_pPt[m_PtNum].nX = point.x; 
	m_pPt[m_PtNum++].nY = point.y; 
	Invalidate(FALSE);
	SetCapture();
	
	CDialog::OnLButtonDown(nFlags, point);
}

void CDrawOnlineDlg::OnLButtonUp(UINT nFlags, CPoint point) 
{
	if(m_bDown){
		m_pStroke[m_StrkNum++].edPtNo = m_PtNum-1;
		m_bDown = FALSE;
		Invalidate(FALSE);
		OnRecog();
		ReleaseCapture();
	}
	
	CDialog::OnLButtonUp(nFlags, point);
}

void CDrawOnlineDlg::OnMouseMove(UINT nFlags, CPoint point) 
{
	CDialog::OnMouseMove(nFlags, point);
	if (!m_DrawRect.PtInRect(point))
	{
		return;
	}
	if(m_bDown){
		if(m_PtNum>= MAXPTNUM/2) return;
		m_pPt[m_PtNum].nX = point.x; 
		m_pPt[m_PtNum++].nY = point.y; 
		Invalidate(FALSE);
	}
}

void CDrawOnlineDlg::OnInWindow() 
{
	// TODO: Add your control notification handler code here
	//InitalizeSignPad();
	m_PadDraw2.ShowWindow(SW_HIDE);
	m_PadDraw2.FinishInput();
}

void CDrawOnlineDlg::OnInSignpad() 
{
	// TODO: Add your control notification handler code here
	//InitailizeWindow();
	this->OnClear();
	m_PadDraw2.ShowWindow(SW_SHOW);
	m_PadDraw2.ClearLCDDisplay();
	m_PadDraw2.StartInput();
}



BEGIN_EVENTSINK_MAP(CDrawOnlineDlg, CDialog)
    //{{AFX_EVENTSINK_MAP(CDrawOnlineDlg)
	ON_EVENT(CDrawOnlineDlg, IDC_PADDRAW2, 3 /* InputEnded */, OnInputEndedPaddraw2, VTS_NONE)
	//}}AFX_EVENTSINK_MAP
END_EVENTSINK_MAP()

void CDrawOnlineDlg::OnInputEndedPaddraw2() 
{
	// TODO: Add your control notification handler code here
	m_PadDraw2.ClearLCDDisplay();
	m_PadDraw2.StartInput();
}
