// RecogMain.cpp: implementation of the CRecogMain class.
//
//////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "RecogMain.h"


//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

CRecogMain::CRecogMain()
{
	m_Code = NULL;
	m_CodeNum = 0;
	SymBNNum = 0; m_SymbolBN = NULL;
	memset(CJZBNNum,0,sizeof(int)*3);
	m_JamoBN[0] = NULL;m_JamoBN[1] = NULL;m_JamoBN[2] = NULL;
	m_JamoBTWBN[0] = NULL;m_JamoBTWBN[1] = NULL;
	m_JamoBoundBN = NULL;
}

CRecogMain::~CRecogMain()
{
	EndDIC();

}
/*
________________________________________________________________
  
Function Name	: LoadDic
	
Purpose			: νĻ 
		
Input			: No

Output			: No

Return Value	: No

Description		: Ǵ ;
				  1. BN(DigitBN.dic)
				  2. ʼBN(ChoBN.dic)
				  3. ߼BN(JungBN.dic)
				  4. BN(ZongBN.dic)
				  5. - ȹBN(C2JBN.dic)
				  6. - ȹBN(J2ZBN.dic)
				  7. ڸġBN(RectBN.dic)
				  ̴.

Ref Journal		: No
	
date			: 2009/07/5
________________________________________________________________
*/
BOOL CRecogMain::LoadDic(char* szDicPath)
{

	FILE* file= NULL;
	char filename[MAX_PATH];


	EndDIC();
	m_Code = CCode::MakeKoreanCodeTable();
	m_CodeNum = KNum;

	int i,j,num;

///////////////////////////////
	sprintf(filename,"%s\\dic\\DigitBN.dic",szDicPath);
	file=fopen(filename,"rb");
	if(file == NULL) return FALSE;
	fread(&SymBNNum,sizeof(int),1,file);
	m_SymbolBN = new JAMOBN[SymBNNum];
	for(j=0;j<SymBNNum;j++){
		m_JamoBNCore.LoadBN(&m_SymbolBN[j],file);
	}
	fclose(file);
/////////////////////////////////////////////

	for(i=0;i<3;i++){
		if(i==0)
			sprintf(filename,"%s\\dic\\ChoBN.dic",szDicPath);
		if(i==1)
			sprintf(filename,"%s\\dic\\JungBN.dic",szDicPath);
		if(i==2)
			sprintf(filename,"%s\\dic\\ZongBN.dic",szDicPath);

		file=fopen(filename,"rb");
		if(file == NULL) return FALSE;
		
		fread(&CJZBNNum[i],sizeof(int),1,file);
		m_JamoBN[i] = (JAMOBN*)malloc(CJZBNNum[i]*sizeof(JAMOBN));
		for(j=0;j<CJZBNNum[i];j++){
			m_JamoBNCore.LoadBN(&m_JamoBN[i][j],file);
		}
		fclose(file);
	}

/////////////////////////////////////////////////

	for(i=0;i<2;i++){
		if(i==0){
			num = CHONum*JUNGNum;
			sprintf(filename,"%s\\dic\\C2JBN.dic",szDicPath);
		}
		if(i==1){
			num = JUNGNum*ZONGNum;
			sprintf(filename,"%s\\dic\\J2ZBN.dic",szDicPath);
		}

		file=fopen(filename,"rb");
		if(file == NULL) return FALSE;
		
		m_JamoBTWBN[i] = (JamoBTWBN*)malloc(num*sizeof(JamoBTWBN));
		for(j=0;j<num;j++){
			m_BTWBNCore.LoadBN(&m_JamoBTWBN[i][j],file);
		}
		fclose(file);
	}
	num = TYPENum;
	sprintf(filename,"%s\\dic\\RectBN.dic",szDicPath);

	file=fopen(filename,"rb");
	if(file == NULL) return FALSE;
	
	m_JamoBoundBN = (JamoBoundBN*)malloc(num*sizeof(JamoBoundBN));
	for(j=0;j<num;j++){
		m_BoundBNCore.LoadBN(&m_JamoBoundBN[j],file);
	}
	fclose(file);

	return TRUE;
}
/*
________________________________________________________________
  
Function Name	: EndDIC
	
Purpose			: ν  Ͽ  
		
Input			: No

Output			: No

Return Value	: No

Description		: 

Ref Journal		: No
	
date			: 2009/07/5
________________________________________________________________
*/
void CRecogMain::EndDIC()
{
	int i,j,no;
	if(m_Code!=NULL)free(m_Code);
	if(m_SymbolBN!=NULL){
		for(j=0;j<SymBNNum;j++) {
			m_JamoBNCore.deleteBN(&m_SymbolBN[j]);
		}
		free(m_SymbolBN);
		SymBNNum = 0;
	}
	for(i=0;i<3;i++){
		if(m_JamoBN[i]!=NULL){
			for(j=0;j<CJZBNNum[i];j++) {
				m_JamoBNCore.deleteBN(&m_JamoBN[i][j]);
			}
			free(m_JamoBN[i]);
			CJZBNNum[i] = 0;
		}
	}
	if(m_JamoBTWBN[0] != NULL){
		no=0;
		for(i=0;i<CHONum;i++)for(j=0;j<JUNGNum;j++){
			m_BTWBNCore.deleteBN(&m_JamoBTWBN[0][no]);
			no++;
		}
		free(m_JamoBTWBN[0]);
	}
	if(m_JamoBTWBN[1] != NULL){
		no=0;
		for(i=0;i<JUNGNum;i++)for(j=0;j<ZONGNum;j++){
			m_BTWBNCore.deleteBN(&m_JamoBTWBN[1][no]);
			no++;
		}
		free(m_JamoBTWBN[1]);
	}
	if(m_JamoBoundBN != NULL){
		for(i=0;i<TYPENum;i++){
			m_BoundBNCore.deleteBN(&m_JamoBoundBN[i]);
		}
		free(m_JamoBoundBN);
	}
}

/*
________________________________________________________________
  
Function Name	: GetBoundingBox
	
Purpose			: Է 迭 RealSt RealEd κ 迭 4 Ѵ.
		
Input			: 
	pPts		: Է 迭
	PtNum		: Է
	RealSt		: Է 迭 Ϸ ùȣ
	RealEd		: Է 迭 Ϸ ȣ

Output			: 4

Return Value	: No

Description		: 
Ref Journal		: No
	
date			: 2009/07/5
________________________________________________________________
*/
RECT CRecogMain::GetBoundingBox(REC_POINT *pPt, int PtNum,int RealSt,int RealEd)
{
	int i;
	RECT r;
	r.left=10000;r.top=10000;r.right=0;r.bottom=0;
	int x,y;
	if(RealSt>=PtNum){
		RealSt = PtNum-1;
	}
	if(RealEd == -1 || RealEd>=PtNum){
		RealEd = PtNum-1;
	}
	for(i=RealSt;i<=RealEd;i++){
		x = (int)max(0,pPt[i].nX);
		y = (int)max(0,pPt[i].nY);
		r.left = min(r.left,x);
		r.top = min(r.top,y);
		r.right = max(r.right,x);
		r.bottom = max(r.bottom,y);
	}
	r.right++;
	r.bottom++;
	return r;
}
/*
________________________________________________________________
  
Function Name	: SortingHuboAry
	
Purpose			: m_Hubo ĺ 迭 νİŸ  Ŀ  .
		
Input			:  m_Hubo

Output			: m_Hubo

Return Value	: No

Description		: 
Ref Journal		: No
	
date			: 2009/07/5
________________________________________________________________
*/
void CRecogMain::SortingHuboAry()
{
	HuboAry* pAry = &m_Hubo;
	HUBO temp;
	int i,j;
	int SortNum=pAry->Num;
	for(i=0;i<SortNum;i++)
	{
		for (j = i+1; j <SortNum ; j++){
			if ( pAry->Hubo[i].Dis  > pAry->Hubo[j].Dis )
			{ 	
				memcpy(&temp,&(pAry->Hubo[i]),sizeof(HUBO));
				memcpy(&(pAry->Hubo[i]),&(pAry->Hubo[j]),sizeof(HUBO));
				memcpy(&(pAry->Hubo[j]),&temp,sizeof(HUBO));
			}
		}
	}
	for(i=0;i<SortNum;i++)
	{
		for (j = i+1; j < SortNum ; j++){
			if ( pAry->Hubo[i].Mistake  > pAry->Hubo[j].Mistake  && pAry->Hubo[j].Dis - pAry->Hubo[i].Dis  < 50.f)
			{ 	
				memcpy(&temp,&(pAry->Hubo[i]),sizeof(HUBO));
				memcpy(&(pAry->Hubo[i]),&(pAry->Hubo[j]),sizeof(HUBO));
				memcpy(&(pAry->Hubo[j]),&temp,sizeof(HUBO));
			}
			if ( pAry->Hubo[i].Mistake  == pAry->Hubo[j].Mistake && 
				pAry->Hubo[i].Dis  > pAry->Hubo[j].Dis )
			{ 	
				memcpy(&temp,&(pAry->Hubo[i]),sizeof(HUBO));
				memcpy(&(pAry->Hubo[i]),&(pAry->Hubo[j]),sizeof(HUBO));
				memcpy(&(pAry->Hubo[j]),&temp,sizeof(HUBO));
			}
		}
	}
	
}
/*
________________________________________________________________
  
Function Name	: RecogSymbolDigitAndEng
	
Purpose			: Էµ  迭κ  ڸ νϴ° .
		
Input			:
	pPts		: Է 迭
	pSamProp	: up-down
	pSamNo		: ǥȭ ȣ 迭 
	SamNum		: ǥȭ 

Output			:  νĺ 迭

Return Value	: No

Description		: ü Է 迭 Ͽ  ν Ѵ.
				   Է 迭 Ͽ  ڻ ִ   Ȯ ϰ 				  
				  Ȯ   MAXHUBO  ĺ   m_Hubo 
				  ִ´.

Ref Journal		: No
	
date			: 2009/07/5
________________________________________________________________
*/
void CRecogMain::RecogSymbolDigitAndEng(REC_POINT* pPts,int* pSamProp,int* pSamNo,int SamNum)
{
	int i,j;//,k;
	HuboAry *pHubo = &m_Hubo;
	HUBO* pPath;
	HUBO  tempPath;
	int minId,sameId;
	int CJZid[3];CJZid[1] = -1;CJZid[2] = -1;
	WORD code;
	int Mistake;
	float dis,minDis;
	JAMOBN* pBN;
	for(i=0;i<SymBNNum;i++){
		pBN = &m_SymbolBN[i];
		if(pBN->StrokeNum<1) continue;
		if(SamNum<pBN->StrokeNum+1) continue;
		dis = m_JamoBNCore.ForwardBN(pBN, pPts,pSamProp,pSamNo,SamNum,Mistake,3);
		if(dis > MAXDIS) continue;
		code = CCode::Sid2SCode(pBN->JamoId);
		CJZid[0] = pBN->JamoId;
		memcpy(tempPath.CJZid,CJZid,sizeof(int)*3);
		tempPath.Code= code;
		tempPath.PtNo[0] = pSamNo[0];
		tempPath.PtNo[1] = pSamNo[SamNum-1];
		tempPath.PtNum = 2;
		tempPath.Dis = dis;
		tempPath.Mistake = 0;
		minDis = 0;
		minId = pHubo->Num;
		sameId = -1;
		for(j=0;j<pHubo->Num;j++){
			pPath = &(pHubo->Hubo[j]);
			if(pPath->Code == tempPath.Code){
				sameId = j;
			}
			if(pPath->Dis > minDis){
				minId = j;
				minDis = pPath->Dis;
			}
		}
		if(pHubo->Num<MAXHUBO) minId = pHubo->Num;
		if(sameId!=-1 )minId = sameId;

		pPath = &(pHubo->Hubo[minId]);
		if(minId == pHubo->Num ){ // New
			memcpy(pPath,&tempPath,sizeof(HUBO));
			pHubo->Num++;
		}else if(pPath->Dis > tempPath.Dis){// Change
			memcpy(pPath,&tempPath,sizeof(HUBO));
		}
	}
}
/*
________________________________________________________________
  
Function Name	: RecogSymbolCho
	
Purpose			: Էµ  迭κ  νϴ° .
		
Input			:
	pPts		: Է 迭
	pSamProp	: up-down
	pSamNo		: ǥȭ ȣ 迭 
	SamNum		: ǥȭ 

Output			: νĺ 迭

Return Value	: No

Description		: ü Է 迭 Ͽ ν Ѵ.
				   Է 迭 Ͽ ڸ ִ   Ȯ ϰ 				  
				  Ȯ   MAXHUBO  ĺ   m_Hubo 
				  ִ´.

Ref Journal		: No
	
date			: 2009/07/5
________________________________________________________________
*/
void CRecogMain::RecogSymbolCho(REC_POINT* pPts,int* pSamProp,int* pSamNo,int SamNum)
{
	int i,j;//,k;
	HuboAry *pHubo = &m_Hubo;
	HUBO* pPath;
	HUBO  tempPath;
	int minId,sameId;
	int CJZid[3];CJZid[1] = -1;CJZid[2] = -1;
	WORD code;
	int Mistake;
	float dis,minDis;
	JAMOBN* pBN;
	for(i=0;i<CJZBNNum[0];i++){
		pBN = &m_JamoBN[0][i];
		if(pBN->StrokeNum<1) continue;
		if(SamNum<pBN->StrokeNum+1) continue;
		dis = m_JamoBNCore.ForwardBN(pBN, pPts,pSamProp,pSamNo,SamNum,Mistake,3);
		if(dis > pBN->ThDis) continue;
		code = CCode::Cid2CCode(pBN->JamoId);
		CJZid[0] = pBN->JamoId;
		memcpy(tempPath.CJZid,CJZid,sizeof(int)*3);
		tempPath.Code= code;
		tempPath.PtNo[0] = pSamNo[0];
		tempPath.PtNo[1] = pSamNo[SamNum-1];
		tempPath.PtNum = 2;
		tempPath.Dis = dis;
		tempPath.Mistake = Mistake;
		minDis = 0;
		minId = pHubo->Num;
		sameId = -1;
		for(j=0;j<pHubo->Num;j++){
			pPath = &(pHubo->Hubo[j]);
			if(pPath->Code == tempPath.Code){
				sameId = j;
			}
			if(pPath->Dis > minDis){
				minId = j;
				minDis = pPath->Dis;
			}
		}
		if(pHubo->Num<MAXHUBO) minId = pHubo->Num;
		if(sameId!=-1 )minId = sameId;

		pPath = &(pHubo->Hubo[minId]);
		if(minId == pHubo->Num ){ // New
			memcpy(pPath,&tempPath,sizeof(HUBO));
			pHubo->Num++;
		}else if(pPath->Dis > tempPath.Dis){// Change
			memcpy(pPath,&tempPath,sizeof(HUBO));
		}
	}
}
void CRecogMain::RecogSymbolJung(REC_POINT* pPts,int* pSamProp,int* pSamNo,int SamNum)
{
	int i,j;//,k;
	HuboAry *pHubo = &m_Hubo;
	HUBO* pPath;
	HUBO  tempPath;
	int minId,sameId;
	int CJZid[3];CJZid[0] = -1;CJZid[2] = -1;
	WORD code;
	int Mistake;
	float dis,minDis;
	JAMOBN* pBN;
	for(i=0;i<CJZBNNum[1];i++){
		pBN = &m_JamoBN[1][i];
		if(pBN->StrokeNum<1) continue;
		if(SamNum<pBN->StrokeNum+1) continue;
		dis = m_JamoBNCore.ForwardBN(pBN, pPts,pSamProp,pSamNo,SamNum,Mistake,3);
		if(dis > pBN->ThDis) continue;
		code = CCode::Jid2JCode(pBN->JamoId);
		CJZid[1] = pBN->JamoId;
		memcpy(tempPath.CJZid,CJZid,sizeof(int)*3);
		tempPath.Code= code;
		tempPath.PtNo[0] = pSamNo[0];
		tempPath.PtNo[1] = pSamNo[SamNum-1];
		tempPath.PtNum = 2;
		tempPath.Dis = dis;
		tempPath.Mistake = Mistake;
		minDis = 0;
		minId = pHubo->Num;
		sameId = -1;
		for(j=0;j<pHubo->Num;j++){
			pPath = &(pHubo->Hubo[j]);
			if(pPath->Code == tempPath.Code){
				sameId = j;
			}
			if(pPath->Dis > minDis){
				minId = j;
				minDis = pPath->Dis;
			}
		}
		if(pHubo->Num<MAXHUBO) minId = pHubo->Num;
		if(sameId!=-1 )minId = sameId;

		pPath = &(pHubo->Hubo[minId]);
		if(minId == pHubo->Num ){ // New
			memcpy(pPath,&tempPath,sizeof(HUBO));
			pHubo->Num++;
		}else if(pPath->Dis > tempPath.Dis){// Change
			memcpy(pPath,&tempPath,sizeof(HUBO));
		}
	}
}
void CRecogMain::RecogSymbolZong(REC_POINT* pPts,int* pSamProp,int* pSamNo,int SamNum)
{
	int i,j;//,k;
	HuboAry *pHubo = &m_Hubo;
	HUBO* pPath;
	HUBO  tempPath;
	int minId,sameId;
	int CJZid[3];CJZid[0] = -1;CJZid[1] = -1;
	WORD code;
	int Mistake;
	float dis,minDis;
	JAMOBN* pBN;
	for(i=0;i<CJZBNNum[2];i++){
		pBN = &m_JamoBN[2][i];
		if(pBN->StrokeNum<1) continue;
		if(SamNum<pBN->StrokeNum+1) continue;
		dis = m_JamoBNCore.ForwardBN(pBN, pPts,pSamProp,pSamNo,SamNum,Mistake,3);
		if(dis > pBN->ThDis) continue;
		code = CCode::Zid2ZCode(pBN->JamoId);
		CJZid[2] = pBN->JamoId;
		memcpy(tempPath.CJZid,CJZid,sizeof(int)*3);
		tempPath.Code= code;
		tempPath.PtNo[0] = pSamNo[0];
		tempPath.PtNo[1] = pSamNo[SamNum-1];
		tempPath.PtNum = 2;
		tempPath.Dis = dis;
		tempPath.Mistake = Mistake;
		minDis = 0;
		minId = pHubo->Num;
		sameId = -1;
		for(j=0;j<pHubo->Num;j++){
			pPath = &(pHubo->Hubo[j]);
			if(pPath->Code == tempPath.Code){
				sameId = j;
			}
			if(pPath->Dis > minDis){
				minId = j;
				minDis = pPath->Dis;
			}
		}
		if(pHubo->Num<MAXHUBO) minId = pHubo->Num;
		if(sameId!=-1 )minId = sameId;

		pPath = &(pHubo->Hubo[minId]);
		if(minId == pHubo->Num ){ // New
			memcpy(pPath,&tempPath,sizeof(HUBO));
			pHubo->Num++;
		}else if(pPath->Dis > tempPath.Dis){// Change
			memcpy(pPath,&tempPath,sizeof(HUBO));
		}
	}
}
/*
________________________________________________________________
  
Function Name	: RecogKorean
	
Purpose			: Էµ  迭κ ѱ νϴ° .
		
Input			:
	pPts		: Է 迭
	pSamProp	: up-down
	pSamNo		: ǥȭ ȣ 迭 
	SamNum		: ǥȭ 

Output			: ѱνĺ 迭

Return Value	: No

Description		: ü Է 迭 Ͽ ѱν Ѵ.
				  ⼭ ȹ  ʼ+߼+߿ Ȯ ū 
				  Ͽ ѱνĺ 迭 ϰ ùĺ νİ ȯѴ.				  

  Ref Journal		: [1] "Bayesian network modeling of strokes and their relationships for on-line handwriting 
  						recognition"   Sung-Jung Cho*, Jin H. Kim   Pattern Recognition 37(2004) 253-264p
		
					  [2] "Bayesian Network Modeling of Hangul Characters for On-line Handwriting Recognition"  
							Sung-Jung Cho*, Jin H. Kim   ICDAR (2003), pp. 207-211 vol.1
	
date			: 2009/07/5
________________________________________________________________
*/
WORD CRecogMain::RecogKorean(REC_POINT* pPts,int* pSamProp,int* pSamNo,int SamNum)
{
	int num = SamNum;
	if(num<3) return -1;
	int i,t;
	if(num >= MAXSAMNUM) return -1;
	HuboPath* path = m_CJZPath;
	memset(path,0,sizeof(HuboPath)*MAXSAMNUM);
	memset(&m_Hubo,0,sizeof(HuboAry));
	for(t=1;t<SamNum-1;t++){
		if(pSamProp[t]==NON_CJZ_Flag)continue;
		if(t<SamNum-2)
			if(pSamProp[t]!=DOWN_Flag)
				RecogChoSung(pPts,pSamProp,pSamNo,t);
		for(i=1;i<t;i++){
			if(pSamProp[i]==NON_CJZ_Flag)continue;
			if(path[i].Hubo1.Num!=0){
				if(pSamProp[t]!=UP_Flag)
					RecogCho2Jung(pPts,pSamProp,pSamNo,i,t);
			}
			if(path[i].Hubo2.Num!=0){
				if(pSamProp[i]!=UP_Flag&&pSamProp[t]!=DOWN_Flag)
					RecogJungSung(pPts,pSamProp,pSamNo,i,t);
			}
			if(path[i].Hubo3.Num!=0){
				if(pSamProp[t]!=UP_Flag)
					RecogJung2Zong(pPts,pSamProp,pSamNo,i,t);
			}
		}
	}
	t = SamNum-1;
	for(i=2;i<t-1;i++){
		if(pSamProp[i]==NON_CJZ_Flag)continue;
		if(path[i].Hubo2.Num!=0){
			if(pSamProp[i]!=UP_Flag)
				FinalRecogJungSung(pPts,pSamProp,pSamNo,i,t);
		}
		if(path[i].Hubo4.Num!=0){
			if(pSamProp[i]!=UP_Flag)
				FinalRecogZongSung(pPts,pSamProp,pSamNo,i,t);
		}
	}

	SortingHuboAry();
	if(m_Hubo.Num > 0){
		return m_Hubo.Hubo[0].Code;
	}else{
		return 0;
	}

}
/*
________________________________________________________________
  
Function Name	: RecogChoSung
	
Purpose			: Էµ  迭κ ʼ νϴ° .
		
Input			:
	pPts		: Է 迭
	pSamProp	: up-down
	pSamNo		: ǥȭ ȣ 迭 
	CurNo		: ùκ Ͽ νϷ ǥȣ

Output			: ʼνĺ 迭

Return Value	: No

Description		: pSamNo[0] pSamNo[CurNo]  迭 Ͽ ʼν Ѵ.
				   pSamNo[0] pSamNo[CurNo]  迭 64*64ũ 2ȭ .
				   ȭ  迭 ʼ ִ   Ȯ Ͽ 
				  Ȯ   MAXHUBONUM1  ĺ   m_CJZPath[CurNo].Hubo1 
				  ִ´.

Ref Journal		: No
	
date			: 2009/07/5
________________________________________________________________
*/
void CRecogMain::RecogChoSung(REC_POINT* pPts,int* pSamProp,int* pSamNo,int CurNo)
{
	RECT rt = GetBoundingBox(pPts,pSamNo[CurNo]+1,pSamNo[0],pSamNo[CurNo]);
	int i,j;//,k;
	
	float left = (float)rt.left;
	float top = (float)rt.top;
	float Width = (float)(rt.right - rt.left);
	float Height = (float)(rt.bottom - rt.top);
	REC_POINT* pNRtPts = m_pNRtPts;
	float rateW,rateH;
	rateW = (float)(W1-1)/Width;
	rateH = (float)(H1-1)/Height;
	for(i=0;i<=pSamNo[CurNo];i++){
		pNRtPts[i].nX = (pPts[i].nX-left)*rateW;
		pNRtPts[i].nY = (pPts[i].nY-top)*rateH;
	}
	float dis,minDis;
	JAMOBN* pBN;
	ChoHubo* pHubo = &(m_CJZPath[CurNo].Hubo1);
	ChoPath* pPath;
	int minId,sameId;
	int Mistake=0;
	for(i=0;i<CJZBNNum[0];i++){
		pBN = &m_JamoBN[0][i];
		if(pBN->StrokeNum<1) continue;
		if(CurNo<pBN->StrokeNum) continue;
		dis = m_JamoBNCore.ForwardBN(pBN, pNRtPts,pSamProp,pSamNo,CurNo+1,Mistake,2);
		
		if(dis > pBN->ThDis) 
			continue;
		if(pBN->GrpId==0 && pHubo->Num<MAXHUBONUM1){
			minId = pHubo->Num;
		}else{
			minDis = 0;
			minId = pHubo->Num;
			sameId = -1;
			for(j=0;j<pHubo->Num;j++){
				pPath = &(pHubo->Hubo[j]);
				if(pPath->ChoId == pBN->JamoId){
					sameId = j;
				}
				if(pPath->SumDis > minDis){
					minId = j;
					minDis = pPath->SumDis;
				}
			}
			if(pHubo->Num<MAXHUBONUM1) minId = pHubo->Num;
			if(sameId!=-1 )minId = sameId;
		}
		pPath = &(pHubo->Hubo[minId]);
		if(minId == pHubo->Num ){ // New
			pPath->ChoId = pBN->JamoId;
			pPath->PtNo = CurNo;
			pPath->rt = rt;
			pPath->SumDis = dis;
			pPath->Mistake = Mistake;
			pHubo->Num++;
		}else if(pPath->SumDis > dis){// Change
			pPath->ChoId = pBN->JamoId;
			pPath->PtNo = CurNo;
			pPath->rt = rt;
			pPath->Mistake = Mistake;
			pPath->SumDis = dis;
		}
	}
}
/*
________________________________________________________________
  
Function Name	: RecogJungSung
	
Purpose			: Էµ  迭κ ߼ νϴ° .
		
Input			:
	pPts		: Է 迭
	pSamProp	: up-down
	pSamNo		: ǥȭ ȣ 迭 
	st			: pSamNo ȹ  ǥȣ
	ed			: pSamNo ȹ  ǥȣ

Output			: ߼νĺ 迭

Return Value	: No

Description		: pSamNo[st] pSamNo[ed]  迭 Ͽ ߼ν Ѵ.
				   pSamNo[st] pSamNo[ed]  迭 64*64ũ 2ȭ Ѵ.
				  ʼνĶʹ ޸  ȭ ߼ Ư ʺ/̺ ũ ̳⶧ 
				   4 ʺ Ȥ ̺  ũ 64*64 ȭѴ.
				  ׸ m_CJZPath[st].hubo2 ϵǾִ  ʼ-߼ ȹĺ鿡 Ͽ ش 
				  ߼ν Ͽ ʼȮ ʼ-߼ ȹȮ,׸ ߼Ȯ 
				  Ȯ  ū   MAXHUBONUM3  ĺ   m_CJZPath[ed].Hubo3 ִ´. 				  				  
				  ̶ ʼ ߼ ġ Ǵ ڸȣ Ȯ(JamoBoundBN) Ѵ.

Ref Journal		: No
	
date			: 2009/07/5
________________________________________________________________
*/
void CRecogMain::RecogJungSung(REC_POINT* pPts,int* pSamProp,int* pSamNo,int st,int ed)
{
	RECT rt = GetBoundingBox(pPts,pSamNo[ed]+1,pSamNo[st],pSamNo[ed]);
	float left = (float)rt.left;
	float top = (float)rt.top;
	float Width = (float)(rt.right - rt.left);
	float Height = (float)(rt.bottom - rt.top);
	REC_POINT* pNRtPts = m_pNRtPts;
	int i,j,k;
	float offx=0,offy=0;
	float rate;
	if((float)(H1-1)/Height>(float)(W1-1)/Width){
		rate = (float)(W1-1)/Width;
		offy = (((float)H1 - Height*rate)/2.0f);
	}else{
		rate = (float)(H1-1)/Height;
		offx = (((float)W1 - Width*rate)/2.0f);
	}
	for(i=pSamNo[st];i<=pSamNo[ed];i++){
		pNRtPts[i].nX = (pPts[i].nX-left)*rate+offx;
		pNRtPts[i].nY = (pPts[i].nY-top)*rate+offy;
	}

	float dis = MAXDIS,minDis,RectDis;
	float thRectDis = 200.0f;
	JAMOBN* pBN;
	JamoBoundBN* pRectBN;
	C2JHubo* pPreHubo = &(m_CJZPath[st].Hubo2);
	JungHubo* pHubo = &(m_CJZPath[ed].Hubo3);
	C2JPath* pPrePath;
	JungPath* pPath;
	JungPath  tempPath;
	int minId,sameId;
	int preIamoId = -1,nType;
	BOOL bJamoFirst;
	int Mistake;
	for(i=0;i<CJZBNNum[1];i++){
		pBN = &m_JamoBN[1][i];
		if(pBN->StrokeNum<1) continue;
		bJamoFirst = TRUE;
		nType = CCode::GetJungType(pBN->JamoId)+3;
		pRectBN = &m_JamoBoundBN[nType];
		for(k=0;k<pPreHubo->Num;k++){
			pPrePath = &(pPreHubo->Hubo[k]);
			if(pPrePath->JungId != pBN->JamoId) continue;
			m_BoundBNCore.SetDataInRect(pRectBN,0,pPrePath->cho.rt);
			m_BoundBNCore.SetDataInRect(pRectBN,1,rt);
			RectDis = m_BoundBNCore.ForwardRect(pRectBN,0)+m_BoundBNCore.ForwardRect(pRectBN,1);
	
			if(RectDis > pRectBN->pRect[0]->ThDis+pRectBN->pRect[1]->ThDis) continue;
			if(bJamoFirst){
				dis = m_JamoBNCore.ForwardBN(pBN, pNRtPts,&pSamProp[st],&pSamNo[st],ed-st+1,Mistake,2);
				preIamoId = pBN->JamoId;
				bJamoFirst = FALSE;
			}
			if(dis > pBN->ThDis) break;
			RectDis += dis; 
			memcpy(&(tempPath.c2J),pPrePath,sizeof(C2JPath));
			tempPath.JungId = pBN->JamoId;
			tempPath.PtNo = ed;
			tempPath.SumDis = tempPath.c2J.SumDis+RectDis;
			tempPath.Mistake = Mistake;
			tempPath.rt = rt;
		////////////////// register Current Path ////////////
			minDis = 0;
			minId = pHubo->Num;
			sameId = -1;
			for(j=0;j<pHubo->Num;j++){
				pPath = &(pHubo->Hubo[j]);
				if(pPath->JungId == tempPath.JungId && pPath->c2J.cho.ChoId == tempPath.c2J.cho.ChoId){
					sameId = j;
				}
				if(pPath->SumDis > minDis){
					minId = j;
					minDis = pPath->SumDis;
				}
			}
			if(pHubo->Num<MAXHUBONUM3) minId = pHubo->Num;
			if(sameId!=-1 )minId = sameId;

			pPath = &(pHubo->Hubo[minId]);
			if(minId == pHubo->Num ){ // New
				memcpy(pPath,&tempPath,sizeof(JungPath));
				pHubo->Num++;
			}else if(pPath->SumDis > tempPath.SumDis){// Change
				memcpy(pPath,&tempPath,sizeof(JungPath));
			}
		}
	}
}
/*
________________________________________________________________
  
Function Name	: FinalRecogJungSung
	
Purpose			: ϴ  Է 迭  쿡 ħ(߼  ) 
				   νĺ 迭 ϴ°.
		
Input			:
	pPts		: Է 迭
	pSamProp	: up-down
	pSamNo		: ǥȭ ȣ 迭 
	st			: pSamNo ȹ  ǥȣ
	ed			: pSamNo  ǥȣ

Output			: ħ νĺ 迭

Return Value	: No

Description		: pSamNo[st] pSamNo[ed]  迭 Ͽ ߼ν Ѵ.
				   pSamNo[st] pSamNo[ed]  迭 64*64ũ 2ȭ Ѵ.
				  ʼνĶʹ ޸  ȭ ߼ Ư ʺ/̺ ũ ̳⶧ 
				   4 ʺ Ȥ ̺  ũ 64*64 ȭѴ.
				  ׸ m_CJZPath[st].hubo2 ϵǾִ  ʼ-߼ ȹĺ鿡 Ͽ ش 
				  ߼ν Ͽ νİŸ(Ȯ) ϰ װ  ū  
				  MAXHUBONUM  ĺ  νĺ 迭m_Hubo ִ´. 				  				  				  

Ref Journal		: No
	
date			: 2009/07/5
________________________________________________________________
*/
void CRecogMain::FinalRecogJungSung(REC_POINT* pPts,int* pSamProp,int* pSamNo,int st,int ed)
{
	RECT rt = GetBoundingBox(pPts,pSamNo[ed]+1,pSamNo[st],pSamNo[ed]);
	float left = (float)rt.left;
	float top = (float)rt.top;
	float Width = (float)(rt.right - rt.left);
	float Height = (float)(rt.bottom - rt.top);
	REC_POINT* pNRtPts = m_pNRtPts;
	int i,j,k;
	float offx=0,offy=0;
	float rate;
	if((float)(H1-1)/Height>(float)(W1-1)/Width){
		rate = (float)(W1-1)/Width;
		offy = (((float)H1 - Height*rate)/2.0f);
	}else{
		rate = (float)(H1-1)/Height;
		offx = (((float)W1 - Width*rate)/2.0f);
	}
	for(i=pSamNo[st];i<=pSamNo[ed];i++){
		pNRtPts[i].nX = (pPts[i].nX-left)*rate+offx;
		pNRtPts[i].nY = (pPts[i].nY-top)*rate+offy;
	}
	float dis = MAXDIS,minDis,RectDis;
	JAMOBN* pBN;
	JamoBoundBN* pRectBN;
	C2JHubo* pPreHubo = &(m_CJZPath[st].Hubo2);
	HuboAry *pHubo = &m_Hubo;
	C2JPath* pPrePath;
	HUBO* pPath;
	HUBO  tempPath;
	int minId,sameId;
	int preIamoId = -1,nType;
	BOOL bJamoFirst;
	int CJZid[3];CJZid[2] = -1;
	WORD code;
	int Mistake;
	for(i=0;i<CJZBNNum[1];i++){
		pBN = &m_JamoBN[1][i];
		if(pBN->StrokeNum<1) continue;

		bJamoFirst = TRUE;

		nType = CCode::GetJungType(pBN->JamoId);
		pRectBN = &m_JamoBoundBN[nType];
		for(k=0;k<pPreHubo->Num;k++){
			pPrePath = &(pPreHubo->Hubo[k]);
			if(pPrePath->JungId != pBN->JamoId) continue;
			CJZid[0] = pPrePath->cho.ChoId;
			CJZid[1] = pPrePath->JungId;
			if(CCode::CJZid2Code(CJZid,code) == FALSE)continue;
			m_BoundBNCore.SetDataInRect(pRectBN,0,pPrePath->cho.rt);
			m_BoundBNCore.SetDataInRect(pRectBN,1,rt);
			RectDis = m_BoundBNCore.ForwardBN(pRectBN);
			if(RectDis > pRectBN->ThDis) continue;
			if(bJamoFirst){
				dis = m_JamoBNCore.ForwardBN(pBN, pNRtPts,&pSamProp[st],&pSamNo[st],ed-st+1,Mistake,2);
				preIamoId = pBN->JamoId;
				bJamoFirst = FALSE;
			}
			if(dis == MAXDIS) break;
			RectDis += dis; 
			memcpy(tempPath.CJZid,CJZid,sizeof(int)*3);
			tempPath.Code= code;
			tempPath.PtNo[0] = pSamNo[0];
			tempPath.PtNo[1] = pSamNo[pPrePath->cho.PtNo];
			tempPath.PtNo[2] = pSamNo[pPrePath->PtNo];
			tempPath.PtNo[3] = pSamNo[ed];
			tempPath.PtNum = 4;
			tempPath.Dis = pPrePath->SumDis+RectDis;
			tempPath.Mistake = pPrePath->Mistake+pPrePath->cho.Mistake+Mistake;

		////////////////// register Current Path ////////////
			minDis = 0;
			minId = pHubo->Num;
			sameId = -1;
			for(j=0;j<pHubo->Num;j++){
				pPath = &(pHubo->Hubo[j]);
				if(pPath->CJZid[0] == tempPath.CJZid[0] && pPath->CJZid[1] == tempPath.CJZid[1]
					&& pPath->CJZid[2] == tempPath.CJZid[2]){
					sameId = j;
				}
				if(pPath->Dis > minDis){
					minId = j;
					minDis = pPath->Dis;
				}
			}
			if(pHubo->Num<MAXHUBO) minId = pHubo->Num;
			if(sameId!=-1 )minId = sameId;

			pPath = &(pHubo->Hubo[minId]);
			if(minId == pHubo->Num ){ // New
				memcpy(pPath,&tempPath,sizeof(HUBO));
				pHubo->Num++;
			}else if(pPath->Dis > tempPath.Dis){// Change
				memcpy(pPath,&tempPath,sizeof(HUBO));
			}
		}
	}
}
/*
________________________________________________________________
  
Function Name	: FinalRecogZongSung
	
Purpose			: ϴ  Է 迭  쿡 ħ(  ) 
				   νĺ 迭 ϴ°.
		
Input			:
	pPts		: Է 迭
	pSamProp	: up-down
	pSamNo		: ǥȭ ȣ 迭 
	st			: pSamNo ȹ  ǥȣ
	ed			: pSamNo  ǥȣ

Output			: ħ νĺ 迭

Return Value	: No

Description		: pSamNo[st] pSamNo[ed]  迭 Ͽ ν Ѵ.
				   pSamNo[st] pSamNo[ed]  迭 64*64ũ ȭ Ѵ.
				   ׸ m_CJZPath[st].hubo4 ϵǾִ  ߼- ȹĺ鿡 Ͽ ش 
				  ν Ͽ νİŸ(Ȯ) ϰ װ  ū  
				  MAXHUBONUM  ĺ  νĺ 迭m_Hubo ִ´. 				  				  				  

Ref Journal		: No
	
date			: 2009/07/5
________________________________________________________________
*/
void CRecogMain::FinalRecogZongSung(REC_POINT* pPts,int* pSamProp,int* pSamNo,int st,int ed)
{
	RECT rt = GetBoundingBox(pPts,pSamNo[ed]+1,pSamNo[st],pSamNo[ed]);
	float left = (float)rt.left;
	float top = (float)rt.top;
	float Width = (float)(rt.right - rt.left);
	float Height = (float)(rt.bottom - rt.top);
	REC_POINT* pNRtPts = m_pNRtPts;
	int i,j,k;
	float rateW,rateH;
	rateW = (float)(W1-1)/Width;
	rateH = (float)(H1-1)/Height;
	for(i=pSamNo[st];i<=pSamNo[ed];i++){
		pNRtPts[i].nX = (pPts[i].nX-left)*rateW;
		pNRtPts[i].nY = (pPts[i].nY-top)*rateH;
	}
	float dis = MAXDIS,minDis,RectDis;
	JAMOBN* pBN;
	JamoBoundBN* pRectBN;
	J2ZHubo* pPreHubo = &(m_CJZPath[st].Hubo4);
	HuboAry *pHubo = &m_Hubo;
	J2ZPath* pPrePath;
	HUBO* pPath;
	HUBO  tempPath;
	int minId,sameId;
	int preIamoId = -1,nType;
	BOOL bJamoFirst;
	int CJZid[3];
	WORD code;
	int Mistake;
	for(i=0;i<CJZBNNum[2];i++){
		pBN = &m_JamoBN[2][i];
		if(pBN->StrokeNum<1) continue;
	
			bJamoFirst = TRUE;

		for(k=0;k<pPreHubo->Num;k++){
			pPrePath = &(pPreHubo->Hubo[k]);
			if(pPrePath->ZongId != pBN->JamoId) continue;
			CJZid[0] = pPrePath->Jung.c2J.cho.ChoId;
			CJZid[1] = pPrePath->Jung.JungId;
			CJZid[2] = pPrePath->ZongId;
			if(CCode::CJZid2Code(CJZid,code) == FALSE)continue;
			nType = CCode::GetJungType(CJZid[1])+3;
			pRectBN = &m_JamoBoundBN[nType];
			m_BoundBNCore.SetDataInRect(pRectBN,0,pPrePath->Jung.c2J.cho.rt);
			m_BoundBNCore.SetDataInRect(pRectBN,1,pPrePath->Jung.rt);
			m_BoundBNCore.SetDataInRect(pRectBN,2,rt);
			RectDis = m_BoundBNCore.ForwardRect(pRectBN,2);
			if(RectDis > pRectBN->pRect[2]->ThDis) continue;
			if(bJamoFirst){
				dis = m_JamoBNCore.ForwardBN(pBN, pNRtPts,&pSamProp[st],&pSamNo[st],ed-st+1,Mistake,2);
				preIamoId = pBN->JamoId;
				bJamoFirst = FALSE;
			}
		
			if(dis == MAXDIS) break;
			RectDis += dis; 
			memcpy(tempPath.CJZid,CJZid,sizeof(int)*3);
			tempPath.Code= code;
			tempPath.PtNo[0] = pSamNo[0];
			tempPath.PtNo[1] = pSamNo[pPrePath->Jung.c2J.cho.PtNo];
			tempPath.PtNo[2] = pSamNo[pPrePath->Jung.c2J.PtNo];
			tempPath.PtNo[3] = pSamNo[pPrePath->Jung.PtNo];
			tempPath.PtNo[4] = pSamNo[pPrePath->PtNo];
			tempPath.PtNo[5] = pSamNo[ed];
			tempPath.PtNum = 6;
			tempPath.Dis = pPrePath->SumDis+RectDis;
			tempPath.Mistake = pPrePath->Mistake+pPrePath->Jung.c2J.Mistake+pPrePath->Jung.Mistake+pPrePath->Jung.c2J.cho.Mistake+Mistake;
			
		////////////////// register Current Path ////////////
			minDis = 0;
			minId = pHubo->Num;
			sameId = -1;
			for(j=0;j<pHubo->Num;j++){
				pPath = &(pHubo->Hubo[j]);
				if(pPath->CJZid[0] == tempPath.CJZid[0] && pPath->CJZid[1] == tempPath.CJZid[1]
					&& pPath->CJZid[2] == tempPath.CJZid[2]){
					sameId = j;
				}
				if(pPath->Dis > minDis){
					minId = j;
					minDis = pPath->Dis;
				}
			}
			if(pHubo->Num<MAXHUBO) minId = pHubo->Num;
			if(sameId!=-1 )minId = sameId;

			pPath = &(pHubo->Hubo[minId]);
			if(minId == pHubo->Num ){ // New
				memcpy(pPath,&tempPath,sizeof(HUBO));
				pHubo->Num++;
			}else if(pPath->Dis > tempPath.Dis){// Change
				memcpy(pPath,&tempPath,sizeof(HUBO));
			}
		}
	}
}
/*
________________________________________________________________
  
Function Name	: RecogCho2Jung
	
Purpose			: Էµ  迭κ ʼ-߼ ȹ νϴ° .
		
Input			:
	pPts		: Է 迭
	pSamProp	: up-down
	pSamNo		: ǥȭ ȣ 迭 
	st			: pSamNo ȹ  ǥȣ
	ed			: pSamNo ȹ  ǥȣ

Output			: ʼ-߼ ȹ νĺ 迭

Return Value	: No

Description		: pSamNo[st] pSamNo[ed]  迭 Ͽ ʼ-߼ν Ѵ.
				  m_CJZPath[st].hubo1 ϵǾִ  ʼĺ鿡 Ͽ  
				  ʼ-߼ ȹ ν Ͽ ʼȮ ʼ-߼ ȹȮ 
				  Ȯ  ū   MAXHUBONUM2  ĺ   m_CJZPath[ed].Hubo2 ִ´. 
				  ̶ ʼ-߼ ȹȣ ȴ.
				  (m_JamoBTWBN[0],m_JamoBTWBN[0]:ʼ-߼ ȹBN,m_JamoBTWBN[1]:߼- ȹBN)

Ref Journal		: No
	
date			: 2009/07/5
________________________________________________________________
*/
void CRecogMain::RecogCho2Jung(REC_POINT* pPts,int *pSamProp,int* pSamNo,int st,int ed)
{
	int i,j,k;
	float dis = MAXDIS,minDis;
	float thBTWDis = 200.0f;
	JamoBTWBN* pBN;
	ChoHubo* pPreHubo = &(m_CJZPath[st].Hubo1);
	C2JHubo* pHubo = &(m_CJZPath[ed].Hubo2);
	ChoPath* pPrePath;
	C2JPath* pPath;
	C2JPath  tempPath;
	int minId,sameId;
	int choId,JungId,no;
	int Mistake=1;

	Mistake = 0;
	for(i=0;i<pPreHubo->Num;i++)
	{
		pPrePath = &(pPreHubo->Hubo[i]);
		choId = pPrePath->ChoId;
		for(k=0;k<JUNGNum;k++)
		{
			JungId = k;
			no = choId*JUNGNum+JungId;
			pBN = &m_JamoBTWBN[0][no];
			if(pBN->bStudied == FALSE) continue;
			m_BTWBNCore.SetDataInBN(pBN,pPts,pSamNo[st],pSamNo[ed]);
			dis = m_BTWBNCore.ForwardBN(pBN);
			if(dis > pBN->ThDis)
				continue;
			memcpy(&(tempPath.cho),pPrePath,sizeof(ChoPath));
			tempPath.JungId = JungId;
			tempPath.PtNo = ed;
			tempPath.SumDis = tempPath.cho.SumDis+dis;
			tempPath.Mistake =Mistake;
		////////////////// register Current Path ////////////
			minDis = 0;
			minId = pHubo->Num;
			sameId = -1;
			for(j=0;j<pHubo->Num;j++)
			{
				pPath = &(pHubo->Hubo[j]);
				if(pPath->JungId == tempPath.JungId && pPath->cho.ChoId == tempPath.cho.ChoId){
					sameId = j;
				}
				if(pPath->SumDis > minDis){
					minId = j;
					minDis = pPath->SumDis;
				}
			}
			if(pHubo->Num<MAXHUBONUM2) minId = pHubo->Num;
			if(sameId!=-1 )minId = sameId;

			pPath = &(pHubo->Hubo[minId]);
			if(minId == pHubo->Num )// New
			{ 
				memcpy(pPath,&tempPath,sizeof(C2JPath));
				pHubo->Num++;
			}else if(pPath->SumDis > tempPath.SumDis)// Change
			{
				memcpy(pPath,&tempPath,sizeof(C2JPath));
			}
		}
	}
}
/*
________________________________________________________________
  
Function Name	: RecogJung2Zong
	
Purpose			: Էµ  迭κ ߼- ȹ νϴ° .
		
Input			:
	pPts		: Է 迭
	pSamProp	: up-down
	pSamNo		: ǥȭ ȣ 迭 
	st			: pSamNo ȹ  ǥȣ
	ed			: pSamNo ȹ  ǥȣ

Output			: ߼- ȹ νĺ 迭

Return Value	: No

Description		: pSamNo[st] pSamNo[ed]  迭 Ͽ ߼-ν Ѵ.
				  m_CJZPath[st].hubo3 ϵǾִ  ߼ĺ鿡   
				  ߼- ȹ ν Ͽ ߼Ȯ ߼- ȹȮ 
				  Ȯ  ū   MAXHUBONUM4  ĺ   m_CJZPath[ed].Hubo4 ִ´. 
				  ̶ ߼- ȹȣ(m_JamoBTWBN[1]) ȴ.
				  (m_JamoBTWBN[0]:ʼ-߼ ȹBN,m_JamoBTWBN[1]:߼- ȹBN)

Ref Journal		: No
	
date			: 2009/07/5
________________________________________________________________
*/
void CRecogMain::RecogJung2Zong(REC_POINT* pPts,int *pSamProp,int* pSamNo,int st,int ed)
{
	int i,j,k;
	float dis = MAXDIS,minDis;
	float thBTWDis = 200.0f;
	JamoBTWBN* pBN;
	JungHubo* pPreHubo = &(m_CJZPath[st].Hubo3);
	J2ZHubo* pHubo = &(m_CJZPath[ed].Hubo4);
	JungPath* pPrePath;
	J2ZPath* pPath;
	J2ZPath  tempPath;
	int minId,sameId;
	int JungId,ZongId,no;
	int CJZId[3];
	WORD Code;
	int Mistake=1;

	Mistake = 0;
	for(i=0;i<pPreHubo->Num;i++)
	{
		pPrePath = &(pPreHubo->Hubo[i]);
		JungId = pPrePath->JungId;
		CJZId[0] = pPrePath->c2J.cho.ChoId;
		CJZId[1] = JungId;
		for(k=0;k<ZONGNum;k++)
		{
			ZongId = k;
			CJZId[2] = ZongId;
			no = JungId*ZONGNum+ZongId;
			pBN = &m_JamoBTWBN[1][no];
			if(pBN->bStudied == FALSE) continue;
			if(CCode::CJZid2Code(CJZId,Code) == FALSE)continue;
			m_BTWBNCore.SetDataInBN(pBN,pPts,pSamNo[st],pSamNo[ed]);
			dis = m_BTWBNCore.ForwardBN(pBN);
			if(dis > pBN->ThDis) continue;
			memcpy(&(tempPath.Jung),pPrePath,sizeof(JungPath));
			tempPath.ZongId = ZongId;
			tempPath.PtNo = ed;
			tempPath.SumDis = tempPath.Jung.SumDis+dis;
			tempPath.Mistake = Mistake;
		////////////////// register Current Path ////////////
			minDis = 0;
			minId = pHubo->Num;
			sameId = -1;
			for(j=0;j<pHubo->Num;j++)
			{
				pPath = &(pHubo->Hubo[j]);
				if(pPath->ZongId == tempPath.ZongId && pPath->Jung.JungId == tempPath.Jung.JungId
					&& pPath->Jung.c2J.cho.ChoId == tempPath.Jung.c2J.cho.ChoId){
					sameId = j;
				}
				if(pPath->SumDis > minDis){
					minId = j;
					minDis = pPath->SumDis;
				}
			}
			if(pHubo->Num<MAXHUBONUM4) minId = pHubo->Num;
			if(sameId!=-1 )minId = sameId;

			pPath = &(pHubo->Hubo[minId]);
			if(minId == pHubo->Num )// New
			{ 
				memcpy(pPath,&tempPath,sizeof(J2ZPath));
				pHubo->Num++;
			}else if(pPath->SumDis > tempPath.SumDis)// Change
			{
				memcpy(pPath,&tempPath,sizeof(J2ZPath));
			}
		}
	}
}
/*
________________________________________________________________
  
Function Name	: Recog
	
Purpose			: Էµ  迭κ ѱ//ڸ νϴ°
		
Input			:
	pOrgPt		: Է 迭
	OrgPtNum	: Է
	pOrgStroke	: ȹ 迭
	nOrgStrkNum	: ȹ 	

Output			: No

Return Value	: νĵ ڵ(ѱ//)

Description		: Է 迭pOrgPt 콺 Ǵ Էġ   ԷµǴ  迭̰
				  ȹ迭pOrgStroke 콺 Ǵ  down-upų ϳ  ȹ迭̴. 

Ref Journal		: [1]   "Bayesian network modeling of strokes and their relationships for on-line handwriting 
									recognition"   Sung-Jung Cho*, Jin H. Kim   Pattern Recognition 37(2004) 253-264p
		
				  [2]   "Bayesian Network Modeling of Hangul Characters for On-line Handwriting Recognition"  
									Sung-Jung Cho*, Jin H. Kim   ICDAR (2003), pp. 207-211 vol.1

date			: 2009/07/5
________________________________________________________________
*/
WORD CRecogMain::Recog(OVR_POINT *pOrgPt, int OrgPtNum, STROKE *pOrgStroke,int nOrgStrkNum)
{
	REC_POINT*	pPts;
	int*		pSelNo,*pSamProp,SelNum;
	
	int			NewPtNum,NorPtNum;	
	STROKE		pNewStroke[MAXSTROKENUM];
	int			nStrkNum = nOrgStrkNum;

	pSelNo = m_pSelNo;
	pSamProp = m_pSamProp;
	memset(pSamProp,NON_CJZ_Flag,sizeof(int)*H1*W1);

	//--------------   Ȱȭ -----------
	OVR_POINT* pNewPt= m_PreProcess.NoisProcess(pOrgPt,OrgPtNum,pOrgStroke,pNewStroke,nStrkNum,NewPtNum );
	//---------------------------------------------
	
	//-------------- ȭ ------------------------------------------------------- 
	OVR_POINT* pNorPt = m_PreProcess.GetNormalizePtsAndStroke(pNewPt,NewPtNum,
													pNewStroke,nStrkNum,pSamProp,pSelNo,SelNum,NorPtNum);
	//-----------------------------------------------------------------------------
	free(pNorPt);

	pPts = m_PreProcess.m_Bec;

	//--------------- ѱ ν ----------------
	RecogKorean(pPts,pSamProp,pSelNo,SelNum);
	//--------------------------------------------

	//--------------- ν --------------
	RecogSymbolCho(pPts,pSamProp,pSelNo,SelNum);
	//--------------------------------------------

	//----- /ν Ͽ ũȭ   迭  -----
	pNorPt = m_PreProcess.GetNormalizeOnlyHorWPtsAndStroke(pNewPt,NewPtNum,
		pNewStroke,nStrkNum,pSamProp,pSelNo,SelNum,NorPtNum);
	//----------------------------------------------------------------
	
	free(pNewPt);	free(pNorPt);
	
	pPts = m_PreProcess.m_Bec;

	//-------- /ν ----------------------------
	RecogSymbolDigitAndEng(pPts,pSamProp,pSelNo,SelNum);
	//---------------------------------------------------

	//------- νİ  -------
	SortingHuboAry();
	//-----------------------------

	//--- 1ĺ νİ ȯ  ---
	if(m_Hubo.Num > 0){
		return m_Hubo.Hubo[0].Code;
	}else{
		return 0;
	}
	//--------------------------------

}
