#ifndef APPLEEVENTS_H
#define APPLEEVENTS_H
#endif

#ifndef HYS_H
#include <OC_Cocoa/hys.h>
#endif

#ifndef __TYPES_H
#include <CoreFoundation/Types.h>
#endif

/*AEBuild Error Codes

Represents syntax errors found by an “AEBuild” routine.

typedef UInt32 AEBuildErrorCode;
enum {
aeBuildSyntaxNoErr = 0,
aeBuildSyntaxBadToken = 1,
aeBuildSyntaxBadEOF = 2,
aeBuildSyntaxNoEOF = 3,
aeBuildSyntaxBadNegative = 4,
aeBuildSyntaxMissingQuote = 5,
aeBuildSyntaxBadHex = 6,
aeBuildSyntaxOddHex = 7,
aeBuildSyntaxNoCloseHex = 8,
aeBuildSyntaxUncoercedHex = 9,
aeBuildSyntaxNoCloseString = 10,
aeBuildSyntaxBadDesc = 11,
aeBuildSyntaxBadData = 12,
aeBuildSyntaxNoCloseParen = 13,
aeBuildSyntaxNoCloseBracket = 14,
aeBuildSyntaxNoCloseBrace = 15,
aeBuildSyntaxNoKey = 16,
aeBuildSyntaxNoColon = 17,
aeBuildSyntaxCoercedList = 18,
aeBuildSyntaxUncoercedDoubleAt = 19
};
Constants
aeBuildSyntaxNoErr

No error.

Available in Mac OS X v10.0 and later.
aeBuildSyntaxBadToken

An illegal character was specified.

Available in Mac OS X v10.0 and later.
aeBuildSyntaxBadEOF

An unexpected end of format string was encountered.

Available in Mac OS X v10.0 and later.
aeBuildSyntaxNoEOF

There were unexpected characters beyond the end of the format string.

Available in Mac OS X v10.0 and later.
aeBuildSyntaxBadNegative

A minus sign “-” was not followed by digits.

Available in Mac OS X v10.0 and later.
aeBuildSyntaxMissingQuote

A string was not terminated by a closing quotation mark.

Available in Mac OS X v10.0 and later.
aeBuildSyntaxBadHex

A hex string contained characters other than hexadecimal digits.

Available in Mac OS X v10.0 and later.
aeBuildSyntaxOddHex

A hex string contained an odd number of digits.

Available in Mac OS X v10.0 and later.
aeBuildSyntaxNoCloseHex

A hex string was missing a “$” or “»” character.

Available in Mac OS X v10.0 and later.
aeBuildSyntaxUncoercedHex

A hex string must be coerced to a type.

Available in Mac OS X v10.0 and later.
aeBuildSyntaxNoCloseString

A string was missing a closing quote.

Available in Mac OS X v10.0 and later.
aeBuildSyntaxBadDesc

An illegal descriptor was specified.

Available in Mac OS X v10.0 and later.
aeBuildSyntaxBadData

Bad data was found inside a variable argument list.

Available in Mac OS X v10.0 and later.
aeBuildSyntaxNoCloseParen

A data value was missing a closing parenthesis.

Available in Mac OS X v10.0 and later.
aeBuildSyntaxNoCloseBracket

A comma or closing bracket “]” was expected.

Available in Mac OS X v10.0 and later.
aeBuildSyntaxNoCloseBrace

A comma or closing brace “}” was expected.

Available in Mac OS X v10.0 and later.
aeBuildSyntaxNoKey

A keyword was missing from a descriptor.

Available in Mac OS X v10.0 and later.
aeBuildSyntaxNoColon

In a descriptor, one of the keywords was not followed by a colon.

Available in Mac OS X v10.0 and later.
aeBuildSyntaxCoercedList

Cannot coerce a list.

Available in Mac OS X v10.0 and later.
aeBuildSyntaxUncoercedDoubleAt

You must coerce a “@@” substitution.

Available in Mac OS X v10.0 and later.*/
typedef UInt32 AEBuildErrorCode;
enum {
aeBuildSyntaxNoErr = 0,
aeBuildSyntaxBadToken = 1,
aeBuildSyntaxBadEOF = 2,
aeBuildSyntaxNoEOF = 3,
aeBuildSyntaxBadNegative = 4,
aeBuildSyntaxMissingQuote = 5,
aeBuildSyntaxBadHex = 6,
aeBuildSyntaxOddHex = 7,
aeBuildSyntaxNoCloseHex = 8,
aeBuildSyntaxUncoercedHex = 9,
aeBuildSyntaxNoCloseString = 10,
aeBuildSyntaxBadDesc = 11,
aeBuildSyntaxBadData = 12,
aeBuildSyntaxNoCloseParen = 13,
aeBuildSyntaxNoCloseBracket = 14,
aeBuildSyntaxNoCloseBrace = 15,
aeBuildSyntaxNoKey = 16,
aeBuildSyntaxNoColon = 17,
aeBuildSyntaxCoercedList = 18,
aeBuildSyntaxUncoercedDoubleAt = 19
};

/*Other Descriptor Type Constants

Specify types for Boolean and character descriptors.

enum {
   typeBoolean = 'bool',
   typeChar = 'TEXT'
};
Constants
typeBoolean

Boolean value—single byte with value 0 or 1.

Available in Mac OS X v10.0 and later.
typeChar

Unterminated string of system script characters.

See the Version Notes section below for important information.

Available in Mac OS X v10.0 and later.
Discussion

The constants described here specify the data type for a descriptor and show the kind of data stored in a descriptor with that type.

Descriptors are the building blocks used by the Apple Event Manager to construct Apple event attributes and parameters. A descriptor is a data structure of type AEDesc, which consists of data storage and a descriptor type that identifies the type of the data. A descriptor type is defined by the data type DescType. 

AppleScript defines descriptor type constants for a wide variety of common data types. For additional types, see “Descriptor Type Constants” and “Numeric Descriptor Type Constants”. For a complete listing, including data types such as units of length, weight, and volume, see the Apple Event Manager and Open Scripting Architecture header files.
Version Notes

On Mac OS X typeChar type is deprecated in favor of typeUTF8Text or typeUTF16ExternalRepresentation. For more information, see typeUTF16ExternalRepresentation.*/
enum {
   typeBoolean = 'bool',
   typeChar = 'TEXT'
};

/*AEBuildError

Defines a structure for storing additional error code information for “AEBuild” routines.

struct AEBuildError {
   AEBuildErrorCode fError;
   UInt32 fErrorPos;
};
typedef struct AEBuildError AEBuildError;
Fields
fError

The error code. See “AEBuild Error Codes” for a list of errors. 
fErrorPos

The character position where the parser detected the error. 
Availability
Available in Mac OS X v10.0 and later.*/
struct AEBuildError {
   AEBuildErrorCode fError;
   UInt32 fErrorPos;
};
typedef struct AEBuildError AEBuildError;

/*ID Constants for the AECreateAppleEvent Function

Specify values for the ID parameters of the AECreateAppleEvent function.

enum {
   kAutoGenerateReturnID = -1,
   kAnyTransactionID = 0
};
Constants
kAutoGenerateReturnID

If you pass this value for the returnID parameter of the AECreateAppleEvent function, the Apple Event Manager assigns to the created Apple event a return ID that is unique to the current session.

Available in Mac OS X v10.0 and later.
kAnyTransactionID

You pass this value for the transactionID parameter of the AECreateAppleEvent function if the Apple event is not one of a series of interdependent Apple events.

A transaction is a sequence of Apple events that are sent back and forth between the client and server applications, beginning with the client’s initial request for a service. All Apple events that are part of a transaction must have the same transaction ID.

Available in Mac OS X v10.0 and later.
Discussion

You use these constants with the AECreateAppleEvent function.*/
enum {
   kAutoGenerateReturnID = -1,
   kAnyTransactionID = 0
};


/*CarbonCore header file MacErrors.h.

For result codes for the AEBuild-related functions, see “AEBuild Error Codes”.Result Code	Value	Description
noPortErr	-903	
Client hasn’t set 'SIZE' resource to indicate awareness of high-level events
destPortErr	-906	
Server hasn’t set 'SIZE' resource to indicate awareness of high-level events, or else is not present
sessClosedErr	-917	
The kAEDontReconnect flag in the sendMode parameter was set and the server quit, then restarted
errAECoercionFail	-1700	
Data could not be coerced to the requested descriptor type
errAEDescNotFound	-1701	
Descriptor was not found
errAECorruptData	-1702	
Data in an Apple event could not be read
errAEWrongDataType	-1703	
Wrong descriptor type
errAENotAEDesc	-1704	
Not a valid descriptor
errAEBadListItem	-1705	
Operation involving a list item failed
errAENewerVersion	-1706	
Need a newer version of the Apple Event Manager
errAENotAppleEvent	-1707	
The event is not in AppleEvent format.
errAEEventNotHandled	-1708	
Event wasn’t handled by an Apple event handler
errAEReplyNotValid	-1709	
AEResetTimer was passed an invalid repl
errAEUnknownSendMode	-1710	
Invalid sending mode was passed
errAEWaitCanceled	-1711	
User canceled out of wait loop for reply or receipt
errAETimeout	-1712	
Apple event timed out
errAENoUserInteraction	-1713	
No user interaction allowed
errAENotASpecialFunction	-1714	
Wrong keyword for a special function
errAEParamMissed	-1715	
A required parameter was not accessed.
errAEUnknownAddressType	-1716	
Unknown Apple event address type
errAEHandlerNotFound	-1717	
No handler found for an Apple event
errAEReplyNotArrived	-1718	
Reply has not yet arrived
errAEIllegalIndex	-1719	
Not a valid list index
errAEImpossibleRange	-1720	
The range is not valid because it is impossible for a range to include the first and last objects that were specified; an example is a range in which the offset of the first object is greater than the offset of the last object
errAEWrongNumberArgs	-1721	
The number of operands provided for the kAENOT logical operator is not 1
errAEAccessorNotFound	-1723	
There is no object accessor function for the specified object class and container type
errAENoSuchLogical	-1725	
The logical operator in a logical descriptor is not kAEAND, kAEOR, or kAENOT
errAEBadTestKey	-1726	
The descriptor in a test key is neither a comparison descriptor nor a logical descriptor
errAENotAnObjectSpec	–1727	
The objSpecifier parameter of AEResolve is not an object specifier
errAENoSuchObject	-1728	
Runtime resolution of an object failed.
errAENegativeCount	-1729	
An object-counting function returned a negative result
errAEEmptyListContainer	-1730	
The container for an Apple event object is specified by an empty list
errAEUnknownObjectType	-1731	
The object type isn’t recognized
errAERecordingIsAlreadyOn	-1732	
Recording is already on
errAEReceiveTerminate	-1733	
Break out of all levels of AEReceive to the topmost (1.1 or greater)
errAEReceiveEscapeCurrent	-1734	
Break out of lowest level only of AEReceive (1.1 or greater)
errAEEventFiltered	-1735	
Event has been filtered and should not be propagated (1.1 or greater)
errAEDuplicateHandler	-1736	
Attempt to install handler in table for identical class and ID (1.1 or greater)
errAEStreamBadNesting	-1737	
Nesting violation while streaming
errAEStreamAlreadyConverted	-1738	
Attempt to convert a stream that has already been converted
errAEDescIsNull	-1739	
Attempt to perform an invalid operation on a null descriptor
errAEBuildSyntaxError	-1740	
AEBuildDesc and related functions detected a syntax error
errAEBufferTooSmall	-1741	
Buffer for AEFlattenDesc too small
errASCantConsiderAndIgnore	-2720	
Can’t both consider and ignore <attribute>.
errASCantCompareMoreThan32k	-2721	
Can’t perform operation on text longer than 32K bytes.
errASTerminologyNestingTooDeep	-2760	
Tell statements are nested too deeply.
errASIllegalFormalParameter	-2761	
<name> is illegal as a formal parameter.
errASParameterNotForEvent	-2762	
<name> is not a parameter name for the event <event>.
errASNoResultReturned	-2763	
No result was returned for some argument of this expression. 
errAEEventFailed	-10000	
Apple event handler failed.
errAETypeError	-10001	
A descriptor type mismatch occurred.
errAEBadKeyForm	-10002	
Invalid key form.
errAENotModifiable	-10003	
Can't set <object or data> to <object or data>. Access not allowed.
errAEPrivilegeError	-10004	
A privilege violation occurred.
errAEReadDenied	-10005	
The read operation was not allowed.
errAEWriteDenied	-10006	
Can't set <object or data> to <object or data>. 
errAEIndexTooLarge	-10007	
The index of the event is too large to be valid.
errAENotAnElement	-10008	
The specified object is a property, not an element.
errAECantSupplyType	-10009	
Can’t supply the requested descriptor type for the data.
errAECantHandleClass	-10010	
The Apple event handler can’t handle objects of this class.
errAEInTransaction	-10011	
Couldn’t handle this command because it wasn’t part of the current transaction.
errAENoSuchTransaction	-10012	
The transaction to which this command belonged isn’t a valid transaction.
errAENoUserSelection	-10013	
There is no user selection.
errAENotASingleObject	-10014	
Handler only handles single objects.
errAECantUndo	-10015	
Can’t undo the previous Apple event or user action.
errAENotAnEnumMember	-10023	
Enumerated value in SetData is not allowed for this property
errAECantPutThatThere	-10024	
In make new, duplicate, etc. class can't be an element of container
errAEPropertiesClash	-10025	
Illegal combination of properties settings for SetData, make new, or duplicate*/
enum{
noPortErr	 = -903,
destPortErr=-906,
sessClosedErr=-917,
errAECoercionFail=	-1700,
errAEDescNotFound	=-1701	,
errAECorruptData	=-1702	,
errAEWrongDataType=	-1703,	
errAENotAEDesc	=-1704	,
errAEBadListItem	=-1705	,
errAENewerVersion	=-1706	,
errAENotAppleEvent	=-1707	,
errAEEventNotHandled	=-1708,	
errAEReplyNotValid	=-1709	,
errAEUnknownSendMode=	-1710,	
errAEWaitCanceled	=-1711	,
errAETimeout	=-1712	,
errAENoUserInteraction	=-1713	,
errAENotASpecialFunction=	-1714,	
errAEParamMissed	=-1715	,
errAEUnknownAddressType=	-1716	,
errAEHandlerNotFound=	-1717	,
errAEReplyNotArrived=	-1718	,
errAEIllegalIndex	       =-1719,
errAEImpossibleRange=	-1720,	
errAEWrongNumberArgs	=-1721,
errAEAccessorNotFound	=-1723,
errAENoSuchLogical	=-1725,
errAEBadTestKey             =-1726,
//errAENotAnObjectSpec    = –1727,
errAENoSuchObject         = -1728	,
errAENegativeCount	=-1729	,
errAEEmptyListContainer=	-1730,	
errAEUnknownObjectType=	-1731	,
errAERecordingIsAlreadyOn=	-1732	,
errAEReceiveTerminate	=-1733	,
errAEReceiveEscapeCurrent=	-1734,	
errAEEventFiltered	=-1735	,
errAEDuplicateHandler=	-1736,	
errAEStreamBadNesting	=-1737	,
errAEStreamAlreadyConverted	=-1738,	
errAEDescIsNull	=-1739	,
errAEBuildSyntaxError=	-1740,	
errAEBufferTooSmall	=-1741	,
errASCantConsiderAndIgnore=	-2720,	
errASCantCompareMoreThan32k=	-2721	,
errASTerminologyNestingTooDeep=	-2760	,
errASIllegalFormalParameter	=-2761	,
errASParameterNotForEvent	=-2762	,
errASNoResultReturned	=-2763	,
errAEEventFailed	=-10000	,
errAETypeError	=-10001	,
errAEBadKeyForm	=-10002	,
errAENotModifiable	=-10003	,
errAEPrivilegeError	=-10004	,
errAEReadDenied	=-10005	,
errAEWriteDenied	=-10006	,
errAEIndexTooLarge=	-10007,	
errAENotAnElement	=-10008	,
errAECantSupplyType=	-10009	,
errAECantHandleClass=	-10010	,
errAEInTransaction	=-10011	,
errAENoSuchTransaction=	-10012	,
errAENoUserSelection=	-10013	,
errAENotASingleObject=	-10014	,
errAECantUndo	=-10015	,
errAENotAnEnumMember	=-10023	,
errAECantPutThatThere	=-10024	,
errAEPropertiesClash	=-10025	
};
#define errAENotAnObjectSpec     –1727
/*Descriptor Type Constants

Specify types for descriptors.

enum {
   typeAEList = 'list',
   typeAERecord = 'reco',
   typeAppleEvent = 'aevt',
   typeEventRecord = 'evrc',
   typeTrue = 'true',
   typeFalse = 'fals',
   typeAlias = 'alis',
   typeEnumerated = 'enum',
   typeType = 'type',
   typeAppParameters = 'appa',
   typeProperty = 'prop',
   typeFSS = 'fss ',
   typeFSRef = 'fsrf',
   typeFileURL = 'furl',
   typeKeyword = 'keyw',
   typeSectionH = 'sect',
   typeWildCard = '****',
   typeApplSignature = 'sign',
   typeQDRectangle = 'qdrt',
   typeFixed = 'fixd',
   typeProcessSerialNumber = 'psn ',
   typeApplicationURL = 'aprl',
   typeNull = 'null'
};
Constants
typeAEList

List of descriptors.

Available in Mac OS X v10.0 and later.
typeAERecord

List of keyword-specified descriptors.

Available in Mac OS X v10.0 and later.
typeAppleEvent

Apple event.

Available in Mac OS X v10.0 and later.
typeTrue

TRUE Boolean value.

Available in Mac OS X v10.0 and later.
typeFalse

FALSE Boolean value.

Available in Mac OS X v10.0 and later.
typeAlias

Alias.

Available in Mac OS X v10.0 and later.
typeEnumerated

Enumerated data.

Available in Mac OS X v10.0 and later.
typeType

Four-character code for event class or event ID

Available in Mac OS X v10.0 and later.
typeAppParameters

Process Manager launch parameters.

Available in Mac OS X v10.0 and later.
typeProperty

Apple event object property.

Available in Mac OS X v10.0 and later.
typeFSS

File system specification. Deprecated in Mac OS X. Use file system references (typeFSRef) instead.

Available in Mac OS X v10.0 and later.
typeFSRef

File system reference. Use in preference to file system specifications (typeFSS).

Available in Mac OS X v10.0 and later.
typeFileURL

A file URL. A descriptor of this type doesn't represent a CFURL, it represents a C-string-style file path.

Available in Mac OS X v10.1 and later.
typeKeyword

Apple event keyword.

Available in Mac OS X v10.0 and later.
typeSectionH

Handle to a section record. (Deprecated.)

Available in Mac OS X v10.0 and later.
typeWildCard

Matches any type.

Available in Mac OS X v10.0 and later.
typeApplSignature

Application signature.

Available in Mac OS X v10.0 and later.
typeProcessSerialNumber

A process serial number. See also AEAddressDesc.

Available in Mac OS X v10.0 and later.
typeApplicationURL

For specifying an application by URL. See Discussion session below for format.

Available in Mac OS X v10.1 and later.
typeNull

A null data storage pointer. When resolving an object specifier, an object with a null storage pointer specifies the default container at the top of the container hierarchy.

Available in Mac OS X v10.0 and later.
Discussion

The constants described here specify the data type for a descriptor and show the kind of data stored in a descriptor with that type.

Descriptors are the building blocks used by the Apple Event Manager to construct Apple event attributes and parameters. A descriptor is a data structure of type AEDesc, which consists of data storage and a descriptor type that identifies the type of the data. A descriptor type is defined by the data type DescType. 

AppleScript defines descriptor type constants for a wide variety of common data types. For additional types, see “Numeric Descriptor Type Constants” and “Other Descriptor Type Constants”. For a complete listing, including data types such as units of length, weight, and volume, see the Apple Event Manager and Open Scripting Architecture header files.

For the constant typeApplicationURL, the data that specifies the application URL takes the following format:eppc://[username[:password]@]host/AppName[[?uid=#]&[pid=#]]


As indicated by this format:
username is optional. If present, an '@' must appear before the host name. password is optional. If present, username is not optional, and the password must be separated from the username by a ':' and must precede the '@'. AppName is not optional; if it contains non-UTF-8 characters or white space, it must be URL-encoded (for example, My%20Application).
uid and pid are optional. If pid is present, uid and AppName are ignored and the event is delivered only to applications with the given process id. If uid is present, events are directed to the application name owned by the given user id.

The following are examples of valid URLs:eppc://Steve%20Zellers:wombat@grrr.apple.com/Microsoft%20Word
eppc://Steve%20Zellers:wombat@grrr.apple.com/Microsoft%20Word?pid=1284*/
enum {
   typeAEList = 'list',
   typeAERecord = 'reco',
   typeAppleEvent = 'aevt',
   typeEventRecord = 'evrc',
   typeTrue = 'true',
   typeFalse = 'fals',
   typeAlias = 'alis',
   typeEnumerated = 'enum',
   typeType = 'type',
   typeAppParameters = 'appa',
   typeProperty = 'prop',
   typeFSS = 'fss ',
   typeFSRef = 'fsrf',
   typeFileURL = 'furl',
   typeKeyword = 'keyw',
   typeSectionH = 'sect',
   typeWildCard = '****',
   typeApplSignature = 'sign',
   typeQDRectangle = 'qdrt',
   typeFixed = 'fixd',
   typeProcessSerialNumber = 'psn ',
   typeApplicationURL = 'aprl',
   typeNull = 'null'
};

/*Event ID Constants

Specify the event ID for an Apple event.

enum {
   kAEOpenApplication            = 'oapp',
   kAEReopenApplication          = 'rapp',
   kAEOpenDocuments              = 'odoc',
   kAEPrintDocuments             = 'pdoc',
   kAEOpenContents               = 'ocon',
   kAEQuitApplication            = 'quit',
   kAEAnswer                     = 'ansr',
   kAEApplicationDied            = 'obit',
   kAEShowPreferences            = 'pref'
};
Constants
kAEOpenApplication

Event that launches an application.

Available in Mac OS X v10.0 and later.
kAEReopenApplication

Event that reopens an application. Sent, for example, when your application is running and a user clicks your application icon in the Dock.

Available in Mac OS X v10.0 and later.
kAEOpenDocuments

Event that provides an application with a list of documents to open. Sent, for example, when a selects one or more documents for your application in the Finder and double-clicks them.

See also the constant keyAESearchText in the enum “keyAEPropData”.

Available in Mac OS X v10.0 and later.
kAEPrintDocuments

Event that provides an application with a list of documents to print.

Available in Mac OS X v10.0 and later.
kAEOpenContents

Event that provides an application with dragged content, such as text or an image. Sent, for example, when a user drags an image file onto your application’s icon in the Dock. The application can use the content as desired—for example, if no document is currently open, it might open a new document and insert the provided text or image.

For more information, see “Handling Apple Events Sent by the Mac OS” in “Responding to Apple Events” in Apple Events Programming Guide.

Available in Mac OS X v10.4 and later.
kAEQuitApplication

Event that causes the application to quit.

Available in Mac OS X v10.0 and later.
kAEAnswer

Event that is a reply Apple event.

Available in Mac OS X v10.0 and later.
kAEApplicationDied

Event sent by the Process Manager to an application that launched another application when the launched application quits or terminates.

Available in Mac OS X v10.0 and later.
kAEShowPreferences

Event sent by the Mac OS X to a process when the user chooses the Preferences item for that process.

Carbon applications that handle the Preferences command can install an Apple event handler for this event, but they more commonly install a Carbon event handler for kEventCommandProcess and check for the kHICommandPreferences command ID.

Available in Mac OS X v10.0 and later.
Discussion

Apple events are identified by their event class and event ID attributes. The event ID is the attribute that identifies the particular Apple event within its event class. In conjunction with the event class, the event ID uniquely identifies the Apple event and communicates what action the Apple event should perform. The event ID appears in the where field of the event record for an Apple event. For example, an event with ID kAEOpenApplication and class kCoreEventClass is an event sent by the Mac OS that launches an application.

Only a small number of event IDs are shown here. For a more complete listing, see the Apple Event Manager and Open Scripting Architecture header files.*/
enum {
   kAEOpenApplication            = 'oapp',
   kAEReopenApplication          = 'rapp',
   kAEOpenDocuments              = 'odoc',
   kAEPrintDocuments             = 'pdoc',
   kAEOpenContents               = 'ocon',
   kAEQuitApplication            = 'quit',
   kAEAnswer                     = 'ansr',
   kAEApplicationDied            = 'obit',
   kAEShowPreferences            = 'pref'
};


/*Event Class Constants

Specify the event class for an Apple event.

enum {
   kCoreEventClass = 'aevt'
};
Constants
kCoreEventClass

An Apple event sent by the Mac OS; applications that present a graphical interface to the user should be able to any events sent by the Mac OS that apply to the application.

Available in Mac OS X v10.0 and later.
Discussion

Apple events are identified by their event class and event ID attributes, each of which specifies an arbitrary four-character code. The event class appears in the message field of the event record for an Apple event. For example, certain Apple events that are sent by the Mac OS have the value 'aevt' in the message fields of their event records. This value can be represented with the constant kCoreEventClass.

Groups of related Apple events are known as suites. For example, the common events that most applications support are grouped in the Standard Suite. The Standard Suite includes the events of the Core suite (open application , reopen, open contents, open documents, print documents, and quit), as well as such events as count, delete, and make. Suites may use a common event class, but doing so is not required, and does not result in any special treatment by AppleScript or the Apple Event Manager.

AppleScript defines suites that provide terminology for Text, Database, Macintosh Connectivity, and other types of related operations. The terms defined in the AppleScript suite itself make up the largest suite. These terms are global to AppleScript, and are available to your application, even if your 'aete' resource doesn’t explicitly include them*/
enum {
   kCoreEventClass = 'aevt'
};

/*AEEventID

Specifies the event ID of an Apple event.

typedef FourCharCode AEEventID;
Discussion

Apple events are identified by their event class and event ID attributes. The event ID is the attribute that identifies a particular Apple event within its event class. In conjunction with the event class, the event ID uniquely identifies the Apple event and communicates what action the Apple event should perform.

For more information on Apple event IDs, see “Event ID Constants”. 
Availability
Available in Mac OS X v10.0 and later.*/
typedef FourCharCode AEEventID;

/*AEEventClass

Specifies the event class of an Apple event.

typedef FourCharCode AEEventClass;
Discussion

Apple events are identified by their event class and event ID attributes. The event class is the attribute that identifies a group of related Apple events. When you call the AEProcessAppleEvent function, the Apple Event Manager uses these attributes to identify a handler for a specific Apple event.

For more information on Apple event classes, see “Event Class Constants”. 
Availability
Available in Mac OS X v10.0 and later.*/
typedef FourCharCode AEEventClass;

/*AEKeyword

A four-character code that uniquely identifies a descriptor in an Apple event record or an Apple event.

typedef FourCharCode AEKeyword;
Discussion

The Apple Event Manager uniquely identifies the various parts of an Apple event by means of keywords associated with corresponding descriptors. Keywords are arbitrary names, stored as four-character codes of type AEKeyword. A keyword combined with a descriptor forms a keyword-specified descriptor, which is defined by a data structure of type AERemoteProcessResolverContext.

The Apple Event Manager also uses keywords for Apple event attributes. Keyword constants used by the Apple Event Manager are defined in “Keyword Attribute Constants” and “Keyword Parameter Constants”. 
Availability
Available in Mac OS X v10.0 and later.*/
typedef FourCharCode AEKeyword;

/*Keyword Parameter Constants

Specify keyword values for Apple event parameters, as well as information for the AEManagerInfo function to retrieve. Some common key word values are shown here.

enum {
   keyDirectObject = '----',
   keyErrorNumber = 'errn',
   keyErrorString = 'errs',
   keyProcessSerialNumber = 'psn ',
   keyPreDispatch = 'phac',
   keySelectProc = 'selh',
   keyAERecorderCount = 'recr',
   keyAEVersion = 'vers'
};
Constants
keyDirectObject

Direct parameter. Usually specifies the data to be acted upon by the target application.

Available in Mac OS X v10.0 and later.
keyErrorNumber

Error number. Often used to extract error information from a reply Apple event.

Available in Mac OS X v10.0 and later.
keyErrorString

Error string. Often used to extract error information from a reply Apple event to display to the user.

Available in Mac OS X v10.0 and later.
keyProcessSerialNumber

Process serial number. See also AEManagerInfo.

Available in Mac OS X v10.0 and later.
keyPreDispatch

A predispatch handler (an Apple event handler that the Apple Event Manager calls immediately before it dispatches an Apple event). See also Managing Special Handler Dispatch Tables.

Available in Mac OS X v10.0 and later.
keySelectProc

You pass this value in the functionClass parameter of the AEManagerInfo function to disable the Object Support Library. Disabling the Object Support Library is not recommended.

Available in Mac OS X v10.0 and later.
keyAERecorderCount

Used with the keyword parameter of the AEManagerInfo function. If you pass this value, on return, the result parameter supplies the number of processes that are currently recording Apple events.

Available with version 1.0.1 and later.
keyAEVersion

Used with the keyword parameter of the AEManagerInfo function. If you pass this value, on return, the result parameter supplies version information for the Apple Event Manager, in NumVersion format.

Available with version 1.0.1 and later.
Discussion

These constants are keyword constants for Apple event parameters. An Apple event consists of attributes (which identify the Apple event and denote its task) and, often, parameters (which contain information to be used by the target application). Taken together, the attributes of an Apple event denote the task to be performed on any data specified in the Apple events parameters.

Keywords are arbitrary names used by the Apple Event Manager to keep track of various descriptors. Your application cannot examine the contents of an Apple event directly. Instead, you call Apple Event Manager routines such as those described in Getting Data or Descriptors From Apple Events to request attributes and parameters by keyword.

See also Keyword Attribute Constants.*/
enum {
   keyDirectObject = '----',
   keyErrorNumber = 'errn',
   keyErrorString = 'errs',
   keyProcessSerialNumber = 'psn ',
   keyPreDispatch = 'phac',
   keySelectProc = 'selh',
   keyAERecorderCount = 'recr',
   keyAEVersion = 'vers'
};

/*AEDataStorage

A pointer to an opaque data type that provides storage for an AEDesc descriptor.

typedef AEStorageDataType * AEDataStorage;
Discussion

The Apple Event Manager defines the AEDataStorage data type to serve as a data storage field in the AEDesc structure. Your application doesnt access the data pointed to by a data storage pointer directly. Rather, you work with the following functions:
AEGetDescDataSize
AEGetDescData
AEGetDescDataRange
AEReplaceDescData
Availability
Available in Mac OS X v10.0 and later.*/
typedef AEStorageDataType * AEDataStorage;

/*AEDesc

Stores data and an accompanying descriptor type to form the basic building block of all Apple Events.

struct AEDesc {
   DescType descriptorType;
   AEDataStorage dataHandle;
};
typedef struct AEDesc AEDesc;
Fields
descriptorType

A four-character code of type DescType that indicates the type of data in the structure. See DescType.
dataHandle

An opaque storage type that points to the storage for the descriptor data. Your application doesnt access this data directly?rather, it calls one of the functions AEGetDescDataSize, AEGetDescData, or AEReplaceDescData. See AEDataStorage.
Discussion

The Apple Event Manager uses one or more descriptors to construct Apple event attributes and parameters, object specifiers, tokens, and many other types of data it works with. (Token is defined in AEDisposeToken.) A descriptor consists of an opaque data storage container and a descriptor type that identifies the type of the data stored in the descriptor.

The descriptor type is a structure of type DescType, which in turn is of data type ResType?that is, a four-character code. Descriptor Type Constants lists the constants for the basic descriptor types used by the Apple Event Manager. For information about descriptor types used with object specifiers, see Key Form and Descriptor Type Object Specifier Constants. 
Version Notes

Prior to Carbon, the AEDataStorage data type was defined as follows:typedef Handle AEDataStorage;

Availability
Available in Mac OS X v10.0 and later.*/

struct AEDesc {
   DescType descriptorType;
   AEDataStorage dataHandle;
};
typedef struct AEDesc AEDesc;

/*AEDescList

A descriptor whose data consists of a list of one or more descriptors.

typedef AEDesc AEDescList;
Discussion

A descriptor list is identical to a descriptor of data type AEDesc ?the only difference is that the data in a descriptor list must always consist of a list of other descriptors.

Descriptor lists are a key building block of Apple events. Many Apple Event Manager functions take or return lists of descriptors in descriptor lists. For example, see the functions described in Counting the Items in Descriptor Lists and Getting Items From Descriptor Lists.

The format of the data in the dataHandle of the descriptor is private. You can only operate on the contained elements with Apple Event Manager functions, including those described in Counting the Items in Descriptor Lists and Getting Items From Descriptor Lists. 
Availability
Available in Mac OS X v10.0 and later.*/
typedef AEDesc AEDescList;


/*AERecord

A descriptor whose data is a list of keyword-specified descriptors.

typedef AEDescList AERecord;
Discussion

The Apple Event Manager provides routines that allow your application to create Apple event records and extract data from them when creating or responding to Apple events. You also work with Apple event records if your application resolves or creates object specifiers. Functions that use Apple event records are described in Getting Data or Descriptors From Apple Events and Adding Parameters and Attributes to an Apple Event. 

The descriptor list of keyword-specified descriptors in an Apple event record must specify Apple event parameters?they cannot specify Apple event attributes. Only descriptor lists of type Apple event can contain both attributes and parameters.
Availability
Available in Mac OS X v10.0 and later.*/
typedef AEDescList AERecord;

/*AppleEvent

A descriptor whose data is a list of descriptors containing both attributes and parameters that make up an Apple event.

typedef AERecord AppleEvent;
Discussion

The Apple event data type describes a full-fledged Apple event. Like the data for an Apple event record (data type AERecord), the data for an Apple event consists of a list of keyword-specified descriptors. Unlike an Apple event record, the data for an Apple event is conceptually divided into two parts, one for attributes and one for parameters. This division within the Apple event allows the Apple Event Manager to distinguish between an event’s attributes and its parameters.

For additional information on the structure of an Apple event and on how to build one, see “Building an Apple Event” in Apple Events Programming Guide.

Many functions work with Apple events, including the functions described in “Getting Data or Descriptors From Apple Events”, “Adding Parameters and Attributes to an Apple Event”, “Creating an Apple Event”, and “Sending an Apple Event”. 
Availability
Available in Mac OS X v10.0 and later.*/
typedef AERecord AppleEvent;

/*AEEventHandlerProcPtr

Defines a pointer to a function that handles one or more Apple events. Your Apple event handler function performs any action requested by the Apple event, adds parameters to the reply Apple event if appropriate (possibly including error information), and returns a result code.

typedef OSErr (*AEEventHandlerProcPtr)
(
   const AppleEvent * theAppleEvent,
   AppleEvent * reply,
   long handlerRefcon
);

If you name your function MyAEEventHandlerCallback, you would declare it like this:

OSErr MyAEEventHandlerCallback (
   const AppleEvent * theAppleEvent,
   AppleEvent * reply,
   long handlerRefcon
);
Parameters
theAppleEvent

A pointer to the Apple event to handle. See AppleEvent.
reply

A pointer to the default reply Apple event provided by the Apple Event Manager. See AppleEvent. If no reply is expected, reply has descriptor type typeNull.
handlerRefcon

The reference constant stored in the Apple event dispatch table when you install the handler function for the Apple event. You can store any 32-bit value in the dispatch table and use it any way you want when the handler is called. The reference constant may have a value of NULL.
Return Value

A result code. See “Apple Event Manager Result Codes”. Your handler should always return noErr if it successfully handled the Apple event. If an error occurs, your handler should return either errAEEventNotHandled or some other nonzero result code. For more information, see the Discussion section.
Discussion

An Apple event handler should extract any parameters and attributes from the Apple event, perform the requested action, and add parameters to the reply Apple event if appropriate. You must provide an Apple event handler for each Apple event your application supports. The AEProcessAppleEvent function calls one of your Apple event handlers when it processes an Apple event.

If an error occurs because your application cannot understand the event, return errAEEventNotHandled, so that the Apple Event Manager may be able to find another handler to handle the event. If the error occurs because the event is impossible to handle as specified, return the result code returned by whatever function caused the failure, or whatever other result code is appropriate.

For example, suppose your application receives a kAEGetData event that requests the name of the current printer, and your application cannot handle such an event. In this situation, you should return errAEEventNotHandled so that another handler available to the Apple Event Manager can have a chance to handle the event. This strategy allows users to take advantage of system capabilities from within your application via system handlers.

If your Apple event handler calls the AEResolve function and AEResolve calls an object accessor function in the system object accessor dispatch table, your Apple event handler may not recognize the descriptor type of the token returned by the function. In this case, your handler should return the result code errAEUnknownObjectType. When your handler returns this result code, the Apple Event Manager attempts to locate a system Apple event handler that can recognize the token.

For additional information on dealing with error conditions, see OSLGetErrDescProcPtr.

To provide a pointer to your event handler callback function, you create a universal procedure pointer (UPP) of type AEEventHandlerUPP, using the function NewAEEventHandlerUPP. You can do so with code like the following:AEEventHandlerUPP MyEventHandlerUPP;
MyEventHandlerUPP = NewAEEventHandlerUPP (&MyEventHandlerCallback)


You can then pass the UPP MyEventHandlerUPP as a parameter to any function that installs or removes a handler, such as AEInstallEventHandler. If your application installs the same event handler to handle more than one kind of event (more than one pair of event class and event ID), you can use the same UPP to install the handler multiple times.

If you wish to call your event handler callback function directly, you can use the InvokeAEEventHandlerUPP function.

After you are finished with an event handler callback function, and have removed it with the AERemoveEventHandler function, you can dispose of the UPP with the DisposeAEEventHandlerUPP function. However, don’t dispose of the UPP if any remaining handler uses it or if you plan to install the handler again. 
Version Notes

Your application should not install a handler in a system dispatch table with the goal that the handler will get called when other applications receive an Apple event—this won’t work in Mac OS X. For more information, see “The System Dispatch Table” in “Apple Event Dispatching” in Apple Events Programming Guide.*/
typedef OSErr (*AEEventHandlerProcPtr)
(
   const AppleEvent * theAppleEvent,
   AppleEvent * reply,
   long handlerRefcon
);

/*AEEventHandlerUPP

Defines a data type for the universal procedure pointer for the AEEventHandlerUPP callback function pointer.

typedef AEEventHandlerProcPtr AEEventHandlerUPP;
Discussion

For a description of an event handler callback function, see AEEventHandlerProcPtr.*/
typedef AEEventHandlerProcPtr AEEventHandlerUPP;

/*AppleEvent

A descriptor whose data is a list of descriptors containing both attributes and parameters that make up an Apple event.

typedef AERecord AppleEvent;
Discussion

The Apple event data type describes a full-fledged Apple event. Like the data for an Apple event record (data type AERecord), the data for an Apple event consists of a list of keyword-specified descriptors. Unlike an Apple event record, the data for an Apple event is conceptually divided into two parts, one for attributes and one for parameters. This division within the Apple event allows the Apple Event Manager to distinguish between an events attributes and its parameters.

For additional information on the structure of an Apple event and on how to build one, see Building an Apple Event in Apple Events Programming Guide.

Many functions work with Apple events, including the functions described in Getting Data or Descriptors From Apple Events, Adding Parameters and Attributes to an Apple Event, Creating an Apple Event, and Sending an Apple Event. 
Availability
Available in Mac OS X v10.0 and later.*/
typedef AERecord AppleEvent;

/*AEInstallEventHandler

Adds an entry for an event handler to an Apple event dispatch table.

OSErr AEInstallEventHandler (
   AEEventClass theAEEventClass,
   AEEventID theAEEventID,
   AEEventHandlerUPP handler,
   long handlerRefcon,
   Boolean isSysHandler
);
Parameters
theAEEventClass

The event class for the Apple event or events to dispatch to this event handler. The Discussion section describes interactions between this parameter and the theAEEventID parameter. See AEEventClass.
theAEEventID

The event ID for the Apple event or events to dispatch to this event handler. The Discussion section describes interactions between this parameter and the theAEEventClass parameter. See AEEventID.
handler

A universal procedure pointer to the Apple event handler function to install. See AEEventHandlerUPP.
handlerRefcon

A reference constant. The Apple Event Manager passes this value to the handler each time it calls it. If your handler doesn’t require a reference constant, pass 0 for this parameter.
isSysHandler

Specifies the Apple event dispatch table to add the handler to. Pass TRUE to add the handler to the system dispatch table or FALSE to add the handler to your application’s dispatch table. See Version Notes for related information.
Return Value

A result code. See “Apple Event Manager Result Codes”.
Discussion

The parameters theAEEventClass and theAEEventID specify the event class and event ID of the Apple events handled by the handler for this dispatch table entry. If there is already an entry in the specified dispatch table for the same event class and event ID, it is replaced. For these parameters, you must provide one of the following combinations:
the event class and event ID of a single Apple event to dispatch to the handler (for example, an event class of kAECoreSuite and an event ID of kAEDelete so that a specific kind of delete event is dispatched to the handler) 
the typeWildCard constant for theAEEventClass and an event ID for theAEEventID, which indicates that Apple events from all event classes whose event IDs match theAEEventID should be dispatched to the handler (for example, an event class of typeWildCard and an event ID of kAEDelete so that for all event classes, the delete event is dispatched to the handler) 
an event class for theAEEventClass and the typeWildCard constant for theAEEventID, which indicates that all events from the specified event class should be dispatched to the handler (for example, an event class of kAECoreSuite and an event ID of typeWildCard so that all events for the core suite are dispatched to the handler) 
the typeWildCard constant for both the theAEEventClass and theAEEventID parameters, which indicates that all Apple events should be dispatched to the handler

If you use the typeWildCard constant for either the theAEEventClass or the theAEEventID parameter (or for both parameters), the corresponding handler must return the error errAEEventNotHandled if it does not handle a particular event.

If an Apple event dispatch table contains one entry for an event class and a specific event ID, and also contains another entry that is identical except that it specifies a wildcard value for either the event class or the event ID, the Apple Event Manager dispatches the more specific entry. For example, if an Apple event dispatch table includes one entry that specifies the event class as kAECoreSuite and the event ID as kAEDelete, and another entry that specifies the event class as kAECoreSuite and the event ID as typeWildCard, the Apple Event Manager dispatches the Apple event handler associated with the entry that specifies the event ID as kAEDelete.

In addition to the Apple event handler dispatch tables, applications can add entries to special handler dispatch tables, as described in “Managing Special Handler Dispatch Tables”. 
Version Notes

Thread safe starting in Mac OS X v10.2.

Your application should not install a handler in a system dispatch table with the goal that the handler will get called when other applications receive events—this won’t work in Mac OS X. For more information, see “The System Dispatch Table” in “Apple Event Dispatching” in Apple Events Programming Guide.
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X v10.0 and later.
Declared In
AppleEvents.h*/
OSErr AEInstallEventHandler (
   AEEventClass theAEEventClass,
   AEEventID theAEEventID,
   AEEventHandlerUPP handler,
   long handlerRefcon,
   Boolean isSysHandler
);
