#ifndef COMPONENTS_H
#define COMPONENTS_H
#endif

#ifndef MACTYPES_H
#include <CarbonCore/MacTypes.h>
#endif

#ifndef  HYS_H
#include <OC_Cocoa/hys.h>
#endif



/*ComponentInstanceRecord

Undocumented

struct ComponentInstanceRecord {
   long    data[1];
};
Fields
data
Discussion

Undocumented
Discussion

Undocumented
Programming Info
C interface file: Components.h*/
struct ComponentInstanceRecord {
   long    data[1];
};
typedef struct ComponentInstanceRecord ComponentInstanceRecord ;
/*ComponentInstance

Abst_ComponentInstance

typedef ComponentInstanceRecord * ComponentInstance;
Availability
Available in Mac OS X v10.0 and later.*/
typedef ComponentInstanceRecord * ComponentInstance;

/*ComponentResult


typedef  ComponentResult;
Special Considerations
Availability
Available in Mac OS X v10.0 and later.*/
typedef  ComponentResult;

/*CloseComponent

Terminates your applications connection to a component. 

OSErr CloseComponent (
   ComponentInstance aComponentInstance
);
Parameters
aComponentInstance

The connection you wish to close. Your application obtains the component instance from the OpenComponent function or the OpenDefaultComponent function. You can use a component identifier here, but you must coerce the data type appropriately. 
Return Value

A result code. See Component Manager Result Codes.
Discussion

This function closes only a single connection. If your application has several connections to a single component, you must call it once for each connection. 
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later. Available in Mac OS X 10.0 and later.
Available in QuickTime for Windows.
Carbon Porting Notes
Declared In
Components.h*/
OSErr CloseComponent (
   ComponentInstance aComponentInstance
);

/*OpenDefaultComponent

Opens a connection to a registered component of the component type and subtype specified by your application. 

ComponentInstance OpenDefaultComponent (
   OSType componentType,
   OSType componentSubType
);
Parameters
componentType

The type of the component. All components of a particular type support a common set of interface functions. Use this parameter to search for components of a given type. 
componentSubType

The subtype of the component. Different subtypes of a component type may support additional features or provide interfaces that extend beyond the standard functions for a given component type. For example, the subtype of an image compressor component indicates the compression algorithm employed by the compressor.

Your application can use the componentSubType parameter to perform a more specific lookup operation than is possible using only the componentType parameter. For example, you may want your application to use only components of a certain component type ('draw') that also have a specific subtype ('oval'). Set this parameter to 0 to select a component with any subtype value.
Return Value

A component instance that identifies the connection opened to the component which matches your search criteria. You must supply this component instance whenever you call the functions provided by the component. When you close the component, you must also supply this component instance to the CloseComponent function.

If more than one component in the list of registered components meets the search criteria, the function opens the first one that it finds in its list. If it cannot open the specified component, it returns NULL.

See the description of the ComponentInstance data type.
Discussion

Your application must open a component before it can call any component functions. This function searches for a component by type and subtype. You do not have to supply a component description structure or call the FindNextComponent function to use this function. If you want to exert more control over the selection process, you can use the FindNextComponent and OpenComponent functions. 
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later. Available in Mac OS X 10.0 and later.
Available in QuickTime for Windows.
Carbon Porting Notes
Declared In
Components.h*/
ComponentInstance OpenDefaultComponent (
   OSType componentType,
   OSType componentSubType
);