#ifndef CFBUNDLE_H
#define CFBUNDLE_H
#endif 

#ifndef CFURL_H
#include <CoreFoundation/CFURL.h>
#endif

/* CFBundleRef

A reference to a CFBundle object.

typedef struct __CFBundle *CFBundleRef;
Availability
Available in Mac OS X v10.0 and later.*/
typedef struct __CFBundle *CFBundleRef;

/*CFBundleCopyResourceURL

Returns the location of a resource contained in the specified bundle.

CFURLRef CFBundleCopyResourceURL (
   CFBundleRef bundle,
   CFStringRef resourceName,
   CFStringRef resourceType,
   CFStringRef subDirName
);
Parameters
bundle

The bundle to examine. 
resourceName

The name of the requested resource. 
resourceType

The abstract type of the requested resource. The type is expressed as a filename extension, such as jpg. Pass NULL if you dont need to search by type.
subDirName

The name of the subdirectory of the bundles resources directory to search. Pass NULL to search the standard CFBundle resource locations.
Return Value

A CFURL object describing the location of the requested resource, or NULL if the resource cannot be found. Ownership follows the Create Rule.
Discussion

For example, if a bundle contains a subdirectory WaterSounds that includes a file Water1.aiff, you can retrieve the URL for the file using:CFBundleCopyResourceURL(bundle, CFSTR("Water1"), CFSTR("aiff"), CFSTR("WaterSounds"));

Availability
Available in CarbonLib v1.0 and later.
Available in Mac OS X v10.0 and later.*/
CFURLRef CFBundleCopyResourceURL (
   CFBundleRef bundle,
   CFStringRef resourceName,
   CFStringRef resourceType,
   CFStringRef subDirName
);

/*CFBundleCopyResourcesDirectoryURL

Returns the location of a bundles Resources directory.

CFURLRef CFBundleCopyResourcesDirectoryURL (
   CFBundleRef bundle
);
Parameters
bundle

The bundle to examine. 
Return Value

A CFURL object describing the location of bundles resources directory, or NULL if it could not be found. Ownership follows the Create Rule.
Discussion

In general, you should never need to use this function. Use CFBundleCopyResourceURL and similar functions instead. 
Availability
Available in CarbonLib v1.0 and later.
Available in Mac OS X v10.0 and later.*/
CFURLRef CFBundleCopyResourcesDirectoryURL (
   CFBundleRef bundle
);