#ifndef CGCONTEXT_H
#define CGCONTEXT_H
#endif

/*CGContextRef

Defines an opaque type that represents a Quartz 2D drawing environment.

typedef struct CGContext * CGContextRef;
Discussion

All objects in Quartz are drawn in, or contained by, a graphics context. Quartz provides several different kinds of context, including the following:
A bitmap graphics context allows you to paint into a bitmap. 
A window graphics context is a bitmap graphics context that you can use to draw into a window. 
A graphics context obtained from the printing framework, is used to draw images directly to a printer. 
A PDF graphics context allows you to create a PDF document. 
A GL graphics contexts lets you draw to an Open GL context.

For detailed information on how to create each flavor of graphics context, including sample code, see Quartz 2D Programming Guide.

In Mac OS X version 10.2 and later, CGContextRef is derived from CFTypeRef and inherits the properties that all Core Foundation types have in common. For more information, see CFType Reference.
Availability
Available in Mac OS X v10.0 and later.*/
typedef struct CGContext * CGContextRef;