#ifndef MACWINDOW_H
#define MACWINDOWS_H
#endif

#ifndef HIGEOMETRY_H
#include <HIToolbox/HIGeometry.h>
#endif

#ifndef QUICKDRWA_H
#include <QD/Quickdraw.h>
#endif

#ifndef _TYPES_H
#include <CoreFoundation/Types.h>
#endif

#ifndef MACTYPES_H
#include <CarbonCore/MacTypes.h>
#endif

#ifndef CORESERVICE_H
#include <CoreService/CoreService.h>
#endif

/*Result Codes

The most common result codes returned by Window Manager are listed below.Result Code	Value	Description
noErr	0	
No error
paramErr	-50	
Invalid value passed in a parameter. Your application passed an invalid parameter for dialog options.
memFullErr	-108	
Not enough memory

Not enough room in heap zone.

Not enough memory to speak
resNotFound	-192	
Unable to read resource

Resource not found
errInvalidWindowPtr	-5600	
Invalid window pointer
errUnsupportedWindowAttributesForClass	-5601	
Attribute bits are inappropriate for the specified window class
errWindowDoesNotHaveProxy	-5602	
No proxy attached to window
errInvalidWindowProperty	-5603	
'appl' creator code not allowed
errWindowPropertyNotFound	-5604	
Specified property does not exist
errUnrecognizedWindowClass	-5605	
Unknown window class
errCorruptWindowDescription	-5606	
Incorrect size or version supplied in the BasicWindowDescription structure
errUserWantsToDragWindow	-5607	
Entire window is being dragged, not proxy icon
errWindowsAlreadyInitialized	-5608	
Called InitFloatingWindows twice, or called InitWindows and then InitFloatingWindows
errFloatingWindowsNotInitialized	-5609	
Called HideFloatingWindows or ShowFloatingWindows without calling InitFloatingWindows*/
#define noErr	0	
#define  paramErr	-50	
#define  memFullErr	-108	
#define  resNotFound	-192	
#define  errInvalidWindowPtr	-5600	
#define  errUnsupportedWindowAttributesForClass	-5601	
#define  errWindowDoesNotHaveProxy	-5602	
#define  errInvalidWindowProperty	-5603	
#define  errWindowPropertyNotFound	-5604	
#define  errUnrecognizedWindowClass	-5605	
#define errCorruptWindowDescription	-5606	
#define  errUserWantsToDragWindow	-5607	
#define  errWindowsAlreadyInitialized	-5608	
#define  errFloatingWindowsNotInitialized	-5609	

/*Window Modality Options

Specify the modality of a window. 

typedef UInt32 WindowModality;
enum {
   kWindowModalityNone = 0,
   kWindowModalitySystemModal = 1,
   kWindowModalityAppModal = 2,
   kWindowModalityWindowModal = 3
};
Constants
kWindowModalityNone

A window does not prevent interaction with any other window in the system. 

Available in Mac OS X v10.0 and later.
kWindowModalitySystemModal

The window is system-modal. On Mac OS 9 and earlier, the user cannot perform any other action until the window is dismissed. On Mac OS X, this constant produces the same behavior as kWindowModalityAppModal, so there is no way to prevent the user from interacting with windows from other applications.

Available in Mac OS X v10.0 and later.
kWindowModalityAppModal

The window is application-modal; that is the user cannot perform any other action within the application until the window is dismissed. The user can switch to other applications, however. 

Available in Mac OS X v10.0 and later.
kWindowModalityWindowModal

The window is document-modal; the user cannot perform any other action within the current document window until the modal window associated with it is dismissed. The user can switch to other windows or applications, however. Sheets are document-modal. 

Available in Mac OS X v10.0 and later.*/
typedef UInt32 WindowModality;
enum {
   kWindowModalityNone = 0,
   kWindowModalitySystemModal = 1,
   kWindowModalityAppModal = 2,
   kWindowModalityWindowModal = 3
};
/*Window Region Constants

Define various window regions. 

typedef UInt16 WindowRegionCode;
enum {
   kWindowTitleBarRgn = 0,
   kWindowTitleTextRgn = 1,
   kWindowCloseBoxRgn = 2,
   kWindowZoomBoxRgn = 3,
   kWindowDragRgn = 5,
   kWindowGrowRgn = 6,
   kWindowCollapseBoxRgn = 7,
   kWindowTitleProxyIconRgn = 8,
   kWindowStructureRgn = 32,
   kWindowContentRgn = 33,
   kWindowUpdateRgn = 34,
   kWindowOpaqueRgn = 35,
   kWindowGlobalPortRgn = 40,
   kWindowToolbarButtonRgn = 41
};
Constants
kWindowTitleBarRgn

The entire area occupied by a windows title bar, including the title text region.

Available in Mac OS X v10.0 and later.
kWindowTitleTextRgn

That portion of a windows title bar that is occupied by the name of the window.

Available in Mac OS X v10.0 and later.
kWindowCloseBoxRgn

The area occupied by a windows close box.

Available in Mac OS X v10.0 and later.
kWindowZoomBoxRgn

The area occupied by a windows zoom box.

Available in Mac OS X v10.0 and later.
kWindowDragRgn

The draggable area of the window frame; this area includes the title bar and window outline and excludes the size box, close box, zoom box, and collapse box.

Available in Mac OS X v10.0 and later.
kWindowGrowRgn

The area occupied by a windows size box.

Available in Mac OS X v10.0 and later.
kWindowCollapseBoxRgn

The area occupied by a windows collapse box. 

Available in Mac OS X v10.0 and later.
kWindowTitleProxyIconRgn

Specifies the region in the windows title area that contains the proxy icon. The proxy icon region is always located within the windows title text region.

Available in Mac OS X v10.0 and later.
kWindowStructureRgn

The entire area occupied by a window, including the frame and content region; the window may be partially off-screen but its structure region does not change.

Available in Mac OS X v10.0 and later.
kWindowContentRgn

The windows content region?the part of a window in which your application displays the contents of the window or dialog, including the size box and any controls. 

Available in Mac OS X v10.0 and later.
kWindowUpdateRgn

The windows update region??the part of the window that needs to be redrawn. 

Available in Mac OS X v10.0 and later.
kWindowOpaqueRgn

Area of window considered to be opaque. Only valid for windows with alpha channels. (Mac OS X only)

Available in Mac OS X v10.0 and later.
kWindowGlobalPortRgn

Bounds of the windows port in global coordinates; not affected by CollapseWindow.

Available in Mac OS X v10.0 and later.
kWindowToolbarButtonRgn

Bounds of the toolbar button area. (Available in Mac OS X v10.4 and later.)

Available in Mac OS X v10.4 and later.
Discussion

You can pass constants of type WindowRegionCode in the inRegionCode parameter of GetWindowRegion to obtain a handle to a specific window region. The WindowRegionCode constants are available with Appearance Manager 1.0 and later. 
Version Notes

With the Window Manager in Mac OS 8.5 and later, you may pass the kWindowTitleProxyIconRgn, kWindowStructureRgn, and kWindowContentRgn constants to the function GetWindowRegion.*/
typedef UInt16 WindowRegionCode;
enum {
   kWindowTitleBarRgn = 0,
   kWindowTitleTextRgn = 1,
   kWindowCloseBoxRgn = 2,
   kWindowZoomBoxRgn = 3,
   kWindowDragRgn = 5,
   kWindowGrowRgn = 6,
   kWindowCollapseBoxRgn = 7,
   kWindowTitleProxyIconRgn = 8,
   kWindowStructureRgn = 32,
   kWindowContentRgn = 33,
   kWindowUpdateRgn = 34,
   kWindowOpaqueRgn = 35,
   kWindowGlobalPortRgn = 40,
   kWindowToolbarButtonRgn = 41
};

/*WindowPtr

Defines a window pointer. 

typedef struct OpaqueWindowPtr * WindowPtr;
Availability
Available in Mac OS X v10.0 and later.*/
typedef struct OpaqueWindowPtr * WindowPtr;

/*WindowRef

Represents a window. 

typedef WindowPtr WindowRef;
Availability
Available in Mac OS X v10.0 and later.*/
typedef WindowPtr WindowRef;



/*RgnHandle

typedef struct OpaqueRgnHandle * RgnHandle;
Availability
Available in Mac OS X v10.0 and later.*/
typedef struct OpaqueRgnHandle * RgnHandle;


/*Window Class Constants

Indicates the class of a window. 

typedef UInt32 WindowClass;
enum {
   kAlertWindowClass = 1,
   kMovableAlertWindowClass = 2,
   kModalWindowClass = 3,
   kMovableModalWindowClass = 4,
   kFloatingWindowClass = 5,
   kDocumentWindowClass = 6,
   kUtilityWindowClass = 8,
   kHelpWindowClass = 10,
   kSheetWindowClass = 11,
   kToolbarWindowClass = 12,
   kPlainWindowClass = 13,
   kOverlayWindowClass = 14,
   kSheetAlertWindowClass = 15,
   kAltPlainWindowClass = 16,
   kDrawerWindowClass = 20,
   kAllWindowClasses = 0xFFFFFFFF
};
Constants
kAlertWindowClass

Identifies an alert box window. An alert window is used when the application needs the user's attention immediately. On Mac OS 9 and earlier, a visible alert window will prevent the user from switching to any other application. Use kThemeBrushAlertBackgroundActive to draw the background of alert windows. Alert windows are initially placed in the modal window group, given a modality of kWindowModalityAppModal, and given an activation scope of kWindowActivationScopeAll.

Available in Mac OS X v10.0 and later.
kMovableAlertWindowClass

Identifies a movable alert box window. Generally, you should use this window class rather than kAlertWindowClass. Use kThemeBrushAlertBackgroundActive to draw the background of alert windows. Alert windows are initially placed in the modal window group, given a modality of kWindowModalityAppModal, and given an activation scope of kWindowActivationScopeAll.

Available in Mac OS X v10.0 and later.
kModalWindowClass

Identifies a modal dialog box window. Use kThemeBrushDialogBackgroundActive to draw the background of modal dialog windows. Modal dialog windows are initially placed in the modal window group, given a modality of kWindowModalityAppModal, and given an activation scope of kWindowActivationScopeAll.

Available in Mac OS X v10.0 and later.
kMovableModalWindowClass

Identifies a movable modal dialog box window. On Mac OS X and CarbonLib 1.3 and later, use kThemeBrushMovableModalBackground to draw the background of alert windows. Alert windows are initially placed in the modal window group, given a modality of kWindowModalityAppModal, and given an activation scope of kWindowActivationScopeAll.

Available in Mac OS X v10.0 and later.
kFloatingWindowClass

Identifies a window that floats above all document windows. If your application assigns this constant to a window, the Window Manager ensures that the window has the proper floating behavior. Use kThemeBrushUtilityWindowBackgroundActive or kThemeBrushDocumentWindowBackground to draw the background of floating windows. Floating windows are initially placed in the floating window group, given a modality of kWindowModalityNone, and given an activation scope of kWindowActivationScopeIndependent. Supported with Mac OS 8.6 and later.

Available in Mac OS X v10.0 and later.
kDocumentWindowClass

Identifies a document window or modeless dialog box window. Use kThemeBrushDocumentWindowBackground or your own custom drawing to draw the background of a document window. Document windows are initially placed in the document window group, given a modality of kWindowModalityNone, and given an activation scope of kWindowActivationScopeAll.The Window Manager assigns this class to pre?Mac OS 8.5 Window Manager windows.

Available in Mac OS X v10.0 and later.
kUtilityWindowClass

Identifies a utility window. A utility window is similar to a floating window, but it floats above the windows of all applications rather than just above the windows of the application that creates it. Use kThemeBrushUtilityWindowBackgroundActive or kThemeBrushDocumentWindowBackground to draw the background of utility windows. Utility windows are initially placed in the utility window group, given a modality of kWindowModalityNone, and given an activation scope of kWindowActivationScopeIndependent.

Available in CarbonLib 1.1 and later, and in Mac OS X.
kHelpWindowClass

Identifies a window used for help tags. It has no window frame. Typically you should use the Help Manager to display help tags, rather than creating a help tag window yourself. Help windows are initially placed in the help window group, given a modality of kWindowModalityNone, and given an activation scope of kWindowActivationScopeNone.

Available in CarbonLib 1.1 and later, and in Mac OS X.
kSheetWindowClass

Identifies a sheet. (Mac OS X only.) Use kThemeBrushSheetBackgroundOpaque to draw an opaque background for sheet windows, or kThemeBrushSheetBackgroundTransparent to draw a transparent background (the transparent brush is only available in Mac OS X 10.1 and later). Sheet windows are initially placed in the document window group, given a modality of kWindowModalityNone, and given an activation scope of kWindowActivationScopeAll.

Available in Mac OS X v10.0 and later.
kToolbarWindowClass

Identifies a toolbar window, which is used to display a palette of controls. A toolbar window is similar to a floating window, and like a floating window, is layered above all application windows except for alert and modal windows, but is layered beneath floating windows. Toolbar windows are initially placed in the toolbar window group, given a modality of kWindowModalityNone, and given an activation scope of kWindowActivationScopeNone. (Available in CarbonLib 1.1 and later, and Mac OS X.)

Available in Mac OS X v10.0 and later.
kPlainWindowClass

Identifies a plain window, which has a single-pixel window frame. Plain windows are initially placed in the document window group, given a modality of kWindowModalityNone, and given an activation scope of kWindowActivationScopeAll. (Available in CarbonLib 1.2.5 and later, and Mac OS X.)

Available in Mac OS X v10.0 and later.
kOverlayWindowClass

Identifies an overlay window, which is a completely transparent window positioned above all other windows. Overlay windows are intended as a replacement for the pre-Carbon practice of drawing directly into the Window Manager port. By creating a full-screen overlay window and drawing into it, you can draw over any window in any application without disturbing the contents of the windows beneath your drawing. Overlay windows have a default handler for kEventWindowPaint that uses CGContextClearRect to clear the overlay window's alpha channel to zero. This ensures the initial transparency of the window. You can install your own kEventWindowPaint handler to do your own drawing; typically, you would call through to the default handler with CallNextEventHandler first, and then use QDBeginCGContext tocreate your own context for drawing. You can use either QuickDraw or Core Graphics to draw into an overlay window, but you must use Core Graphics to draw if you need any of your drawing to be non-opaque, since QuickDraw always sets the alpha channel of any pixels that it touches to 1.0. (QuickDraw is also deprecated in Mac OS X v10.4 and later.) You can also use the standard window event handler together with regular controls in an overlay window. When using the standard window event handler, you will probably want your kEventWindowPaint handler to return eventNotHandledErr (after calling the default handler with CallNextEventHandler first) so that after the Paint handler returns, the Window Manager will send a kEventWindowDrawContent event which the standard window event handler can respond to by drawing the controls in the window. Overlay windows are initially placed in the overlay window group, given a modality of kWindowModalityNone, and given an activation scope of kWindowActivationScopeNone. (

Available in Mac OS X.)
kSheetAlertWindowClass

Identifies an alert sheet. Use kThemeBrushSheetBackgroundOpaque to draw an opaque background for sheet alert windows, or kThemeBrushSheetBackgroundTransparent to draw a transparent background (the transparent brush is only available in Mac OS X 10.1 and later). Sheet alert windows are initially placed in the document window group, given a modality of kWindowModalityNone, and given an activation scope of kWindowActivationScopeAll. (Mac OS X only.)

Available in Mac OS X v10.1 and later.
kAltPlainWindowClass

Identifies an alternate plain window, which is similar to a plain window but has a solid black shadow on its right and bottom sides. It is rarely used in modern Mac OS applications. Alternate plain windows are initially placed in the document window group, given a modality of kWindowModalityNone, and given an activation scope of kWindowActivationScopeAll. (Available in CarbonLib 1.3 and later and Mac OS X v10.1 and later.)

Available in Mac OS X v10.1 and later.
kDrawerWindowClass

Identifies a drawer. Use kThemeBrushDrawerBackground or kThemeBrushDocumentWindowBackground to draw the background of drawer windows. Drawer windows are initially placed in the document window group, given a modality of kWindowModalityNone, and given an activation scope of kWindowActivationScopeAll. Drawer windows should always be created using the compositing window attribute.(Mac OS X v10.2 and later)

Available in Mac OS X v10.2 and later.
kAllWindowClasses

Specifier used to designate all window classes. Used with GetFrontWindowOfClass, FindWindowOfClass, and GetNextWindowOfClass to indicate that there should be no restriction on the class of the returned window. Also used with GetWindowGroupOfClass to get the root window group.

Available in Mac OS X v10.0 and later.
Discussion

The WindowClass constants categorize windows into groups of like types. The grouping of windows facilitates the appropriate display (that is, both the look and the front-to-back ordering) and tracking of windows.

You can define a windows class using the function CreateNewWindow and obtain a windows class using the function GetWindowClass. You can change the class of certain windows by calling HIWindowChangeClass.*/
typedef UInt32 WindowClass;
enum {
   kAlertWindowClass = 1,
   kMovableAlertWindowClass = 2,
   kModalWindowClass = 3,
   kMovableModalWindowClass = 4,
   kFloatingWindowClass = 5,
   kDocumentWindowClass = 6,
   kUtilityWindowClass = 8,
   kHelpWindowClass = 10,
   kSheetWindowClass = 11,
   kToolbarWindowClass = 12,
   kPlainWindowClass = 13,
   kOverlayWindowClass = 14,
   kSheetAlertWindowClass = 15,
   kAltPlainWindowClass = 16,
   kDrawerWindowClass = 20,
   kAllWindowClasses = 0xFFFFFFFF
};

/*GetFrontWindowOfClass

Obtains the frontmost window of a given class. 

WindowRef GetFrontWindowOfClass (
   WindowClass inWindowClass,
   Boolean mustBeVisible
);
Parameters
inWindowClass

The class of the window you want to obtain. If you pass kAllWindowClasses, the function returns the frontmost window in the window list. 
mustBeVisible

If set to true, the function returns the frontmost visible window. If set to false, the function returns the frontmost window of the specified class, regardless of whether the window is visible.
Return Value

A reference to the frontmost window of the class specified by inWindowClass.
Availability
Available in CarbonLib 1.0 and later.
Available in Mac OS X v10.0 and later.
Carbon Porting Notes
Declared In
MacWindows.h*/
WindowRef GetFrontWindowOfClass (
   WindowClass inWindowClass,
   Boolean mustBeVisible
);

/*SetWindowResizeLimits

Sets the maximum and minimum resize limits for windows. 

OSStatus SetWindowResizeLimits (
   WindowRef inWindow,
   const HISize * inMinLimits,
   const HISize * inMaxLimits
);
Parameters
inWindow

The window whose maximum and minimum resize limits are to be set.
inMinLimits

The minimum limits. Pass NULL if you dont want to set this limit. For information on the HISize data type, see HIGeometry.h.
inMaxLimits

The maximum limits. Pass NULL if you dont want to set this limit. For information on the HISize data type, see HIGeometry.h.
Return Value

A result code. See Window Manager Result Codes.
Availability
Available in Mac OS X v10.2 and later. 
Declared In
MacWindows.h*/
OSStatus SetWindowResizeLimits (
   WindowRef inWindow,
   const HISize * inMinLimits,
   const HISize * inMaxLimits
);

/*ShowWindow

Makes an invisible window visible.

void ShowWindow (
   WindowRef window
);
Parameters
window

The window that is to be made visible.
Discussion

The ShowWindow function makes an invisible window visible. If the specified window is already visible, ShowWindow has no effect. Your application typically creates a new window in an invisible state, performs any necessary setup of the content region, and then calls ShowWindow to make the window visible.

When you call ShowWindow to display a window that is invisible, the Window Manager draws the window frame and sends an event to request the application to draw the content region before the window becomes visible. For compositing windows, the Window Manager sends a kEventControlDraw event to each HIView in the window. For non-compositing windows, the Window Manager sends a kEventWindowDrawContent event. If a non-compositing window does not handle the kEventWindowDrawContent, the Window Manager shows the window and generates an update event to request your application to draw the content region.

If the newly visible window is the frontmost window, ShowWindow highlights it if its not already highlighted and generates an activate event to make it active. The ShowWindow function does not activate a window that is not frontmost on the desktop.

Because ShowWindow does not change the front-to-back ordering of windows, it is not the inverse of HideWindow. If you make the frontmost window invisible with HideWindow, andHideWindow has activated another window, you must call both ShowWindow and SelectWindow to bring the original window back to the front.
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X v10.0 and later.
Declared In
MacWindows.h*/
void ShowWindow (
   WindowRef window
);

/*SetWindowResizeLimits

Sets the maximum and minimum resize limits for windows. 

OSStatus SetWindowResizeLimits (
   WindowRef inWindow,
   const HISize * inMinLimits,
   const HISize * inMaxLimits
);
Parameters
inWindow

The window whose maximum and minimum resize limits are to be set.
inMinLimits

The minimum limits. Pass NULL if you dont want to set this limit. For information on the HISize data type, see HIGeometry.h.
inMaxLimits

The maximum limits. Pass NULL if you dont want to set this limit. For information on the HISize data type, see HIGeometry.h.
Return Value

A result code. See Window Manager Result Codes.
Availability
Available in Mac OS X v10.2 and later. 
Declared In
MacWindows.h*/
OSStatus SetWindowResizeLimits (
   WindowRef inWindow,
   const HISize * inMinLimits,
   const HISize * inMaxLimits
);

/*SetWindowBounds

Sets a windows size and position from the bounding rectangle of the specified window region.

OSStatus SetWindowBounds (
   WindowRef window,
   WindowRegionCode regionCode,
   const Rect * globalBounds
);
Parameters
window

The window whose bounds are to be set.
regionCode

A constant specifying the region to be used in determining the windows size and position. The only region codes allowed for this parameter are kWindowStructureRgn and kWindowContentRgn.
globalBounds

Set the rectangle to specify the dimensions and position, in global coordinates, of the window region specified in the regionCode parameter. 
Return Value

A result code. See Window Manager Result Codes.
Discussion

The SetWindowBounds function sets a windows size and position to that specified by the rectangle that your application passes in the globalBounds parameter. After doing so, SetWindowBounds redraws the window, if the window is visible.

When you call the SetWindowBounds function, your application specifies whether the windows content region or its structure region is more important in determining the windows ultimate size and position. This distinction can be important with versions of the Mac OS running the Appearance Manager, since the total dimensions of a window?and, therefore, its spatial relationship to the rest of the screen?may vary from appearance to appearance. In general, you should specify kWindowStructureRgn for the regionCode parameter if how the window as a whole relates to a given monitor is more important than the exact positioning of its content on the screen. On the other hand, if you specify kWindowContentRgn for the regionCode parameter because the positioning of your applications content is of greatest concern, then it is important to note that with some appearances some part of the windows structure region or frame may extend past the edge of a monitor and not be displayed.

See also the function GetWindowBounds. 
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.5 or later.
Available in Mac OS X v10.0 and later.
Declared In
MacWindows.h*/
OSStatus SetWindowBounds (
   WindowRef window,
   WindowRegionCode regionCode,
   const Rect * globalBounds
);

/*SetWindowBounds

Sets a windows size and position from the bounding rectangle of the specified window region.

OSStatus SetWindowBounds (
   WindowRef window,
   WindowRegionCode regionCode,
   const Rect * globalBounds
);
Parameters
window

The window whose bounds are to be set.
regionCode

A constant specifying the region to be used in determining the windows size and position. The only region codes allowed for this parameter are kWindowStructureRgn and kWindowContentRgn.
globalBounds

Set the rectangle to specify the dimensions and position, in global coordinates, of the window region specified in the regionCode parameter. 
Return Value

A result code. See Window Manager Result Codes.
Discussion

The SetWindowBounds function sets a windows size and position to that specified by the rectangle that your application passes in the globalBounds parameter. After doing so, SetWindowBounds redraws the window, if the window is visible.

When you call the SetWindowBounds function, your application specifies whether the windows content region or its structure region is more important in determining the windows ultimate size and position. This distinction can be important with versions of the Mac OS running the Appearance Manager, since the total dimensions of a window?and, therefore, its spatial relationship to the rest of the screen?may vary from appearance to appearance. In general, you should specify kWindowStructureRgn for the regionCode parameter if how the window as a whole relates to a given monitor is more important than the exact positioning of its content on the screen. On the other hand, if you specify kWindowContentRgn for the regionCode parameter because the positioning of your applications content is of greatest concern, then it is important to note that with some appearances some part of the windows structure region or frame may extend past the edge of a monitor and not be displayed.

See also the function GetWindowBounds. 
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.5 or later.
Available in Mac OS X v10.0 and later.
Declared In
MacWindows.h*/
OSStatus SetWindowBounds (
   WindowRef window,
   WindowRegionCode regionCode,
   const Rect * globalBounds
);

/*HideWindow

Makes a window invisible.

void HideWindow (
   WindowRef window
);
Parameters
window

The window that is to be made invisible.
Discussion

The HideWindow function make a visible window invisible. If you hide the frontmost window, HideWindow removes the highlighting, brings the window behind it to the front, highlights the new frontmost window, and generates the appropriate activate events.

To reverse the actions of HideWindow, you must call both ShowWindow, to make the window visible, and SelectWindow, to select it. 
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X v10.0 and later.
Declared In
MacWindows.h*/
void HideWindow (
   WindowRef window
);

/*GetWindowBounds

Obtains the size and position of the bounding rectangle of the specified window region.

OSStatus GetWindowBounds (
   WindowRef window,
   WindowRegionCode regionCode,
   Rect * globalBounds
);
Parameters
window

The window whose bounds you want to obtain.
regionCode

A constant identifying the window region whose bounds you want to obtain. See Window Region Constants for a list of possible values.
globalBounds

A pointer to a structure of type Rect. On return, the rectangle contains the dimensions and position, in global coordinates, of the window region specified in the regionCode parameter. 
Return Value

A result code. See Window Manager Result Codes.
Discussion

Use the GetWindowBounds function to obtain the bounding rectangle for the specified window region for the specified window.
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.5 or later.
Available in Mac OS X v10.0 and later.
Declared In
MacWindows.h*/
OSStatus GetWindowBounds (
   WindowRef window,
   WindowRegionCode regionCode,
   Rect * globalBounds
);

/*SetWindowBounds

Sets a windows size and position from the bounding rectangle of the specified window region.

OSStatus SetWindowBounds (
   WindowRef window,
   WindowRegionCode regionCode,
   const Rect * globalBounds
);
Parameters
window

The window whose bounds are to be set.
regionCode

A constant specifying the region to be used in determining the windows size and position. The only region codes allowed for this parameter are kWindowStructureRgn and kWindowContentRgn.
globalBounds

Set the rectangle to specify the dimensions and position, in global coordinates, of the window region specified in the regionCode parameter. 
Return Value

A result code. See Window Manager Result Codes.
Discussion

The SetWindowBounds function sets a windows size and position to that specified by the rectangle that your application passes in the globalBounds parameter. After doing so, SetWindowBounds redraws the window, if the window is visible.

When you call the SetWindowBounds function, your application specifies whether the windows content region or its structure region is more important in determining the windows ultimate size and position. This distinction can be important with versions of the Mac OS running the Appearance Manager, since the total dimensions of a window?and, therefore, its spatial relationship to the rest of the screen?may vary from appearance to appearance. In general, you should specify kWindowStructureRgn for the regionCode parameter if how the window as a whole relates to a given monitor is more important than the exact positioning of its content on the screen. On the other hand, if you specify kWindowContentRgn for the regionCode parameter because the positioning of your applications content is of greatest concern, then it is important to note that with some appearances some part of the windows structure region or frame may extend past the edge of a monitor and not be displayed.

See also the function GetWindowBounds. 
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.5 or later.
Available in Mac OS X v10.0 and later.
Declared In
MacWindows.h*/
OSStatus SetWindowBounds (
   WindowRef window,
   WindowRegionCode regionCode,
   const Rect * globalBounds
);

/*SetWindowModified

Sets the modification state of the specified window.

OSStatus SetWindowModified (
   WindowRef window,
   Boolean modified
);
Parameters
window

The window whose modification state is to be set.
modified

Pass true if the content of the window has been modified; otherwise, pass false.
Return Value

A result code. See “Window Manager Result Codes”.
Discussion

Your application can use the functions SetWindowModified and IsWindowModified instead of maintaining its own separate record of the modification state of the content of a window. The modification state of a window is visually represented by a dot in the window’s close box. If the dot is present, the window is modified; if the dot is absent, the window is not modified.

Your application should distinguish between the modification state of the window and the modification state of the window’s contents, typically a document. The modification state of the window contents are what should affect SetWindowModified. For example, in the case of a word processing document, you call SetWindowModified (passing true in the modified parameter) whenever the user types new characters into the document. However, you do not call SetWindowModified when the user moves the window, because that change does not affect the document contents. If you need to track whether the window position has changed, you need to do this with your own flag. 
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.5 or later.
Available in Mac OS X v10.0 and later.
Declared In
MacWindows.h*/
OSStatus SetWindowModified (
   WindowRef window,
   Boolean modified
);

/*DisposeWindow

Removes a window.

void DisposeWindow (
   WindowRef window
);
Parameters
window

On input, the window to be closed.
Discussion

The DisposeWindow function reduces a window’s reference count by one. If the resulting reference count is zero, then DisposeWindow removes the window from the screen and deletes it from the window list, then releases the memory occupied by all structures associated with the window, including the window structure. 

Note that DisposeWindow assumes that any picture pointed to by the window structure field windowPic is data, not a resource, and it calls the QuickDraw function KillPicture to delete it. If your application uses a picture stored as a resource, you must release the resource or release the memory it occupies with the ReleaseResource function and set the windowPic field to NULL before closing the window.

Any pending update events for the window are discarded. If the window being removed is the frontmost window, the window behind it, if any, becomes the active window. 
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X v10.0 and later.
Declared In
MacWindows.h*/
void DisposeWindow (
   WindowRef window
);

/*HIWindowSetProxyFSRef

Sets the proxy icon for a window using an FSRef to a file system object.

OSStatus HIWindowSetProxyFSRef (
   WindowRef inWindow,
   const FSRef * inRef
);
Parameters
inWindow

The window whose proxy icon is to be set.
inRef

The file system object the window represents.
Return Value

A result code. See “Window Manager Result Codes”.
Discussion

This function determines the window’s proxy icon by asking Icon Services for the icon for the object specified by inRef.
Availability
Available in Mac OS X v10.4 and later. 
Declared In
MacWindows.h*/
OSStatus HIWindowSetProxyFSRef (
   WindowRef inWindow,
   const FSRef * inRef
);

/*SetWindowProxyFSSpec	
Use of file specifications is no longer recommended. Instead, use HIWindowSetProxyFSRef.*/
OSStatus SetWindowSetProxyFSSpec(WindowRef inWindow,const FSRef * inRef);

