#include <CoreAudio/CoreAudio.h>
/*
/* AudioDeviceGetProperty


Queries an the AudioDevice object to get the data of the given property and places it in the provided buffer. 
extern OSStatus AudioDeviceGetProperty(
    AudioDeviceID inDevice, 
    UInt32 inChannel, 
    Boolean isInput, 
    AudioDevicePropertyID inPropertyID, 
    UInt32*ioPropertyDataSize, 
    void*outPropertyData);  
Parameters
inDevice
The AudioDevice to query.
inChannel
The channel of the property to query where 0 is the master channel.
isInput
Which section of the AudioDevice to query.
inPropertyID
The AudioDevicePropertyID of the property to query.
ioPropertyDataSize
A UInt32 which on entry indicates the size of the buffer pointed to by outData and on exit indicates how much of the buffer was used.
outPropertyData
The buffer into which the object will put the data for the given property.
Return Value

An OSStatus indicating success or failure. 
Discussion 

Note that the same functionality is provided by the function AudioObjectGetPropertyData(). 
Availability
Introduced in Mac OS X v10.0.*/
OSStatus AudioDeviceGetProperty(
    AudioDeviceID inDevice, 
    UInt32 inChannel, 
    Boolean isInput, 
    AudioDevicePropertyID inPropertyID, 
    UInt32*ioPropertyDataSize, 
    void*outPropertyData){
//TODO
};  


/*AudioHardwareGetProperty


Queries an the AudioSystemObject to get the data of the given property and places it in the provided buffer. 
extern OSStatus AudioHardwareGetProperty(
    AudioHardwarePropertyID inPropertyID, 
    UInt32*ioPropertyDataSize, 
    void*outPropertyData);  
Parameters
inPropertyID
The AudioHardwarePropertyID of the property to query.
ioDataSize
A UInt32 which on entry indicates the size of the buffer pointed to by outData and on exit indicates how much of the buffer was used.
outData
The buffer into which the AudioSystemObject will put the data for the given property.
Return Value

An OSStatus indicating success or failure. 
Discussion 

Note that the same functionality is provided by the function AudioObjectGetPropertyData(). 
Availability
Introduced in Mac OS X v10.0.*/
OSStatus AudioHardwareGetProperty(
    AudioHardwarePropertyID inPropertyID, 
    UInt32*ioPropertyDataSize, 
    void*outPropertyData){
//TODO
};  

/*AudioDeviceSetProperty



Tells the AudioDevice object to change the value of the given property using the provided data. 
extern OSStatus AudioDeviceSetProperty(
    AudioDeviceID inDevice, 
    const AudioTimeStamp*inWhen, 
    UInt32 inChannel, 
    Boolean isInput, 
    AudioDevicePropertyID inPropertyID, 
    UInt32 inPropertyDataSize, 
    const void*inPropertyData);  
Parameters
inDevice
The AudioDevice to change.
inWhen
A pointer to an AudioTimeStamp that says when to change the property's value relative to the device's time base. NULL means execute the change immediately.
inChannel
The channel of the property to change where 0 is the master channel.
isInput
Which section of the AudioDevice to change.
inPropertyID
The AudioDevicePropertyID of the property to change.
inPropertyDataSize
A UInt32 indicating the size of the buffer pointed to by inData.
inPropertyData
The buffer containing the data to be used to change the property's value.
Return Value

An OSStatus indicating success or failure. 
Discussion 

Note that the value of the property should not be considered changed until the HAL has called the listeners as many properties values are changed asynchronously. Also note that the same functionality is provided by the function AudioObjectGetPropertyData(). 
Availability
Introduced in Mac OS X v10.0.*/

OSStatus AudioDeviceSetProperty(
    AudioDeviceID inDevice, 
    const AudioTimeStamp*inWhen, 
    UInt32 inChannel, 
    Boolean isInput, 
    AudioDevicePropertyID inPropertyID, 
    UInt32 inPropertyDataSize, 
    const void*inPropertyData){
//TODO
};  

/* AudioDeviceAddIOProc


Registers the given AudioDeviceIOProc with the AudioDevice. 
extern OSStatus AudioDeviceAddIOProc(
    AudioDeviceID inDevice, 
    AudioDeviceIOProc inProc, 
    void*inClientData);  
Parameters
inDevice
The AudioDevice to register the IOProc with.
inProc
The AudioDeviceIOProc to register.
inClientData
A pointer to client data that is passed back to the IOProc when it is called.
Return Value

An OSStatus indicating success or failure. 
Discussion 

A client may have multiple IOProcs for a given device, but the device is free to only accept as many as it can handle. Note that it is not recommended for clients to have more than a single IOProc registered at a time as this can be wasteful of system resources. Rather, it is recommended that the client do any necessary mixing itself so that only one IOProc is necessary. 
Availability
Introduced in Mac OS X v10.0.*/
OSStatus AudioDeviceAddIOProc(
    AudioDeviceID inDevice, 
    AudioDeviceIOProc inProc, 
    void*inClientData){
//TODO
};  

/* AudioDeviceStart


Starts IO for the given AudioDeviceIOProc. 
extern OSStatus AudioDeviceStart(
    AudioDeviceID inDevice, 
    AudioDeviceIOProc inProc);  
Parameters
inDevice
The AudioDevice to start the IOProc on.
inProc
The AudioDeviceIOProc to start. Note that this can be NULL, which starts the hardware regardless of whether or not there are any IOProcs registered. This is necessary if any of the AudioDevice's timing services are to be used. A balancing call to AudioDeviceStop with a NULL IOProc is required to stop the hardware.
Return Value

An OSStatus indicating success or failure. 
Availability
Introduced in Mac OS X v10.0.*/
OSStatus AudioDeviceStart(
    AudioDeviceID inDevice, 
    AudioDeviceIOProc inProc){
//TODO
};  

/*AudioDeviceRemoveIOProc


Unregisters the given AudioDeviceIOProc from the AudioDevice. 
extern OSStatus AudioDeviceRemoveIOProc(
    AudioDeviceID inDevice, 
    AudioDeviceIOProc inProc);  
Parameters
inDevice
The AudioDevice to unregister the IOProc from.
inProc
The AudioDeviceIOProc to unregister.
Return Value

An OSStatus indicating success or failure. 
Availability
Introduced in Mac OS X v10.0. */
OSStatus AudioDeviceRemoveIOProc(
    AudioDeviceID inDevice, 
    AudioDeviceIOProc inProc){
//TODO
};  

/*AudioDeviceStop


Stops IO for the given AudioDeviceIOProc. 
extern OSStatus AudioDeviceStop(
    AudioDeviceID inDevice, 
    AudioDeviceIOProc inProc);  
Parameters
inDevice
The AudioDevice to stop the IOProc on.
inProc
The AudioDeviceIOProc to stop.
Return Value

An OSStatus indicating success or failure. 
Availability
Introduced in Mac OS X v10.0.*/
OSStatus AudioDeviceStop(
    AudioDeviceID inDevice, 
    AudioDeviceIOProc inProc){
//TODO
};  

/*AudioHardwareGetPropertyInfo


Retrieve information about the given property. 
extern OSStatus AudioHardwareGetPropertyInfo(
    AudioHardwarePropertyID inPropertyID, 
    UInt32*outSize, 
    Boolean*outWritable);  
Parameters
inPropertyID
The AudioHardwarePropertyID of the property to query.
outSize
A pointer to a UInt32 that receives the size of the property data in bytes on exit. This can be NULL if the size information is not being requested.
outWritable
A pointer to a Boolean that receives indication of whether or not the given property can be set. This can be NULL if the writability is not being requested.
Return Value

An OSStatus indicating success or failure. 
Discussion 

Note that the same functionality is provided by the functions AudioObjectHasProperty(), AudioObjectIsPropertySettable(), and AudioObjectGetPropertyDataSize(). 
Availability
Introduced in Mac OS X v10.0.*/
OSStatus AudioHardwareGetPropertyInfo(
    AudioHardwarePropertyID inPropertyID, 
    UInt32*outSize, 
    Boolean*outWritable){
//TODO
}; 