#ifndef MACTYPES_H
#include <CarbonCore/MacTypes.h>
#endif

#ifndef HYS_H
#include <OC_Cocoa/hys.h>
#endif

#ifndef CFBASE_H
#include <CoreFoundation/CFBase.h>
#endif

#ifndef CONTROLS_H
#include <HIToolbox/Controls.h>
#endif

#ifndef CARBONEVENTCORE_H
#include <HIToolbox/CarbonEventsCore.h>
#endif

#ifndef CARBONEVENTS_H
#include <HIToolbox/CarbonEvents.h>
#endif

#ifndef HIVIEW_H
#include <HIToolbox/HIView.h>
#endif

#ifndef MACTEXTEDITOR_H
#include <HIToolbox/MacTextEditor.h>
#endif

#ifndef IBCARBONRUNTIME_H
#include <HIToolbox/IBCarbonRuntime.h>
#endif

#ifndef DIALOGS_H
#include <HIToolbox/Dialogs.h>
#endif

#ifndef HIVIEW_H
#include <HIToolbox/HIView.h>
#endif

/*SetControlData

Sets control-specific data.

OSErr SetControlData (
   ControlRef inControl,
   ControlPartCode inPart,
   ResType inTagName,
   Size inSize,
   const void * inData
);
Parameters
inControl

A handle to the control for which data is to be set. 
inPart

The part code of the control part for which data is to be set; see Control Meta Part Code Constants, Control Part Code Constants, and Control State Part Code Constants. Passing kControlEntireControl indicates that either the control has no parts or the data is not tied to any specific part of the control. 
inTagName

A constant representing the control-specific data you wish to set see the data tag constants in the Control Manager Constants section. 
inSize

The size (in bytes) of the data pointed to by the inData parameter. For variable-length control data, pass the value returned in the outMaxSize parameter of GetControlDataSize in the inSize parameter. The number of bytes must match the actual data size. 
inData

A pointer to a buffer allocated by your application. This buffer contains the data that you are sending to the control. After calling SetControlData, your application is responsible for disposing of this buffer, if necessary, as information is copied by control.
Return Value

A result code. See Control Manager Result Codes. The result code errDataNotSupported indicates that the inTagName parameter is not valid.
Discussion

The SetControlData function sets control-specific data represented by the value in the inTagName parameter to the data pointed to by the inData parameter. SetControlData could be used, for example, to switch a progress indicator from a determinate to indeterminate state. For a list of the control attributes that can be set, see the data tag constants in the Control Manager Constants section. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
Controls.h*/
OSErr SetControlData ( ControlRef inControl,ControlPartCode inPart,ResType inTagName,Size inSize,const void * inData){
//TODO
};


/*GetControlByID

Finds a control in a window by its unique ID.

OSStatus GetControlByID (
   WindowRef inWindow,
   const ControlID * inID,
   ControlRef * outControl
);
Parameters
inWindow

The window to query.
inID

The control ID.
outControl

A pointer to a value of type ControlRef that, on output, is filled in with the control reference for the control specified by inID. For a description of this data type, see ControlRef.
Return Value

A result code. See Control Manager Result Codes.
Discussion

As of Mac OS X v10.3, this function is superseded by the HIViewFindByID function, which is preferred over the GetControlByID function. The first parameter to the HIViewFindByID function is a view and not a window, so you can start the search at any point in the hierarchy.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Controls.h 
GetControlClickActivation*/
OSStatus GetControlByID (WindowRef inWindow,const ControlID * inID,ControlRef * outControl){
//TODO
};
/*GetMainEventLoop

Obtains a reference to the main event loop.

EventLoopRef GetMainEventLoop ();
Return Value

An event loop reference. 
Discussion

The main loop is the event loop for the main application thread. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
CarbonEventsCore.h*/
EventLoopRef GetMainEventLoop (){
//TODO
};

/*InstallEventLoopIdleTimer

Installs a timer that fires only when there is no user activity.

OSStatus InstallEventLoopIdleTimer (
   EventLoopRef inEventLoop,
   EventTimerInterval inFireDelay,
   EventTimerInterval inInterval,
   EventLoopIdleTimerUPP inTimerProc,
   void * inTimerData,
   EventLoopTimerRef * outTimer
);
Parameters
inEventLoop

The event loop to add the timer. 
inFireDelay

The delay before first firing this timer, in seconds. In Mac OS X v10.3 and earlier, this delay must be greater than zero. In Mac OS X v10.4 and later, the delay must be greater than or equal to zero. You cannot pass kEventDurationForever.
inInterval

The timer interval, in seconds. Pass 0 or kEventDurationForever for a one-shot timer. 
inTimerProc

The function to call when the timer fires. 
inTimerData

Data to pass to the timer function when called.
outTimer

A reference to the newly installed timer. 
Return Value

A result code. See Carbon Event Manager Result Codes.
Discussion

An idle timer is the same as a standard event timer except that it fires only when no user events are being received. That is, if the system receives no user events for the inFireDelay delay time, the idle timer fires, and will continue to fire at the rate specified by inInterval. If the user begins activity again, the timer stops and resets. For example, you could use an idle timer in a search engine to begin a search 2 seconds after the user stops typing in the search text field. 

The callback function for idle timers takes an additional parameter that tells the callback the user status. See EventLoopIdleTimerProcPtr and Idle Timer Event Constants for more information. 

Be sure to dispose of the timer when you no longer need it by calling RemoveEventLoopTimer. Doing so is especially important if your timer calls code that may no longer exist. For example, if a plugin creates a timer that calls back to it, the timer will attempt to call it even after the plugin is removed. 
Availability
Available in Mac OS X v10.2 and later.
Declared In
CarbonEventsCore.h*/
OSStatus InstallEventLoopIdleTimer (EventLoopRef inEventLoop,EventTimerInterval inFireDelay,EventTimerInterval inInterval,EventLoopIdleTimerUPP inTimerProc,void * inTimerData,EventLoopTimerRef * outTimer){
//TODO
};

/*InstallEventLoopTimer

Installs a timer.

OSStatus InstallEventLoopTimer (
   EventLoopRef inEventLoop,
   EventTimerInterval inFireDelay,
   EventTimerInterval inInterval,
   EventLoopTimerUPP inTimerProc,
   void * inTimerData,
   EventLoopTimerRef * outTimer
);
Parameters
inEventLoop

The event loop to add the timer. 
inFireDelay

The delay before first firing this timer, in seconds. In Mac OS X v10.3 and earlier, the delay must be greater than zero. In Mac OS X v10.4, the delay can be greater than or equal to zero. 

In Mac OS X and CarbonLib 1.5 and later, you may pass kEventDurationForever to stop the timer from firing at all until SetEventLoopTimerNextFireTime is used to start it; in earlier versions of CarbonLib, to achieve the same effect, just pass zero and then immediately call SetEventLoopTimerNextFireTime( timer, (kEventDurationForever ) before returning control to your event loop.
inInterval

The timer interval, in seconds. Pass 0 or (in Mac OS X and CarbonLib 1.5 and later) kEventDurationForever for a one-shot timer. 
inTimerProc

The function to call when the timer fires. 
inTimerData

Data to pass to the timer function when called.
outTimer

A reference to the newly installed timer. 
Return Value

A result code. See Carbon Event Manager Result Codes.
Discussion

Installs a timer onto the event loop specified. The timer can either fire once or repeatedly at a specified interval depending on the parameters passed to this function. It executes at task level and should not be confused with Time Manager tasks or any other interrupt-level callback. This means you can call toolbox functions, allocate memory, and draw without worrying about consequences. When a timer fires, it calls the callback you specified when the timer was installed.

Timers in general have two uses: as a timeout mechanism and as a periodic task. An everyday example of using a timer for a timeout might be a light that goes out if no motion is detected in a room for 5 minutes. For this, you might install a timer which will fire in 5 minutes. If motion is detected, you would reset the timer fire time and let the clock start over. If no motion is detected for the full 5 minutes, the timer will fire and you could power off the light. A periodic timer is one that fires at regular intervals (say every second or so). You might use such a timer to blink the insertion point in your editor, and so on.

One advantage of timers is that you can install the timer right from the code that wants the time. For example, the standard editable text control can install a timer to blink the cursor when its active, meaning that the Control Manager function IdleControls is a no-op for that control and doesnt need to be called. When the control is inactive, it removes its timer and doesnt waste CPU time in that state.

Currently, if you do decide to draw when your timer is called, be sure to save and restore the current port so that calling your timer doesnt inadvertently change the port out from under someone. 

Be sure to dispose of the timer when you no longer need it by calling RemoveEventLoopTimer. Doing so is especially important if your timer calls code that may no longer exist. For example, if a plugin creates a timer that calls back to it, the timer will attempt to call it even after the plugin is removed. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
CarbonEventsCore.h*/

OSStatus InstallEventLoopTimer (
   EventLoopRef inEventLoop,
   EventTimerInterval inFireDelay,
   EventTimerInterval inInterval,
   EventLoopTimerUPP inTimerProc,
   void * inTimerData,
   EventLoopTimerRef * outTimer){
//TODO
};





/*NewEventHandlerUPP

Creates an event handler UPP.

EventHandlerUPP NewEventHandlerUPP (
   EventHandlerProcPtr userRoutine
);
Parameters
userRoutine

A pointer to your event handler. 
Return Value

The UPP for your event handler.
Discussion

When registering your event handler with InstallEventHandler, you must pass a universal procedure pointer (UPP) to your event handler instead of a standard procedure pointer. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
CarbonEventsCore.h*/
EventHandlerUPP NewEventHandlerUPP (EventHandlerProcPtr userRoutine){
//TODO
};

/*RunApplicationEventLoop

Runs the application event loop.

void RunApplicationEventLoop ();
Discussion

This function is used as the main event loop for a Carbon Event-based application. Once entered, this function waits for events to arrive and dispatches them to your event handlers automatically. 

Note that calling RunApplicationEventLoop also installs the standard application handler, which provides standard handler responses for menu and application events. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
CarbonEvents.h*/
void RunApplicationEventLoop (){
//TODO
};

/*similar macro, InstallApplicationEventHandler, needs no parameter to identify the application itself as the target; the call
InstallApplicationEventHandler (handlerUPP,
                                numTypes, typeList,
                                userData, &handlerRef);*/
/*The function for installing an event handler is called InstallEventHandler:
OSStatus InstallEventHandler (EventTargetRef        target,
                              EventHandlerUPP       handlerProc,
                              UInt32                numTypes,
                              const EventTypeSpec*  typeList,
                              void*                 userData,
                              EventHandlerRef*      handlerRef);*/
OSStatus InstallApplicationEventHandler (EventHandlerUPP       handlerUPP,
                              UInt32                numTypes,
                              const EventTypeSpec*  typeList,
                              void*                 userData,
                              EventHandlerRef*      handlerRef){
//TODO
};//hys

/*For convenience, The Carbon Event Manager also defines a set of specialized macros, InstallWindowEventHandler, InstallMenuEventHandler, and InstallControlEventHandler, which accept the targeted object as a parameter, obtain the corresponding target reference for you, and pass it to InstallEventHandler. The remaining parameters to these macros are the same as for the InstallEventHandler routine itself. For example, the macro callWindowRef theWindow;
 
InstallWindowEventHandler (theWindow, handlerUPP,
                           numTypes, typeList,
                           userData, &handlerRef);*/
OSStatus InstallWindowEventHandler (void* theWindow,
                              EventHandlerUPP       handlerUPP,
                              UInt32                numTypes,
                              const EventTypeSpec*  typeList,
                              void*                 userData,
                              EventHandlerRef*      handlerRef){
//TODO
};//hys

/*Custom Drawing in User Panes

If you have only simple drawing needs, you can attach a kEventControlDraw handler to a user pane control. Conveniently, Interface Builder converts dialog user items to user panes when importing from resources. 

Listing 2-9 shows how you would install a simple, one-event drawing handler onto a user pane.

Listing 2-9  Installing a draw ing handler onto a user paneWindowRef window;
 
HIViewRef       userPane;
// 1
static const HIViewID userPaneID = { 'Moof', 127 };// 1
 
// 2
static const EventTypeSpec myEventTypes =// 2
                        { kEventClassControl, kEventControlDraw };
 
// 3
HIViewFindByID (HIViewGetRoot(window), userPaneID, &userPane);// 3
// 4
InstallControlEventHandler (userPane, myUserDraw, 1, &myEventTypes,// 4
                            userPane, NULL);*/
OSStatus InstallControlEventHandler (void* userPane,
                              EventHandlerUPP       handlerUPP,
                              UInt32                numTypes,
                              const EventTypeSpec*  typeList,
                              void*                 userData,
                              EventHandlerRef*      handlerRef){
//TODO
}; //hys

/*GetEventClass

Returns the class of an event (for example, window, mouse, or keyboard).

UInt32 GetEventClass (
   EventRef inEvent
);
Parameters
inEvent

The event in question. 
Return Value

The class ID of the event. See Event Class Constants for more details. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
CarbonEventsCore.h*/
UInt32 GetEventClass (EventRef inEvent){
//TODO
};

/* GetEventKind

Returns the event kind for the specified event.

UInt32 GetEventKind (
   EventRef inEvent
);
Parameters
inEvent

The event in question. 
Return Value

The kind of the event. 
Discussion

Event kind values overlap in different event classes. For example, kEventMouseDown and kEventAppActivated both have the same value (1). The combination of class and kind determines a unique event signature.
Availability
Available in Mac OS X v10.0 and later.
Declared In
CarbonEventsCore.h*/
UInt32 GetEventKind (EventRef inEvent){
//TODO
};

/*GetEventParameter

Obtains a parameter from the specified event. 

OSStatus GetEventParameter (
   EventRef inEvent,
   EventParamName inName,
   EventParamType inDesiredType,
   EventParamType * outActualType,
   UInt32 inBufferSize,
   UInt32 * outActualSize,
   void * outData
);
Parameters
inEvent

The event to get the parameter from. 
inName

The symbolic name of the parameter (for example, kEventParamDirectObject). The Carbon Event Manager defines a number of constants defining possible parameters. 
inDesiredType

The desired type of the parameter (for example, typeWindowRef). The Carbon Event Manager automatically uses AppleEvent coercion handlers to convert the data in the event into the desired type, if possible. The Carbon Event Manager defines a number of constants to indicate possible parameter types. Pass typeWildCard to request that the data be returned in its original format. 
outActualType

The actual type of the parameter (can be NULL if you are not interested in receiving this information).
inBufferSize

The size of the output buffer. 
outActualSize

The actual size of the data, or NULL if you dont want this information.
outData

The pointer to the buffer receiving the parameter data.
Return Value

A result code. See Carbon Event Manager Result Codes. 
Discussion

Events often contain additional useful pieces of data, such as the location of a mouse-down event or the window in which an event occurred. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
CarbonEventsCore.h*/
OSStatus GetEventParameter (
   EventRef inEvent,
   EventParamName inName,
   EventParamType inDesiredType,
   EventParamType * outActualType,
   UInt32 inBufferSize,
   UInt32 * outActualSize,
   void * outData){
//TODO
};

/*HIViewGetBounds

Obtains the local bounds of a view. 

OSStatus HIViewGetBounds (
   HIViewRef inView,
   HIRect* outRect
);
Parameters
inView

The view whose local bounds are to be obtained.
outRect

The local bounds of the view.
Return Value

An operating system result code.
Discussion

The local bounds are the coordinate system that is completely view-relative. A views top left coordinate starts out at 0, 0. Most operations use local coordinates. Note, however, that the frame is used to move a view, not local coordinates.
Availability
Available in Mac OS X v10.2 and later.*/
OSStatus HIViewGetBounds (
   HIViewRef inView,
   HIRect* outRect){
//TODO
};

/*HIViewSetNeedsDisplay

Marks a view as needing or not needing to be redrawn.

OSStatus HIViewSetNeedsDisplay (
   HIViewRef inView,
   Boolean inNeedsDisplay
);
Parameters
inView

The view to mark as dirty (needing to be redrawn) or clean (not needing to be redrawn).
inNeedsDisplay

A Boolean whose value is true to mark the view as dirty or false to mark it as clean.
Return Value

An operating system result code.
Discussion

If the view is not visible or is obscured completely by other views, no action is taken.
Availability
Available in Mac OS X v10.2 and later.*/

OSStatus HIViewSetNeedsDisplay (
   HIViewRef inView,
   Boolean inNeedsDisplay){
//TODO
};

/*RegisterEventHotKey

Registers a global hot key.

OSStatus RegisterEventHotKey (
   UInt32 inHotKeyCode,
   UInt32 inHotKeyModifiers,
   EventHotKeyID inHotKeyID,
   EventTargetRef inTarget,
   OptionBits inOptions,
   EventHotKeyRef * outRef
);
Parameters
inHotKeyCode

The virtual key code of the hot key you want to register. 
inHotKeyModifiers

The keyboard modifiers to look for. In Mac OS X v10.2 and earlier, if you do not specify a modifier key, this function returns paramErr. In Mac OS X v10.3 and later, passing 0 does not cause an error.
inHotKeyID

The application-specified hot key ID. You will receive this ID in the kEventHotKeyPressed event as the direct object parameter. 
inTarget

The target to notify when the hot key is pressed. 
inOptions

Currently unused. You must pass 0.
outRef

On return, a reference to the new hot key. You need this reference if you later wish to unregister it. 
Return Value

A result code. See Carbon Event Manager Result Codes.
Discussion

This function registers a global hot key based on the virtual key code and modifiers you pass in. When the user enters the hot-key combination, a kEventHotKeyPressed event is sent to the target you specified. Only one such combination can exist for the current application (that is, multiple entities in the same application cannot register for the same hot key combination). The same hot key can, however, be registered by multiple applications. This means that multiple applications can potentially be notified when a particular hot key is requested. This might not necessarily be desirable, but it is how it works at present. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
CarbonEvents.h*/
OSStatus RegisterEventHotKey (UInt32 inHotKeyCode,UInt32 inHotKeyModifiers,EventHotKeyID inHotKeyID,EventTargetRef inTarget,OptionBits inOptions,EventHotKeyRef * outRef){
//TODO
};

/*GetApplicationEventTarget

Obtains the event target reference for the application.

EventTargetRef GetApplicationEventTarget ();
Return Value

An event target reference. 
Discussion

Once you obtain this reference, you can send events to the target and install event handlers on it. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
CarbonEvents.h*/
EventTargetRef GetApplicationEventTarget (){
//TODO
};

/*UnregisterEventHotKey

Unregisters a global hot key. 

OSStatus UnregisterEventHotKey (
   EventHotKeyRef inHotKey
);
Parameters
inHotKey

The event hot key reference of the hot key you want to unregister. 
Return Value

A result code. See Carbon Event Manager Result Codes.
Discussion

Unregisters a global hot key that was previously registered with the function RegisterEventHotKey. You do not need to unregister a hot key when your application terminates; the system takes care of that for you. You can use this function if the user changes a hot key for something in your application?you would unregister the previous key and register your new key. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
CarbonEvents.h*/
OSStatus UnregisterEventHotKey (EventHotKeyRef inHotKey){
//TODO
};

/*CreateNibReference

Creates a reference to a nib file in the current bundle.

OSStatus CreateNibReference (
   CFStringRef inNibName,
   IBNibRef * outNibRef
);
Parameters
inNibName

A CFStringRef that represents the name of a nib file you created for your application, but without the nib extension. See the Base Services documentation for a description of the CFStringRef data type. You can use the Core Foundation function CFSTR to convert a string to a CFString. 
outNibRef

On output, points to a nib reference. You pass the nib reference to Interface Builder Services functions that unarchive objects from a nib file.
Return Value

A result code. See Runtime Errors.
Discussion

Use this function if the nib file is located in the current bundle. Use the function CreateNibReferenceWithCFBundle if the nib file is located in a framework or other bundle that is not the current bundle. 
Availability
Available in CarbonLib 1.1 and later.
Available in Mac OS X 10.0 and later.
Declared In
IBCarbonRuntime.h*/

OSStatus CreateNibReference ( CFStringRef inNibName, IBNibRef * outNibRef){
//TODO
};

/*SetMenuBarFromNib

Unarchives a menu bar from a nib file, then makes the menu bar available in your application.

OSStatus SetMenuBarFromNib (
   IBNibRef inNibRef,
   CFStringRef inName
);
Parameters
inNibRef

A reference to the nib file that contains the menu bar you want to unarchive. You obtain this reference by calling the function CreateNibReference or CreateNibReferenceWithCFBundle.
inName

A CFStringRef that denotes the menu bar you want to unarchive. This is the name you supplied to the menu bar in the Instances pane of Interface Builder. (The default name is MainMenu.) See the Base Services documentation for a description of the CFStringRef data type. You can use the Core Foundation function CFSTR to convert a string to a CFString.
Return Value

A result code. See Runtime Errors.
Discussion

The function SetMenuBarFromNib makes the menu bar visible and selectable by the user when your application opens. If you dont want the menu bar to be visible and selectable when it is unarchived, use the function CreateMenuBarFromNib. 
Availability
Available in CarbonLib 1.1 and later.
Available in Mac OS X 10.0 and later.
Declared In
IBCarbonRuntime.h*/
OSStatus SetMenuBarFromNib (IBNibRef inNibRef,CFStringRef inName){

};

/*CreateWindowFromNib

Unarchives a window from a nib file.

OSStatus CreateWindowFromNib (
   IBNibRef inNibRef,
   CFStringRef inName,
   WindowRef *outWindow
);
Parameters
inNibRef

A reference to the nib file that contains the window you want to unarchive. You obtain this reference by calling the function CreateNibReference or CreateNibReferenceWithCFBundle.
inName

A CFStringRef that denotes the window you want to unarchive. This is the name you supplied to the window in the Instances pane of Interface Builder. See the Base Services documentation for a description of the CFStringRef data type. You can use the Core Foundation function CFSTR to convert a string to a CFString. 
outWindow

On output, points to the window unarchived from the nib file.
Return Value

A result code. See Runtime Errors.
Discussion

You need to call the Window Manager function ShowWindow to make the unarchived window visible. 
Availability
Available in CarbonLib 1.1 and later.
Available in Mac OS X 10.0 and later.
Declared In
IBCarbonRuntime.h*/

OSStatus CreateWindowFromNib (IBNibRef inNibRef,CFStringRef inName,WindowRef *outWindow){
//TODO
};

/*DisposeNibReference

Disposes of a nib reference.

void DisposeNibReference (
   IBNibRef inNibRef
);
Parameters
inNibRef

A nib reference you created by calling the function CreateNibReference or CreateNibReferenceWithCFBundle.
Return Value
Discussion

You should call the function DisposeNibReference immediately after you have finished unarchiving objects (windows, menus, menu bar, and so forth) from the nib file associated with the nib reference. 
Availability
Available in CarbonLib 1.1 and later.
Available in Mac OS X 10.0 and later.
Declared In
IBCarbonRuntime.h*/
void DisposeNibReference (IBNibRef inNibRef){
//TODO
};



/*NewEventLoopTimerUPP

Creates an event loop timer UPP. 

EventLoopTimerUPP NewEventLoopTimerUPP (
   EventLoopTimerProcPtr userRoutine
);
Parameters
userRoutine

A pointer to your event timer callback function. 
Return Value

The UPP for your event timer callback function. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
CarbonEventsCore.h*/
EventLoopTimerUPP NewEventLoopTimerUPP (EventLoopTimerProcPtr userRoutine){
//TODO
};


/*CreateStandardAlert

Creates an alert containing standard elements and using standard formatting rules.

OSStatus CreateStandardAlert (
   AlertType alertType,
   CFStringRef error,
   CFStringRef explanation,
   const AlertStdCFStringAlertParamRec * param,
   DialogRef * outAlert
);
Parameters
alertType

The type of alert to create. 
error

The error string to display. 
explanation

The explanation string to display. May be NULL or empty to display no explanation.
param

The parameter block describing how to create the alert. May be NULL. 
outAlert

On exit, contains the new alert. 
Return Value

A result code. See Dialog Manager Result Codes.
Discussion

CreateStandardAlert should be used in conjunction with RunStandardAlert. After CreateStandardAlert returns, the alert is still invisible. RunStandardAlert will show the alert and run a modal dialog loop to process events in the alert.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Dialogs.h*/
OSStatus CreateStandardAlert (
   AlertType alertType,
   CFStringRef error,
   CFStringRef explanation,
   const AlertStdCFStringAlertParamRec * param,
   DialogRef * outAlert){
//TODO
};

/*EnableMenuCommand

Enables the menu item with a specified command ID.

void EnableMenuCommand (
   MenuRef inMenu,
   MenuCommand inCommandID
);
Parameters
inMenu

The menu in which to begin searching for the item. Pass NULL to begin searching with the root menu. The search will descend into all submenus of this menu. 
inCommandID

The command ID of the menu item to be enabled. If more than one item has this command ID, only the first will be enabled. 
Discussion

If you have access to the menu item index, in most cases you should use EnableMenuItem instead, as that function is faster and requires no searching. For example, when receiving a kEventCommandUpdateStatus event, the HICommand structure contains both the menu items command ID and index. If you wanted to enable the menu item, you should call EnableMenuItem.
Availability
Available in CarbonLib 1.0 and later.
Available in Mac OS X v10.0 and later.
Declared In
Menus.h*/
void EnableMenuCommand (
   MenuRef inMenu,
   MenuCommand inCommandID){
//TODO
};

/*DisposeHandle

Releases memory occupied by a relocatable block.

void DisposeHandle (
   Handle h
);
Parameters
h

A handle to a relocatable block. 
Discussion

The DisposeHandle function releases the memory occupied by the relocatable block whose handle is h. It also frees the handles master pointer for other uses.

Do not use DisposeHandle to dispose of a handle obtained from the Resource Manager (for example, by a previous call to GetResource), use ReleaseResource instead. If, however, you have called DetachResource on a resource handle, you should dispose of the storage by calling DisposeHandle.

Call the function MemError to get the result code. See Memory Manager Result Codes.
Special Considerations

After a call to DisposeHandle, all handles to the released block become invalid and should not be used again. Any subsequent calls to DisposeHandle using an invalid handle might crash your application.
Availability
Available in Mac OS X v10.0 and later.
Declared In
MacMemory.h*/
void DisposeHandle (
   Handle h){
//TODO
};


/*RunStandardAlert

Shows and runs a standard alert using a modal dialog loop.

OSStatus RunStandardAlert (
   DialogRef inAlert,
   ModalFilterUPP filterProc,
   DialogItemIndex * outItemHit
);
Parameters
inAlert

The alert to display. Note that this function automatically disposes of the dialog you pass in this parameter before returning. 
filterProc

An event filter function for handling events that do not apply to the alert. May be NULL. 
outItemHit

On exit, contains the item index of the button that was pressed to close the alert. 
Return Value

A result code. See Dialog Manager Result Codes.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Dialogs.h*/
OSStatus RunStandardAlert (
   DialogRef inAlert,
   ModalFilterUPP filterProc,
   DialogItemIndex * outItemHit){
//TODO
};


/*TXNRevert

Reverts to the last saved version of a document. 

OSStatus TXNRevert (
   TXNObject iTXNObject
);
Parameters
iTXNObject

The text object for the active document. 
Return Value

A result code. See “MLTE Result Codes”.
Discussion

You can use the TXNRevert function with files that contain only text as well as files that were created using MLTE. If the file was not previously saved, the document reverts to an empty document. To revert to data that is embedded in a private file type, use the TXNSetSelection function to select all of the current data and then use the TXNSetDataFromFile function to read in the old data. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
MacTextEditor.h*/
OSStatus TXNRevert (TXNObject iTXNObject){
//TODO
};

/*TXNNewObject

Creates a new MLTE text object which is an opaque structure that handles text formatting at the document level. (Deprecated in Mac OS X v10.3. Use TXNCreateObject instead.)

Not recommended.

OSStatus TXNNewObject (
   const FSSpec *iFileSpec,
   WindowRef iWindow,
   const Rect *iFrame,
   TXNFrameOptions iFrameOptions,
   TXNFrameType iFrameType,
   TXNFileType iFileType,
   TXNPermanentTextEncodingType iPermanentEncoding,
   TXNObject *oTXNObject,
   TXNFrameID *oTXNFrameID,
   TXNObjectRefcon iRefCon
);
Parameters
iFileSpec

A pointer to a variable of type FSSpec. If you pass NULL you start with an empty document. Otherwise, the contents of the file to which iFileSpec points are read into the object. The referenced file must consist entirely of data that MLTE can read ('TEXT', 'RTF ', 'utxt', or 'txtn'). If the referenced file contains your application’s private data and data that MLTE can read, you should call the TXNNewObject function with the iFileSpec parameter set to NULL. Once TXNNewObject creates the text object, your application can read the private data into the text object by calling the TXNSetDataFromFile function. 
iWindow

A reference to the window in which the document will be displayed. This parameter can be NULL. If it is NULL, you must attach a window or graphics port to the text object by using the TXNAttachObjectToWindow function. 
iFrame

A pointer to a variable of type Rect. If you pass NULL, the window’s portRect rectangle is used as the frame. If you do not want to fill the entire window, you use the iFrame parameter to specify the area to fill. 
iFrameOptions

A value that specifies the options you want the frame to support. See Frame Option Masks for a description of possible values. 

If you want to create a read-only document, you need to pass the option kTXNReadOnlyMask. Note that this option puts the text object into a state that does not allow user input. However, your application can put data into the text object by calling the function TXNSetData. If you want the text object set into a more restrictive read-only state that does not allow user input or your application to put data into the text object programmatically, you need to call the function TXNSetTXNObjectControls, passing the tag kTXNIOPrivilegesTag. If you choose to set the text object into this restrictive state, you will get an error if you try to call the function TXNSetData on the text object. (In this case, you can change the text object to a less restrictive state by calling TXNSetTXNObjectControls, passing the tag kTXNNoUserIOTag.)
iFrameType

A value that specifies the frame type of the text object. See Supported Frame Types for a description of possible values. 
iFileType

A value that specifies the file type of the text object. See Supported File Types for a description of possible values. You should specify the primary file type. If you use the kTXNTextensionFile constant, files are saved in a custom format. If you want saved files to be plain text files, you should specify the kTXNTextFile constant, then use the iframeOptions parameter to specify whether the plain text files should be saved with kTXNSingleStylePerTextDocumentResType or kTXNMultipleStylesPerTextDocumentResType resources. 
iPermanentEncoding

A value that specifies the encoding in which the document is saved. See Text Encoding Preferences for a description of possible values. 
oTXNObject

A pointer to a structure of type TXNObject. On return, this points to the opaque text object data structure allocated by the function. You need to pass this object to most MLTE functions. 
oTXNFrameID

On return, a pointer to the unique ID for the text object’s frame. However, in MLTE version 1.1 and earlier, the frame ID is always set to 0. 
iRefCon

A value of type TXNObjectRefcon. You can define how to use this for your application. You can set this to any value and retrieve it later. 
Return Value

A result code. See “MLTE Result Codes”.
Discussion

For each document, a new text object is allocated by the TXNNewObject function and returned in the oTXNObject parameter. The object is allocated only if no errors occur, including errors that may occur when reading a file. If there is an error during the allocation process, MLTE frees the text object. 

If you are writing a text editing application, you may want to call the TXNNewObject function when the application launches (a new document will be displayed) and whenever the user selects New from the File menu. 

Many MLTE functions require you to pass a text object; some functions also require the frame ID supplied back to your application in the oTXNFrameID parameter of TXNNewObject.

Because of how MLTE uses Carbon events internally, the window in which the document is displayed must have the standard event handlers installed. You can do this in one of the following ways:
When you create the window, add the attribute kWindowStandardHandlerAttribute to the window. See Inside Mac OS X: Window Manager Reference for more information.
Call the Carbon Event Manager function InstallStandardEventHandler on the window's event target. See Inside Mac OS X: Handling Carbon Events for more information.
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.3.
Declared In
MacTextEditor.h*/
OSStatus TXNNewObject (
   const FSSpec *iFileSpec,
   WindowRef iWindow,
   const Rect *iFrame,
   TXNFrameOptions iFrameOptions,
   TXNFrameType iFrameType,
   TXNFileType iFileType,
   TXNPermanentTextEncodingType iPermanentEncoding,
   TXNObject *oTXNObject,
   TXNFrameID *oTXNFrameID,
   TXNObjectRefcon iRefCon){
//TODO
};


/*TXNPageSetup

Displays the Page Setup dialog for the current default printer and manages changes, such as reformatting the text, in response to page layout changes.

OSStatus TXNPageSetup (
   TXNObject iTXNObject
);
Parameters
iTXNObject

The text object for the active document. 
Return Value

A result code. See “MLTE Result Codes”.
Availability
Available in Mac OS X v10.0 and later.
Declared In
MacTextEditor.h*/
OSStatus TXNPageSetup (TXNObject iTXNObject){
//TODO
};


/*TXNPrint

Prints the document so it is formatted to fit the page size selected for the printer. 

OSStatus TXNPrint (
   TXNObject iTXNObject
);
Parameters
iTXNObject

The text object that identifies the document you want to print. 
Return Value

A result code. See “MLTE Result Codes”.
Availability
Available in Mac OS X v10.0 and later.
Declared In
MacTextEditor.h*/
OSStatus TXNPrint (TXNObject iTXNObject){
//'TODO
};


/*TXNGetDataEncoded

Copies the text in a specified range, and if necessary, translates the text to match your application’s preferred encoding. 

OSStatus TXNGetDataEncoded (
   TXNObject iTXNObject,
   TXNOffset iStartOffset,
   TXNOffset iEndOffset,
   Handle * oDataHandle,
   TXNDataType iEncoding
);
Parameters
iTXNObject

The text object that contains the data you want to copy.
iStartOffset

The absolute offset from which data copying should begin. You can use the TXNGetSelection function to get the absolute offsets of the current selection. 
iEndOffset

The absolute offset at which data copying should end. You can use the TXNGetSelection function to get the absolute offsets of the current selection.
oDataHandle

A pointer to a handle. On return, a handle to the requested data. TXNGetDataEncoded allocates the handle as necessary. Your application must dispose of the handle. If there is no text in the range specified, the returned handle is NULL, and the function returns noErr.
encoding

The type of data to be encoded. See Supported Data Types for a full description of possible values. You should specify either the kTXNTextData or kTXNUnicodeTextData constant. If the iEncoding parameter specifies an encoding different from that used to store the text data internally, the Conversion Manager translates the data to the specified type (text or Unicode). If the iEncoding parameter is not recognized, the data is returned in the current encoding. On systems that do not use ATSUI version 1.1 or later, the current encoding is the Mac OS encoding. Otherwise, the current encoding is Unicode. 
Return Value

A result code. See “MLTE Result Codes”.
Discussion

Offsets in MLTE are always character offsets. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
MacTextEditor.h*/
OSStatus TXNGetDataEncoded (
   TXNObject iTXNObject,
   TXNOffset iStartOffset,
   TXNOffset iEndOffset,
   Handle * oDataHandle,
   TXNDataType iEncoding){
//TODO
};


/*GetControl32BitValue

Obtains the current setting of a control.

SInt32 GetControl32BitValue (
   ControlRef theControl
);
Parameters
theControl

A handle to the control whose current setting you wish to obtain. 
Return Value

The current setting of the control. 
Discussion

Your application may use the GetControl32BitValue function to obtain a 32-bit value previously set with the function SetControl32BitValue.

If your application uses a 32-bit control value, it should not attempt to obtain this value by calling the pre–Mac OS 8.5 function GetControlValue because the 16-bit value that is returned does not accurately reflect the current 32-bit control value.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Controls.h*/
SInt32 GetControl32BitValue (ControlRef theControl){
//TODO
};


/*SetControl32BitMaximum

Changes the maximum setting of a control and, if appropriate, redraws it accordingly.

void SetControl32BitMaximum (
   ControlRef theControl,
   SInt32 newMaximum
);
Parameters
theControl

A handle to the control whose maximum setting you wish to change. For a description of this data type, see “ControlRef”.
newMaximum

The new maximum setting of the control. In general, to avoid unpredictable behavior, do not set the maximum control value lower than the current minimum value. 
Discussion

Your application may use the SetControl32BitMaximum function to set a 32-bit value as the maximum setting for a control.

If your application uses a 32-bit control maximum value, it should not attempt to obtain this value by calling the pre–Mac OS 8.5 function GetControlMaximum because the 16-bit value that is returned does not accurately reflect the current 32-bit control value. Instead, use the function GetControl32BitMaximum.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Controls.h*/
void SetControl32BitMaximum (ControlRef theControl,SInt32 newMaximum){
//TODO
};


/*GetControlPopupMenuHandle

Gets the menu handle for a pop-up control.

MenuRef GetControlPopupMenuHandle (
   ControlRef control
);
Parameters
control

The pop-up control to query.
Return Value

See the Menu Manager documentation for a description of the MenuRef data type.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Controls.h*/
MenuRef GetControlPopupMenuHandle (ControlRef control){
//TODO
};


/*CopyMenuItemTextAsCFString

Returns a CFString containing the text of a menu item.

OSStatus CopyMenuItemTextAsCFString (
   MenuRef inMenu,
   MenuItemIndex inItem,
   CFStringRef * outString
);
Parameters
menu

The menu containing the item. 
item

The item whose text you want to copy. 
outString

On exit, a CFString containing the item's text. The caller must release this string when it is no longer needed. 
Return Value

A result code. See “Menu Manager Result Codes”.
Availability
Available in CarbonLib 1.1 and later.
Available in Mac OS X v10.0 and later.
Declared In
Menus.h*/
OSStatus CopyMenuItemTextAsCFString (
   MenuRef inMenu,
   MenuItemIndex inItem,
   CFStringRef * outString){
//TODO
};


/*DeleteMenuItem

Deletes an item from a menu. 

void DeleteMenuItem (
   MenuRef theMenu,
   short item
);
Parameters
theMenu

The menu from which you want to delete the menu item. 
item

The item number of the menu item to delete. If you specify 0 or a number greater than the last item in the menu, DeleteMenuItem does not delete any item from the menu. 
Discussion

The DeleteMenuItem function deletes a specified menu item from a menu. You should not delete items from an existing menu unless the user expects the menu (such as a menu that lists open documents) to change. 
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X v10.0 and later.
Declared In
Menus.h*/
void DeleteMenuItem (MenuRef theMenu,short item){
//TODO
};


/*AppendMenuItemTextWithCFString

Appends a new menu item with text from a CFString.

OSStatus AppendMenuItemTextWithCFString (
   MenuRef inMenu,
   CFStringRef inString,
   MenuItemAttributes inAttributes,
   MenuCommand inCommandID,
   MenuItemIndex * outNewItem
);
Parameters
menu

The menu to which to append the new item. 
inString

The text of the new item. 
inAttributes

The attributes of the new item. 
inCommandID

The command ID of the new item. 
outNewItem

On exit, the index of the new item. May be NULL if the caller does not need this information. 
Return Value

A result code. See “Menu Manager Result Codes”.
Discussion

The Menu Manager will make its own copy of the CFString before returning from this function. Modifying the string after calling AppendMenuItemTextWithCFString will have no effect on the menu item's actual text. The caller may release the string after the call.
Availability
Available in CarbonLib 1.1 and later.
Available in Mac OS X v10.0 and later.
Declared In
Menus.h*/
OSStatus AppendMenuItemTextWithCFString (
   MenuRef inMenu,
   CFStringRef inString,
   MenuItemAttributes inAttributes,
   MenuCommand inCommandID,
   MenuItemIndex * outNewItem){
//TODO
};


/*GetFrontWindowOfClass

Obtains the frontmost window of a given class. 

WindowRef GetFrontWindowOfClass (
   WindowClass inWindowClass,
   Boolean mustBeVisible
);
Parameters
inWindowClass

The class of the window you want to obtain. If you pass kAllWindowClasses, the function returns the frontmost window in the window list. 
mustBeVisible

If set to true, the function returns the frontmost visible window. If set to false, the function returns the frontmost window of the specified class, regardless of whether the window is visible.
Return Value

A reference to the frontmost window of the class specified by inWindowClass.
Availability
Available in CarbonLib 1.0 and later.
Available in Mac OS X v10.0 and later.
Carbon Porting Notes
Declared In
MacWindows.h*/
WindowRef GetFrontWindowOfClass (WindowClass inWindowClass,Boolean mustBeVisible){
//TODO
};

/*SetWindowResizeLimits

Sets the maximum and minimum resize limits for windows. 

OSStatus SetWindowResizeLimits (
   WindowRef inWindow,
   const HISize * inMinLimits,
   const HISize * inMaxLimits
);
Parameters
inWindow

The window whose maximum and minimum resize limits are to be set.
inMinLimits

The minimum limits. Pass NULL if you dont want to set this limit. For information on the HISize data type, see HIGeometry.h.
inMaxLimits

The maximum limits. Pass NULL if you dont want to set this limit. For information on the HISize data type, see HIGeometry.h.
Return Value

A result code. See Window Manager Result Codes.
Availability
Available in Mac OS X v10.2 and later. 
Declared In
MacWindows.h*/
OSStatus SetWindowResizeLimits (WindowRef inWindow,const HISize * inMinLimits,const HISize * inMaxLimits){
//TODO
};

/*ShowWindow

Makes an invisible window visible.

void ShowWindow (
   WindowRef window
);
Parameters
window

The window that is to be made visible.
Discussion

The ShowWindow function makes an invisible window visible. If the specified window is already visible, ShowWindow has no effect. Your application typically creates a new window in an invisible state, performs any necessary setup of the content region, and then calls ShowWindow to make the window visible.

When you call ShowWindow to display a window that is invisible, the Window Manager draws the window frame and sends an event to request the application to draw the content region before the window becomes visible. For compositing windows, the Window Manager sends a kEventControlDraw event to each HIView in the window. For non-compositing windows, the Window Manager sends a kEventWindowDrawContent event. If a non-compositing window does not handle the kEventWindowDrawContent, the Window Manager shows the window and generates an update event to request your application to draw the content region.

If the newly visible window is the frontmost window, ShowWindow highlights it if its not already highlighted and generates an activate event to make it active. The ShowWindow function does not activate a window that is not frontmost on the desktop.

Because ShowWindow does not change the front-to-back ordering of windows, it is not the inverse of HideWindow. If you make the frontmost window invisible with HideWindow, andHideWindow has activated another window, you must call both ShowWindow and SelectWindow to bring the original window back to the front.
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X v10.0 and later.
Declared In
MacWindows.h*/
void ShowWindow ( WindowRef window){
//TODO
};

/*SetWindowBounds

Sets a windows size and position from the bounding rectangle of the specified window region.

OSStatus SetWindowBounds (
   WindowRef window,
   WindowRegionCode regionCode,
   const Rect * globalBounds
);
Parameters
window

The window whose bounds are to be set.
regionCode

A constant specifying the region to be used in determining the windows size and position. The only region codes allowed for this parameter are kWindowStructureRgn and kWindowContentRgn.
globalBounds

Set the rectangle to specify the dimensions and position, in global coordinates, of the window region specified in the regionCode parameter. 
Return Value

A result code. See Window Manager Result Codes.
Discussion

The SetWindowBounds function sets a windows size and position to that specified by the rectangle that your application passes in the globalBounds parameter. After doing so, SetWindowBounds redraws the window, if the window is visible.

When you call the SetWindowBounds function, your application specifies whether the windows content region or its structure region is more important in determining the windows ultimate size and position. This distinction can be important with versions of the Mac OS running the Appearance Manager, since the total dimensions of a window?and, therefore, its spatial relationship to the rest of the screen?may vary from appearance to appearance. In general, you should specify kWindowStructureRgn for the regionCode parameter if how the window as a whole relates to a given monitor is more important than the exact positioning of its content on the screen. On the other hand, if you specify kWindowContentRgn for the regionCode parameter because the positioning of your applications content is of greatest concern, then it is important to note that with some appearances some part of the windows structure region or frame may extend past the edge of a monitor and not be displayed.

See also the function GetWindowBounds. 
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.5 or later.
Available in Mac OS X v10.0 and later.
Declared In
MacWindows.h*/
OSStatus SetWindowBounds (  WindowRef window,WindowRegionCode regionCode,const Rect * globalBounds){
//TODO
};

/*HideWindow

Makes a window invisible.

void HideWindow (
   WindowRef window
);
Parameters
window

The window that is to be made invisible.
Discussion

The HideWindow function make a visible window invisible. If you hide the frontmost window, HideWindow removes the highlighting, brings the window behind it to the front, highlights the new frontmost window, and generates the appropriate activate events.

To reverse the actions of HideWindow, you must call both ShowWindow, to make the window visible, and SelectWindow, to select it. 
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X v10.0 and later.
Declared In
MacWindows.h*/
void HideWindow (WindowRef window){
//TODO
};


/*GetWindowBounds

Obtains the size and position of the bounding rectangle of the specified window region.

OSStatus GetWindowBounds (
   WindowRef window,
   WindowRegionCode regionCode,
   Rect * globalBounds
);
Parameters
window

The window whose bounds you want to obtain.
regionCode

A constant identifying the window region whose bounds you want to obtain. See Window Region Constants for a list of possible values.
globalBounds

A pointer to a structure of type Rect. On return, the rectangle contains the dimensions and position, in global coordinates, of the window region specified in the regionCode parameter. 
Return Value

A result code. See Window Manager Result Codes.
Discussion

Use the GetWindowBounds function to obtain the bounding rectangle for the specified window region for the specified window.
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.5 or later.
Available in Mac OS X v10.0 and later.
Declared In
MacWindows.h*/
OSStatus GetWindowBounds ( WindowRef window,WindowRegionCode regionCode,Rect * globalBounds){
//TODO
};


/*SetWindowModified

Sets the modification state of the specified window.

OSStatus SetWindowModified (
   WindowRef window,
   Boolean modified
);
Parameters
window

The window whose modification state is to be set.
modified

Pass true if the content of the window has been modified; otherwise, pass false.
Return Value

A result code. See “Window Manager Result Codes”.
Discussion

Your application can use the functions SetWindowModified and IsWindowModified instead of maintaining its own separate record of the modification state of the content of a window. The modification state of a window is visually represented by a dot in the window’s close box. If the dot is present, the window is modified; if the dot is absent, the window is not modified.

Your application should distinguish between the modification state of the window and the modification state of the window’s contents, typically a document. The modification state of the window contents are what should affect SetWindowModified. For example, in the case of a word processing document, you call SetWindowModified (passing true in the modified parameter) whenever the user types new characters into the document. However, you do not call SetWindowModified when the user moves the window, because that change does not affect the document contents. If you need to track whether the window position has changed, you need to do this with your own flag. 
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.5 or later.
Available in Mac OS X v10.0 and later.
Declared In
MacWindows.h*/
OSStatus SetWindowModified (
   WindowRef window,
   Boolean modified){
//TODO
};;


/*CreateEvent

Creates an event.

OSStatus CreateEvent (
   CFAllocatorRef inAllocator,
   UInt32 inClassID,
   UInt32 kind,
   EventTime when,
   EventAttributes flags,
   EventRef * outEvent
);
Parameters
inAllocator

A reference to the desired memory allocator to use to allocate memory for the event. Pass NULL to use the default allocator. See the Base Services documentation for a description of the CFAllocatorRef data type.
inClassID

The event class of the event to create.
kind

The event kind of the event to create. 
when

The time the event occurred. Pass 0 to specify the current event time (as returned by the GetCurrentEventTime function). 
flags

The event attributes to set. Currently you can pass kEventAttributeNone or kEventAttributeUserEvent. 
outEvent

On return, a reference to the newly created event. 
Return Value

A result code. See “Carbon Event Manager Result Codes”.
Discussion

You can use this function to create your own custom events or to simulate existing events. If you are creating custom events, you must make sure that the event signature (the combination of event class and event kind) does not conflict with any existing events. 
Declared In
CarbonEventsCore.h*/
OSStatus CreateEvent (
   CFAllocatorRef inAllocator,
   UInt32 inClassID,
   UInt32 kind,
   EventTime when,
   EventAttributes flags,
   EventRef * outEvent){
//TODO
};

/*GetCurrentEventTime

Returns the current time since last system startup, in seconds. 

EventTime GetCurrentEventTime ();
Return Value

EventTime. 
Discussion

Returns the current time since last system startup in seconds. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
CarbonEventsCore.h*/
EventTime GetCurrentEventTime (){
//TODO
};


/*SetEventParameter

Sets a parameter associated with a particular event. 

OSStatus SetEventParameter (
   EventRef inEvent,
   EventParamName inName,
   EventParamType inType,
   UInt32 inSize,
   const void * inDataPtr
);
Parameters
inEvent

The event to set the data for. 
inName

The symbolic name of the parameter. 
inType

The symbolic type of the parameter. 
inSize

The size of the parameter data. 
inDataPtr

A pointer to the parameter data.
Return Value

A result code. See “Carbon Event Manager Result Codes”.
Discussion

When creating events, you may want to specify additional event-related information, such as the mouse location or the window in which the event occurred. To set these you call SetEventParameter, specifying the type and value for the desired parameter. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
CarbonEventsCore.h*/
OSStatus SetEventParameter (
   EventRef inEvent,
   EventParamName inName,
   EventParamType inType,
   UInt32 inSize,
   const void * inDataPtr){
//TODO
};


/*ReleaseEvent

Releases, and possibly disposes of, the specified event.

void ReleaseEvent (
   EventRef inEvent
);
Parameters
inEvent

The event to release.
Discussion

This function decrements the reference count of an event. If the reference count reaches 0, the event is disposed. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
CarbonEventsCore.h*/
void ReleaseEvent (EventRef inEvent){
//TODO
};



/*SetWindowTitleWithCFString

Sets the window title to the contents of a Core Foundation string. 

OSStatus SetWindowTitleWithCFString (
   WindowRef inWindow,
   CFStringRef inString
);
Parameters
inWindow

The window whose title is to be set.
inString

The title to set. 
Return Value

A result code. See “Window Manager Result Codes”.
Availability
Available in CarbonLib 1.1 and later.
Available in Mac OS X v10.0 and later.
Declared In
MacWindows.h*/
OSStatus SetWindowTitleWithCFString (
   WindowRef inWindow,
   CFStringRef inString){
//TODO
};


/*DisposeWindow

Removes a window.

void DisposeWindow (
   WindowRef window
);
Parameters
window

On input, the window to be closed.
Discussion

The DisposeWindow function reduces a window’s reference count by one. If the resulting reference count is zero, then DisposeWindow removes the window from the screen and deletes it from the window list, then releases the memory occupied by all structures associated with the window, including the window structure. 

Note that DisposeWindow assumes that any picture pointed to by the window structure field windowPic is data, not a resource, and it calls the QuickDraw function KillPicture to delete it. If your application uses a picture stored as a resource, you must release the resource or release the memory it occupies with the ReleaseResource function and set the windowPic field to NULL before closing the window.

Any pending update events for the window are discarded. If the window being removed is the frontmost window, the window behind it, if any, becomes the active window. 
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X v10.0 and later.
Declared In
MacWindows.h*/
void DisposeWindow (WindowRef window){
//TODO
};



/*HIViewFindByID

Obtains a view by its ID. 

OSStatus HIViewFindByID (
   HIViewRef inStartView,
   HIViewID inID,
   HIViewRef * outControl
);
Parameters
inStartView

The view to start searching at. 
inID

The ID of the view you are looking for. 
outControl

Receives the control if found. 
Return Value

An operating system result code.
Discussion

Allows you to find a particular view by its ID. The HIViewID type used by this function is identical to the ControlID type used by the Control Manager.
Availability
Available in Mac OS X v10.2 and later.*/
OSStatus HIViewFindByID (
   HIViewRef inStartView,
   HIViewID inID,
   HIViewRef * outControl){
//TODO
};

/*HIViewGetRoot

Obtains the root view for a window. 

HIViewRef HIViewGetRoot (
   WindowRef inWindow
);
Parameters
inWindow

The window to get the root for.
Return Value

The root view for the window, or NULL if an invalid window is passed.
Discussion

Note that the root view is not the same as the Control Manager root control.
Availability
Available in Mac OS X v10.2 and later.*/
HIViewRef HIViewGetRoot (WindowRef inWindow){
//TODO
};


/*HITextViewGetTXNObject

Obtains the text object associated with an HITextView.

TXNObject HITextViewGetTXNObject(
   HIViewRef inTextView)
);
Parameters
inTextView

The HITextView associated with the text object you want to retrieve.
Return Value

Returns the text object associated with the given view.
Discussion

You can supply the extracted text object as a parameter to many of the MLTE functions that take a text object as a parameter. However, not all MLTE functions that take a text object can operate on an MLTE object that comes from an HITextView. In general, you cannot use MLTE functions that may alter the geometry of the object or explicitly invoke drawing. If you do, the function returns the result code kTXNDisabledFunctionalityErr. See HITextViewCreate for a list of the functions that return an error if you pass a text object that comes from an HITextView.
Availability
Available in Mac OS X v10.3 and later.
Declared In
MacTextEditor.h*/
TXNObject HITextViewGetTXNObject(
   HIViewRef inTextView){
//TODO
};


/*TXNSetData

Replaces a range of data (text, graphics, and so forth).

OSStatus TXNSetData (
   TXNObject iTXNObject,
   TXNDataType iDataType,
   const void * iDataPtr,
   ByteCount iDataSize,
   TXNOffset iStartOffset,
   TXNOffset iEndOffset
);
Parameters
iTXNObject

The text object that identifies the document in which you want to replace data.
iDataType

The type of the replacement data. See Supported Data Types for a description of possible values. 
iDataPtr

A pointer to the data that will replace the data that is in the range specified by the iStartOffset and iEndOffset parameters.
iDataSize

The size of the data (in bytes) to which iDataPtr points.
iStartOffset

The beginning of the range of data to replace. You can use the TXNGetSelection function to get the absolute offsets of the current selection. 
iEndOffset

The end of the range to replace. You can use the TXNGetSelection function to get the absolute offsets of the current selection. If you want to insert text, the ending and starting offsets should be the same value.
Return Value

A result code. See “MLTE Result Codes”.
Discussion

If you have a text object that has word wrap disabled, and you want to avoid horizontal scrolling, you can try the following. After you call the function TXNSetData, call TXNSetSelection with the value of the ending offset set to what it was before you called TXNSetData. Then, call the function TXNShowSelection to scroll the text back into view.

Offsets in MLTE are always character offsets. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
MacTextEditor.h*/
OSStatus TXNSetData (
   TXNObject iTXNObject,
   TXNDataType iDataType,
   const void * iDataPtr,
   ByteCount iDataSize,
   TXNOffset iStartOffset,
   TXNOffset iEndOffset){
//TODO
};


/*TXNSetDataFromCFURLRef

Replaces a range of data with the contents of a file. (Deprecated in Mac OS X v10.4. Use TXNReadFromCFURL instead.)

Not recommended.

OSStatus TXNSetDataFromCFURLRef (
   TXNObject   iTXNObject,
   CFURLRef    iURL,
   TXNOffset   iStartOffset,
   TXNOffset   iEndOffset
);
Parameters
iTXNObject

The text object that identifies the document in which you want to replace data. You can either call the function TXNCreateObject to allocate a text object or you can call the function HITextViewGetTXNObject to obtain the text object associated with an HITextView. 
iURL

A reference to the Core Foundation URL that specifies the file which contains the data you want to add to the object. 
iStartOffset

The starting position at which to insert the file into the document. If you want to replace the current selection, set the iStartOffset parameter to kTXNCurrentSelection. If you want to replace the entire document, set the iStartOffset parameter to 0. Offsets in MLTE are always character offsets.
iEndOffset

The ending position of the range being replaced by the file. You can use the TXNGetSelection function to get the absolute offsets of the current selection. Offsets in MLTE are always character offsets.
Return Value

A result code. See “MLTE Result Codes”.
Discussion

Your application must open the file and set the iStartOffset parameter to the appropriate value before you call the TXNSetDataFromCFURLRef function. If you want to embed MLTE data within private data or other MLTE data, you must set the file position to the appropriate position.

In the (now deprecated) function TXNNewObject your could pass a file reference and MLTE supported functionality to revert back to the original file reference. When you call the function TXNSetDataFromURLRef, MLTE saves the CFURLRef. If you change the contents of the text object and then call the function TXNRevert, the document reverts to the contents specified by the saved CFURLRef.
Availability
Available in Mac OS X v10.3 and later.
Deprecated in Mac OS X v10.4.
Declared In
MacTextEditor.h*/
OSStatus TXNSetDataFromCFURLRef (
   TXNObject   iTXNObject,
   CFURLRef    iURL,
   TXNOffset   iStartOffset,
   TXNOffset   iEndOffset){
//TODO
};

/*TXNShowSelection

Scrolls the current selection into view.

void TXNShowSelection (
   TXNObject iTXNObject,
   Boolean iShowEnd
);
Parameters
iTXNObject

The text object for the current text area. 
iShowEnd

A Boolean value. If you set this to true, the end of the selection is scrolled into view. Otherwise, the beginning of the selection is scrolled into view. 
Discussion

You can use this to scroll text into view after you have called the TXNFind function and the matching text is not in the current view of the text object. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
MacTextEditor.h*/
void TXNShowSelection (
   TXNObject iTXNObject,
   Boolean iShowEnd){
//TODO
};


/*TXNSetSelection

Specifies the selection range or the position of the insertion point. 

OSStatus TXNSetSelection (
   TXNObject iTXNObject,
   TXNOffset iStartOffset,
   TXNOffset iEndOffset
);
Parameters
iTXNObject

The text object that identifies the document for which you want to set the selection range or insertion point position. 
iStartOffset

The new starting offset. Offset values are character offsets. 
iEndOffset

The new ending offset. Offset values are character offsets.
Return Value

A result code. See “MLTE Result Codes”.
Discussion

You can use the TXNSetSelection function to highlight an initial default value in a document, such as a data-entry form, or to position the insertion point at the start of the field where you want the user to enter a value. To position the insertion point, specify the same value for the iStartOffset and iEndOffset parameters. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
MacTextEditor.h*/
OSStatus TXNSetSelection (
   TXNObject iTXNObject,
   TXNOffset iStartOffset,
   TXNOffset iEndOffset){
//TODO
};

/*HIWindowSetProxyFSRef

Sets the proxy icon for a window using an FSRef to a file system object.

OSStatus HIWindowSetProxyFSRef (
   WindowRef inWindow,
   const FSRef * inRef
);
Parameters
inWindow

The window whose proxy icon is to be set.
inRef

The file system object the window represents.
Return Value

A result code. See “Window Manager Result Codes”.
Discussion

This function determines the window’s proxy icon by asking Icon Services for the icon for the object specified by inRef.
Availability
Available in Mac OS X v10.4 and later. 
Declared In
MacWindows.h*/
OSStatus HIWindowSetProxyFSRef (
   WindowRef inWindow,
   const FSRef * inRef){
//TODO
};

/*SetWindowProxyFSSpec	
Use of file specifications is no longer recommended. Instead, use HIWindowSetProxyFSRef.*/
OSStatus SetWindowSetProxyFSRef (WindowRef inWindow,const FSRef * inRef){
   OSStatus HIWindowSetProxyFSRef (WindowRef inWindow,const FSRef * inRef);
};

