#ifndef FILES_H
#define FILES_H
#endif

#ifndef MACTYPES_H
#include <CarbonCore/MacTypes.h>
#endif

#ifndef DATETIMEUTILS_H
#include <CarbonCore/DateTimeUtils.h>
#endif

#ifndef TEXTCOMMONH
#include <CarbonCore/TextCommon.h>
#endif

#ifndef __TYPES_H
#include <CoreFoundation/Types.h>
#endif

#ifndef CORESERVICE_H
#include <CoreService/CoreService.h>
#endif

#ifndef QUICKTIME_H
#include <Quicktime/Quicktime.h>
#endif

#ifndef OSTYPES_H
 #include <libkern/OSTypes.h>
#endif

/*Position Mode Constants

Together with an offset, specify a position within a fork.

enum {
   fsAtMark = 0,
   fsFromStart = 1,
   fsFromLEOF = 2,
   fsFromMark = 3
};
Constants
fsAtMark

The starting point is the access path’s current position. The offset is ignored.

Available in Mac OS X v10.0 and later.
fsFromStart

The starting point is offset bytes from the start of the fork. The offset must be non-negative.

Available in Mac OS X v10.0 and later.
fsFromLEOF

The starting point is offset bytes from the logical end of the fork. The offset must not be positive.

Available in Mac OS X v10.0 and later.
fsFromMark

The starting point is offset bytes from the access path’s current position. The offset may be positive or negative.

Available in Mac OS X v10.0 and later.
Discussion

These constants are used in the ioPosMode and positionMode fields and parameters of the HFS and HFS Plus file access functions. These functions include those for reading from and writing to files or forks, changing the current position within a file or fork, changing the size of a file or fork, and allocating space to a file or fork.

For the FSReadFork and FSWriteFork calls, you may also add either of the pleaseCacheMask or noCacheMask constants to hint whether the data should be cached or not. See Cache Constants.*/
enum {
   fsAtMark = 0,
   fsFromStart = 1,
   fsFromLEOF = 2,
   fsFromMark = 3
};

/*Catalog Information Bitmap Constants

Specify what file or fork information to get or set.

enum {
   kFSCatInfoNone = 0x00000000,
   kFSCatInfoTextEncoding = 0x00000001,
   kFSCatInfoNodeFlags = 0x00000002,
   kFSCatInfoVolume = 0x00000004,
   kFSCatInfoParentDirID = 0x00000008,
   kFSCatInfoNodeID = 0x00000010,
   kFSCatInfoCreateDate = 0x00000020,
   kFSCatInfoContentMod = 0x00000040,
   kFSCatInfoAttrMod = 0x00000080,
   kFSCatInfoAccessDate = 0x00000100,
   kFSCatInfoBackupDate = 0x00000200,
   kFSCatInfoPermissions = 0x00000400,
   kFSCatInfoFinderInfo = 0x00000800,
   kFSCatInfoFinderXInfo = 0x00001000,
   kFSCatInfoValence = 0x00002000,
   kFSCatInfoDataSizes = 0x00004000,
   kFSCatInfoRsrcSizes = 0x00008000,
   kFSCatInfoSharingFlags = 0x00010000,
   kFSCatInfoUserPrivs = 0x00020000,
   kFSCatInfoUserAccess = 0x00080000,
   kFSCatInfoSetOwnership = 0x00100000,
   kFSCatInfoAllDates = 0x000003E0,
   kFSCatInfoGettableInfo = 0x0003FFFF,
   kFSCatInfoSettableInfo = 0x00001FE3,
   kFSCatInfoReserved = 0xFFFC0000
};
Constants
kFSCatInfoNone

No catalog information.

Available in Mac OS X v10.0 and later.
kFSCatInfoTextEncoding

Retrieve or set the text encoding hint, in the textEncodingHint field.

Available in Mac OS X v10.0 and later.
kFSCatInfoNodeFlags

Retrieve or set the catalog node flags. Currently, you can only set bits 0 and 4. See Catalog Information Node Flags for more information on these flags.

Available in Mac OS X v10.0 and later.
kFSCatInfoVolume

Retrieve the volume reference number of the volume on which the file or directory resides.

Available in Mac OS X v10.0 and later.
kFSCatInfoParentDirID

Retrieve the parent directory ID.

Available in Mac OS X v10.0 and later.
kFSCatInfoNodeID

Retrieve the file or directory ID.

Available in Mac OS X v10.0 and later.
kFSCatInfoCreateDate

Retrieve or set the creation date.

Available in Mac OS X v10.0 and later.
kFSCatInfoContentMod

Retrieve or set the date that the resource or data fork was last modified.

Available in Mac OS X v10.0 and later.
kFSCatInfoAttrMod

Retrieve or set the date that an attribute or named fork was last modified.

Available in Mac OS X v10.0 and later.
kFSCatInfoAccessDate

Retrieve or set the date that the fork or file was last accessed.

Available in Mac OS X v10.0 and later.
kFSCatInfoBackupDate

Retrieve or set the date that the fork or file was last backed up.

Available in Mac OS X v10.0 and later.
kFSCatInfoPermissions

Retrieve or set the file or fork’s permissions.

Available in Mac OS X v10.0 and later.
kFSCatInfoFinderInfo

Retrieve or set the file or fork’s Finder information.

Available in Mac OS X v10.0 and later.
kFSCatInfoFinderXInfo

Retrieve or set the file or fork’s extended Finder information.

Available in Mac OS X v10.0 and later.
kFSCatInfoValence

For folders only, retrieve the valence of the folder. For files, this is zero.

Available in Mac OS X v10.0 and later.
kFSCatInfoDataSizes

Retrieve the logical and physical size of the data fork.

Available in Mac OS X v10.0 and later.
kFSCatInfoRsrcSizes

Retrieve the logical and physical size of the resource fork.

Available in Mac OS X v10.0 and later.
kFSCatInfoSharingFlags

Retrieve the fork or file’s sharing flags: kioFlAttribMountedBit, kioFlAttribSharePointBit. See File Attribute Constants for more information on these bits.

Available in Mac OS X v10.0 and later.
kFSCatInfoUserPrivs

Retrieve the file’s user privileges.

Available in Mac OS X v10.0 and later.
kFSCatInfoUserAccess

Available in Mac OS X v10.1 and later.
kFSCatInfoSetOwnership

Attempt to set the file’s user and group (UID and GID). If the File Manager cannot set the the user or group ID, the call fails. (Mac OS X only).

Available in Mac OS X v10.3 and later.
kFSCatInfoAllDates

Retrieve or set all of the date information for the fork or file: creation date, modification dates, access date, backup date, etc.

Available in Mac OS X v10.0 and later.
kFSCatInfoGettableInfo

Retrieve all gettable data.

Available in Mac OS X v10.0 and later.
kFSCatInfoSettableInfo

Set all settable data. This includes the flags, dates, permissions, Finder info, and text encoding hint.

Available in Mac OS X v10.0 and later.
kFSCatInfoReserved

Represents bits that are currently reserved.

Available in Mac OS X v10.0 and later.
Discussion

These constants are used in the FSCatalogInfoBitmap type to specify what file or fork information to get or set. If used with the FSGetCatalogInfo or FSGetCatalogInfoBulk functions, these constants tell the File Manager which fields to return information in. If used with the FSSetCatalogInfo function, these constants tell the File Manager which fields you’ve filled out with values that it should use to change the fork or file’s catalog information.*/
enum {
   kFSCatInfoNone = 0x00000000,
   kFSCatInfoTextEncoding = 0x00000001,
   kFSCatInfoNodeFlags = 0x00000002,
   kFSCatInfoVolume = 0x00000004,
   kFSCatInfoParentDirID = 0x00000008,
   kFSCatInfoNodeID = 0x00000010,
   kFSCatInfoCreateDate = 0x00000020,
   kFSCatInfoContentMod = 0x00000040,
   kFSCatInfoAttrMod = 0x00000080,
   kFSCatInfoAccessDate = 0x00000100,
   kFSCatInfoBackupDate = 0x00000200,
   kFSCatInfoPermissions = 0x00000400,
   kFSCatInfoFinderInfo = 0x00000800,
   kFSCatInfoFinderXInfo = 0x00001000,
   kFSCatInfoValence = 0x00002000,
   kFSCatInfoDataSizes = 0x00004000,
   kFSCatInfoRsrcSizes = 0x00008000,
   kFSCatInfoSharingFlags = 0x00010000,
   kFSCatInfoUserPrivs = 0x00020000,
   kFSCatInfoUserAccess = 0x00080000,
   kFSCatInfoSetOwnership = 0x00100000,
   kFSCatInfoAllDates = 0x000003E0,
   kFSCatInfoGettableInfo = 0x0003FFFF,
   kFSCatInfoSettableInfo = 0x00001FE3,
   kFSCatInfoReserved = 0xFFFC0000
};
/*FSCatalogInfoBitmap

Describes which fields of the FSCatalogInfo structure you wish to retrieve or set.

typedef UInt32 FSCatalogInfoBitmap;
Discussion

If the bit corresponding to a particular field is not set in the bitmap, then that field is not changed in the FSCatalogInfo structure if it is an output parameter, and that field is ignored if the FSCatalogInfo structure is an input parameter. See Catalog Information Bitmap Constants for a description of the constants you should use with this data type. 
Availability
Available in Mac OS X v10.0 and later.*/
typedef UInt32 FSCatalogInfoBitmap;

/*FSVolumeRefNum

Identifies a particular mounted volume.

typedef SInt16 FSVolumeRefNum;
Discussion

This data type is the same as the 16-bit volume refnum previously passed in the ioVRefNum fields of a parameter block; this is simply a new type name for the old data type. 
Availability
Available in Mac OS X v10.0 and later.*/
typedef SInt16 FSVolumeRefNum;

/*FSCatalogInfo

Holds basic information about a file or directory.

struct FSCatalogInfo {
   UInt16 nodeFlags;
   FSVolumeRefNum volume;
   UInt32 parentDirID;
   UInt32 nodeID;
   UInt8 sharingFlags;
   UInt8 userPrivileges;
   UInt8 reserved1;
   UInt8 reserved2;
   UTCDateTime createDate;
   UTCDateTime contentModDate;
   UTCDateTime attributeModDate;
   UTCDateTime accessDate;
   UTCDateTime backupDate;
   UInt32 permissions[4];
   UInt8 finderInfo[16];
   UInt8 extFinderInfo[16];
   UInt64 dataLogicalSize;
   UInt64 dataPhysicalSize;
   UInt64 rsrcLogicalSize;
   UInt64 rsrcPhysicalSize;
   UInt32 valence;
   TextEncoding textEncodingHint;
};
typedef struct FSCatalogInfo FSCatalogInfo;
typedef FSCatalogInfo * FSCatalogInfoPtr;
Fields
nodeFlags

Node flags. This field has two defined bits that indicate whether an object is a file or folder, and whether a file is locked (constants kFSNodeIsDirectoryMask and kFSNodeLockedMask). See Catalog Information Node Flags for the values you can use here.
volume

The object's volume reference. 
parentDirID

The ID of the directory that contains the given object. The root directory of a volume always has ID fsRtDirID (2); the parent of the root directory is ID fsRtParID (1). Note that there is no object with ID fsRtParID; this is merely used when the File Manager is asked for the parent of the root directory.
nodeID

The file or directory ID.
sharingFlags

The object’s sharing flags. See Catalog Information Sharing Flags for the meaning of the bits defined for this field.
userPrivileges

The user's effective AFP privileges (same as ioACUser in the old HFileInfo and DirInfo structures). See User Privileges Constants.
reserved1

Reserved.
reserved2

Reserved.
createDate

The date and time of the creation of the object. Note that file systems other than AFP, HFS and HFS Plus do not generally support creation dates. For file systems which do not support creation dates, FSGetCatalogInfo, PBGetCatalogInfoSync, and PBGetCatalogInfoAsync return 0 in this field. 
contentModDate

The date and time that the data or resource fork was last modified.
attributeModDate

The date and time that an attribute of the object (such as a fork other than the data or resource fork) was last modified.
accessDate

The date and time that the object was last accessed. The Mac OS 9 File Manager does not automatically update the accessDate field; it exists primarily for use by other operating systems (notably Mac OS X).
backupDate

The date and time of the object’s last backup. This field is not updated by the File Manager a backup utility may use this field if it wishes. Note that file systems other than AFP, HFS and HFS Plus do not generally support backup dates. For file systems which do not support backup dates, FSGetCatalogInfo, PBGetCatalogInfoSync, and PBGetCatalogInfoAsync return 0 in this field.
permissions

User and group permission information. The Mac OS 8 and 9 File Manager does not use or enforce this permission information. It could be used by a file server program or other operating system (primarily Mac OS X). In Mac OS X, this array contains the file system permissions of the returned item. To use this information, coerce the parameter to a FSPermissionInfo structure.
finderInfo

Basic Finder information for the object. This information is available in the catalog information, instead of in a named fork, for historical reasons. The File Manager does not interpret the contents of these fields. To use this information, coerce the parameter to a FileInfo or FolderInfo structure.
extFinderInfo

Extended Finder information for the object. This information is available in the catalog information, instead of in a named fork, for historical reasons. The File Manager does not interpret the contents of these fields. To use this information, coerce the parameter to an ExtendedFileInfo or ExtendedFolderInfo structure.
dataLogicalSize

The size of the data fork in bytes (the fork’s logical size). The information in this field is only valid for files do not rely upon the value returned in this field for folders.
dataPhysicalSize

The amount of disk space, in bytes, occupied by the data fork (the fork’s physical size). The information in this field is only valid for files do not rely upon the value returned in this field for folders.
rsrcLogicalSize

The size of the resource fork (the fork’s logical size). The information in this field is only valid for files do not rely upon the value returned in this field for folders.
rsrcPhysicalSize

The amount of disk space occupied by the resource fork (the fork’s physical size). The information in this field is only valid for files do not rely upon the value returned in this field for folders.
valence

For folders only, the number of items (files plus directories) contained within the directory. For files, it is set to zero. Many volume formats do not store a field containing a directory’s valence. For those volume formats, this field is very expensive to compute. Think carefully before you ask the File Manager to return this field.
textEncodingHint

The textEncodingHint field is used in conjunction with the Unicode filename of the object. It is an optional hint that can be used by the volume format when converting the Unicode to some other encoding. For example, HFS Plus stores this value and uses it when converting the name to a Mac OS encoding, such as when the name is returned by PBGetCatInfoSync or PBGetCatInfoAsync. As another example, HFS volumes use this value to convert the Unicode name to a Mac OS encoded name stored on disk. If the entire Unicode name can be converted to a single Mac OS encoding, then that encoding should be used as the textEncodingHint; otherwise, a text encoding corresponding to the first characters of the name will probably provide the best user experience. 

If a textEncodingHint is not supplied when a file or directory is created or renamed, the volume format will use a default value. This default value may not be the best possible choice for the given filename. Whenever possible, a client should supply a textEncodingHint.

Discussion

The FSCatalogInfoBitmap type is used to indicate which fields of the FSCatalogInfo should be set or retrieved. If the bit corresponding to a particular field is not set, then that field is not changed if the FSCatalogInfo is an output parameter, and that field is ignored if the FSCatalogInfo is an input parameter. 
Availability
Available in Mac OS X v10.0 and later.*/
struct FSCatalogInfo {
   UInt16 nodeFlags;
   FSVolumeRefNum volume;
   UInt32 parentDirID;
   UInt32 nodeID;
   UInt8 sharingFlags;
   UInt8 userPrivileges;
   UInt8 reserved1;
   UInt8 reserved2;
   UTCDateTime createDate;
   UTCDateTime contentModDate;
   UTCDateTime attributeModDate;
   UTCDateTime accessDate;
   UTCDateTime backupDate;
   UInt32 permissions[4];
   UInt8 finderInfo[16];
   UInt8 extFinderInfo[16];
   UInt64 dataLogicalSize;
   UInt64 dataPhysicalSize;
   UInt64 rsrcLogicalSize;
   UInt64 rsrcPhysicalSize;
   UInt32 valence;
   TextEncoding textEncodingHint;
};
typedef struct FSCatalogInfo FSCatalogInfo;
typedef FSCatalogInfo * FSCatalogInfoPtr;

/*FSIterator

Refers to a position within the catalog, used when iterating over files and folders in a directory.

typedef struct OpaqueFSIterator * FSIterator;
Discussion

This data type is like a file reference number because it maintains state internally to the File Manager and must be explicitly opened and closed.

An FSIterator is returned by FSOpenIterator and is passed as input to FSGetCatalogInfoBulk , FSCatalogSearch and FSCloseIterator. 
Availability
Available in Mac OS X v10.0 and later.*/
typedef struct OpaqueFSIterator * FSIterator;

/*Iterator Flags

Indicate whether an iterator iterates over subtrees or just the immediate children of the container.

enum {
   kFSIterateFlat = 0,
   kFSIterateSubtree = 1,
   kFSIterateDelete = 2,
   kFSIterateReserved = 0xFFFFFFFC
};
typedef OptionBits FSIteratorFlags;
Constants
kFSIterateFlat

Iterate over the immediate children of the container only. 

Available in Mac OS X v10.0 and later.
kFSIterateSubtree

Iterate over the entire subtree rooted at the container.

Available in Mac OS X v10.0 and later.
kFSIterateDelete

Available in Mac OS X v10.0 and later.
kFSIterateReserved

Available in Mac OS X v10.0 and later.*/
enum {
   kFSIterateFlat = 0,
   kFSIterateSubtree = 1,
   kFSIterateDelete = 2,
   kFSIterateReserved = 0xFFFFFFFC
};
typedef OptionBits FSIteratorFlags;

/*HFSUniStr255

Used by the File Manager to return Unicode strings.

struct HFSUniStr255 {
   UInt16 length;
   UniChar unicode[255];
};
typedef struct HFSUniStr255 HFSUniStr255;
Fields
length

The number of unicode characters in the string.
unicode

The string, in unicode characters.
Discussion

This data type is a string of up to 255 16-bit Unicode characters, with a preceding 16-bit length (number of characters). Note that only the first length characters have meaningful values; the remaining characters may be set to arbitrary values. A caller should always assume that the entire structure will be modified, even if the actual string length is less than 255. 
Availability
Available in Mac OS X v10.0 and later.*/
struct HFSUniStr255 {
   UInt16 length;
   UniChar unicode[255];
};
typedef struct HFSUniStr255 HFSUniStr255;

/*FSSpec

Specifies the name and location of a file or directory.

struct FSSpec {
   short vRefNum;
   long parID;
   StrFileName name;
};
typedef struct FSSpec FSSpec;
typedef FSSpec * FSSpecPtr;
Fields
vRefNum

The volume reference number of the volume containing the specified file or directory.
parID

The parent directory ID of the specified file or directory (the directory ID of the directory containing the given file or directory).
name

The name of the specified file or directory. In Carbon, this name must be a leaf name; the name cannot contain a semicolon.
Discussion

The FSSpec structure can describe only a file or a directory, not a volume. A volume can be identified by its root directory, although the system software never uses an FSSpec structure to describe a volume. The directory ID of the roots parent directory is fsRtParID. The name of the root directory is the same as the name of the volume.

If you need to convert a file specification into an FSSpec structure, call the function FSMakeFSSpec . Do not fill in the fields of an FSSpec structure yourself. 
Availability
Available in Mac OS X v10.0 and later.*/
struct FSSpec {
   short vRefNum;
   long parID;
   StrFileName name;
};
typedef struct FSSpec FSSpec;
typedef FSSpec * FSSpecPtr;


/*FSOpenIterator

Creates a catalog iterator that can be used to iterate over the contents of a directory or volume.

OSErr FSOpenIterator (
   const FSRef * container,
   FSIteratorFlags iteratorFlags,
   FSIterator * iterator
);
Parameters
container

A pointer to an FSRef for the directory to iterate. The set of items to iterate over can either be the objects directly contained in the directory, or all items directly or indirectly contained in the directory (in which case, the specified directory is the root of the subtree to iterate). See FSRef for a description of the FSRef data type.
iteratorFlags

A set of flags which controls whether the iterator iterates over subtrees or just the immediate children of the container. See Iterator Flags for a description of the flags defined for this parameter.

Iteration over subtrees which do not originate at the root directory of a volume are not currently supported, and passing the kFSIterateSubtree flag in this parameter returns errFSBadIteratorFlags. To determine whether subtree iterators are supported, check that the bSupportsSubtreeIterators bit returned by PBHGetVolParmsSync or PBHGetVolParmsAsync is set.
iterator

On return, a pointer to the new FSIterator. You can pass this iterator to the FSGetCatalogInfoBulk or FSCatalogSearch functions and their parameter block-based counterparts.

The iterator is automatically initialized so that the next use of the iterator returns the first item. The order that items are returned in is volume format dependent and may be different for two different iterators created with the same container and flags.

See FSIterator for a description of the FSIterator data type.
Return Value

A result code. See “File Manager Result Codes”.
Discussion

Catalog iterators must be closed when you are done using them, whether or not you have iterated over all the items. Iterators are automatically closed upon process termination, just like open files. However, you should use the FSCloseIterator function, or one of the related parameter block functions, PBCloseIteratorSync and PBCloseIteratorAsync , to close an iterator to free up any system resources allocated to the iterator.

Before calling this function, you should check that it is present, by calling the Gestalt function. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
Files.h*/
OSErr FSOpenIterator (
   const FSRef * container,
   FSIteratorFlags iteratorFlags,
   FSIterator * iterator
);

/*FSGetCatalogInfoBulk

Returns information about one or more objects from a catalog iterator. This function can return information about multiple objects in a single call.

OSErr FSGetCatalogInfoBulk (
   FSIterator iterator,
   ItemCount maximumObjects,
   ItemCount * actualObjects,
   Boolean * containerChanged,
   FSCatalogInfoBitmap whichInfo,
   FSCatalogInfo * catalogInfos,
   FSRef * refs,
   FSSpec * specs,
   HFSUniStr255 * names
);
Parameters
iterator

The iterator to use. You can obtain a catalog iterator with the function FSOpenIterator, or with one of the related parameter block calls, PBOpenIteratorSync and PBOpenIteratorAsync. Currently, the iterator must be created with the kFSIterateFlat option. See FSIterator for a description of the FSIterator data type.
maximumObjects

The maximum number of items to return for this call. 
actualObjects

On return, a pointer to the actual number of items found for this call.
containerChanged

On return, a pointer to a value indicating whether or not the container’s contents have changed since the previous FSGetCatalogInfoBulk call. If true, the contents have changed. Objects may still be returned, even though the container has changed. If so, note that if the container has changed, then the total set of items returned may be incorrect: some items may be returned multiple times, and some items may not be returned at all.

This parameter is optional if you don’t want this information returned, pass a NULL pointer. 

On versions of Mac OS X prior to 10.2, this parameter is unset. On Mac OS X version 10.2, this parameter is always set to false. To find out whether the container has changed since the last call to FSGetCatalogInfoBulk, check the modification date of the container.
whichInfo

A bitmap specifying the catalog information fields to return for each item. If you don’t wish any catalog information returned, pass the constant kFSCatInfoNone in this parameter. For a description of the bits in this parameter, see Catalog Information Bitmap Constants.
catalogInfos

A pointer to an array of catalog information structures; one for each returned item. On input, the catalogInfos parameter should point to an array of maximumObjects catalog information structures.

This parameter is optional; if you do not wish any catalog information returned, pass NULL here.

refs

A pointer to an array of FSRef structures; one for each returned item. On input, this parameter should to point to an array of maximumObjectsFSRef structures. 

This parameter is optional; if you do not wish any FSRef structures returned, pass NULL here.
specs

A pointer to an array of FSSpec structures; one for each returned item. On input, this parameter should to point to an array of maximumObjectsFSSpec structures. 

This parameter is optional; if you do not wish any FSSpec structures returned, pass NULL here.
names

A pointer to an array of names; one for each returned item. If you want the Unicode name for each item found, set this parameter to point to an array of maximumObjectsHFSUniStr255 structures. Otherwise, set it to NULL. 
Return Value

A result code. See “File Manager Result Codes”. When all of the iterator’s objects have been returned, the call will return errFSNoMoreItems.
Discussion

The FSGetCatalogInfoBulk call may complete and return noErr with fewer than maximumObjects items returned. This may be due to various reasons related to the internal implementation. In this case, you may continue to make FSGetCatalogInfoBulk calls using the same iterator.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Files.h*/
OSErr FSGetCatalogInfoBulk (
   FSIterator iterator,
   ItemCount maximumObjects,
   ItemCount * actualObjects,
   Boolean * containerChanged,
   FSCatalogInfoBitmap whichInfo,
   FSCatalogInfo * catalogInfos,
   FSRef * refs,
   FSSpec * specs,
   HFSUniStr255 * names
);

/*FSMakeFSRefUnicode

Constructs an FSRef for a file or directory, given a parent directory and a Unicode name. 

OSErr FSMakeFSRefUnicode (
   const FSRef * parentRef,
   UniCharCount nameLength,
   const UniChar * name,
   TextEncoding textEncodingHint,
   FSRef * newRef
);
Parameters
parentRef

A pointer to the FSRef of the parent directory of the file or directory for which to create a new FSRef. See FSRef for a description of the FSRef data type.
nameLength

The length of the file or directory name. 
name

A pointer to the Unicode name for the file or directory. The name must be a leaf name; partial or full pathnames are not allowed. If you have a partial or full pathname in Unicode, you will have to parse it yourself and make multiple calls to FSMakeFSRefUnicode. 
textEncodingHint

The suggested text encoding to use when converting the Unicode name of the file or directory to some other encoding. If you pass the constant kTextEncodingUnknown, the File Manager will use a default value. 
newRef

On return, if the function returns a result of noErr, a pointer to the new FSRef.
Return Value

A result code. See “File Manager Result Codes”.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Files.h*/
OSErr FSMakeFSRefUnicode (
   const FSRef * parentRef,
   UniCharCount nameLength,
   const UniChar * name,
   TextEncoding textEncodingHint,
   FSRef * newRef
);

/*FSCloseIterator

Closes a catalog iterator. 

OSErr FSCloseIterator (
   FSIterator iterator
);
Parameters
iterator

The catalog iterator to be closed. FSCloseIterator releases memory and other system resources used by the iterator, making the iterator invalid. See FSIterator for a description of the FSIterator data type.
Return Value

A result code. See “File Manager Result Codes”.
Discussion

This function releases memory and other system resources used by the iterator. The iterator becomes invalid. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
Files.h*/
OSErr FSCloseIterator (
   FSIterator iterator
);

/*FSCloseFork

Closes an open fork.

OSErr FSCloseFork (
   SInt16 forkRefNum
);
Parameters
forkRefNum

The reference number of the fork to close. After the call to this function, the reference number in this parameter is invalid. 
Return Value

A result code. See “File Manager Result Codes”.
Discussion

The FSCloseFork function causes all data written to the fork to be written to disk, in the same manner as the FSFlushFork function, before it closes the fork. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
Files.h*/
OSErr FSCloseFork (
   SInt16 forkRefNum
);

/*FSReadFork

Reads data from an open fork.

OSErr FSReadFork (
   SInt16 forkRefNum,
   UInt16 positionMode,
   SInt64 positionOffset,
   ByteCount requestCount,
   void * buffer,
   ByteCount * actualCount
);
Parameters
forkRefNum

The reference number of the fork to read from. You should have previously opened this fork using the FSOpenFork call, or one of the corresponding parameter block calls, PBOpenForkSync and PBOpenForkAsync. 
positionMode

A constant specifying the base location within the fork for the start of the read. See Position Mode Constants for a description of the constants which you can use to specify the base location.

The caller can also use this parameter to hint to the File Manager whether the data being read should or should not be cached. Caching reads appropriately can be important in ensuring that your program access files efficiently. 

If you add the forceReadMask constant to the value you pass in this parameter, this tells the File Manager to force the data to be read directly from the disk. This is different from adding the noCacheMask constant since forceReadMask tells the File Manager to flush the appropriate part of the cache first, then ignore any data already in the cache. However, data that is read may be placed in the cache for future reads. The forceReadMask constant is also passed to the device driver, indicating that the driver should avoid reading from any device caches.

See Cache Constants for further description of the constants that you can use to indicate your preference for caching the read.

positionOffset

The offset from the base location for the start of the read. 
requestCount

The number of bytes to read. 
buffer

A pointer to the buffer where the data will be returned. 
actualCount

On return, a pointer to the number of bytes actually read. The value pointed to by the actualCount parameter should be equal to the value in the requestCount parameter unless there was an error during the read operation.

This parameter is optional; if you don’t want this information returned, set actualCount to NULL.
Return Value

A result code. See “File Manager Result Codes”. If there are fewer than requestCount bytes from the specified position to the logical end-of-file, then all of those bytes are read, and eofErr is returned.
Discussion

FSReadFork reads data starting at the position specified by the positionMode and positionOffset parameters. The function reads up to requestCount bytes into the buffer pointed to by the buffer parameter and sets the fork’s current position to the byte immediately after the last byte read (that is, the initial position plus actualCount).

To verify that data previously written has been correctly transferred to disk, read it back in using the forceReadMask constant in the positionMode parameter and compare it with the data you previously wrote.

When reading data from a fork, it is important to pay attention to that way that your program accesses the fork, because this can have a significant performance impact. For best results, you should use an I/O size of at least 4KB and block align your read requests. On Mac OS X, you should align your requests to 4KB boundaries; on the traditional Mac OS, byte-alignments beyond 512-bytes are irrelevant, but 4KB aligned requests will perform well on current and future versions. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
Files.h*/
OSErr FSReadFork (
   SInt16 forkRefNum,
   UInt16 positionMode,
   SInt64 positionOffset,
   ByteCount requestCount,
   void * buffer,
   ByteCount * actualCount
);

/*FSOpenFork

Opens any fork of a file or directory for streaming access.

OSErr FSOpenFork (
   const FSRef * ref,
   UniCharCount forkNameLength,
   const UniChar * forkName,
   SInt8 permissions,
   SInt16 * forkRefNum
);
Parameters
ref

A pointer to an FSRef specifying the file or directory owning the fork to open. See FSRef for a description of the FSRef data type.
forkNameLength

The length of the fork name in Unicode characters. 
forkName

A pointer to the Unicode name of the fork to open. You can obtain the string constants for the data fork and resource fork names using the FSGetDataForkName and FSGetResourceForkName functions. All volume formats should support data and resource forks; other named forks may be supported by some volume formats. 
permissions

A constant indicating the type of access which you wish to have to the fork via the returned fork reference. This parameter is the same as the permission parameter passed to the FSpOpenDF and FSpOpenRF functions. For a description of the types of access which you can request, see File Access Permission Constants. 
forkRefNum

On return, a pointer to the fork reference number for accessing the open fork. 
Return Value

A result code. See “File Manager Result Codes”. On some file systems, FSOpenFork will return the error eofErr if you try to open the resource fork of a file for which no resource fork exists with read-only access.
Discussion

When you use this function to open a file on a local volume and pass in a permissions value of fsCurPerm, fsWrPerm, or fsRdWrPerm , Mac OS X does not guarantee exclusive file access. Before making any assumptions about the underlying file access, you should always check to see whether the Supports Exclusive Locks feature is available. If this feature is not available, your application cannot know whether another application has access to the same file. For more information, see ADC Technical Note TN2037. 

To access named forks or forks larger than 2GB, you must use the FSOpenFork function or one of the corresponding parameter block calls: PBOpenForkSync and PBOpenForkAsync. To determine if the FSOpenFork function is present, call the Gestalt function. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
Files.h*/
OSErr FSOpenFork (
   const FSRef * ref,
   UniCharCount forkNameLength,
   const UniChar * forkName,
   SInt8 permissions,
   SInt16 * forkRefNum
);

/*FSGetCatalogInfo

Returns catalog information about a file or directory. You can use this function to map an FSRef to an FSSpec.

OSErr FSGetCatalogInfo (
   const FSRef * ref,
   FSCatalogInfoBitmap whichInfo,
   FSCatalogInfo * catalogInfo,
   HFSUniStr255 * outName,
   FSSpec * fsSpec,
   FSRef * parentRef
);
Parameters
ref

A pointer to an FSRef specifying the file or directory for which to retrieve information. See FSRef for a description of the FSRef data type. 
whichInfo

A bitmap specifying the catalog information fields to return. If you don’t want any catalog information, set whichInfo to the constant kFSCatInfoNone. See Catalog Information Bitmap Constants for a description of the bits in this parameter.
catalogInfo

On return, a pointer to a catalog information structure containing the information about the file or directory. Only the information specified in the whichInfo parameter is returned. If you don’t want any catalog information, pass NULL here. See FSCatalogInfo for a description of the FSCatalogInfo data type.
outName

On return, a pointer to the Unicode name of the file or directory is returned here. This parameter is optional; if you do not wish the name returned, pass NULL here. See HFSUniStr255 for a description of the HFSUniStr255 data type.
fsSpec

On return, a pointer to the FSSpec for the file or directory. This parameter is optional; if you do not wish the FSSpec returned, pass NULL here. See FSSpec for a description of the FSSpec data type.
parentRef

On return, a pointer to the FSRef for the object's parent directory. This parameter is optional; if you do not wish the parent directory returned, pass NULL here.

If the object specified in the ref parameter is a volume’s root directory, then the FSRef returned here will not be a valid FSRef, since the root directory has no parent object.
Return Value

A result code. See “File Manager Result Codes”.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Files.h*/
OSErr FSGetCatalogInfo (
   const FSRef * ref,
   FSCatalogInfoBitmap whichInfo,
   FSCatalogInfo * catalogInfo,
   HFSUniStr255 * outName,
   FSSpec * fsSpec,
   FSRef * parentRef
);