#ifndef IOCDTYPES_H
#define IOCDTYPES_H
#endif

/*Reading a Sector From the Device

Listing 1-6 shows a function, MyReadSector, that reads a sector of the media. The caller of this function passes the file descriptor for a device file. The device is assumed to be open. MyReadSector first uses the DKIOCGETBLOCKSIZE ioctl to get the preferred block size for the media. Then, it allocates a buffer of the preferred block size and attempts to read a sector, using the read function defined in the unistd.h. 

Listing 1-6  Reading a sector of the media, given the file descriptorBoolean MyReadSector( int fileDescriptor )
{
    char *buffer;
    size_t numBytes;
    u_int32_t blockSize;
 
    if ( ioctl( fileDescriptor, DKIOCGETBLOCKSIZE, &blockSize ) == -1)
    {
        perror( "Error getting preferred block size." );
        // Set a reasonable block size instead.
        // kCDSectorSizeCDDA is defined in IOCDTypes.h as 2352.
        blockSize = kCDSectorSizeCDDA;
    }
    buffer = malloc( blockSize );
    numBytes = read( fileDescriptor, buffer, blockSize );
    free( buffer );
    return numBytes == blockSize ? true : false;
}*/

#define kCDSectorSizeCDDA 2352