#ifndef LSINFO_H
#define LSINFO_H
#endif

/*Acceptance Flags

Specify behavior to observe when testing whether an application can accept (open) an item.

typedef OptionBits LSAcceptanceFlags;enum {
   kLSAcceptDefault = 0x00000001,
   kLSAcceptAllowLoginUI = 0x00000002
};
Constants
kLSAcceptDefault

Requests the default behavior (as opposed to the behavior specified by the kLSAcceptAllowLoginUI flag).

Available in Mac OS X v10.0 and later.
kLSAcceptAllowLoginUI

Requests that the user interface to log in be presented if necessary. If LSCanRefAcceptItem or LSCanURLAcceptURL is called during a drag-and-drop operation, showing a server login dialog would be an inappropriate user experience. If the target designated in the function call is an alias to an application, Launch Services needs to resolve the alias to ascertain what file types the application can open; however, if the application is on a server that needs to be authenticated, Launch Services will by default fail to resolve the alias, to avoid having to present the login interface. To override this default behavior by allowing the server login interface, set the kLSAcceptAllowLoginUI flag.

Available in Mac OS X v10.0 and later.
Discussion

These flags are passed to the functions LSCanRefAcceptItem and LSCanURLAcceptURL.*/
typedef OptionBits LSAcceptanceFlags;enum {
   kLSAcceptDefault = 0x00000001,
   kLSAcceptAllowLoginUI = 0x00000002
};

/*Roles Mask

Specify the desired role or roles for an application to claim with respect to an item or family of items.

typedef OptionBits LSRolesMask;enum {
   kLSRolesNone = 0x00000001,
   kLSRolesViewer = 0x00000002,
   kLSRolesEditor = 0x00000004,
   kLSRolesShell = 0x00000008,
   kLSRolesAll = 0xFFFFFFFF
};
Constants
kLSRolesNone

Requests the role None (the application cannot open the item, but provides an icon and a kind string for it).

Available in Mac OS X v10.0 and later.
kLSRolesViewer

Requests the role Viewer (the application can read and present the item, but cannot manipulate or save it).

Available in Mac OS X v10.0 and later.
kLSRolesEditor

Requests the role Editor (the application can read, present, manipulate, and save the item).

Available in Mac OS X v10.0 and later.
kLSRolesShell

Requests the role Shell (the application can execute the item).

Available in Mac OS X v10.4 and later.
kLSRolesAll

Accepts any role with respect to the item.

Available in Mac OS X v10.0 and later.
Discussion

This bit mask is passed to functions that find the preferred application for a given item or family of items (LSGetApplicationForItem, LSGetApplicationForURL, LSGetApplicationForInfo), or that determine whether a given application can open a designated item (LSCanRefAcceptItem, LSCanURLAcceptURL), to specify the application’s desired role or roles with respect to the item. For example, to request only an editor application, specify kLSRolesEditor; if either an editor or a viewer application is acceptable, specify kLSRolesEditor | kLSRolesViewer.*/
typedef OptionBits LSRolesMask;enum {
   kLSRolesNone = 0x00000001,
   kLSRolesViewer = 0x00000002,
   kLSRolesEditor = 0x00000004,
   kLSRolesShell = 0x00000008,
   kLSRolesAll = 0xFFFFFFFF
};

/*LSKindID

Data type of the kindID field of an item-information record (LSItemInfoRecord); no longer used.

typedef UInt32 LSKindID;
Availability
Available in Mac OS X v10.0 and later.*/
typedef UInt32 LSKindID;

/*Item-Information Flags

Provide information about an item.

typedef OptionBits LSItemInfoFlags;enum {
   kLSItemInfoIsPlainFile = 0x00000001,
   kLSItemInfoIsPackage = 0x00000002,
   kLSItemInfoIsApplication = 0x00000004,
   kLSItemInfoIsContainer = 0x00000008,
   kLSItemInfoIsAliasFile = 0x00000010,
   kLSItemInfoIsSymlink = 0x00000020,
   kLSItemInfoIsInvisible = 0x00000040,
   kLSItemInfoIsNativeApp = 0x00000080,
   kLSItemInfoIsClassicApp = 0x00000100,
   kLSItemInfoAppPrefersNative = 0x00000200,
   kLSItemInfoAppPrefersClassic = 0x00000400,
   kLSItemInfoAppIsScriptable = 0x00000800,
   kLSItemInfoIsVolume = 0x00001000,
   kLSItemInfoExtensionIsHidden = 0x00100000
};
Constants
kLSItemInfoIsPlainFile

Item is a data file (and not, for example, a directory, volume, or UNIX symbolic link).

Available in Mac OS X v10.0 and later.
kLSItemInfoIsPackage

Item is a packaged directory.

Available in Mac OS X v10.0 and later.
kLSItemInfoIsApplication

Item is a single-file or packaged application.

Available in Mac OS X v10.0 and later.
kLSItemInfoIsContainer

Item is a directory (includes packages) or volume.

Available in Mac OS X v10.0 and later.
kLSItemInfoIsAliasFile

Item is an alias file (includes symbolic links).

Available in Mac OS X v10.0 and later.
kLSItemInfoIsSymlink

Item is a UNIX symbolic link.

Available in Mac OS X v10.0 and later.
kLSItemInfoIsInvisible

Item is invisible, because either its name begins with a period or its isInvisible Finder flag is set.

Available in Mac OS X v10.0 and later.
kLSItemInfoIsNativeApp

Item is an application that can run natively in Mac OS X.

Available in Mac OS X v10.0 and later.
kLSItemInfoIsClassicApp

Item is an application that cannot run natively and must be launched in the Classic emulation environment.

Available in Mac OS X v10.0 and later.
kLSItemInfoAppPrefersNative

Item is an application that can run either natively or in the Classic emulation environment, but prefers to be launched natively. This flag is valid only when kLSItemInfoIsNativeApp is set.

Available in Mac OS X v10.0 and later.
kLSItemInfoAppPrefersClassic

Item is an application that can run either natively or in the Classic emulation environment, but prefers to be launched in the Classic environment. This flag is valid only when kLSItemInfoIsNativeApp is set.

Available in Mac OS X v10.0 and later.
kLSItemInfoAppIsScriptable

Item is an application that can be scripted.

Available in Mac OS X v10.0 and later.
kLSItemInfoIsVolume

Item is the root directory of a volume or mount point.

Available in Mac OS X v10.0 and later.
kLSItemInfoExtensionIsHidden

Item has a hidden filename extension.

Available in Mac OS X v10.1 and later.
Discussion

These flags are set in an item-information record to provide information about an item; see “LSItemInfoRecord” for a description of this structure.*/
typedef OptionBits LSItemInfoFlags;enum {
   kLSItemInfoIsPlainFile = 0x00000001,
   kLSItemInfoIsPackage = 0x00000002,
   kLSItemInfoIsApplication = 0x00000004,
   kLSItemInfoIsContainer = 0x00000008,
   kLSItemInfoIsAliasFile = 0x00000010,
   kLSItemInfoIsSymlink = 0x00000020,
   kLSItemInfoIsInvisible = 0x00000040,
   kLSItemInfoIsNativeApp = 0x00000080,
   kLSItemInfoIsClassicApp = 0x00000100,
   kLSItemInfoAppPrefersNative = 0x00000200,
   kLSItemInfoAppPrefersClassic = 0x00000400,
   kLSItemInfoAppIsScriptable = 0x00000800,
   kLSItemInfoIsVolume = 0x00001000,
   kLSItemInfoExtensionIsHidden = 0x00100000
};

/*LSItemInfoRecord

Contains requested information about an item.

struct LSItemInfoRecord {
   LSItemInfoFlags flags;
   OSType filetype;
   OSType creator;
   CFStringRef extension;
   CFStringRef iconFileName;
   LSKindID kindID;
};
typedef struct LSItemInfoRecord LSItemInfoRecord;
Fields
flags

Item-information flags specifying information about the item; see “Item-Information Flags” for a description of these flags.
filetype

The item’s file type.
creator

The item’s creator signature.
extension

A Core Foundation string object specifying the item’s filename extension; see the CFString Reference in the Core Foundation Reference Documentation for a description of the CFStringRef data type.
iconFileName

No longer used.
kindID

No longer used.
Discussion

This data type defines an item-information record used by the LSCopyItemInfoForRef and LSCopyItemInfoForURL functions to return requested information about an item.
Availability
Available in Mac OS X v10.0 and later.*/
struct LSItemInfoRecord {
   LSItemInfoFlags flags;
   OSType filetype;
   OSType creator;
   CFStringRef extension;
   CFStringRef iconFileName;
   LSKindID kindID;
};
typedef struct LSItemInfoRecord LSItemInfoRecord;

/*Requested-Information Flags

Specify what information to obtain about an item.

typedef OptionBits LSRequestedInfo;enum {
   kLSRequestExtension = 0x00000001,
   kLSRequestTypeCreator = 0x00000002,
   kLSRequestBasicFlagsOnly = 0x00000004,
   kLSRequestAppTypeFlags = 0x00000008,
   kLSRequestAllFlags = 0x00000010,
   kLSRequestIconAndKind = 0x00000020,
   kLSRequestExtensionFlagsOnly = 0x00000040,
   kLSRequestAllInfo = 0xFFFFFFFF
};
Constants
kLSRequestExtension

Requests the item’s filename extension.

Available in Mac OS X v10.0 and later.
kLSRequestTypeCreator

Requests the item’s file type and creator signature.

Available in Mac OS X v10.0 and later.
kLSRequestBasicFlagsOnly

Requests all item-information flags that are not application-specific: that is, all except kLSItemInfoIsNativeApp through kLSItemInfoAppIsScriptable.

Available in Mac OS X v10.0 and later.
kLSRequestAppTypeFlags

Requests all application-specific item-information flags: that is, kLSItemInfoIsNativeApp through kLSItemInfoAppIsScriptable.

Available in Mac OS X v10.0 and later.
kLSRequestAllFlags

Requests all item-information flags.

Available in Mac OS X v10.0 and later.
kLSRequestIconAndKind

Not used.

Available in Mac OS X v10.0 and later.
kLSRequestExtensionFlagsOnly

Requests only the kLSItemInfoExtensionIsHidden item-information flag.

Available in Mac OS X v10.1 and later.
kLSRequestAllInfo

Requests all available item information.

Available in Mac OS X v10.0 and later.
Discussion

These flags are passed to the LSCopyItemInfoForRef and LSCopyItemInfoForURL functions to specify the type of information to be obtained in an item-information record; see “LSItemInfoRecord” for a description of this structure.*/
typedef OptionBits LSRequestedInfo;enum {
   kLSRequestExtension = 0x00000001,
   kLSRequestTypeCreator = 0x00000002,
   kLSRequestBasicFlagsOnly = 0x00000004,
   kLSRequestAppTypeFlags = 0x00000008,
   kLSRequestAllFlags = 0x00000010,
   kLSRequestIconAndKind = 0x00000020,
   kLSRequestExtensionFlagsOnly = 0x00000040,
   kLSRequestAllInfo = 0xFFFFFFFF
};


/*LSCopyDisplayNameForRef

Obtains the display name for an item designated by file-system reference.

OSStatus LSCopyDisplayNameForRef (
   const FSRef *inRef,
   CFStringRef *outDisplayName
);
Parameters
inRef

A pointer to a file-system reference designating the item whose display name is requested; see the File Manager Reference in the Carbon File Management Documentation for a description of the FSRef data type.
outDisplayName

A pointer to a Core Foundation string object that, on return, will contain the items display name; see the CFString Reference in the Core Foundation Reference Documentation for a description of the CFStringRef data type. You are responsible for releasing this object.
Return Value

A result code; see Launch Services Result Codes.
Discussion

The items display name is returned in the form in which it will appear on the users screen; it may be localized (for applications and folders), and it excludes the filename extension if the extension is set to be hidden and the Finder preference to always show extensions is not enabled.
Version Notes

Thread-safe since Mac OS version 10.2.
Availability
Available in Mac OS X v10.1 and later.
Declared In
LSInfo.h*/
OSStatus LSCopyDisplayNameForRef (
   const FSRef *inRef,
   CFStringRef *outDisplayName
);

/*LSCopyItemInfoForRef

Obtains requested information about an item designated by file-system reference.

OSStatus LSCopyItemInfoForRef (
   const FSRef *inItemRef,
   LSRequestedInfo inWhichInfo,
  OSStatus LSCopyItemInfoForRef (
   const FSRef *inItemRef,
   LSRequestedInfo inWhichInfo,
   LSItemInfoRecord *outItemInfo
); LSItemInfoRecord *outItemInfo
);
Parameters
inItemRef

A pointer to a file-system reference designating the item about which information is requested; see the File Manager Reference in the Carbon File Management Documentation for a description of the FSRef data type.
inWhichInfo

Flags specifying what information to obtain; see “Requested-Information Flags” for a description of these flags.
outItemInfo

A pointer to an item-information record that, on return, will contain the requested information; see “LSItemInfoRecord” for a description of this structure.

If you request the item’s filename extension (field extension of the item-information record, requested by flag kLSRequestExtension), you are responsible for releasing the Core Foundation string object in which the extension is returned.
Return Value

A result code; see “Launch Services Result Codes”.
Discussion

The information obtained about an item can include its filename extension, file type, creator signature, and various item-information flags (indicating, for example, whether the item is an application, or whether it has a hidden extension); see “Item-Information Flags” for a description of these flags.
Version Notes

Thread-safe since Mac OS version 10.2.
Availability
Available in Mac OS X v10.0 and later.
Declared In
LSInfo.h*/
OSStatus LSCopyItemInfoForRef (
   const FSRef *inItemRef,
   LSRequestedInfo inWhichInfo,
   LSItemInfoRecord *outItemInfo
);

/*LSCanRefAcceptItem

Tests whether an application can accept (open) an item designated by file-system reference.

OSStatus LSCanRefAcceptItem (
   const FSRef *inItemFSRef,
   const FSRef *inTargetFSRef,
   LSRolesMask inRolesMask,
   LSAcceptanceFlags inFlags,
   Boolean *outAcceptsItem
);
Parameters
inItemFSRef

A pointer to a file-system reference designating the source item (the item to test for acceptance by the target application); see the File Manager Reference in the Carbon File Management Documentation for a description of the FSRef data type.
inTargetFSRef

A pointer to a file-system reference designating the target application; see the File Manager Reference in the Carbon File Management Documentation for a description of the FSRef data type.
inRolesMask

A bit mask specifying the target application’s desired role or roles with respect to the source item; see “Roles Mask” for a description of this mask. If the role is unimportant, pass kLSRolesAll.
inFlags

Flags specifying behavior to observe during the acceptance test; see “Acceptance Flags” for a description of these flags.
outAcceptsItem

A pointer to a Boolean value that, on return, will indicate whether the target application can accept the source item with at least one of the specified roles.
Return Value

A result code; see “Launch Services Result Codes”.
Version Notes

Thread-safe since Mac OS version 10.2.
Availability
Available in Mac OS X v10.0 and later.
Declared In
LSInfo.h*/
OSStatus LSCanRefAcceptItem (
   const FSRef *inItemFSRef,
   const FSRef *inTargetFSRef,
   LSRolesMask inRolesMask,
   LSAcceptanceFlags inFlags,
   Boolean *outAcceptsItem
);