#ifndef COREAUDIO_H
 #include <CoreAudio/CoreAudio.h>
#endif


#ifndef CORESERVICE_H
 #include <CoreService/CoreService.h>
#endif

#ifndef COREFOUNDAYION_H
 #include <CoreFoundation/CoreFoundation.h>
#endif

#include <libkern/OSTypes.h>

/*FSPathMakeRef

Converts a path into an FSRef structure.

OSStatus FSPathMakeRef (
   const UInt8 * path,
   FSRef * ref,
   Boolean * isDirectory
);
Parameters
path

The path for which to return an FSRef. This path can be used by POSIX-style calls. 
ref

On return, a pointer to the FSRef. 
isDirectory

A Boolean value indicating whether the object at specified by the given path is a directory. This parameter is optional and can be NULL. 
Return Value

A result code. See File Manager Result Codes.
Special Considerations

This function, though available through Carbon on Mac OS 8 and 9, is only implemented on Mac OS X.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Files.h*/
OSStatus FSPathMakeRef (const UInt8 * path,FSRef * ref,Boolean * isDirectory){
//TODO
};

/*FSOpenResourceFile

Opens the specified named fork as a resource fork.

OSErr FSOpenResourceFile (
   const FSRef * ref,
   UniCharCount forkNameLength,
   const UniChar * forkName,
   SInt8 permissions,
   SInt16 * refNum
);
Parameters
ref

A pointer to an FSRef representing the file containing the fork to open. See the File Manager documentation for a description of the FSRef data type.
forkNameLength

A value of type UniCharCount representing the length of the fork name (in Unicode characters).
forkName

A pointer to a value of type UniChar representing he name of the fork to open (in Unicode). This pointer may be set to NULL.
permissions

A constant indicating the type of access with which to open the resource fork. For a description of the types of access you can request, see the section File Access Permission Constants in File Manager Reference.
refNum

A pointer to a value of type SInt16. On return, this points to the reference number for accessing the open fork.
Return Value

A result code. See Resource Manager Result Codes.
Discussion

This function allows any named fork of a file to be used for storing resources. Passing in a null forkname will result in the data fork being used.
Availability
Available in CarbonLib 1.3 and later.
Available in Mac OS X 10.0 and later.
Declared In
Resources.h*/
OSErr FSOpenResourceFile (
   const FSRef * ref,
   UniCharCount forkNameLength,
   const UniChar * forkName,
   SInt8 permissions,
   SInt16 * refNum){
//TODO
};

/*FSOpenResFile

Opens a resource file using a file system reference (FSRef).

short FSOpenResFile (
   const FSRef * ref,
   SInt8 permission
);
Availability
Available in CarbonLib 1.1 and later when running Mac OS 9.1 or later.
Available in Mac OS X 10.0 and later.
Declared In
Resources.h*/
short FSOpenResFile (
   const FSRef * ref,
   SInt8 permission){
//TODO
};

/*FSFindFolder

Obtains location information for system-related directories.

OSErr FSFindFolder (
   short vRefNum,
   OSType folderType,
   Boolean createFolder,
   FSRef * foundRef
);
Parameters
vRefNum

Pass the volume reference number of the volume on which you want to locate a directory, or a constant specifying a disk or domain. The constants which you can use in this parameter are described in Disk and Domain Constants.

Note that, on Mac OS X, passing a volume reference number in this parameter does not make sense for most of the folder type selectors which you can specify in the folderType parameter. On Mac OS X, folders are "domain-oriented"; because there may be more than one domain on any given physical volume, asking for these folders on a per-volume basis yields undefined results. For example, if you were to request the Fonts folder (represented by the selector kFontsFolderType)on volume -100, are you requesting the folder /System/Library/Fonts, /Library/Fonts, or ~/Fonts? On Mac OS X you should pass a disk or domain constant in this parameter.
folderType

Pass a four-character folder type, or a constant that represents the type, for the folder you want to find; see Folder Type Constants.
createFolder

A value of type Boolean, as defined in Create Folder Flags. Pass the constant kCreateFolder to create a directory if it does not already exist; otherwise, pass the constant kDontCreateFolder. Passing kCreateFolder will not create a parent folder; if the parent of the target folder does not already exist, attempting to create the target will fail.
foundRef

A pointer to a file system reference. On return, the FSRef refers to the directory specified by the vRefNum and folderType parameters.
Return Value

A result code. See "Folder Manager Result Codes".
Availability
Available in Mac OS X v10.0 and later.
Declared In
Folders.h*/
OSErr FSFindFolder (
   short vRefNum,
   OSType folderType,
   Boolean createFolder,
   FSRef * foundRef){
//TODO
};

/*FSRefMakePath

Converts an FSRef into a path.

OSStatus FSRefMakePath (
   const FSRef * ref,
   UInt8 * path,
   UInt32 maxPathSize
);
Parameters
ref

The FSRef to convert into a path. 
path

On return, a pointer to the path. This path can be used by POSIX-style calls. 
pathSize

The size of the path. 
Return Value

A result code. See File Manager Result Codes.
Special Considerations

This function, though available through Carbon on Mac OS 8 and 9, is only implemented on Mac OS X.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Files.h*/
OSStatus FSRefMakePath (
   const FSRef * ref,
   UInt8 * path,
   UInt32 maxPathSize){
//TODO
};

int  UseResFile(){
//TODO
};

int CloseResFile(){
//TODO
};

int  Get1IndResource(){
//TODO
};

int  GetResource(){
//TODO
};

int  ReleaseResource(){
//TODO
};

int HLock(){
//TODO
};

int HUnlock(){
//TODO
};

int  GetHandleSize(){
//TODO
};