#ifndef	HYS_H
#include <OC_Cocoa/hys.h>
#endif

#ifndef KPI_MBUF_H
#include <sys/kpi_mbuf.h>
#endif


/*mbuf_freem

void mbuf_freem(
    mbuf_t mbuf);  
Parameters
mbuf
The first mbuf in the chain to free.
Discussion 

Frees a chain of mbufs link through mnext.*/
void mbuf_freem(mbuf_t mbuf){
//TODO
};


/*mbuf_gethdr

errno_t mbuf_gethdr(
    mbuf_how_t how,
    mbuf_type_t type,
    mbuf_t*mbuf);  
Parameters
how
Blocking or non-blocking.
type
The type of the mbuf.
mbuf
The mbuf.
Return Value

0 on success, errno error on failure. 
Discussion 

Allocates an mbuf without a cluster for external data. Sets a flag to indicate there is a packet header and initializes the packet header.*/
errno_t mbuf_gethdr(
    mbuf_how_t how,
    mbuf_type_t type,
    mbuf_t*mbuf){
//TODO
};  


/*mbuf_setnext

errno_t mbuf_setnext(
    mbuf_t mbuf,
    mbuf_t next);  
Parameters
mbuf
The mbuf.
next
The new next mbuf.
Return Value

0 upon success otherwise the errno error. 
Discussion 

Sets the next mbuf in the chain.*/
errno_t mbuf_setnext(
    mbuf_t mbuf,
    mbuf_t next){
//TODO
};  


/*mbuf_setnextpkt

void mbuf_setnextpkt(
    mbuf_t mbuf,
    mbuf_t nextpkt);  
Parameters
mbuf
The mbuf.
nextpkt
The new next packet.
Discussion 

Sets the next packet attached to this mbuf.*/
void mbuf_setnextpkt(
    mbuf_t mbuf,
    mbuf_t nextpkt){
//TODO
};  


/*mbuf_nextpkt

mbuf_t mbuf_nextpkt(
    mbuf_t mbuf);  
Parameters
mbuf
The mbuf.
Return Value

The nextpkt. 
Discussion 

Gets the next packet from the mbuf.*/
mbuf_t mbuf_nextpkt(
    mbuf_t mbuf){
//TODO
};  


/*mbuf_pkthdr_setlen

void mbuf_pkthdr_setlen(
    mbuf_t mbuf,
    size_t len);  
Parameters
mbuf
The mbuf containing the packet header.
len
The new length of the packet.
Return Value

0 upon success otherwise the errno error. 
Discussion 

Sets the length of the packet in the packet header.*/
void mbuf_pkthdr_setlen(
    mbuf_t mbuf,
    size_t len){
//TODO
};  


/*mbuf_setlen

void mbuf_setlen(
    mbuf_t mbuf,
    size_t len);  
Parameters
mbuf
The mbuf.
len
The new length.
Return Value

0 upon success otherwise the errno error. 
Discussion 

Sets the length of data in this packet. Be careful to not set the length over the space available in the mbuf.*/
void mbuf_setlen(
    mbuf_t mbuf,
    size_t len){
//TODO
};  


/*mbuf_pkthdr_setrcvif

errno_t mbuf_pkthdr_setrcvif(
    mbuf_t mbuf,
    ifnet_t ifnet);  
Parameters
mbuf
The mbuf containing the packet header.
ifnet
A reference to an interface.
Return Value

0 upon success otherwise the errno error. 
Discussion 

Sets the interface the packet was received on.*/
errno_t mbuf_pkthdr_setrcvif(
    mbuf_t mbuf,
    ifnet_t ifnet){
//TODO
};  


/*mbuf_tag_find

errno_t mbuf_tag_find(
    mbuf_t mbuf,
    mbuf_tag_id_t module_id, 
    mbuf_tag_type_t type,
    size_t *length,
    void** data_p);  
Parameters
mbuf
The mbuf the tag is attached to.
module_id
A module identifier returned by mbuf_tag_id_find.
type
The 16 bit type of the tag to find.
length
Upon success, the length of data will be store in *length.
data_p
Upon successful return, *data_p will point to the buffer allocated for the mtag.
Return Value

0 upon success otherwise the errno error. 
Discussion 

Find the data associated with an mbuf tag.*/

errno_t mbuf_tag_find(
    mbuf_t mbuf,
    mbuf_tag_id_t module_id, 
    mbuf_tag_type_t type,
    size_t *length,
    void** data_p){
//TODO
};  



/*mbuf_tag_allocate

errno_t mbuf_tag_allocate(
    mbuf_t mbuf,
    mbuf_tag_id_t module_id, 
    mbuf_tag_type_t type,
    size_t length, 
    mbuf_how_t how,
    void** data_p);  
Parameters
mbuf
The mbuf to attach this tag to.
module_id
A module identifier returned by mbuf_tag_id_find.
type
A 16 bit type value. For a given module_id, you can use a number of different tag types.
length
The length, in bytes, to allocate for storage that will be associated with this tag on this mbuf.
how
Indicate whether you want to block and wait for memory if memory is not immediately available.
data_p
Upon successful return, *data_p will point to the buffer allocated for the mtag.
Return Value

0 upon success otherwise the errno error. 
Discussion 

Allocate an mbuf tag. Mbuf tags allow various portions of the stack to tag mbufs with data that will travel with the mbuf through the stack. 

Tags may only be added to mbufs with packet headers (MBUF_PKTHDR flag is set). Mbuf tags are freed when the mbuf is freed or when mbuf_tag_free is called.*/
errno_t mbuf_tag_allocate(
    mbuf_t mbuf,
    mbuf_tag_id_t module_id, 
    mbuf_tag_type_t type,
    size_t length, 
    mbuf_how_t how,
    void** data_p){
//TODO
};  


/*mbuf_flags

mbuf_flags_t mbuf_flags(
    mbuf_t mbuf);  
Parameters
mbuf
The mbuf.
Return Value

The flags. 
Discussion 

Returns the set flags.*/
mbuf_flags_t mbuf_flags(
    mbuf_t mbuf){
//TODO
};  


/*mbuf_len

size_t mbuf_len(
    mbuf_t mbuf);  
Parameters
mbuf
The mbuf.
Return Value

The length. 
Discussion 

Gets the length of data in this mbuf.*/

size_t mbuf_len(
    mbuf_t mbuf){
//TODO
};  


/*mbuf_next

mbuf_t mbuf_next(
    mbuf_t mbuf);  
Parameters
mbuf
The mbuf.
Return Value

The next mbuf in the chain. 
Discussion 

Returns the next mbuf in the chain.*/
mbuf_t mbuf_next(
    mbuf_t mbuf){
//TODO
};  
