//incl
#ifndef AEDATAMODEL_H
#define AEDATAMODEL_H


#ifndef CORESERVICES_H
#include <CoreServices/CoreServices.h>
#endif


#include <AvailabilityMacros.h>

#if PRAGMA_ONCE
#pragma once
#endif

#ifdef __cplusplus
extern "C" {
#endif



/*Descriptor Type Constants

Specify types for descriptors.

enum {
   typeAEList = 'list',
   typeAERecord = 'reco',
   typeAppleEvent = 'aevt',
   typeEventRecord = 'evrc',
   typeTrue = 'true',
   typeFalse = 'fals',
   typeAlias = 'alis',
   typeEnumerated = 'enum',
   typeType = 'type',
   typeAppParameters = 'appa',
   typeProperty = 'prop',
   typeFSS = 'fss ',
   typeFSRef = 'fsrf',
   typeFileURL = 'furl',
   typeKeyword = 'keyw',
   typeSectionH = 'sect',
   typeWildCard = '****',
   typeApplSignature = 'sign',
   typeQDRectangle = 'qdrt',
   typeFixed = 'fixd',
   typeProcessSerialNumber = 'psn ',
   typeApplicationURL = 'aprl',
   typeNull = 'null'
};
Constants
typeAEList

List of descriptors.

Available in Mac OS X v10.0 and later.
typeAERecord

List of keyword-specified descriptors.

Available in Mac OS X v10.0 and later.
typeAppleEvent

Apple event.

Available in Mac OS X v10.0 and later.
typeTrue

TRUE Boolean value.

Available in Mac OS X v10.0 and later.
typeFalse

FALSE Boolean value.

Available in Mac OS X v10.0 and later.
typeAlias

Alias.

Available in Mac OS X v10.0 and later.
typeEnumerated

Enumerated data.

Available in Mac OS X v10.0 and later.
typeType

Four-character code for event class or event ID

Available in Mac OS X v10.0 and later.
typeAppParameters

Process Manager launch parameters.

Available in Mac OS X v10.0 and later.
typeProperty

Apple event object property.

Available in Mac OS X v10.0 and later.
typeFSS

File system specification. Deprecated in Mac OS X. Use file system references (typeFSRef) instead.

Available in Mac OS X v10.0 and later.
typeFSRef

File system reference. Use in preference to file system specifications (typeFSS).

Available in Mac OS X v10.0 and later.
typeFileURL

A file URL. A descriptor of this type doesn't represent a CFURL, it represents a C-string-style file path.

Available in Mac OS X v10.1 and later.
typeKeyword

Apple event keyword.

Available in Mac OS X v10.0 and later.
typeSectionH

Handle to a section record. (Deprecated.)

Available in Mac OS X v10.0 and later.
typeWildCard

Matches any type.

Available in Mac OS X v10.0 and later.
typeApplSignature

Application signature.

Available in Mac OS X v10.0 and later.
typeProcessSerialNumber

A process serial number. See also AEAddressDesc.

Available in Mac OS X v10.0 and later.
typeApplicationURL

For specifying an application by URL. See Discussion session below for format.

Available in Mac OS X v10.1 and later.
typeNull

A null data storage pointer. When resolving an object specifier, an object with a null storage pointer specifies the default container at the top of the container hierarchy.

Available in Mac OS X v10.0 and later.
Discussion

The constants described here specify the data type for a descriptor and show the kind of data stored in a descriptor with that type.

Descriptors are the building blocks used by the Apple Event Manager to construct Apple event attributes and parameters. A descriptor is a data structure of type AEDesc, which consists of data storage and a descriptor type that identifies the type of the data. A descriptor type is defined by the data type DescType. 

AppleScript defines descriptor type constants for a wide variety of common data types. For additional types, see “Numeric Descriptor Type Constants” and “Other Descriptor Type Constants”. For a complete listing, including data types such as units of length, weight, and volume, see the Apple Event Manager and Open Scripting Architecture header files.

For the constant typeApplicationURL, the data that specifies the application URL takes the following format:eppc://[username[:password]@]host/AppName[[?uid=#]&[pid=#]]


As indicated by this format:
username is optional. If present, an '@' must appear before the host name. password is optional. If present, username is not optional, and the password must be separated from the username by a ':' and must precede the '@'. AppName is not optional; if it contains non-UTF-8 characters or white space, it must be URL-encoded (for example, My%20Application).
uid and pid are optional. If pid is present, uid and AppName are ignored and the event is delivered only to applications with the given process id. If uid is present, events are directed to the application name owned by the given user id.

The following are examples of valid URLs:eppc://Steve%20Zellers:wombat@grrr.apple.com/Microsoft%20Word
eppc://Steve%20Zellers:wombat@grrr.apple.com/Microsoft%20Word?pid=1284
AEDatamodel.h*/
enum {
   typeAEList = 'list',
   typeAERecord = 'reco',
   typeAppleEvent = 'aevt',
   typeEventRecord = 'evrc',
   typeTrue = 'true',
   typeFalse = 'fals',
   typeAlias = 'alis',
   typeEnumerated = 'enum',
   typeType = 'type',
   typeAppParameters = 'appa',
   typeProperty = 'prop',
   typeFSS = 'fss ',
   typeFSRef = 'fsrf',
   typeFileURL = 'furl',
   typeKeyword = 'keyw',
   typeSectionH = 'sect',
   typeWildCard = '****',
   typeApplSignature = 'sign',
   typeQDRectangle = 'qdrt',
   typeFixed = 'fixd',
   typeProcessSerialNumber = 'psn ',
   typeApplicationURL = 'aprl',
   typeNull = 'null'
};


/*Other Descriptor Type Constants

Specify types for Boolean and character descriptors.

enum {
   typeBoolean = 'bool',
   typeChar = 'TEXT'
};
Constants
typeBoolean

Boolean value—single byte with value 0 or 1.

Available in Mac OS X v10.0 and later.
typeChar

Unterminated string of system script characters.

See the Version Notes section below for important information.

Available in Mac OS X v10.0 and later.
Discussion

The constants described here specify the data type for a descriptor and show the kind of data stored in a descriptor with that type.

Descriptors are the building blocks used by the Apple Event Manager to construct Apple event attributes and parameters. A descriptor is a data structure of type AEDesc, which consists of data storage and a descriptor type that identifies the type of the data. A descriptor type is defined by the data type DescType. 

AppleScript defines descriptor type constants for a wide variety of common data types. For additional types, see “Descriptor Type Constants” and “Numeric Descriptor Type Constants”. For a complete listing, including data types such as units of length, weight, and volume, see the Apple Event Manager and Open Scripting Architecture header files.
Version Notes

On Mac OS X typeChar type is deprecated in favor of typeUTF8Text or typeUTF16ExternalRepresentation. For more information, see typeUTF16ExternalRepresentation.
AEDataModel.h*/
enum {
   typeBoolean = 'bool',
   typeChar = 'TEXT'
};


/*ID Constants for the AECreateAppleEvent Function

Specify values for the ID parameters of the AECreateAppleEvent function.

enum {
   kAutoGenerateReturnID = -1,
   kAnyTransactionID = 0
};
Constants
kAutoGenerateReturnID

If you pass this value for the returnID parameter of the AECreateAppleEvent function, the Apple Event Manager assigns to the created Apple event a return ID that is unique to the current session.

Available in Mac OS X v10.0 and later.
kAnyTransactionID

You pass this value for the transactionID parameter of the AECreateAppleEvent function if the Apple event is not one of a series of interdependent Apple events.

A transaction is a sequence of Apple events that are sent back and forth between the client and server applications, beginning with the client’s initial request for a service. All Apple events that are part of a transaction must have the same transaction ID.

Available in Mac OS X v10.0 and later.
Discussion

You use these constants with the AECreateAppleEvent function.
AEDataModel.h*/
enum {
   kAutoGenerateReturnID = -1,
   kAnyTransactionID = 0
};

/*DescType

Specifies the type of the data stored in an AEDesc descriptor.

typedef ResType DescType;
Discussion

A DescType data type is a four-character code that stores a value that identifies the data in an AEDesc descriptor, the basic building block for all Apple events.

The descriptor type constants used by the Apple Event Manager are described in “Descriptor Type Constants” and “Key Form and Descriptor Type Object Specifier Constants”. 
Availability
Available in Mac OS X v10.0 and later.
AEDataModel.h*/
typedef ResType DescType;

/*AEDataStorage

A pointer to an opaque data type that provides storage for an AEDesc descriptor.

typedef AEStorageDataType * AEDataStorage;
Discussion

The Apple Event Manager defines the AEDataStorage data type to serve as a data storage field in the AEDesc structure. Your application doesnt access the data pointed to by a data storage pointer directly. Rather, you work with the following functions:
AEGetDescDataSize
AEGetDescData
AEGetDescDataRange
AEReplaceDescData
Availability
Available in Mac OS X v10.0 and later.
AEDataModel.h*/
//typedef AEStorageDataType * AEDataStorage;
typedef Handle AEDataStorage; //?

/*AEDesc

Stores data and an accompanying descriptor type to form the basic building block of all Apple Events.

struct AEDesc {
   DescType descriptorType;
   AEDataStorage dataHandle;
};
typedef struct AEDesc AEDesc;
Fields
descriptorType

A four-character code of type DescType that indicates the type of data in the structure. See DescType.
dataHandle

An opaque storage type that points to the storage for the descriptor data. Your application doesn’t access this data directly—rather, it calls one of the functions AEGetDescDataSize, AEGetDescData, or AEReplaceDescData. See AEDataStorage.
Discussion

The Apple Event Manager uses one or more descriptors to construct Apple event attributes and parameters, object specifiers, tokens, and many other types of data it works with. (Token is defined in AEDisposeToken.) A descriptor consists of an opaque data storage container and a descriptor type that identifies the type of the data stored in the descriptor.

The descriptor type is a structure of type DescType, which in turn is of data type ResType—that is, a four-character code. “Descriptor Type Constants” lists the constants for the basic descriptor types used by the Apple Event Manager. For information about descriptor types used with object specifiers, see “Key Form and Descriptor Type Object Specifier Constants”. 
Version Notes

Prior to Carbon, the AEDataStorage data type was defined as follows:typedef Handle AEDataStorage;

Availability
Available in Mac OS X v10.0 and later.
AEDataModel.h*/
struct AEDesc {
   DescType descriptorType;
   AEDataStorage dataHandle;
};
typedef struct AEDesc AEDesc;


/*AEDescList

A descriptor whose data consists of a list of one or more descriptors.

typedef AEDesc AEDescList;
Discussion

A descriptor list is identical to a descriptor of data type AEDesc ?the only difference is that the data in a descriptor list must always consist of a list of other descriptors.

Descriptor lists are a key building block of Apple events. Many Apple Event Manager functions take or return lists of descriptors in descriptor lists. For example, see the functions described in Counting the Items in Descriptor Lists and Getting Items From Descriptor Lists.

The format of the data in the dataHandle of the descriptor is private. You can only operate on the contained elements with Apple Event Manager functions, including those described in Counting the Items in Descriptor Lists and Getting Items From Descriptor Lists. 
Availability
Available in Mac OS X v10.0 and later.
AEDaraModel.h*/
typedef AEDesc AEDescList;



/*AERecord

A descriptor whose data is a list of keyword-specified descriptors.

typedef AEDescList AERecord;
Discussion

The Apple Event Manager provides routines that allow your application to create Apple event records and extract data from them when creating or responding to Apple events. You also work with Apple event records if your application resolves or creates object specifiers. Functions that use Apple event records are described in “Getting Data or Descriptors From Apple Events” and “Adding Parameters and Attributes to an Apple Event”. 

The descriptor list of keyword-specified descriptors in an Apple event record must specify Apple event parameters—they cannot specify Apple event attributes. Only descriptor lists of type Apple event can contain both attributes and parameters.
Availability
Available in Mac OS X v10.0 and later.*/
typedef AEDescList AERecord;


/*AppleEvent

A descriptor whose data is a list of descriptors containing both attributes and parameters that make up an Apple event.

typedef AERecord AppleEvent;
Discussion

The Apple event data type describes a full-fledged Apple event. Like the data for an Apple event record (data type AERecord), the data for an Apple event consists of a list of keyword-specified descriptors. Unlike an Apple event record, the data for an Apple event is conceptually divided into two parts, one for attributes and one for parameters. This division within the Apple event allows the Apple Event Manager to distinguish between an event’s attributes and its parameters.

For additional information on the structure of an Apple event and on how to build one, see “Building an Apple Event” in Apple Events Programming Guide.

Many functions work with Apple events, including the functions described in “Getting Data or Descriptors From Apple Events”, “Adding Parameters and Attributes to an Apple Event”, “Creating an Apple Event”, and “Sending an Apple Event”. 
Availability
Available in Mac OS X v10.0 and later.*/
typedef AERecord AppleEvent;


/*AEEventID

Specifies the event ID of an Apple event.

typedef FourCharCode AEEventID;
Discussion

Apple events are identified by their event class and event ID attributes. The event ID is the attribute that identifies a particular Apple event within its event class. In conjunction with the event class, the event ID uniquely identifies the Apple event and communicates what action the Apple event should perform.

For more information on Apple event IDs, see “Event ID Constants”. 
Availability
Available in Mac OS X v10.0 and later.
AEDataModel.h*/
typedef FourCharCode AEEventID;






/*AEEventHandlerProcPtr

Defines a pointer to a function that handles one or more Apple events. Your Apple event handler function performs any action requested by the Apple event, adds parameters to the reply Apple event if appropriate (possibly including error information), and returns a result code.

typedef OSErr (*AEEventHandlerProcPtr)
(
   const AppleEvent * theAppleEvent,
   AppleEvent * reply,
   long handlerRefcon
);

If you name your function MyAEEventHandlerCallback, you would declare it like this:

OSErr MyAEEventHandlerCallback (
   const AppleEvent * theAppleEvent,
   AppleEvent * reply,
   long handlerRefcon
);
Parameters
theAppleEvent

A pointer to the Apple event to handle. See AppleEvent.
reply

A pointer to the default reply Apple event provided by the Apple Event Manager. See AppleEvent. If no reply is expected, reply has descriptor type typeNull.
handlerRefcon

The reference constant stored in the Apple event dispatch table when you install the handler function for the Apple event. You can store any 32-bit value in the dispatch table and use it any way you want when the handler is called. The reference constant may have a value of NULL.
Return Value

A result code. See “Apple Event Manager Result Codes”. Your handler should always return noErr if it successfully handled the Apple event. If an error occurs, your handler should return either errAEEventNotHandled or some other nonzero result code. For more information, see the Discussion section.
Discussion

An Apple event handler should extract any parameters and attributes from the Apple event, perform the requested action, and add parameters to the reply Apple event if appropriate. You must provide an Apple event handler for each Apple event your application supports. The AEProcessAppleEvent function calls one of your Apple event handlers when it processes an Apple event.

If an error occurs because your application cannot understand the event, return errAEEventNotHandled, so that the Apple Event Manager may be able to find another handler to handle the event. If the error occurs because the event is impossible to handle as specified, return the result code returned by whatever function caused the failure, or whatever other result code is appropriate.

For example, suppose your application receives a kAEGetData event that requests the name of the current printer, and your application cannot handle such an event. In this situation, you should return errAEEventNotHandled so that another handler available to the Apple Event Manager can have a chance to handle the event. This strategy allows users to take advantage of system capabilities from within your application via system handlers.

If your Apple event handler calls the AEResolve function and AEResolve calls an object accessor function in the system object accessor dispatch table, your Apple event handler may not recognize the descriptor type of the token returned by the function. In this case, your handler should return the result code errAEUnknownObjectType. When your handler returns this result code, the Apple Event Manager attempts to locate a system Apple event handler that can recognize the token.

For additional information on dealing with error conditions, see OSLGetErrDescProcPtr.

To provide a pointer to your event handler callback function, you create a universal procedure pointer (UPP) of type AEEventHandlerUPP, using the function NewAEEventHandlerUPP. You can do so with code like the following:AEEventHandlerUPP MyEventHandlerUPP;
MyEventHandlerUPP = NewAEEventHandlerUPP (&MyEventHandlerCallback)


You can then pass the UPP MyEventHandlerUPP as a parameter to any function that installs or removes a handler, such as AEInstallEventHandler. If your application installs the same event handler to handle more than one kind of event (more than one pair of event class and event ID), you can use the same UPP to install the handler multiple times.

If you wish to call your event handler callback function directly, you can use the InvokeAEEventHandlerUPP function.

After you are finished with an event handler callback function, and have removed it with the AERemoveEventHandler function, you can dispose of the UPP with the DisposeAEEventHandlerUPP function. However, don’t dispose of the UPP if any remaining handler uses it or if you plan to install the handler again. 
Version Notes

Your application should not install a handler in a system dispatch table with the goal that the handler will get called when other applications receive an Apple event—this won’t work in Mac OS X. For more information, see “The System Dispatch Table” in “Apple Event Dispatching” in Apple Events Programming Guide.
AEDataModel.h*/
typedef OSErr (*AEEventHandlerProcPtr)
(
   const AppleEvent * theAppleEvent,
   AppleEvent * reply,
   long handlerRefcon
);


/*AppleEvent

A descriptor whose data is a list of descriptors containing both attributes and parameters that make up an Apple event.

typedef AERecord AppleEvent;
Discussion

The Apple event data type describes a full-fledged Apple event. Like the data for an Apple event record (data type AERecord), the data for an Apple event consists of a list of keyword-specified descriptors. Unlike an Apple event record, the data for an Apple event is conceptually divided into two parts, one for attributes and one for parameters. This division within the Apple event allows the Apple Event Manager to distinguish between an events attributes and its parameters.

For additional information on the structure of an Apple event and on how to build one, see Building an Apple Event in Apple Events Programming Guide.

Many functions work with Apple events, including the functions described in Getting Data or Descriptors From Apple Events, Adding Parameters and Attributes to an Apple Event, Creating an Apple Event, and Sending an Apple Event. 
Availability
Available in Mac OS X v10.0 and later.
AEDataModel.h*/
typedef AERecord AppleEvent;


/*AEEventHandlerUPP

Defines a data type for the universal procedure pointer for the AEEventHandlerUPP callback function pointer.

typedef AEEventHandlerProcPtr AEEventHandlerUPP;
Discussion

For a description of an event handler callback function, see AEEventHandlerProcPtr.
AEDataModel.h*/
typedef AEEventHandlerProcPtr AEEventHandlerUPP;


/*AppleEvent

A descriptor whose data is a list of descriptors containing both attributes and parameters that make up an Apple event.

typedef AERecord AppleEvent;
Discussion

The Apple event data type describes a full-fledged Apple event. Like the data for an Apple event record (data type AERecord), the data for an Apple event consists of a list of keyword-specified descriptors. Unlike an Apple event record, the data for an Apple event is conceptually divided into two parts, one for attributes and one for parameters. This division within the Apple event allows the Apple Event Manager to distinguish between an event’s attributes and its parameters.

For additional information on the structure of an Apple event and on how to build one, see “Building an Apple Event” in Apple Events Programming Guide.

Many functions work with Apple events, including the functions described in “Getting Data or Descriptors From Apple Events”, “Adding Parameters and Attributes to an Apple Event”, “Creating an Apple Event”, and “Sending an Apple Event”. 
Availability
Available in Mac OS X v10.0 and later.
AEDataModel.h*/
typedef AERecord AppleEvent;



/*AERecord

A descriptor whose data is a list of keyword-specified descriptors.

typedef AEDescList AERecord;
Discussion

The Apple Event Manager provides routines that allow your application to create Apple event records and extract data from them when creating or responding to Apple events. You also work with Apple event records if your application resolves or creates object specifiers. Functions that use Apple event records are described in Getting Data or Descriptors From Apple Events and Adding Parameters and Attributes to an Apple Event. 

The descriptor list of keyword-specified descriptors in an Apple event record must specify Apple event parameters?they cannot specify Apple event attributes. Only descriptor lists of type Apple event can contain both attributes and parameters.
Availability
Available in Mac OS X v10.0 and later.
AEDataModel.h*/
typedef AEDescList AERecord;




/*AEEventClass

Specifies the event class of an Apple event.

typedef FourCharCode AEEventClass;
Discussion

Apple events are identified by their event class and event ID attributes. The event class is the attribute that identifies a group of related Apple events. When you call the AEProcessAppleEvent function, the Apple Event Manager uses these attributes to identify a handler for a specific Apple event.

For more information on Apple event classes, see “Event Class Constants”. 
Availability
Available in Mac OS X v10.0 and later.
AEDataModel.h*/
typedef FourCharCode AEEventClass;


/*AEKeyword

A four-character code that uniquely identifies a descriptor in an Apple event record or an Apple event.

typedef FourCharCode AEKeyword;
Discussion

The Apple Event Manager uniquely identifies the various parts of an Apple event by means of keywords associated with corresponding descriptors. Keywords are arbitrary names, stored as four-character codes of type AEKeyword. A keyword combined with a descriptor forms a keyword-specified descriptor, which is defined by a data structure of type AERemoteProcessResolverContext.

The Apple Event Manager also uses keywords for Apple event attributes. Keyword constants used by the Apple Event Manager are defined in “Keyword Attribute Constants” and “Keyword Parameter Constants”. 
Availability
Available in Mac OS X v10.0 and later.
AEDataModel.h*/
typedef FourCharCode AEKeyword;

/*AEDisposeDesc

Deallocates the memory used by a descriptor.

OSErr AEDisposeDesc (
   AEDesc * theAEDesc
);
Parameters
theAEDesc

A pointer to the descriptor to deallocate. On return, a null descriptor. If you pass a null descriptor in this parameter, AEDisposeDesc returns noErr. See AEDesc.
Return Value

A result code. See Apple Event Manager Result Codes. As currently implemented, AEDisposeDesc always returns noErr.
Discussion

The AEDisposeDesc function deallocates the memory used by a descriptor. After calling this method, the descriptor becomes an empty descriptor with a type of typeNULL. Because all Apple event structures (except for keyword-specified descriptors) are descriptors, you can use AEDisposeDesc for any of them.

Do not call AEDisposeDesc on a descriptor obtained from another Apple Event Manager function (such as the reply event from a call to AESend) unless that function returns successfully.
Special Considerations

If the AEDesc might contain an OSL token, dispose of it with AEDisposeToken.
Version Notes

Thread safe starting in Mac OS X v10.2.
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X v10.0 and later.
Declared In
AEDataModel.h*/
extern OSErr AEDisposeDesc (
   AEDesc * theAEDesc
);

/*AEGetParamDesc

Gets a copy of the descriptor for a keyword-specified Apple event parameter from an Apple event or an Apple event record (type AERecord); typically used when your application needs to pass the extracted data to another function as a descriptor. 

OSErr AEGetParamDesc (
   const AppleEvent * theAppleEvent,
   AEKeyword theAEKeyword,
   DescType desiredType,
   AEDesc * result
);
Parameters
theAppleEvent

A pointer to the Apple event to get the parameter descriptor from. See AppleEvent.
theAEKeyword

A keyword that specifies the desired Apple event parameter. Some keyword constants are described in “Keyword Parameter Constants”. See AEKeyword.
desiredType

The descriptor type for the desired Apple event parameter. For a list of AppleScript’s predefined descriptor types, see “Descriptor Type Constants”.

If the requested Apple event parameter is not of the desired type, the Apple Event Manager attempts to coerce it to the desired type. However, if you pass a value of typeWildCard, no coercion is performed, and the descriptor type of the returned descriptor is the same as the descriptor type of the Apple event parameter.

See DescType.
result

A pointer to a descriptor. On successful return, a copy of the descriptor for the specified Apple event parameter, coerced, if necessary, to the descriptor type specified by the desiredType parameter. On error, a null descriptor. If the function returns successfully, your application should call the AEDisposeDesc function to dispose of the resulting descriptor after it has finished using it. See AEDesc.
Return Value

A result code. See “Apple Event Manager Result Codes”.
Discussion

To get Apple event parameter data for your application to use directly, call AEGetParamPtr. To get a descriptor for an Apple event parameter to pass on to another Apple Event Manager routine, call AEGetParamDesc.

If the actual parameter you are getting with AEGetParamDesc is a record, AEGetParamDesc will only allow you to request it as a typeAERecord, typeAEList, or typeWildcard. For any other type, it will return errAECoercionFail.
Version Notes

Thread safe starting in Mac OS X v10.2.
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X v10.0 and later.
Declared In
AEDataModel.h*/

extern OSErr AEGetParamDesc (
   const AppleEvent * theAppleEvent,
   AEKeyword theAEKeyword,
   DescType desiredType,
   AEDesc * result
);

/*NewAEEventHandlerUPP

Creates a new universal procedure pointer to an event handler function.

AEEventHandlerUPP NewAEEventHandlerUPP (
   AEEventHandlerProcPtr userRoutine
);
Return Value

See AEEventHandlerUPP.
Discussion

See the AEEventHandlerProcPtr callback function. 
Availability
Available in CarbonLib 1.0 and later.
Available in Mac OS X v10.0 and later.
Declared In
AEDataModel.h*/

extern AEEventHandlerUPP NewAEEventHandlerUPP (
   AEEventHandlerProcPtr userRoutine
);

/*AECountItems

Counts the number of descriptors in a descriptor list.

OSErr AECountItems (
   const AEDescList * theAEDescList,
   long * theCount
);
Parameters
theAEDescList

A pointer to the descriptor list to count. See AEDescList.
theCount

A pointer to a count variable. On return, the number of descriptors in the specified descriptor list.
Return Value

A result code. See “Apple Event Manager Result Codes”.
Discussion

Your application typically counts the descriptors in a descriptor list when it is extracting data from an Apple event. You can use the functions in “Getting Items From Descriptor Lists” to get an individual item from a descriptor list or to iterate through the items. 
Version Notes

Thread safe starting in Mac OS X v10.2.
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X v10.0 and later.
Declared In
AEDataModel.h*/
extern OSErr AECountItems (
   const AEDescList * theAEDescList,
   long * theCount
);

/*AEGetNthPtr

Gets a copy of the data from a descriptor at a specified position in a descriptor list; typically used when your application needs to work with the extracted data directly.

OSErr AEGetNthPtr (
   const AEDescList * theAEDescList,
   long index,
   DescType desiredType,
   AEKeyword * theAEKeyword,
   DescType * typeCode,
   void * dataPtr,
   Size maximumSize,
   Size * actualSize
);
Parameters
theAEDescList

A pointer to the descriptor list that contains the descriptor. See AEDescList.
index

A one-based positive integer indicating the position in the descriptor list of the descriptor to get the data from. AEGetNthPtr returns an error if you pass zero, a negative number, or a value that is out of range.
desiredType

The desired descriptor type for the copied data. For a list of AppleScript’s predefined descriptor types, see “Descriptor Type Constants”.

If the descriptor specified by the index parameter is not of the desired type, AEGetNthPtr attempts to coerce the data to this type. If you pass a value of typeWildCard, no coercion is performed, and the descriptor type of the copied data is the same as the descriptor type of the original descriptor.

See DescType.
theAEKeyword

A pointer to a keyword. On return, the keyword for the specified descriptor, if you are getting data from a list of keyword-specified descriptors; otherwise, AEGetNthPtr returns the value typeWildCard. Some keyword constants are described in “Keyword Attribute Constants” and “Keyword Parameter Constants”. See AEKeyword.
typeCode

A pointer to a descriptor type. On return, specifies the descriptor type of the data pointed to by dataPtr. For a list of AppleScript’s predefined descriptor types, see “Descriptor Type Constants”.
dataPtr

A pointer to a buffer, local variable, or other storage location created and disposed of by your application. The size in bytes must be at least as large as the value you pass in the maximumSize parameter. On return, contains the data from the descriptor at the position in the descriptor list specified by the index parameter.
maximumSize

The maximum length, in bytes, of the expected data. The AEGetNthPtr function will not return more data than you specify in this parameter. 
actualSize

A pointer to a size variable. On return, the length, in bytes, of the data for the specified descriptor. If this value is larger than the value of the maximumSize parameter, the buffer pointed to by dataPtr was not large enough to contain all of the data for the descriptor, though AEGetNthPtr does not write beyond the end of the buffer. If the buffer was too small, you can resize it and call AEGetNthPtr again.
Return Value

A result code. See “Apple Event Manager Result Codes”.
Discussion

The AEGetNthPtr function uses a buffer to return the data for a specified descriptor from a specified descriptor list. The function attempts to coerce the descriptor to the descriptor type specified by the desiredType parameter.

Before calling AEGetNthPtr, you can call the AESizeOfNthItem function to determine a size for the dataPtr buffer. However, unless you specify typeWildCard for the desiredType parameter, AESizeOfNthItem may coerce the data, which may cause the size of the data to change. If you are using AEGetNthPtr to iterate through a list of descriptors of the same type with a fixed size, such as a list of descriptors of type typeFSS, you can get the size once, allocate a buffer, and reuse it for each call.

The order of items in an Apple event record may change after an insertion or deletion. In addition, duplicating an Apple event record is not guaranteed to preserve the item order. 
Version Notes

Thread safe starting in Mac OS X v10.2.
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X v10.0 and later.
Declared In
AEDataModel.h*/
extern OSErr AEGetNthPtr (
   const AEDescList * theAEDescList,
   long index,
   DescType desiredType,
   AEKeyword * theAEKeyword,
   DescType * typeCode,
   void * dataPtr,
   Size maximumSize,
   Size * actualSize
);

/*AEGetDescData

Gets the data from the specified descriptor.

OSErr AEGetDescData (
   const AEDesc * theAEDesc,
   void * dataPtr,
   Size maximumSize
);
Parameters
theAEDesc

A pointer to the descriptor to get the data from. See AEDesc.
dataPtr

A pointer to a buffer, local variable, or other storage location created and disposed of by your application. The size in bytes should be the same as the value you pass in the maximumSize parameter. On return, contains the data from the descriptor.
maximumSize

The length, in bytes, of the expected descriptor data. The AEGetDescData function will not return more data than you specify in this parameter. You typically determine the maximum size by calling AEGetDescDataSize.
Return Value

A result code. See “Apple Event Manager Result Codes”.
Discussion

Your application can call AEGetDescDataSize to get the size, in bytes, of the data in a descriptor, allocate a buffer or variable of that size, then call AEGetDescData to get the data. 
Version Notes

Thread safe starting in Mac OS X v10.2.
Availability
Available in CarbonLib 1.0 and later.
Available in Mac OS X v10.0 and later.
Declared In
AEDataModel.h*/

extern OSErr AEGetDescData (
   const AEDesc * theAEDesc,
   void * dataPtr,
   Size maximumSize
);


/*AECreateDesc

Creates a new descriptor that incorporates the specified data.

OSErr AECreateDesc (
   DescType typeCode,
   const void * dataPtr,
   Size dataSize,
   AEDesc * result
);
Parameters
typeCode

The descriptor type for the new descriptor. For a list of AppleScript’s predefined descriptor types, see “Descriptor Type Constants”. See DescType.
dataPtr

A pointer to the data for the new descriptor. This data is copied into a newly-allocated block of memory for the descriptor that is created. To minimize copying overhead, consider using AECreateDescFromExternalPtr.
dataSize

The length, in bytes, of the data for the new descriptor.
result

A pointer to a descriptor. On successful return, a descriptor that incorporates the data specified by the dataPtr parameter. On error, a null descriptor. If the function returns successfully, your application should call the AEDisposeDesc function to dispose of the resulting descriptor after it has finished using it. See AEDesc.
Return Value

A result code. See “Apple Event Manager Result Codes”.
Discussion

While it is possible to create an Apple event descriptor or a descriptor list or a descriptor with the AECreateDesc function (assuming you have access to the raw data for an Apple event, list, or descriptor), you typically create these structured objects with their specific creation routines—AECreateAppleEvent, AECreateList, or AECreateDesc. 
Version Notes

Thread safe starting in Mac OS X v10.2.
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X v10.0 and later.
Declared In
AEDataModel.h*/
extern OSErr AECreateDesc (
   DescType typeCode,
   const void * dataPtr,
   Size dataSize,
   AEDesc * result
);

#ifdef __cplusplus
}
#endif
#endif