#ifndef COLLECTIONS_H
#define COLLECTIONS_H

#ifndef MACTYPES_H
#include <CarbonCore/MacTypes.h>
#endif

#ifndef MIXEDMODE_H
#include <CarbonCore/MixedMode.h>
#endif



#include <AvailabilityMacros.h>

#if PRAGMA_ONCE
#pragma once
#endif

#ifdef __cplusplus
extern "C" {
#endif
/*Collection

Defines defines a reference to an opaque type that your compiler can type-check.

typedef struct OpaqueCollection * Collection;
Discussion

The Collection Manager provides you with access to a collection object through a Collection reference. The Collection type defines a reference type that your compiler can type-check; it does not define a pointer to a publicly defined data structure. The contents of the collection object are private; you must use the Collection Manager functions to manipulate collection objects. 
Availability
Available in Mac OS X v10.0 and later.*/
typedef struct OpaqueCollection * Collection;

#ifdef __cplusplus
}
#endif

#endif