#ifndef COMPONENTS_H
#define COMPONENTS_H


#ifndef MACERRORS_H
#include <CarbonCore/MacErrors.h>
#endif

#ifndef MACTYPES_H
#include <CarbonCore/MacTypes.h>
#endif

#ifndef MIXEDMODE_H
#include <CarbonCore/MixedMode.h>
#endif

#ifndef FILES_H
#include <CarbonCore/Files.h>
#endif



#include <AvailabilityMacros.h>

#if PRAGMA_ONCE
#pragma once
#endif

#ifdef __cplusplus
extern "C" {
#endif




#include <AvailabilityMacros.h>

/*ComponentRecord


struct ComponentRecord {
   long data[1];
};
typedef struct ComponentRecord ComponentRecord;
typedef ComponentRecord * Component;
Fields
data
Availability
Available in Mac OS X v10.0 and later.*/
struct ComponentRecord {
   long data[1];
};
typedef struct ComponentRecord ComponentRecord;
typedef ComponentRecord * Component;

/*ComponentDescription


struct ComponentDescription {
   OSType componentType;
   OSType componentSubType;
   OSType componentManufacturer;
   unsigned long componentFlags;
   unsigned long componentFlagsMask;
};
typedef struct ComponentDescription ComponentDescription;
Fields
componentType

A four-character code that identifies the type of component. All components of a particular type must support a common set of interface functions. For example, drawing components all have a component type of 'draw'.

If you are developing an application which uses components, you can use this field to search for components of a given type by specifying the component type in this field of the component description structure you supply to the FindNextComponent function or the CountComponents function. A value of 0 operates as a wildcard.

If you are developing a component, it must support all of the standard functions for the component type specified by this field. Type codes with all lowercase characters are reserved for definition by Apple. You can define your own component type code as long as you register it with Apple’s Component Registry Group.

componentSubType

A four-character code that identifies the subtype of the component. Different subtypes of a component type may support additional features or provide interfaces that extend beyond the standard functions for a given component type. For example, the subtype of drawing components indicates the type of object the component draws. Drawing components that draw ovals have a subtype of 'oval'.

If you are developing an application which uses components, you can use the componentSubType field to perform a more specific lookup operation than is possible using only the componentType field. By specifying particular values for both fields in the component description structure that you supply to the FindNextComponent or CountComponents function, your application retrieves information about only those components that meet both of these search criteria. A value of 0 operates as a wildcard.

If you are developing a component, you may use this field to indicate more specific information about the capabilities of the component. There are no restrictions on the content you assign to this field. If no additional information is appropriate for your component type, you may set the componentSubType field to 0.
componentManufacturer

A four-character code that identifies the manufacturer of the component. This field allows for further differentiation between individual components. For example, components made by a specific manufacturer may support an extended feature set. Components provided by Apple use a manufacturer value of 'appl'.

If you are developing an application which uses components, you can use this field to find components from a certain manufacturer. Specify the appropriate manufacturer code in this field of the component description structure you supply to the FindNextComponent or CountComponents function. A value of 0 operates as a wildcard.

If you are developing a component, you obtain your manufacturer code, which can be the same as your application signature, from Apple’s Component Registry Group.
componentFlags

A 32-bit field that provides additional information about a particular component.

The high-order 8 bits are reserved for definition by the Component Manager. If you are developing an application, you should usually set these bits to 0.

The low-order 24 bits are specific to each component type. These flags can be used to indicate the presence of features or capabilities in a given component.

If you are developing an application which uses components, you can use these flags to further narrow the search criteria applied by the FindNextComponent or CountComponents function. If you use the componentFlags field in a component search, you use the componentFlagsMask field to indicate which flags are to be considered in the search.

If you are developing a component, you can use these flags to indicate any special capabilities or features of your component. You may use all 24 bits, as appropriate to its component type. You must set all unused bits to 0.
componentFlagsMask

A 32-bit field that indicates which flags in the componentFlags field are relevant to a particular component search operation. 

If you are developing an application which uses components, your application should set each bit which corresponds to a flag in the componentFlags field that is to be considered as a search criterion by the FindNextComponent or CountComponents function to 1. The Component Manager considers only these flags during the search. You specify the desired flag value (either 0 or 1) in the componentFlags field. 

For example, to look for a component with a specific control flag that is set to 0, set the appropriate bit in the ComponentFlags field to 0 and the same bit in the ComponentFlagsMask field to 1. To look for a component with a specific control flag that is set to 1, set the bit in the ComponentFlags field to 1 and the same bit in the ComponentFlagsMask field to 1. To ignore a flag, set the bit in the ComponentFlagsMask field to 0.

If you are developing a component, your component must set the componentFlagsMask field in its component description structure to 0.
Discussion

The ComponentDescription structure identifies the characteristics of a component, including the type of services offered by the component and its manufacturer.

Applications and components use component description structures in different ways. An application that uses components specifies the selection criteria for a component in a component description structure. The functions FindNextComponent , CountComponents , and GetComponentInfo all use the component description structure to specify the criteria for their search.

A component uses the component description structure to specify its registration information and capabilities and identify itself to the Component Manager. If your component is stored in a component resource, the information in the component description structure must be part of that resource. See the description of the component ‘thng’ resource. If you have developed an application that registers your component, that application must supply a component description structure to the RegisterComponent function. See “Registering Components” for information about registering components.

The ComponentDescription data type defines the component description structure. Note that the valid values of fields in the component description structure are determined by the component type specification. For example, all image compressor components must use the componentSubType field to specify the compression algorithm used by the compressor. 
Special Considerations
Availability
Available in Mac OS X v10.0 and later.*/
struct ComponentDescription {
   OSType componentType;
   OSType componentSubType;
   OSType componentManufacturer;
   unsigned long componentFlags;
   unsigned long componentFlagsMask;
};
typedef struct ComponentDescription ComponentDescription;

/*ComponentInstanceRecord


struct ComponentInstanceRecord {
   long data[1];
};
typedef struct ComponentInstanceRecord ComponentInstanceRecord;
typedef ComponentInstanceRecord * ComponentInstance;
Fields
data
Special Considerations
Availability
Available in Mac OS X v10.0 and later.
Components.h*/


struct ComponentInstanceRecord {
   long data[1];
};
typedef struct ComponentInstanceRecord ComponentInstanceRecord;
typedef ComponentInstanceRecord * ComponentInstance;



/*ComponentResult

Abst_ComponentResult

typedef long ComponentResult;
Availability
Available in Mac OS X v10.0 and later
Components.h.*/

typedef long ComponentResult;


/*CloseComponent

Terminates your applications connection to a component. 

OSErr CloseComponent (
   ComponentInstance aComponentInstance
);
Parameters
aComponentInstance

The connection you wish to close. Your application obtains the component instance from the OpenComponent function or the OpenDefaultComponent function. You can use a component identifier here, but you must coerce the data type appropriately. 
Return Value

A result code. See Component Manager Result Codes.
Discussion

This function closes only a single connection. If your application has several connections to a single component, you must call it once for each connection. 
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later. Available in Mac OS X 10.0 and later.
Available in QuickTime for Windows.
Carbon Porting Notes
Declared In
Components.h*/


OSErr CloseComponent (
   ComponentInstance aComponentInstance
);

/*OpenDefaultComponent

Opens a connection to a registered component of the component type and subtype specified by your application. 

ComponentInstance OpenDefaultComponent (
   OSType componentType,
   OSType componentSubType
);
Parameters
componentType

The type of the component. All components of a particular type support a common set of interface functions. Use this parameter to search for components of a given type. 
componentSubType

The subtype of the component. Different subtypes of a component type may support additional features or provide interfaces that extend beyond the standard functions for a given component type. For example, the subtype of an image compressor component indicates the compression algorithm employed by the compressor.

Your application can use the componentSubType parameter to perform a more specific lookup operation than is possible using only the componentType parameter. For example, you may want your application to use only components of a certain component type ('draw') that also have a specific subtype ('oval'). Set this parameter to 0 to select a component with any subtype value.
Return Value

A component instance that identifies the connection opened to the component which matches your search criteria. You must supply this component instance whenever you call the functions provided by the component. When you close the component, you must also supply this component instance to the CloseComponent function.

If more than one component in the list of registered components meets the search criteria, the function opens the first one that it finds in its list. If it cannot open the specified component, it returns NULL.

See the description of the ComponentInstance data type.
Discussion

Your application must open a component before it can call any component functions. This function searches for a component by type and subtype. You do not have to supply a component description structure or call the FindNextComponent function to use this function. If you want to exert more control over the selection process, you can use the FindNextComponent and OpenComponent functions. 
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later. Available in Mac OS X 10.0 and later.
Available in QuickTime for Windows.
Carbon Porting Notes
Declared In
Components.h*/
ComponentInstance OpenDefaultComponent (
   OSType componentType,
   OSType componentSubType
);

/*OpenADefaultComponent


OSErr OpenADefaultComponent (
   OSType componentType,
   OSType componentSubType,
   ComponentInstance * ci
);
Parameters
componentType
componentSubType
ci
Return Value

A result code. See “Component Manager Result Codes”.
Availability
Available in CarbonLib 1.0 and later when QuickTime 2.5 or later is present. Available in Mac OS X 10.0 and later.
Available in QuickTime for Windows.
Carbon Porting Notes
Declared In
Components.h*/
OSErr OpenADefaultComponent (
   OSType componentType,
   OSType componentSubType,
   ComponentInstance * ci
);

/*OpenComponent

Opens a connection to the component with the component identifier specified by your application.

ComponentInstance OpenComponent (
   Component aComponent
);
Parameters
aComponent

The component you wish to open. Your application obtains this identifier from the FindNextComponent function. If your application registers a component, it can also obtain a component identifier from the RegisterComponent function or the RegisterComponentResource function. 
Return Value

A component instance which identifies your application’s connection to the component. You must supply this component instance whenever you call the functions provided by the component. When you close the component, you must also supply this component instance to the CloseComponent function.

If it cannot open the specified component, the function returns NULL.

See the description of the ComponentInstance data type.
Discussion

Your application must open a component before it can call any component functions. To use this function, you must already have obtained a component identifier. Alternatively, you can use the OpenDefaultComponent function to open a component without calling FindNextComponent. 

Note that your application may maintain several connections to a single component, or it may have connections to several components at the same time. 
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later. Available in Mac OS X 10.0 and later.
Available in QuickTime for Windows.
Carbon Porting Notes
Declared In
Components.h*/

ComponentInstance OpenComponent (
   Component aComponent
);

/*FindNextComponent

Returns the component identifier for the next registered component that meets the selection criteria specified by your application. 

Component FindNextComponent (
   Component aComponent,
   ComponentDescription * looking
);
Parameters
aComponent

The starting point for the search. Set this field to 0 to start the search at the beginning of the component list. If you are continuing a search, you can specify a component identifier previously returned by this function. The function then searches the remaining components. 
looking

A pointer to a ComponentDescription structure. Your application specifies the criteria for the component search in the fields of this structure.

The Component Manager ignores fields in the component description structure that are set to 0. For example, if you set all the fields to 0, all components meet the search criteria. In this case, your application can retrieve information about all of the components that are registered in the system by repeatedly calling FindNextComponent and GetComponentInfo until the search is complete. Similarly, if you set all fields to 0 except for the componentManufacturer field, the Component Manager searches all registered components for a component supplied by the manufacturer you specify. Note that this function does not modify the contents of the component description structure you supply. To retrieve detailed information about a component, you need to use the GetComponentInfo function to get the component description structure for each returned component.

Return Value

The component identifier of a component that meets the search criteria or 0 when there are no more matching components. Your application can use the component identifier returned by this function to get more information about the component, using GetComponentInfo, or to open the component, using either the OpenDefaultComponent function or the OpenComponent function. See the description of the Component data type.
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later. Available in Mac OS X 10.0 and later.
Available in QuickTime for Windows.
Carbon Porting Notes
Declared In
Components.h*/
Component FindNextComponent (
   Component aComponent,
   ComponentDescription * looking
);


#ifdef __cplusplus
}
#endif
#endif