#ifndef FOLDERS_H
#define FOLDERS_H


#ifndef MACTYPES_H
#include <CarbonCore/MacTypes.h>
#endif

#ifndef MIXEDMODE_H
#include <CarbonCore/MixedMode.h>
#endif

#ifndef FILES_H
#include <CarbonCore/Files.h>
#endif



#include <AvailabilityMacros.h>

#if PRAGMA_ONCE
#pragma once
#endif

#ifdef __cplusplus
extern "C" {
#endif


/*Create Folder Flags

Indicate whether a folder should be created, if it is not found.

enum {
   kCreateFolder = true,
   kDontCreateFolder = false
};
Constants
kCreateFolder

Specifies that the folder should be created, if it is not found. 

Available in Mac OS X v10.0 and later.
kDontCreateFolder

Specifies that the folder should not be created, if it is not found.

Available in Mac OS X v10.0 and later.
Discussion

You can pass these flag constants in the createFolder parameter of the function FSFindFolder.*/

enum {
   kCreateFolder = true,
   kDontCreateFolder = false
};


/*kDomainTopLevelFolderType



enum {
   kDomainTopLevelFolderType = 'dtop',
   kDomainLibraryFolderType = 'dlib',
   kColorSyncFolderType = 'sync',
   kColorSyncCMMFolderType = 'ccmm',
   kColorSyncScriptingFolderType = 'cscr',
   kPrintersFolderType = 'impr',
   kSpeechFolderType = 'spch',
   kCarbonLibraryFolderType = 'carb',
   kDocumentationFolderType = 'info',
   kDeveloperDocsFolderType = 'ddoc',
   kDeveloperHelpFolderType = 'devh',
   kISSDownloadsFolderType = 'issd',
   kUserSpecificTmpFolderType = 'utmp',
   kCachedDataFolderType = 'cach',
   kFrameworksFolderType = 'fram',
   kPrivateFrameworksFolderType = 'pfrm',
   kClassicDesktopFolderType = 'sdsk',
   kDeveloperFolderType = 'devf',
   kSystemSoundsFolderType = 'ssnd',
   kComponentsFolderType = 'cmpd',
   kQuickTimeComponentsFolderType = 'wcmp',
   kCoreServicesFolderType = 'csrv',
   kPictureDocumentsFolderType = 'pdoc',
   kMovieDocumentsFolderType = 'mdoc',
   kMusicDocumentsFolderType = 'doc',
   kInternetSitesFolderType = 'site',
   kPublicFolderType = 'pubb',
   kAudioSupportFolderType = 'adio',
   kAudioSoundsFolderType = 'asnd',
   kAudioSoundBanksFolderType = 'bank',
   kAudioAlertSoundsFolderType = 'alrt',
   kAudioPlugInsFolderType = 'aplg',
   kAudioComponentsFolderType = 'acmp',
   kKernelExtensionsFolderType = 'kext',
   kDirectoryServicesFolderType = 'dsrv',
   kDirectoryServicesPlugInsFolderType = 'dplg',
   kInstallerReceiptsFolderType = 'rcpt',
   kFileSystemSupportFolderType = 'fsys',
   kAppleShareSupportFolderType = 'shar',
   kAppleShareAuthenticationFolderType = 'auth',
   kMIDIDriversFolderType = 'midi',
   kKeyboardLayoutsFolderType = 'klay',
   kIndexFilesFolderType = 'indx',
   kFindByContentIndexesFolderType = 'fbcx',
   kManagedItemsFolderType = 'mang',
   kBootTimeStartupItemsFolderType = 'empz'
};*/
enum {
   kDomainTopLevelFolderType = 'dtop',
   kDomainLibraryFolderType = 'dlib',
   kColorSyncFolderType = 'sync',
   kColorSyncCMMFolderType = 'ccmm',
   kColorSyncScriptingFolderType = 'cscr',
   kPrintersFolderType = 'impr',
   kSpeechFolderType = 'spch',
   kCarbonLibraryFolderType = 'carb',
   kDocumentationFolderType = 'info',
   kDeveloperDocsFolderType = 'ddoc',
   kDeveloperHelpFolderType = 'devh',
   kISSDownloadsFolderType = 'issd',
   kUserSpecificTmpFolderType = 'utmp',
   kCachedDataFolderType = 'cach',
   kFrameworksFolderType = 'fram',
   kPrivateFrameworksFolderType = 'pfrm',
   kClassicDesktopFolderType = 'sdsk',
   kDeveloperFolderType = 'devf',
   kSystemSoundsFolderType = 'ssnd',
   kComponentsFolderType = 'cmpd',
   kQuickTimeComponentsFolderType = 'wcmp',
   kCoreServicesFolderType = 'csrv',
   kPictureDocumentsFolderType = 'pdoc',
   kMovieDocumentsFolderType = 'mdoc',
   kMusicDocumentsFolderType = 'doc',
   kInternetSitesFolderType = 'site',
   kPublicFolderType = 'pubb',
   kAudioSupportFolderType = 'adio',
   kAudioSoundsFolderType = 'asnd',
   kAudioSoundBanksFolderType = 'bank',
   kAudioAlertSoundsFolderType = 'alrt',
   kAudioPlugInsFolderType = 'aplg',
   kAudioComponentsFolderType = 'acmp',
   kKernelExtensionsFolderType = 'kext',
   kDirectoryServicesFolderType = 'dsrv',
   kDirectoryServicesPlugInsFolderType = 'dplg',
   kInstallerReceiptsFolderType = 'rcpt',
   kFileSystemSupportFolderType = 'fsys',
   kAppleShareSupportFolderType = 'shar',
   kAppleShareAuthenticationFolderType = 'auth',
   kMIDIDriversFolderType = 'midi',
   kKeyboardLayoutsFolderType = 'klay',
   kIndexFilesFolderType = 'indx',
   kFindByContentIndexesFolderType = 'fbcx',
   kManagedItemsFolderType = 'mang',
   kBootTimeStartupItemsFolderType = 'empz'
};


/*Disk and Domain Constants

Identify the disk or domain in which to locate a folder.

enum {
   kOnSystemDisk = -32768L,
   kOnAppropriateDisk = -32767,
   kSystemDomain = -32766,
   kLocalDomain = -32765,
   kNetworkDomain = -32764,
   kUserDomain = -32763,
   kClassicDomain = -32762
};
enum {
   kLastDomainConstant = kUserDomain
};
Constants
kOnSystemDisk

Specifies the system disk.

Available in Mac OS X v10.0 and later.
kOnAppropriateDisk

In most cases, the equivalent of kOnSystemDisk. On Mac OS X, use this constant instead of the constant kOnSytemDisk to indicate any disk.

Available in Mac OS X v10.0 and later.
kSystemDomain

Available in Mac OS X v10.0 and later.
kLocalDomain

Available in Mac OS X v10.0 and later.
kNetworkDomain

Available in Mac OS X v10.0 and later.
kUserDomain

Available in Mac OS X v10.0 and later.
kClassicDomain

Available in Mac OS X v10.0 and later.
kLastDomainConstant

Available in Mac OS X v10.0 and later.
Discussion

You can pass this constant in the vRefNum parameter of FSFindFolder to locate a folder on the startup disk.*/
enum {
   kOnSystemDisk = -32768L,
   kOnAppropriateDisk = -32767,
   kSystemDomain = -32766,
   kLocalDomain = -32765,
   kNetworkDomain = -32764,
   kUserDomain = -32763,
   kClassicDomain = -32762
};
enum {
   kLastDomainConstant = kUserDomain
};


#ifdef __cplusplus
}
#endif

#endif