#ifndef CGDIRECT_DISPLAY_H
#define CGDIRECT_DISPLAY_H

#include <CoreGraphics/CGBase.h>
#include <CoreGraphics/CGGeometry.h>
#include <CoreGraphics/CGError.h>
#include <CoreGraphics/CGContext.h>
#include <CoreFoundation/CoreFoundation.h>
#include <stdint.h>
#include <AvailabilityMacros.h>
#include <mach/boolean.h>

/*CGDirectDisplayID

Represents a unique identifier for an attached display.

typedef struct _CGDirectDisplayID * CGDirectDisplayID;
Discussion

In Quartz, the term display refers to a graphics hardware system consisting of a framebuffer, a color correction (gamma) table or color palette, and possibly an attached monitor. If no monitor is attached, a display is characterized as offline.

When a monitor is attached, Quartz assigns a unique display identifier (ID). A display ID can persist across processes and system reboot, and typically remains constant as long as certain display parameters do not change.

When assigning a display ID, Quartz considers the following parameters:
vendor
model
serial number
position in the I/O Kit registry

For information about how to obtain a display ID, see “Finding Displays”.
Availability
Available in Mac OS X v10.0 and later.*/
typedef struct _CGDirectDisplayID * CGDirectDisplayID;

#endif