#ifndef CGGEOMETRY_H
#define CGGEOMETRY_H


#include <CoreGraphics/CGBase.h>
#include <CoreFoundation/CFByteOrder.h>

/*CGPoint

Represents a point in a two-dimensional coordinate system.

struct CGPoint {
   float x;
   float y;
};
typedef struct CGPoint CGPoint;
Fields
x

The x-coordinate of the point.
y

The y-coordinate of the point.
Availability
Available in Mac OS X v10.0 and later.*/
struct CGPoint {
   float x;
   float y;
};
typedef struct CGPoint CGPoint;

/*CGSize

Represents the dimensions of width and height.

struct CGSize {
   float width;
   float height;
};
typedef struct CGSize CGSize;
Fields
width

A width value.
height

A height value.
Availability
Available in Mac OS X v10.0 and later.*/
struct CGSize {
   float width;
   float height;
};
typedef struct CGSize CGSize;


/*CGRect

Represents the location and dimensions of a rectangle.

struct CGRect {
   CGPoint origin;
   CGSize size;
};
typedef struct CGRect CGRect;
Fields
origin

A CGPoint structure that specifies the coordinates of the rectangles origin. 
size

A CGSize structure that specifies the height and width of the rectangle. 
Availability
Available in Mac OS X v10.0 and later.*/
struct CGRect {
   CGPoint origin;
   CGSize size;
};
typedef struct CGRect CGRect;

/*CGRectInfinite

Represents a rectangle that has infinite extent.

const CGRect CGRectInfinite;
Constants
CGRectInfinite

Defines a rectangle that has infinite extent.

Available in Mac OS X v10.4 and later.
Availability
Available in Mac OS X v10.4 and later.*/
const CGRect CGRectInfinite;





/*CGRectIsInfinite

Checks whether a rectangle is infinite.

bool CGRectIsInfinite (
   CGRect rect
);
Parameters
rect

The rectangle to examine.
Return Value

Returns true if the specified rectangle is infinite, false otherwise.
Discussion

An infinite rectangle is one that has no defined bounds. Infinite rectangles can be created as output from a tiling filter. For example, the Core Image framework perspective tile filter creates an image whose extent is described by an infinite rectangle.
Availability
Available in Mac OS X v10.4 and later.
Declared In
CGGeometry.h*/
bool CGRectIsInfinite (
   CGRect rect
);

/*CGRectIntegral

Returns a rectangle with integer values for its origin and size.

CGRect CGRectIntegral (
   CGRect rect
);
Parameters
rect

The source rectangle. 
Return Value

The rectangle with smallest integer values for its origin and size that contains the source rectangle. That is, given a rectangle with fractional origin or size values, CGRectIntegral rounds the rectangle’s origin downward and its size upward to the nearest whole integers, such that the result contains the original rectangle. 
Availability
Available in Mac OS X version 10.0 and later.
Declared In
CGGeometry.h*/
CGRect CGRectIntegral (
   CGRect rect
);

/*CGRectIntersection

Returns the intersection of two rectangles.

CGRect CGRectIntersection (
   CGRect rect1,
   CGRect rect2
);
Parameters
rect1

The first source rectangle.
rect2

The second source rectangle.
Return Value

A rectangle that is the intersection of the two specified rectangles. If the two rectangles do not intersect, returns the null rectangle. To check for this condition, use CGRectIsNull. 
Availability
Available in Mac OS X version 10.0 and later.
Declared In
CGGeometry.h*/

CGRect CGRectIntersection (
   CGRect rect1,
   CGRect rect2
);

/*CGRectInset

Returns a rectangle that is smaller or larger than the source rectangle, with the same center point.

CGRect CGRectInset (
   CGRect rect,
   float dx,
   float dy
);
Parameters
rect

The source rectangle. 
dx

The value by which to adjust the x-coordinates of the source rectangle. To create an inset rectangle, specify a positive value. To create a larger, encompassing rectangle, specify a negative value.
dy

The value by which to adjust the y-coordinates of the source rectangle. To create an inset rectangle, specify a positive value. To create a larger, encompassing rectangle, specify a negative value.
Return Value

A rectangle with its origin offset in the x-axis by the distance specified by the dx parameter and in the y-axis by the distance specified by the dy parameter, and its size adjusted by (2*dx,2*dy), relative to the source rectangle. If dx and dy are positive values, then the rectangle’s size is decreased. If dx and dy are negative values, the rectangle’s size is increased.
Availability
Available in Mac OS X version 10.0 and later.
Declared In
CGGeometry.h*/
CGRect CGRectInset (
   CGRect rect,
   float dx,
   float dy
);

/*CGRectGetHeight

Returns the height of a rectangle.

float CGRectGetHeight (
   CGRect rect
);
Parameters
rect

The rectangle to examine. 
Return Value

The height of the specified rectangle. 
Availability
Available in Mac OS X version 10.0 and later.
Declared In
CGGeometry.h*/

float CGRectGetHeight (
   CGRect rect
);

/*CGRectGetWidth

Returns the width of a rectangle.

float CGRectGetWidth (
   CGRect rect
);
Parameters
rect

The rectangle to examine. 
Return Value

The width of the specified rectangle. 
Availability
Available in Mac OS X version 10.0 and later.
Declared In
CGGeometry.h*/

float CGRectGetWidth (
   CGRect rect
);

/*CGRectMake

Returns a rectangle structure constructed from coordinate and dimension values you provide.

CGRect CGRectMake (
   float x,
   float y,
   float width,
   float height
);
Parameters
x

The x-coordinate of the rectangle’s origin point.
y

The y-coordinate of the rectangle’s origin point.
width

The width of the rectangle.
height

The height of the rectangle.
Return Value

Returns a rectangle with the specified location and dimensions. 
Availability
Available in Mac OS X version 10.0 and later.
Declared In
CGGeometry.h*/
CGRect CGRectMake (
   float x,
   float y,
   float width,
   float height
);

/*CGRectIsInfinite

Checks whether a rectangle is infinite.

bool CGRectIsInfinite (
   CGRect rect
);
Parameters
rect

The rectangle to examine.
Return Value

Returns true if the specified rectangle is infinite, false otherwise.
Discussion

An infinite rectangle is one that has no defined bounds. Infinite rectangles can be created as output from a tiling filter. For example, the Core Image framework perspective tile filter creates an image whose extent is described by an infinite rectangle.
Availability
Available in Mac OS X v10.4 and later.
Declared In
CGGeometry.h*/
bool CGRectIsInfinite (
   CGRect rect
);

#endif
